(function(){'use strict';var
FormatOptions=['decimals','thousand','mark','prefix','postfix','encoder','decoder','negativeBefore','negative','edit','undo'];function strReverse(a){return a.split('').reverse().join('');}
function strStartsWith(input,match){return input.substring(0,match.length)===match;}
function strEndsWith(input,match){return input.slice(-1*match.length)===match;}
function throwEqualError(F,a,b){if((F[a]||F[b])&&(F[a]===F[b])){throw new Error(a);}}
function isValidNumber(input){return typeof input==='number'&&isFinite(input);}
function toFixed(value,decimals){var scale=Math.pow(10,decimals);return(Math.round(value*scale)/scale).toFixed(decimals);}
function formatTo(decimals,thousand,mark,prefix,postfix,encoder,decoder,negativeBefore,negative,edit,undo,input){var originalInput=input,inputIsNegative,inputPieces,inputBase,inputDecimals='',output='';if(encoder){input=encoder(input);}
if(!isValidNumber(input)){return false;}
if(decimals!==false&&parseFloat(input.toFixed(decimals))===0){input=0;}//
if(input<0){inputIsNegative=true;input=Math.abs(input);}
if(decimals!==false){input=toFixed(input,decimals);}
input=input.toString();if(input.indexOf('.')!==-1){inputPieces=input.split('.');inputBase=inputPieces[0];if(mark){inputDecimals=mark+inputPieces[1];}}else{inputBase=input;}
if(thousand){inputBase=strReverse(inputBase).match(/.{1,3}/g);inputBase=strReverse(inputBase.join(strReverse(thousand)));}
if(inputIsNegative&&negativeBefore){output+=negativeBefore;}
if(prefix){output+=prefix;}
if(inputIsNegative&&negative){output+=negative;}
output+=inputBase;output+=inputDecimals;if(postfix){output+=postfix;}
if(edit){output=edit(output,originalInput);}
return output;}
function formatFrom(decimals,thousand,mark,prefix,postfix,encoder,decoder,negativeBefore,negative,edit,undo,input){var originalInput=input,inputIsNegative,output='';if(undo){input=undo(input);}
if(!input||typeof input!=='string'){return false;}
if(negativeBefore&&strStartsWith(input,negativeBefore)){input=input.replace(negativeBefore,'');inputIsNegative=true;}
if(prefix&&strStartsWith(input,prefix)){input=input.replace(prefix,'');}
if(negative&&strStartsWith(input,negative)){input=input.replace(negative,'');inputIsNegative=true;}
if(postfix&&strEndsWith(input,postfix)){input=input.slice(0,-1*postfix.length);}
if(thousand){input=input.split(thousand).join('');}
if(mark){input=input.replace(mark,'.');}
if(inputIsNegative){output+='-';}
output+=input;output=output.replace(/[^0-9\.\-.]/g,'');if(output===''){return false;}
output=Number(output);if(decoder){output=decoder(output);}
if(!isValidNumber(output)){return false;}
return output;}
function validate(inputOptions){var i,optionName,optionValue,filteredOptions={};for(i=0;i<FormatOptions.length;i+=1){optionName=FormatOptions[i];optionValue=inputOptions[optionName];if(optionValue===undefined){//
if(optionName==='negative'&&!filteredOptions.negativeBefore){filteredOptions[optionName]='-';}else if(optionName==='mark'&&filteredOptions.thousand!=='.'){filteredOptions[optionName]='.';}else{filteredOptions[optionName]=false;}}else if(optionName==='decimals'){if(optionValue>=0&&optionValue<8){filteredOptions[optionName]=optionValue;}else{throw new Error(optionName);}}else if(optionName==='encoder'||optionName==='decoder'||optionName==='edit'||optionName==='undo'){if(typeof optionValue==='function'){filteredOptions[optionName]=optionValue;}else{throw new Error(optionName);}}else{if(typeof optionValue==='string'){filteredOptions[optionName]=optionValue;}else{throw new Error(optionName);}}}
throwEqualError(filteredOptions,'mark','thousand');throwEqualError(filteredOptions,'prefix','negative');throwEqualError(filteredOptions,'prefix','negativeBefore');return filteredOptions;}
function passAll(options,method,input){var i,args=[];for(i=0;i<FormatOptions.length;i+=1){args.push(options[FormatOptions[i]]);}
args.push(input);return method.apply('',args);}
function wNumb(options){if(!(this instanceof wNumb)){return new wNumb(options);}
if(typeof options!=="object"){return;}
options=validate(options);this.to=function(input){return passAll(options,formatTo,input);};this.from=function(input){return passAll(options,formatFrom,input);};}
window.wNumb=wNumb;}());(function($){'use strict';function isInstance(a){return a instanceof $||($.zepto&&$.zepto.isZ(a));}
function fromPrefix(target,method){if(typeof target==='string'&&target.indexOf('-inline-')===0){this.method=method||'html';this.target=this.el=$(target.replace('-inline-','')||'<div/>');return true;}}
function fromString(target){if(typeof target==='string'&&target.indexOf('-')!==0){this.method='val';var element=document.createElement('input');element.name=target;element.type='hidden';this.target=this.el=$(element);return true;}}
function fromFunction(target){if(typeof target==='function'){this.target=false;this.method=target;return true;}}
function fromInstance(target,method){if(isInstance(target)&&!method){if(target.is('input, select, textarea')){//
this.method='val';this.target=target.on('change.liblink',this.changeHandler);}else{this.target=target;this.method='html';}
return true;}}
function fromInstanceMethod(target,method){if(isInstance(target)&&(typeof method==='function'||(typeof method==='string'&&target[method]))){this.method=method;this.target=target;return true;}}
var
creationFunctions=[fromPrefix,fromString,fromFunction,fromInstance,fromInstanceMethod];function Link(target,method,format){var that=this,valid=false;this.changeHandler=function(changeEvent){var decodedValue=that.formatInstance.from( $(this).val());if(decodedValue===false||isNaN(decodedValue)){$(this).val(that.lastSetValue);return false;}
that.changeHandlerMethod.call('',changeEvent,decodedValue);};this.el=false;this.formatInstance=format;$.each(creationFunctions,function(i,fn){valid=fn.call(that,target,method);return!valid;});if(!valid){throw new RangeError("(Link) Invalid Link.");}}
Link.prototype.set=function(value){var args=Array.prototype.slice.call(arguments),additionalArgs=args.slice(1);this.lastSetValue=this.formatInstance.to(value);additionalArgs.unshift(this.lastSetValue);(typeof this.method==='function'?this.method:this.target[this.method]).apply(this.target,additionalArgs);};function LinkAPI(origin){this.items=[];this.elements=[];this.origin=origin;}
LinkAPI.prototype.push=function(item,element){this.items.push(item);if(element){this.elements.push(element);}};LinkAPI.prototype.reconfirm=function(flag){var i;for(i=0;i<this.elements.length;i+=1){this.origin.LinkConfirm(flag,this.elements[i]);}};LinkAPI.prototype.remove=function(flag){var i;for(i=0;i<this.items.length;i+=1){this.items[i].target.off('.liblink');}
for(i=0;i<this.elements.length;i+=1){this.elements[i].remove();}};LinkAPI.prototype.change=function(value){if(this.origin.LinkIsEmitting){return false;}
this.origin.LinkIsEmitting=true;var args=Array.prototype.slice.call(arguments,1),i;args.unshift(value);for(i=0;i<this.items.length;i+=1){this.items[i].set.apply(this.items[i],args);}
this.origin.LinkIsEmitting=false;};function binder(flag,target,method,format){if(flag===0){flag=this.LinkDefaultFlag;}
if(!this.linkAPI){this.linkAPI={};}
if(!this.linkAPI[flag]){this.linkAPI[flag]=new LinkAPI(this);}
var linkInstance=new Link(target,method,format||this.LinkDefaultFormatter);if(!linkInstance.target){linkInstance.target=$(this);}
linkInstance.changeHandlerMethod=this.LinkConfirm(flag,linkInstance.el);this.linkAPI[flag].push(linkInstance,linkInstance.el);//
this.LinkUpdate(flag);}
$.fn.Link=function(flag){var that=this;if(flag===false){return that.each(function(){if(!this.linkAPI){return;}
$.map(this.linkAPI,function(api){api.remove();});delete this.linkAPI;});}
if(flag===undefined){flag=0;}else if(typeof flag!=='string'){throw new Error("Flag must be string.");}
return{to:function(a,b,c){return that.each(function(){binder.call(this,flag,a,b,c);});}};};}(window.jQuery||window.Zepto));(function($){'use strict';function unique(array){return $.grep(array,function(el,index){return index===$.inArray(el,array);});}
function closest(value,to){return Math.round(value/to)*to;}
function isNumeric(a){return typeof a==='number'&&!isNaN(a)&&isFinite(a);}
function accurateNumber(number){var p=Math.pow(10,7);return Number((Math.round(number*p)/p).toFixed(7));}
function addClassFor(element,className,duration){element.addClass(className);setTimeout(function(){element.removeClass(className);},duration);}
function limit(a){return Math.max(Math.min(a,100),0);}
function asArray(a){return $.isArray(a)?a:[a];}
function countDecimals(numStr){var pieces=numStr.split(".");return pieces.length>1?pieces[1].length:0;}
var
doc=$(document),$val=$.fn.val,namespace='.nui',actions=window.navigator.pointerEnabled?{start:'pointerdown',move:'pointermove',end:'pointerup'}:window.navigator.msPointerEnabled?{start:'MSPointerDown',move:'MSPointerMove',end:'MSPointerUp'}:{start:'mousedown touchstart',move:'mousemove touchmove',end:'mouseup touchend'},Classes=['noUi-target','noUi-base','noUi-origin','noUi-handle','noUi-horizontal','noUi-vertical','noUi-background','noUi-connect','noUi-ltr','noUi-rtl','noUi-dragable','','noUi-state-drag','','noUi-state-tap','noUi-active','','noUi-stacking'];function subRangeRatio(pa,pb){return(100/(pb-pa));}
function fromPercentage(range,value){return(value*100)/(range[1]-range[0]);}
function toPercentage(range,value){return fromPercentage(range,range[0]<0?value+Math.abs(range[0]):value-range[0]);}
function isPercentage(range,value){return((value*(range[1]-range[0]))/100)+range[0];}
function getJ(value,arr){var j=1;while(value>=arr[j]){j+=1;}
return j;}
function toStepping(xVal,xPct,value){if(value>=xVal.slice(-1)[0]){return 100;}
var j=getJ(value,xVal),va,vb,pa,pb;va=xVal[j-1];vb=xVal[j];pa=xPct[j-1];pb=xPct[j];return pa+(toPercentage([va,vb],value)/subRangeRatio(pa,pb));}
function fromStepping(xVal,xPct,value){if(value>=100){return xVal.slice(-1)[0];}
var j=getJ(value,xPct),va,vb,pa,pb;va=xVal[j-1];vb=xVal[j];pa=xPct[j-1];pb=xPct[j];return isPercentage([va,vb],(value-pa)*subRangeRatio(pa,pb));}
function getStep(xPct,xSteps,snap,value){if(value===100){return value;}
var j=getJ(value,xPct),a,b;if(snap){a=xPct[j-1];b=xPct[j];if((value-a)>((b-a)/2)){return b;}
return a;}
if(!xSteps[j-1]){return value;}
return xPct[j-1]+closest(value-xPct[j-1],xSteps[j-1]);}
function handleEntryPoint(index,value,that){var percentage;if(typeof value==="number"){value=[value];}
if(Object.prototype.toString.call(value)!=='[object Array]'){throw new Error("noUiSlider: 'range' contains invalid value.");}
 if(index==='min'){percentage=0;}else if(index==='max'){percentage=100;}else{percentage=parseFloat(index);}
if(!isNumeric(percentage)||!isNumeric(value[0])){throw new Error("noUiSlider: 'range' value isn't numeric.");}
that.xPct.push(percentage);that.xVal.push(value[0]);if(!percentage){if(!isNaN(value[1])){that.xSteps[0]=value[1];}}else{that.xSteps.push(isNaN(value[1])?false:value[1]);}}
function handleStepPoint(i,n,that){if(!n){return true;}
that.xSteps[i]=fromPercentage([that.xVal[i],that.xVal[i+1]],n)/subRangeRatio(that.xPct[i],that.xPct[i+1]);}
function Spectrum(entry,snap,direction,singleStep){this.xPct=[];this.xVal=[];this.xSteps=[singleStep||false];this.xNumSteps=[false];this.snap=snap;this.direction=direction;var index,ordered=[];for(index in entry){if(entry.hasOwnProperty(index)){ordered.push([entry[index],index]);}}
ordered.sort(function(a,b){return a[0]-b[0];});for(index=0;index<ordered.length;index++){handleEntryPoint(ordered[index][1],ordered[index][0],this);}
this.xNumSteps=this.xSteps.slice(0);
for(index=0;index<this.xNumSteps.length;index++){handleStepPoint(index,this.xNumSteps[index],this);}}
Spectrum.prototype.getMargin=function(value){return this.xPct.length===2?fromPercentage(this.xVal,value):false;};Spectrum.prototype.toStepping=function(value){value=toStepping(this.xVal,this.xPct,value);if(this.direction){value=100-value;}
return value;};Spectrum.prototype.fromStepping=function(value){if(this.direction){value=100-value;}
return accurateNumber(fromStepping(this.xVal,this.xPct,value));};Spectrum.prototype.getStep=function(value){if(this.direction){value=100-value;}
value=getStep(this.xPct,this.xSteps,this.snap,value);if(this.direction){value=100-value;}
return value;};Spectrum.prototype.getApplicableStep=function(value){var j=getJ(value,this.xPct),offset=value===100?2:1;return[this.xNumSteps[j-2],this.xVal[j-offset],this.xNumSteps[j-offset]];};Spectrum.prototype.convert=function(value){return this.getStep(this.toStepping(value));};/**/
var defaultFormatter={'to':function(value){return value.toFixed(2);},'from':Number};function testStep(parsed,entry){if(!isNumeric(entry)){throw new Error("noUiSlider: 'step' is not numeric.");}
parsed.singleStep=entry;}
function testRange(parsed,entry){if(typeof entry!=='object'||$.isArray(entry)){throw new Error("noUiSlider: 'range' is not an object.");}
if(entry.min===undefined||entry.max===undefined){throw new Error("noUiSlider: Missing 'min' or 'max' in 'range'.");}
parsed.spectrum=new Spectrum(entry,parsed.snap,parsed.dir,parsed.singleStep);}
function testStart(parsed,entry){entry=asArray(entry);if(!$.isArray(entry)||!entry.length||entry.length>2){throw new Error("noUiSlider: 'start' option is incorrect.");}
parsed.handles=entry.length;parsed.start=entry;}
function testSnap(parsed,entry){parsed.snap=entry;if(typeof entry!=='boolean'){throw new Error("noUiSlider: 'snap' option must be a boolean.");}}
function testAnimate(parsed,entry){parsed.animate=entry;if(typeof entry!=='boolean'){throw new Error("noUiSlider: 'animate' option must be a boolean.");}}
function testConnect(parsed,entry){if(entry==='lower'&&parsed.handles===1){parsed.connect=1;}else if(entry==='upper'&&parsed.handles===1){parsed.connect=2;}else if(entry===true&&parsed.handles===2){parsed.connect=3;}else if(entry===false){parsed.connect=0;}else{throw new Error("noUiSlider: 'connect' option doesn't match handle count.");}}
function testOrientation(parsed,entry){switch(entry){case 'horizontal':parsed.ort=0;break;case 'vertical':parsed.ort=1;break;default:throw new Error("noUiSlider: 'orientation' option is invalid.");}}
function testMargin(parsed,entry){if(!isNumeric(entry)){throw new Error("noUiSlider: 'margin' option must be numeric.");}
parsed.margin=parsed.spectrum.getMargin(entry);if(!parsed.margin){throw new Error("noUiSlider: 'margin' option is only supported on linear sliders.");}}
function testLimit(parsed,entry){if(!isNumeric(entry)){throw new Error("noUiSlider: 'limit' option must be numeric.");}
parsed.limit=parsed.spectrum.getMargin(entry);if(!parsed.limit){throw new Error("noUiSlider: 'limit' option is only supported on linear sliders.");}}
function testDirection(parsed,entry){switch(entry){case 'ltr':parsed.dir=0;break;case 'rtl':parsed.dir=1;parsed.connect=[0,2,1,3][parsed.connect];break;default:throw new Error("noUiSlider: 'direction' option was not recognized.");}}
function testBehaviour(parsed,entry){if(typeof entry!=='string'){throw new Error("noUiSlider: 'behaviour' must be a string containing options.");}
var tap=entry.indexOf('tap')>=0,drag=entry.indexOf('drag')>=0,fixed=entry.indexOf('fixed')>=0,snap=entry.indexOf('snap')>=0;parsed.events={tap:tap||snap,drag:drag,fixed:fixed,snap:snap};}
function testFormat(parsed,entry){parsed.format=entry;if(typeof entry.to==='function'&&typeof entry.from==='function'){return true;}
throw new Error("noUiSlider: 'format' requires 'to' and 'from' methods.");}
function testOptions(options){var parsed={margin:0,limit:0,animate:true,format:defaultFormatter},tests;tests={'step':{r:false,t:testStep},'start':{r:true,t:testStart},'connect':{r:true,t:testConnect},'direction':{r:true,t:testDirection},'snap':{r:false,t:testSnap},'animate':{r:false,t:testAnimate},'range':{r:true,t:testRange},'orientation':{r:false,t:testOrientation},'margin':{r:false,t:testMargin},'limit':{r:false,t:testLimit},'behaviour':{r:true,t:testBehaviour},'format':{r:false,t:testFormat}};options=$.extend({'connect':false,'direction':'ltr','behaviour':'tap','orientation':'horizontal'},options);$.each(tests,function(name,test){//
if(options[name]===undefined){if(test.r){throw new Error("noUiSlider: '"+name+"' is required.");}
return true;}
test.t(parsed,options[name]);});parsed.style=parsed.ort?'top':'left';return parsed;}
function getPositions(a,b,delimit){var c=a+b[0],d=a+b[1];if(delimit){if(c<0){d+=Math.abs(c);}
if(d>100){c-=(d-100);}
return[limit(c),limit(d)];}
return[c,d];}
function fixEvent(e){e.preventDefault();var touch=e.type.indexOf('touch')===0,mouse=e.type.indexOf('mouse')===0,pointer=e.type.indexOf('pointer')===0,x,y,event=e;if(e.type.indexOf('MSPointer')===0){pointer=true;}
if(e.originalEvent){e=e.originalEvent;}
if(touch){x=e.changedTouches[0].pageX;y=e.changedTouches[0].pageY;}
if(mouse||pointer){if(!pointer&&window.pageXOffset===undefined){window.pageXOffset=document.documentElement.scrollLeft;window.pageYOffset=document.documentElement.scrollTop;}
x=e.clientX+window.pageXOffset;y=e.clientY+window.pageYOffset;}
event.points=[x,y];event.cursor=mouse;return event;}
function addHandle(direction,index){var handle=$('<div><div/></div>').addClass(Classes[2]),additions=['-lower','-upper'];if(direction){additions.reverse();}
handle.children().addClass(Classes[3]+" "+Classes[3]+additions[index]);return handle;}
function addConnection(connect,target,handles){switch(connect){case 1:target.addClass(Classes[7]);handles[0].addClass(Classes[6]);break;case 3:handles[1].addClass(Classes[6]);case 2:handles[0].addClass(Classes[7]);case 0:target.addClass(Classes[6]);break;}}
function addHandles(nrHandles,direction,base){var index,handles=[];for(index=0;index<nrHandles;index+=1){handles.push(addHandle(direction,index).appendTo(base));}
return handles;}
function addSlider(direction,orientation,target){target.addClass([Classes[0],Classes[8+direction],Classes[4+orientation]].join(' '));return $('<div/>').appendTo(target).addClass(Classes[1]);}
function closure(target,options,originalOptions){var $Target=$(target),$Locations=[-1,-1],$Base,$Handles,$Spectrum=options.spectrum,$Values=[],triggerPos=['lower','upper'].slice(0,options.handles);if(options.dir){triggerPos.reverse();}
function baseSize(){return $Base[['width','height'][options.ort]]();}
function fireEvents(events){var index,values=[$Target.val()];for(index=0;index<events.length;index+=1){$Target.trigger(events[index],values);}}
function inSliderOrder(values){if(values.length===1){return values[0];}
if(options.dir){return values.reverse();}
return values;}
function createChangeHandler(trigger){return function(ignore,value){$Target.val([trigger?null:value,trigger?value:null],true);};}
function linkUpdate(flag){var trigger=$.inArray(flag,triggerPos);if($Target[0].linkAPI&&$Target[0].linkAPI[flag]){$Target[0].linkAPI[flag].change($Values[trigger],$Handles[trigger].children(),$Target);}}//
function linkConfirm(flag,element){var trigger=$.inArray(flag,triggerPos);if(element){element.appendTo($Handles[trigger].children());}
if(options.dir&&options.handles>1){trigger=trigger===1?0:1;}
return createChangeHandler(trigger);}
function reAppendLink(){var i,flag;for(i=0;i<triggerPos.length;i+=1){if(this.linkAPI&&this.linkAPI[(flag=triggerPos[i])]){this.linkAPI[flag].reconfirm(flag);}}}
target.LinkUpdate=linkUpdate;target.LinkConfirm=linkConfirm;target.LinkDefaultFormatter=options.format;target.LinkDefaultFlag='lower';target.reappend=reAppendLink;function attach(events,element,callback,data){events=events.replace(/\s/g,namespace+' ')+namespace;return element.on(events,function(e){if(!!$Target.attr('disabled')){return false;}
if($Target.hasClass(Classes[14])){return false;}
e=fixEvent(e);e.calcPoint=e.points[options.ort];callback(e,data);});}//
function move(event,data){var handles=data.handles||$Handles,positions,state=false,proposal=((event.calcPoint-data.start)*100)/baseSize(),h=handles[0][0]!==$Handles[0][0]?1:0;positions=getPositions(proposal,data.positions,handles.length>1);state=setHandle(handles[0],positions[h],handles.length===1);if(handles.length>1){state=setHandle(handles[1],positions[h?0:1],false)||state;}
if(state){fireEvents(['slide']);}}
function end(event){$('.'+Classes[15]).removeClass(Classes[15]);if(event.cursor){$('body').css('cursor','').off(namespace);}
doc.off(namespace);$Target.removeClass(Classes[12]);fireEvents(['set','change']);}
function start(event,data){if(data.handles.length===1){data.handles[0].children().addClass(Classes[15]);}
event.stopPropagation();attach(actions.move,doc,move,{start:event.calcPoint,handles:data.handles,positions:[$Locations[0],$Locations[$Handles.length-1]]});attach(actions.end,doc,end,null);if(event.cursor){//
$('body').css('cursor',$(event.target).css('cursor'));if($Handles.length>1){$Target.addClass(Classes[12]);}
$('body').on('selectstart'+namespace,false);}}
function tap(event){var location=event.calcPoint,total=0,to;event.stopPropagation();$.each($Handles,function(){total+=this.offset()[options.style];});total=(location<total/2||$Handles.length===1)?0:1;location-=$Base.offset()[options.style];to=(location*100)/baseSize();if(!options.events.snap){addClassFor($Target,Classes[14],300);}
setHandle($Handles[total],to);fireEvents(['slide','set','change']);if(options.events.snap){start(event,{handles:[$Handles[total]]});}}
function events(behaviour){var i,drag;if(!behaviour.fixed){for(i=0;i<$Handles.length;i+=1){attach(actions.start,$Handles[i].children(),start,{handles:[$Handles[i]]});}}
if(behaviour.tap){attach(actions.start,$Base,tap,{handles:$Handles});}
if(behaviour.drag){drag=$Base.find('.'+Classes[7]).addClass(Classes[10]);if(behaviour.fixed){drag=drag.add($Base.children().not(drag).children());}
attach(actions.start,drag,start,{handles:$Handles});}}

function setHandle(handle,to,noLimitOption){var trigger=handle[0]!==$Handles[0][0]?1:0,lowerMargin=$Locations[0]+options.margin,upperMargin=$Locations[1]-options.margin,lowerLimit=$Locations[0]+options.limit,upperLimit=$Locations[1]-options.limit;if($Handles.length>1){to=trigger?Math.max(to,lowerMargin):Math.min(to,upperMargin);}
if(noLimitOption!==false&&options.limit&&$Handles.length>1){to=trigger?Math.min(to,lowerLimit):Math.max(to,upperLimit);}
to=$Spectrum.getStep(to);to=limit(parseFloat(to.toFixed(7)));if(to===$Locations[trigger]){return false;}
handle.css(options.style,to+'%');if(handle.is(':first-child')){handle.toggleClass(Classes[17],to>50);}
$Locations[trigger]=to;$Values[trigger]=$Spectrum.fromStepping(to);linkUpdate(triggerPos[trigger]);return true;}
function setValues(count,values){var i,trigger,to;if(options.limit){ count+=1;}
for(i=0;i<count;i+=1){trigger=i%2;to=values[trigger];if(to!==null&&to!==false){if(typeof to==='number'){to=String(to);}
to=options.format.from(to);if(to===false||isNaN(to)||setHandle($Handles[trigger],$Spectrum.toStepping(to),i===(3-options.dir))===false){linkUpdate(triggerPos[trigger]);}}}}
function valueSet(input){if($Target[0].LinkIsEmitting){return this;}
var count,values=asArray(input);if(options.dir&&options.handles>1){values.reverse();}
if(options.animate&&$Locations[0]!==-1){addClassFor($Target,Classes[14],300);}
count=$Handles.length>1?3:1;if(values.length===1){count=1;}
setValues(count,values);fireEvents(['set']);return this;}
function valueGet(){var i,retour=[];for(i=0;i<options.handles;i+=1){retour[i]=options.format.to($Values[i]);}
return inSliderOrder(retour);}
function destroyTarget(){$(this).off(namespace)
.removeClass(Classes.join(' '))
.empty();delete this.LinkUpdate;delete this.LinkConfirm;delete this.LinkDefaultFormatter;delete this.LinkDefaultFlag;delete this.reappend;delete this.vGet;delete this.vSet;delete this.getCurrentStep;delete this.getInfo;delete this.destroy;return originalOptions;}
function getCurrentStep(){var retour=$.map($Locations,function(location,index){var step=$Spectrum.getApplicableStep(location),stepDecimals=countDecimals(String(step[2])),value=$Values[index],increment=location===100?null:step[2],prev=Number((value-step[2]).toFixed(stepDecimals)),decrement=location===0?null:(prev>=step[1])?step[2]:(step[0]||false);return[[decrement,increment]];});//
return inSliderOrder(retour);}
function getOriginalOptions(){return originalOptions;}
if($Target.hasClass(Classes[0])){throw new Error('Slider was already initialized.');}
$Base=addSlider(options.dir,options.ort,$Target);$Handles=addHandles(options.handles,options.dir,$Base);addConnection(options.connect,$Target,$Handles);events(options.events);target.vSet=valueSet;target.vGet=valueGet;target.destroy=destroyTarget;target.getCurrentStep=getCurrentStep;target.getOriginalOptions=getOriginalOptions;target.getInfo=function(){return[$Spectrum,options.style,options.ort];};$Target.val(options.start);}
function initialize(originalOptions){var options=testOptions(originalOptions,this);return this.each(function(){closure(this,options,originalOptions);});}
function rebuild(options){return this.each(function(){if(!this.destroy){$(this).noUiSlider(options);return;}
var values=$(this).val(),originalOptions=this.destroy(),newOptions=$.extend({},originalOptions,options);//
$(this).noUiSlider(newOptions);this.reappend();if(originalOptions.start===newOptions.start){$(this).val(values);}});}
function value(){return this[0][!arguments.length?'vGet':'vSet'].apply(this[0],arguments);}
$.fn.val=function(arg){function valMethod(a){return a.hasClass(Classes[0])?value:$val;}
if(!arguments.length){var first=$(this[0]);return valMethod(first).call(first);}
var isFunction=$.isFunction(arg);return this.each(function(i){var val=arg,$t=$(this);if(isFunction){val=arg.call(this,i,$t.val());}
valMethod($t).call($t,val);});};$.fn.noUiSlider=function(options,rebuildFlag){switch(options){case 'step':return this[0].getCurrentStep();case 'options':return this[0].getOriginalOptions();}
return(rebuildFlag?rebuild:initialize).call(this,options);};function getGroup($Spectrum,mode,values,stepped){if(mode==='range'||mode==='steps'){return $Spectrum.xVal;}
if(mode==='count'){var spread=(100/(values-1)),v,i=0;values=[];//
while((v=i++*spread)<=100){values.push(v);}
mode='positions';}
if(mode==='positions'){return $.map(values,function(value){return $Spectrum.fromStepping(stepped?$Spectrum.getStep(value):value);});}
if(mode==='values'){if(stepped){return $.map(values,function(value){return $Spectrum.fromStepping($Spectrum.getStep($Spectrum.toStepping(value)));});}
return values;}}
function generateSpread($Spectrum,density,mode,group){var originalSpectrumDirection=$Spectrum.direction,indexes={},firstInRange=$Spectrum.xVal[0],lastInRange=$Spectrum.xVal[$Spectrum.xVal.length-1],ignoreFirst=false,ignoreLast=false,prevPct=0;$Spectrum.direction=0;group=unique(group.slice().sort(function(a,b){return a-b;}));if(group[0]!==firstInRange){group.unshift(firstInRange);ignoreFirst=true;}
if(group[group.length-1]!==lastInRange){group.push(lastInRange);ignoreLast=true;}
$.each(group,function(index){var step,i,q,low=group[index],high=group[index+1],newPct,pctDifference,pctPos,type,steps,realSteps,stepsize;//
if(mode==='steps'){step=$Spectrum.xNumSteps[index];}
if(!step){step=high-low;}
if(low===false||high===undefined){return;}
for(i=low;i<=high;i+=step){newPct=$Spectrum.toStepping(i);pctDifference=newPct-prevPct;steps=pctDifference/density;realSteps=Math.round(steps);stepsize=pctDifference/realSteps;for(q=1;q<=realSteps;q+=1){pctPos=prevPct+(q*stepsize);indexes[pctPos.toFixed(5)]=['x',0];}
type=($.inArray(i,group)>-1)?1:(mode==='steps'?2:0);if(!index&&ignoreFirst){type=0;}
if(!(i===high&&ignoreLast)){indexes[newPct.toFixed(5)]=[i,type];}
prevPct=newPct;}});$Spectrum.direction=originalSpectrumDirection;return indexes;}
function addMarking(CSSstyle,orientation,direction,spread,filterFunc,formatter){var style=['horizontal','vertical'][orientation],element=$('<div/>');element.addClass('noUi-pips noUi-pips-'+style);function getSize(type,value){return['-normal','-large','-sub'][type];}
function getTags(offset,source,values){return 'class="'+source+' '+
source+'-'+style+' '+
source+getSize(values[1],values[0])+
'" style="'+CSSstyle+': '+offset+'%"';}
function addSpread(offset,values){if(direction){offset=100-offset;}
values[1]=(values[1]&&filterFunc)?filterFunc(values[0],values[1]):values[1];element.append('<div '+getTags(offset,'noUi-marker',values)+'></div>');if(values[1]){element.append('<div '+getTags(offset,'noUi-value',values)+'>'+formatter.to(values[0])+'</div>');}}
$.each(spread,addSpread);return element;}
$.fn.noUiSlider_pips=function(grid){var mode=grid.mode,density=grid.density||1,filter=grid.filter||false,values=grid.values||false,format=grid.format||{to:Math.round},stepped=grid.stepped||false;return this.each(function(){var info=this.getInfo(),group=getGroup(info[0],mode,values,stepped),spread=generateSpread(info[0],density,mode,group);return $(this).append(addMarking(info[1],info[2],info[0].direction,spread,filter,format));});};}(window.jQuery||window.Zepto));