<!DOCTYPE html>
<html lang="en">
    <head>
        <title>Floor Rooms</title>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">

        <!--=====================================================-->
        <link rel="shortcut icon" type="image/x-icon" href="{$path}/externals/images/favicon.png">

        <!-- link of css -->
        <link rel="stylesheet" href="{$path}/externals/css/animate.css">
        <link rel="stylesheet" href="{$path}/externals/css/bootstrap.min.css">
        <link rel="stylesheet" href="{$path}/externals/css/bootstrap-rtl.min.css">
        <link rel="stylesheet" href="{$path}/externals/css/flip.min.css">
        <link rel="stylesheet" href="{$path}/externals/css/icofont.min.css">
        <link rel="stylesheet" href="{$path}/externals/css/lightcase.css">
        <link rel="stylesheet" href="{$path}/externals/css/swiper.min.css">
        <link rel="stylesheet" href="{$path}/externals/css/style.css">
        <link rel="stylesheet" href="{$path}/externals/css/style-rtl.css">       
        <!--========================================================-->
        <style>
            #yourTurn {
                background-color: #b1ddff;
                color: #000;
                text-align: center;
                padding: 10px;
                border-radius: 5px;
                display: none;
            }

            #passedTurn {
                background-color: #e3a8a6;
                color: #000;
                text-align: center;
                padding: 10px;
                border-radius: 5px;
                display: none;
            }
        </style>
    </head>
    <body>

        <div class="container" style="    padding: 75px 30px;">
            <div class="row justify-content-center">
                <div class="col-md-6 ">
                    <input type="hidden" id="visitDate" value="{$visitDateC}">
                    <input type="hidden" id="passed" value="{$passed}">
                    <div class="message">
                        <h3>عيادات يهب ترحب بك</h3>
                        <p>موعد الكشف الخاص بك  <br>
                            <span>{$dayName}</span> <span>{$visitDate}</span></p>
                        <p id="yourTurn" >
                            <span>   الكشف الحالى رقم : </span> <span>{$current}</span> <br>
                            <span>دورك رقم : </span> <span>{$yours}</span>
                        </p>
                        <p id="passedTurn" >زيارة قديمة </p>
                        <h6>متبقي من الزمن<br>
                            <div class="tick" data-did-init="handleTickInit" >
                                <div data-repeat="true"
                                     data-layout="horizontal center fit"
                                     data-transform="preset(d, h, m, s) -> delay">
                                    <div class="tick-group">
                                        <div data-key="value"
                                             data-repeat="true"
                                             data-transform="pad(00) -> split -> delay">
                                            <span data-view="flip"></span>
                                        </div>
                                        <span data-key="label"
                                              data-view="text"
                                              class="tick-label"></span>
                                    </div>
                                </div>

                            </div>
                        </h6>



                    </div>

                </div>
            </div>
        </div>

        <script src="{$path}/externals/js/jquery.js"></script>
        <script src="{$path}/externals/js/bootstrap.bundle.min.js"></script>
        <script src="{$path}/externals/js/isotope.pkgd.min.js"></script>
        <script src="{$path}/externals/js/lightcase.js"></script>
        <script src="{$path}/externals/js/swiper.min.js"></script>
        <script src="{$path}/externals/js/waypoints.min.js"></script>
        <script src="{$path}/externals/js/wow.min.js"></script>
        <script src="{$path}/externals/js/functions.js"></script>
        <script src="{$path}/externals/js/flip.min.js"></script>


        <script>
            function handleTickInit(tick) {
                var visitDate = $('#visitDate').val();
                var counter = Tick.count.down(visitDate);
                counter.onupdate = function (value) {
                    tick.value = value;
                };
                counter.onended = function () {
                    var passed = $('#passed').val();
                    if (passed == 1) {
                        $('#passedTurn').show();
                        $('#yourTurn').hide();
                    } else {
                        $('#yourTurn').show();
                        $('#passedTurn').hide();
                    }
                }
            }
        </script>

    </body>
</html>
