
Dropzone.options.myEndDropzone = {
    paramName: "file",
    acceptedMimeTypes: 'image/*',
    init: function () {
        this.on("sending", function (file, xhr, formData) {
            formData.append("patient_id", $('#patient_id').val());
            formData.append("endoscopy_id", $('#endoscopy_id').val());
        });
        this.on("success", function (file, response) {
            var removeButton = Dropzone.createElement("<a href='javascript:' class='btn red btn-sm btn-block remove_image_item' data-id='" + response + "'>Remove</a>");
            var _this = this;
            file.previewElement.appendChild(removeButton);
        });
    }
};

$(document).ready(function () {
    let host_url = $('#hosturl').val();

    $(".rtn-show-patient").click(function () {
        let control_name = $(this).attr("data-control");
        let patient_id = $(this).attr("data-patient-id");
        // similar behavior as an HTTP redirect
        //window.location.replace(hosturl+"/index");
        // similar behavior as clicking on a link
        window.location.href = host_url + "/controllers/" + control_name + ".php?ac=show&patientid=" + patient_id;
    });

    $('body').on('click', '.remove_image_item', function () {
        var id = $(this).attr('data-id');
        var thisElem = $(this);

        $.post(host_url + '/controllers/endoscopy.php?ac=removeImage', {id: id}, function (data) {
            console.log(data)
            thisElem.parent().remove();
        });
    })

    $("body").on('click', '.print-endoscopy', function () {
        let id = $(this).attr('data-id');
        let patient_id = $(this).attr('data-patient-id');
        $.post(host_url + '/controllers/endoscopy.php?ac=printReport', {id: id, patientId: patient_id}, function (data) {
            let $printDiv = $("#printDiv");
            $printDiv.html(data);
            $.print("#printDiv");
            $printDiv.html('');
        });

    });
})