$(document).ready(function () {

    let host_url = $('#hosturl').val();

    $('.vote-form').validate();

    // append new question in the form
    $('#append-vote-question').click(function () {
        let vote_questions_itr = $('#vote_questions_itr');
        let question_count = parseInt(vote_questions_itr.val()) + 1;
        let question_html = `
        <li class="list-group-item row">
            <div class="form-group col-md-11">
                <label class="col-md-3 control-label">Question ${question_count}</label>
                <div class="col-md-9">
                    <input type="text" class="form-control" name="question_${question_count}" required>
                </div>
            </div>
            <div class="col-md-1 pull-right">
                <button type="button" class="btn btn-sm spinner-down red remove-vote-question" data-edit-mode="0">
                    <i class="fa fa-minus"></i>
                </button>
            </div>
            <div class="form-group col-md-2">
                <label class="control-label">Answers:</label>
            </div>
            <div class="form-group col-md-2">
                <input type="text" class="form-control" placeholder="Answer 1" name="answer_1_${question_count}" value="ممتاز" required>
                <label class="col-md-11 control-label bold">Send Email
                    <span style="float: left;">
                        <input type="checkbox" class="checkGroup" value="1" name="send_mail_1_${question_count}">
                    </span>
                </label>
                <select class="form-control select2me${question_count}" required="required" name="face_1_${question_count}" data-placeholder="Select...">
                    <option value="happy" selected>&#128513; &nbsp; happy</option>
                    <option value="good">&#128523; &nbsp; good</option>
                    <option value="ok">&#128528; &nbsp; ok</option>
                    <option value="sad">&#128542; &nbsp; sad</option>
                    <option value="angry">&#128545; &nbsp; angry</option>
                </select>
            </div>
            <div class="form-group col-md-2">
                <input type="text" class="form-control" placeholder="Answer 2" name="answer_2_${question_count}" value="جيد" required>
                <label class="col-md-11 control-label bold">Send Email
                    <span style="float: left;">
                        <input type="checkbox" class="checkGroup" value="1" name="send_mail_2_${question_count}">
                    </span>
                </label>
                <select class="form-control select2me${question_count}" required="required" name="face_2_${question_count}" data-placeholder="Select...">
                    <option value="happy">&#128513; &nbsp; happy</option>
                    <option value="good" selected>&#128523; &nbsp; good</option>
                    <option value="ok">&#128528; &nbsp; ok</option>
                    <option value="sad">&#128542; &nbsp; sad</option>
                    <option value="angry">&#128545; &nbsp; angry</option>
                </select>
            </div>
            <div class="form-group col-md-2">
                <input type="text" class="form-control" placeholder="Answer 3" name="answer_3_${question_count}" value="مقبول" required>
                <label class="col-md-11 control-label bold">Send Email
                    <span style="float: left;">
                        <input type="checkbox" class="checkGroup" value="1" name="send_mail_3_${question_count}">
                    </span>
                </label>
                <select class="form-control select2me${question_count}" required="required" name="face_3_${question_count}" data-placeholder="Select...">
                    <option value="happy">&#128513; &nbsp; happy</option>
                    <option value="good">&#128523; &nbsp; good</option>
                    <option value="ok" selected>&#128528; &nbsp; ok</option>
                    <option value="sad">&#128542; &nbsp; sad</option>
                    <option value="angry">&#128545; &nbsp; angry</option>
                </select>
            </div>
            <div class="form-group col-md-2">
                <input type="text" class="form-control" placeholder="Answer 4" name="answer_4_${question_count}" value="غير راضي">
                <label class="col-md-11 control-label bold">Send Email
                    <span style="float: left;">
                        <input type="checkbox" class="checkGroup" value="1" name="send_mail_4_${question_count}">
                    </span>
                </label>
                <select class="form-control select2me${question_count}" name="face_4_${question_count}" data-placeholder="Select...">
                    <option></option>
                    <option value="happy">&#128513; &nbsp; happy</option>
                    <option value="good">&#128523; &nbsp; good</option>
                    <option value="ok">&#128528; &nbsp; ok</option>
                    <option value="sad" selected>&#128542; &nbsp; sad</option>
                    <option value="angry">&#128545; &nbsp; angry</option>
                </select>
            </div>
            <div class="form-group col-md-2">
                <input type="text" class="form-control" placeholder="Answer 5" name="answer_5_${question_count}" value="غاضب جدا">
                <label class="col-md-11 control-label bold">Send Email
                    <span style="float: left;">
                        <input type="checkbox" class="checkGroup" value="1" name="send_mail_5_${question_count}">
                    </span>
                </label>
                <select class="form-control select2me${question_count}" name="face_5_${question_count}" data-placeholder="Select...">
                    <option></option>
                    <option value="happy">&#128513; &nbsp; happy</option>
                    <option value="good">&#128523; &nbsp; good</option>
                    <option value="ok">&#128528; &nbsp; ok</option>
                    <option value="sad">&#128542; &nbsp; sad</option>
                    <option value="angry" selected>&#128545; &nbsp; angry</option>
                </select>
            </div>
        </li>
        `;
        $('#vote_question_container').append(question_html);
        vote_questions_itr.val(question_count);
        $('.checkGroup').uniform();
        $('.select2me'+question_count).select2({
            placeholder: "Select",
            width: 'auto',
            allowClear: true
        });
    });

    // remove vote question
    $(document).on('click', '.remove-vote-question', function () {
        let edit_mode = $(this).attr('data-edit-mode');
        if (parseInt(edit_mode) === 1) {
            let question_id = $(this).attr('data-question-id');
            $.post(host_url + '/controllers/vote.php?ac=removeQuestion', {question_id: question_id}, function (data) {
                let title;
                let msg;
                let shortCutFunction;
                if (parseInt(data) === 1) {
                    shortCutFunction = 'success';
                    msg = 'Question removed successfully';
                    title = 'Success';
                } else {
                    shortCutFunction = 'error';
                    msg = 'Something went wrong';
                    title = 'Error';

                }
                toastr.options = {
                    closeButton: true,
                    positionClass: 'toast-top-right',
                    onclick: null
                };
                toastr[shortCutFunction](msg, title);
            })
        }
        $(this).parent().parent().remove();
    });

    // see client_vote_contact is checked or not
    $(document).on('change', '.client_vote_contact', function () {
        let vote_id = $(this).attr('data-vote-id');
        let is_contact = $(this).is(':checked');
        $.post(host_url + '/controllers/vote.php?ac=updateClientVoteContact', {vote_id: vote_id, is_contact: is_contact});
    });

    // save vote reply keyup
    $(document).on('keyup', '.client_vote_reply', function () {
        let vote_id = $(this).attr('data-vote-id');
        let reply = $(this).val();
        $.post(host_url + '/controllers/vote.php?ac=updateVoteReply', {vote_id: vote_id, reply: reply});
    });

});