<?php

require_once("imp/_imp.php");

class Controllers
{
    public $smarty;
    public $hostUrl;
    public $controlName;
    public $displayControlName;
    public $active;
    public $time;
    public $today;
    public $patientId;

    public function __construct()
    {
        require_once("../public/aw_config.php");
        require_once("imp/_autho.php"); //general functions
        $this->smarty = $smarty;
        $this->hostUrl = $hosturl;

        //here name of control to known
        $this->controlName = 'tanks';
        $this->displayControlName = 'tanks';
        $this->smarty->assign('controllname', $this->controlName);
        $this->smarty->assign('shcontrollname', $this->displayControlName);


        //breadcrumbs
        require_once("../../_library/plugins/Breadcrumbs/Breadcrumbs.php");
        $acty = filter_input(INPUT_GET, 'ac');
        $bc = new breadcrumbs($hosturl, '', '', $acty);
        $bc->crumbs();
        $breadcrumbs = $bc->breadcrumbs;
        $smarty->assign('breadcrumbs', $breadcrumbs);

        # here show the active page in menu
        // array called active[] with level of active element
        $active[0] = 'tanks'; //controller name or tab name
        $active[1] = 'tanks'; //controller name
        // do name  // switch($do)
        switch ($acty) {
            case '':
                $active[2] = 'tanksadd';
                break;
            default:
                $active[2] = 'tanksshow';
                break;
        }
        $this->active = $active;

        R::ext('xdispense', function ($type) {
            return R::getRedBean()->dispense($type);
        });

        //here will call all php pages
        require_once("_header.php");
        require_once("_patientdata.php");
        require_once("_sidebar.php");
        require_once("_leftsidebar.php");
        require_once("_footer.php");

        $this->patientId = patientdata::patientid();

        //find loading time
        $this->time = microtime(true);
        $this->today = date('Y-m-d');
    }

    public function index()
    {
        autho::checkautho($this->hostUrl);
        autho::checkauthoize($this->controlName, $this->hostUrl, $_SESSION['role_id']);

        $patientId = filter_input(INPUT_GET, "patientid");
        $this->smarty->assign('patientId', $patientId);

        //call other class with other content
        header::headershow($this->smarty, $this->hostUrl);
        sidebar::sidebarshow($this->smarty, $this->hostUrl, $this->active);
        if ($patientId) {
            patientdata::patientdatashow($this->smarty, $this->hostUrl);
        }
        $this->smarty->display('tanks/add.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hostUrl);
        footer::footershow($this->smarty, $this->hostUrl);
    }

    public function add()
    {
        autho::checkautho($this->hostUrl);
        autho::checkauthoize($this->controlName, $this->hostUrl, $_SESSION['role_id']);

        $name = filter_input(INPUT_POST, 'name');
        $tankType = filter_input(INPUT_POST, 'tank_type');

        try {
            R::begin();

            $tank = R::dispense('tanks');
            $tank->name = $name;
            $tank->tank_type = $tankType;
            $id = R::store($tank);

            // Create cells based on tank type
            switch ((int)$tankType) {
                case 1:
                case 2:
                    $this->createTankCells($id, 10, 20, 5);
                    break;
                case 3:
                    $this->createTankCells($id, 10, 30, 10);
                    break;
            }

            R::commit();

            header('Location:' . $this->hostUrl . '/controllers/' . $this->controlName . '.php?ac=show');
        } catch (Exception $e) {
            R::rollback();
            header('Location:' . $this->hostUrl . '/controllers/error.php?ac=notadd&id=' . $this->controlName);
        }
    }

    // Function to create tank cells
    protected function createTankCells($tankId, $upLevels, $cells, $parts)
    {
        $tankCells = [];
        $currentTime = date('Y-m-d H:i:s');

        for ($i = 1; $i <= $upLevels; $i++) {
            for ($x = 1; $x <= $cells; $x++) {
                for ($y = 1; $y <= $parts; $y++) {
                    $tank_cell = R::xdispense('tank_cells');
                    $tank_cell->tank_id = $tankId;
                    $tank_cell->up_level_name = $i;
                    $tank_cell->cell_name = $x;
                    $tank_cell->cell_part_name = $y;
                    $tank_cell->patient_id = 0;
                    $tank_cell->created_at = $currentTime;
                    $tankCells[] = $tank_cell;
                }
            }
        }

        R::storeAll($tankCells);
    }

    public function show()
    {
        autho::checkautho($this->hostUrl);
        autho::checkauthoize($this->controlName, $this->hostUrl, $_SESSION['role_id']);

        $tanks = R::findAll('tanks');
        $this->smarty->assign('tanks', $tanks);

        $patientId = filter_input(INPUT_GET, "patientid");
        $this->smarty->assign('patientId', $patientId);

        header::headershow($this->smarty, $this->hostUrl);
        sidebar::sidebarshow($this->smarty, $this->hostUrl, $this->active);
        if ($patientId) {
            patientdata::patientdatashow($this->smarty, $this->hostUrl);
        }
        $this->smarty->display('tanks/show.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hostUrl);
        footer::footershow($this->smarty, $this->hostUrl);
    }

    public function edit()
    {
        autho::checkautho($this->hostUrl);
        autho::checkauthoize($this->controlName, $this->hostUrl, $_SESSION['role_id']);

        $id = filter_input(INPUT_GET, 'id');
        $patientId = filter_input(INPUT_GET, "patientid");

        $tank = R::load('tanks', $id);
        $this->smarty->assign('tank', $tank);

        header::headershow($this->smarty, $this->hostUrl);
        sidebar::sidebarshow($this->smarty, $this->hostUrl, $this->active);
        if ($patientId) {
            patientdata::patientdatashow($this->smarty, $this->hostUrl);
        }
        $this->smarty->display('tanks/edit.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hostUrl);
        footer::footershow($this->smarty, $this->hostUrl);
    }

    public function update()
    {
        autho::checkautho($this->hostUrl);
        autho::checkauthoize($this->controlName, $this->hostUrl, $_SESSION['role_id']);

        $name = filter_input(INPUT_POST, 'name');

        $id = filter_input(INPUT_POST, 'id');
        $patientId = filter_input(INPUT_GET, "patientid");
        $this->smarty->assign('patientId', $patientId);

        try {
            $tank = R::load('tanks', $id);
            $tank->name = $name;
            R::store($tank);

            header('Location:' . $this->hostUrl . '/controllers/' . $this->controlName . '.php?ac=show');
        } catch (Exception $e) {
            header('Location:' . $this->hostUrl . '/controllers/error.php?ac=notupdate&id=' . $this->controlName);
        }
    }

    /*public function cells()
    {
        autho::checkautho($this->hostUrl);
        autho::checkauthoize($this->controlName, $this->hostUrl, $_SESSION['role_id']);

        $id = filter_input(INPUT_GET, 'id');
        $patientId = filter_input(INPUT_GET, "patientid");

        $tank = R::load('tanks', $id);
        $this->smarty->assign('tank', $tank);

        if ((int)$tank->tank_type === 1) {
            // get main level --- with 4 down cell as 1 cell # 20 cell max
            $levels = R::getAll('SELECT DISTINCT up_level_name FROM tank_cells where tank_id = ?', [$id]);
            foreach ($levels as &$level) {
                $leve_full = 0;
                // get second level
                $sec_levels = R::getAll('SELECT DISTINCT cell_name FROM tank_cells where up_level_name = ? and tank_id = ?', [$level['up_level_name'], $id]);
                foreach ($sec_levels as &$sec_level) {
                    $sec_level_full = 0;
                    // get 3rd level
                    $third_levels = R::getAll('SELECT cell_part_name,patient_id,id,tank_id FROM tank_cells where cell_name = ? and up_level_name = ? and tank_id = ?',
                        [$sec_level['cell_name'], $level['up_level_name'], $id]);
                    $sec_level['third_levels'] = $third_levels;

                    $sec_level['patient_id'] = 0;

                    foreach ($third_levels as $third_level) {
                        if ($third_level['patient_id'] > 0) {
                            // there are patient
                            ++$sec_level_full;
                            $sec_level['patient_id'] = $third_level['patient_id'];
                        }
                    }
                    $sec_level['full'] = $sec_level_full;

                    if ($sec_level_full > 0) {
                        ++$leve_full;
                    }

                }
                unset($sec_level);
                $level['sec_levels'] = $sec_levels;
                $level['sec_total'] = 5;
                $level['full'] = $leve_full;
            }
            unset($level);
            $this->smarty->assign('levels', $levels);
            $this->smarty->assign('total_cells', 20);
        }

        if ((int)$tank->tank_type === 2) {
            // get main level --- with 4 down cell as 1 cell # 20 cell max
            $levels = R::getAll('SELECT DISTINCT up_level_name FROM tank_cells where tank_id = ?', [$id]);
            foreach ($levels as &$level) {
                $leve_full = 0;
                // get second level
                $sec_levels = R::getAll('SELECT DISTINCT cell_name FROM tank_cells where up_level_name = ? and tank_id = ?', [$level['up_level_name'], $id]);
                foreach ($sec_levels as &$sec_level) {
                    $sec_level_full = 0;
                    // get 3rd level
                    $third_levels = R::getAll('SELECT cell_part_name,patient_id,id,tank_id FROM tank_cells where cell_name = ? and up_level_name = ? and tank_id = ?',
                        [$sec_level['cell_name'], $level['up_level_name'], $id]);
                    $sec_level['third_levels'] = $third_levels;

                    $sec_level['patient_id'] = 0;

                    foreach ($third_levels as $third_level) {
                        if ($third_level['patient_id'] > 0) {
                            // there are patient
                            ++$sec_level_full;
                            ++$leve_full;
                            $sec_level['patient_id'] = $third_level['patient_id'];
                        }
                    }
                    $sec_level['full'] = $sec_level_full;

                }
                unset($sec_level);
                $level['sec_levels'] = $sec_levels;
                $level['sec_total'] = 5;
                $level['full'] = $leve_full;
            }
            unset($level);
            $this->smarty->assign('levels', $levels);
            $this->smarty->assign('total_cells', 100);
        }

        if ((int)$tank->tank_type === 3) {
            // get main level --- with 4 down cell as 1 cell # 20 cell max
            $levels = R::getAll('SELECT DISTINCT up_level_name FROM tank_cells where tank_id = ?', [$id]);
            foreach ($levels as &$level) {
                $leve_full = 0;
                // get second level
                $sec_levels = R::getAll('SELECT DISTINCT cell_name FROM tank_cells where up_level_name = ? and tank_id = ?', [$level['up_level_name'], $id]);
                foreach ($sec_levels as &$sec_level) {
                    $sec_level_full = 0;
                    // get 3rd level
                    $third_levels = R::getAll('SELECT tank_cells.cell_part_name,tank_cells.patient_id,tank_cells.id,tank_cells.tank_id,patients.wifename FROM tank_cells
                                            inner join patients on patients.id = tank_cells.patient_id
                                            where tank_cells.cell_name = ? and tank_cells.up_level_name = ? and tank_cells.tank_id = ?',
                        [$sec_level['cell_name'], $level['up_level_name'], $id]);
                    $sec_level['third_levels'] = $third_levels;

                    $sec_level['patient_id'] = 0;

                    foreach ($third_levels as $third_level) {
                        if ($third_level['patient_id'] > 0) {
                            // there are patient
                            ++$sec_level_full;
                            ++$leve_full;
                            $sec_level['patient_id'] = $third_level['patient_id'];
                        }
                    }
                    $sec_level['full'] = $sec_level_full;

                }
                unset($sec_level);
                $level['sec_levels'] = $sec_levels;
                $level['sec_total'] = 10;
                $level['full'] = $leve_full;
            }
            unset($level);
            $this->smarty->assign('levels', $levels);
            $this->smarty->assign('total_cells', 300);
        }

        //call other class with other content
        header::headershow($this->smarty, $this->hostUrl);
        sidebar::sidebarshow($this->smarty, $this->hostUrl, $this->active);
        if ($patientId) {
            patientdata::patientdatashow($this->smarty, $this->hostUrl);
        }
        $this->smarty->display('tanks/cells.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hostUrl);
        footer::footershow($this->smarty, $this->hostUrl);
    }*/

    // Helper function to get third levels
    private function getThirdLevels($secLevel, $upLevelName, $tankId)
    {
        $thirdLevels = R::getAll(
            '
        SELECT 
            tank_cells.cell_part_name,
            tank_cells.tank_txt, 
            tank_cells.cell_color, 
            tank_cells.patient_id, 
            tank_cells.control_name, 
            tank_cells.id, 
            tank_cells.tank_id, 
            patients.wifename,
            patients.husdandname
        FROM 
            tank_cells 
        LEFT JOIN 
            patients 
        ON 
            tank_cells.patient_id = patients.id 
        WHERE 
            tank_cells.cell_name = ? 
            AND tank_cells.up_level_name = ? 
            AND tank_cells.tank_id = ?
        ORDER BY tank_cells.cell_part_name ASC',
            [$secLevel, $upLevelName, $tankId]
        );
        $secLevelFull = 0;
        $thirdCount = count($thirdLevels);
        foreach ($thirdLevels as $thirdLevel) {
            if ($thirdLevel['patient_id'] > 0) {
                ++$secLevelFull;
            }
        }
        return [$thirdLevels, $secLevelFull, $thirdCount];
    }

    // Helper function to get second levels
    private function getSecondLevels($upLevelName, $tankId)
    {
        $secLevels = R::getAll('SELECT DISTINCT cell_name FROM tank_cells WHERE up_level_name = ? AND tank_id = ?', [$upLevelName, $tankId]);
        $leveFull = 0;
        $allThirdCount = 0;
        foreach ($secLevels as &$secLevel) {
            $returnedData = $this->getThirdLevels($secLevel['cell_name'], $upLevelName, $tankId);
            $thirdLevels = $returnedData[0];
            $secLevelFull  = $returnedData[1];
            $thirdCount = $returnedData[2];
            $secLevel['third_levels'] = $thirdLevels;
            $secLevel['patient_id'] = $secLevelFull > 0 ? $thirdLevels[0]['patient_id'] : 0;
            $secLevel['full'] = $secLevelFull;
            if ($secLevelFull > 0) {
                ++$leveFull;
                $allThirdCount = $allThirdCount + $secLevelFull;
            }
        }
        unset($secLevel);
        return [$secLevels, $leveFull, $allThirdCount];
    }

    // Refactored getLevels function
    private function getLevels($tankId, $tankType)
    {
        $levels = R::getAll('SELECT DISTINCT up_level_name FROM tank_cells WHERE tank_id = ?', [$tankId]);
        foreach ($levels as &$level) {
            list($secLevels, $leveFull, $thirdCount) = $this->getSecondLevels($level['up_level_name'], $tankId);
            $level['sec_levels'] = $secLevels;
            $level['sec_total'] = $tankType === 3 ? 10 : 5;
            $level['full'] = $leveFull;
            $level['third_full'] = $thirdCount;
        }
        unset($level);
        return $levels;
    }

    private function assignLevelsToSmarty($levels, $totalCells)
    {
        $this->smarty->assign('levels', $levels);
        $this->smarty->assign('total_cells', $totalCells);
    }

    public function cells()
    {
        autho::checkautho($this->hostUrl);
        autho::checkauthoize($this->controlName, $this->hostUrl, $_SESSION['role_id']);

        $id = filter_input(INPUT_GET, 'id');
        $patientId = filter_input(INPUT_GET, "patientid");

        $tank = R::load('tanks', $id);
        $this->smarty->assign('tank', $tank);

        $levels = [];
        $totalCells = 0;

        switch ((int)$tank->tank_type) {
            case 1:
                $levels = $this->getLevels($id, 1);
                $totalCells = 20;
                break;
            case 2:
                $levels = $this->getLevels($id, 2);
                $totalCells = 100;
                break;
            case 3:
                $levels = $this->getLevels($id, 3);
                $totalCells = 300;
                break;
        }

        $this->assignLevelsToSmarty($levels, $totalCells);

        header::headershow($this->smarty, $this->hostUrl);
        sidebar::sidebarshow($this->smarty, $this->hostUrl, $this->active);
        if ($patientId) {
            patientdata::patientdatashow($this->smarty, $this->hostUrl);
        }
        $this->smarty->display('tanks/cells.html.tpl');
        leftsidebar::leftsidebarshow($this->smarty, $this->hostUrl);
        footer::footershow($this->smarty, $this->hostUrl);
    }

    public function del()
    {
        autho::checkautho($this->hostUrl);
        autho::checkauthoize($this->controlName, $this->hostUrl, $_SESSION['role_id']);

        $id = filter_input(INPUT_POST, 'id');
        try {
            $tank = R::findOne('tanks', 'id = ?', [$id]);
            R::trash($tank);
            $tank_cells = R::findAll('tank_cells', 'tank_id = ?', [$id]);
            R::trashAll($tank_cells);
            echo 1;
        } catch (Exception $e) {
            echo 0;
        }
    }

    public function removePatientCell()
    {
        autho::checkautho($this->hostUrl);

        $cell_id = filter_input(INPUT_POST, 'cell_id');
        try {
            $remove = R::findOne('tank_cells', 'id = ?', [$cell_id]);
            if ($remove) {
                // add to history
                $cell_history = R::dispense('tankcellhistory');
                $cell_history->tank_id = $remove->tank_id;
                $cell_history->cell_id = $remove->id;
                $cell_history->patient_id = $remove->patient_id;
                $cell_history->action_type = 'Remove patient';
                $cell_history->done_date = date('Y-m-d H:i:s');
                $cell_history->by_user_id = $_SESSION['user_id'];
                R::store($cell_history);

                $remove->patient_id = 0;
                R::store($remove);
                echo true;
            } else {
                echo false;
            }
        } catch (Exception $exception) {
            echo false;
        }
    }

    /*public function tankLabCells()
    {

        //check login
        autho::checkautho($this->hostUrl);

        //get id for item
        $id = filter_input(INPUT_POST, 'tank_id');
        $patient_id = filter_input(INPUT_POST, "patient_id");

        //load all here
        $tank = R::load('tanks', $id);
        $this->smarty->assign('tank', $tank);

        $total_cells = 100;

        if ((int)$tank->tank_type === 1) {
            // get main level --- with 4 down cell as 1 cell # 20 cell max
            $levels = R::getAll('SELECT DISTINCT up_level_name FROM tank_cells where tank_id = ?', [$id]);
            foreach ($levels as &$level) {
                $leve_full = 0;
                // get second level
                $sec_levels = R::getAll('SELECT DISTINCT cell_name FROM tank_cells where up_level_name = ? and tank_id = ?', [$level['up_level_name'], $id]);
                foreach ($sec_levels as &$sec_level) {
                    $sec_level_full = 0;
                    // get 3rd level
                    $third_levels = R::getAll('SELECT cell_part_name,patient_id,id,tank_id FROM tank_cells where cell_name = ? and up_level_name = ? and tank_id = ?',
                        [$sec_level['cell_name'], $level['up_level_name'], $id]);
                    $sec_level['third_levels'] = $third_levels;

                    $sec_level['patient_id'] = 0;

                    foreach ($third_levels as $third_level) {
                        if ($third_level['patient_id'] > 0) {
                            // there are patient
                            ++$sec_level_full;
                            $sec_level['patient_id'] = $third_level['patient_id'];
                        }
                    }
                    $sec_level['full'] = $sec_level_full;

                    if ($sec_level_full > 0) {
                        ++$leve_full;
                    }

                }
                unset($sec_level);
                $level['sec_levels'] = $sec_levels;
                $level['sec_total'] = 5;
                $level['full'] = $leve_full;
                //$tank_cells[] = $level;
            }
            unset($level);
            //print_r($tank_cells);
            $this->smarty->assign('levels', $levels);
            $this->smarty->assign('total_cells', 20);
        }

        if ((int)$tank->tank_type === 2) {
            // get main level --- with 4 down cell as 1 cell # 20 cell max
            $levels = R::getAll('SELECT DISTINCT up_level_name FROM tank_cells where tank_id = ?', [$id]);
            foreach ($levels as &$level) {
                $leve_full = 0;
                // get second level
                $sec_levels = R::getAll('SELECT DISTINCT cell_name FROM tank_cells where up_level_name = ? and tank_id = ?', [$level['up_level_name'], $id]);
                foreach ($sec_levels as &$sec_level) {
                    $sec_level_full = 0;
                    // get 3rd level
                    $third_levels = R::getAll('SELECT cell_part_name,patient_id,id,tank_id FROM tank_cells where cell_name = ? and up_level_name = ? and tank_id = ?',
                        [$sec_level['cell_name'], $level['up_level_name'], $id]);
                    $sec_level['third_levels'] = $third_levels;

                    $sec_level['patient_id'] = 0;

                    foreach ($third_levels as $third_level) {
                        if ($third_level['patient_id'] > 0) {
                            // there are patient
                            ++$sec_level_full;
                            ++$leve_full;
                            $sec_level['patient_id'] = $third_level['patient_id'];
                        }
                    }
                    $sec_level['full'] = $sec_level_full;

                }
                unset($sec_level);
                $level['sec_levels'] = $sec_levels;
                $level['sec_total'] = 5;
                $level['full'] = $leve_full;
            }
            unset($level);
            $this->smarty->assign('levels', $levels);
            $this->smarty->assign('total_cells', 100);
        }

        if ((int)$tank->tank_type === 3) {
            // get main level --- with 4 down cell as 1 cell # 20 cell max
            $levels = R::getAll('SELECT DISTINCT up_level_name FROM tank_cells where tank_id = ?', [$id]);
            foreach ($levels as &$level) {
                $leve_full = 0;
                // get second level
                $sec_levels = R::getAll('SELECT DISTINCT cell_name FROM tank_cells where up_level_name = ? and tank_id = ?', [$level['up_level_name'], $id]);
                foreach ($sec_levels as &$sec_level) {
                    $sec_level_full = 0;
                    // get 3rd level
                    $third_levels = R::getAll('SELECT cell_part_name,patient_id,id,tank_id FROM tank_cells where cell_name = ? and up_level_name = ? and tank_id = ?',
                        [$sec_level['cell_name'], $level['up_level_name'], $id]);
                    $sec_level['third_levels'] = $third_levels;

                    $sec_level['patient_id'] = 0;

                    foreach ($third_levels as $third_level) {
                        if ($third_level['patient_id'] > 0) {
                            // there are patient
                            ++$sec_level_full;
                            ++$leve_full;
                            $sec_level['patient_id'] = $third_level['patient_id'];
                        }
                    }
                    $sec_level['full'] = $sec_level_full;

                }
                unset($sec_level);
                $level['sec_levels'] = $sec_levels;
                $level['sec_total'] = 10;
                $level['full'] = $leve_full;
                $total_cells = 300;
            }
            unset($level);
            $this->smarty->assign('levels', $levels);
            $this->smarty->assign('total_cells', $total_cells);
        }

        $this->smarty->display('tanks/lab_cells.html.tpl');
    }*/

    // Refactored tankLabCells function
    public function tankLabCells()
    {
        autho::checkautho($this->hostUrl);

        $id = filter_input(INPUT_POST, 'tank_id');
        $patientId = filter_input(INPUT_POST, "patient_id");

        $tank = R::load('tanks', $id);
        $this->smarty->assign('tank', $tank);

        $totalCells = 0;
        $levels = [];

        switch ((int)$tank->tank_type) {
            case 1:
                $levels = $this->getLevels($id, 1);
                $totalCells = 20;
                break;
            case 2:
                $levels = $this->getLevels($id, 2);
                $totalCells = 100;
                break;
            case 3:
                $levels = $this->getLevels($id, 3);
                $totalCells = 300;
                break;
        }

        $this->smarty->assign('levels', $levels);
        $this->smarty->assign('total_cells', $totalCells);

        $colors = R::findAll('colors');
        $this->smarty->assign('colors', $colors);

        $this->smarty->display('tanks/lab_cells.html.tpl');
    }

    public function saveTankLabCell()
    {
        autho::checkautho($this->hostUrl);

        $res = false;
        try {
            $tank_id = filter_input(INPUT_POST, 'lab_tank_id');
            $up_level_name = filter_input(INPUT_POST, 'up_level_name');
            $cell_name = filter_input(INPUT_POST, 'cell_name');
            $lab_patient_id = filter_input(INPUT_POST, 'lab_patient_id');
            $last_cells = $_POST['last_cell'];
            $color = filter_input(INPUT_POST, 'cell_color');
            $tank_txt = filter_input(INPUT_POST, 'tank_txt');
            //$controlId = filter_input(INPUT_POST, 'control_id');
            $controlName = filter_input(INPUT_POST, 'control_name');
            $assignAt = filter_input(INPUT_POST, 'assignAt');

            //ray("tank id = $tank_id --> up level = $up_level_name --> cell name = $cell_name --> last level = $last_cells --> patient id = $lab_patient_id --> color = $color");
            //R::debug(true);

            $cells = explode(',', $last_cells);
            foreach ($cells as $cell) {
                $tankCell = R::findOne('tank_cells', 'tank_id = ? AND up_level_name = ? AND cell_name = ? AND cell_part_name = ?', [$tank_id, $up_level_name, $cell_name, $cell]);
                if ($tankCell && $tankCell->patient_id < 1) {
                    $tankCell->patient_id = $lab_patient_id;
                    $tankCell->cell_color = $color;
                    $tankCell->tank_txt = $tank_txt;
                    $tankCell->control_name = $controlName;
                    if($assignAt) {
                        $tankCell->assign_at = $assignAt;
                    }else{
                        $tankCell->assign_at = date('Y-m-d H:i:s');
                    }
                    //$tankCell->control_id = $controlId;
                    R::store($tankCell);

                    // add to history
                    $cell_history = R::dispense('tankcellhistory');
                    $cell_history->tank_id = $tank_id;
                    $cell_history->cell_id = $tankCell->id;
                    $cell_history->patient_id = $lab_patient_id;
                    $cell_history->action_type = 'Add patient';
                    $cell_history->done_date = date('Y-m-d H:i:s');
                    $cell_history->by_user_id = $_SESSION['user_id'];
                    R::store($cell_history);

                    $res = true;
                }
            }
        } catch (Exception $exception) {
            $res = false;
        }
        echo $res;
    }

    public function __destruct()
    {
        R::close();
    }
}
