<?php

require_once("imp/_imp.php");

class Controllers
{
    public $smarty;
    public $hosturl;
    public $controllname;
    public $shcontrollname;
    public $active;
    public $time;
    public $today;

    public function __construct()
    {
        require_once("../public/aw_config.php");
        require_once("imp/_autho.php");
        /** @var $smarty
         * @var $hosturl
         */
        $this->smarty = $smarty;
        $this->hosturl = $hosturl;

        $this->controllname = 'hystroscopic';
        $this->shcontrollname = 'Hystroscopic';
        $this->smarty->assign('controllname', $this->controllname);
        $this->smarty->assign('shcontrollname', $this->shcontrollname);

        require_once("../../_library/plugins/Breadcrumbs/Breadcrumbs.php");
        $acty = filter_input(INPUT_GET, 'ac');
        $bc = new breadcrumbs($hosturl, '', '', $acty);
        $bc->crumbs();
        $breadcrumbs = $bc->breadcrumbs;
        $smarty->assign('breadcrumbs', $breadcrumbs);

        $active[0] = 'hystroscopic';
        $active[1] = 'hystroscopic';
        switch ($acty) {
            case '':
                $active[2] = 'hystroscopicadd';
                break;
            default :
                $active[2] = 'hystroscopicshow';
                break;
        }
        $this->active = $active;

        require_once("_header.php");
        require_once("_patientdata.php");
        require_once("_sidebar.php");
        require_once("_leftsidebar.php");
        require_once("_footer.php");

        $this->time = microtime(true);
        $this->today = date('Y-m-d');
    }

    public function index()
    {
        autho::checkautho($this->hosturl);
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('hystroscopic/add.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function add()
    {
        autho::checkautho($this->hosturl);
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $row = R::dispense('hystroscopic');
        $row->template_name = filter_input(INPUT_POST,'template_name');
        $row->entry = filter_input(INPUT_POST, 'entry');
        $row->entry_procedures = filter_input(INPUT_POST, 'entry_procedures');
        $row->external_os = filter_input(INPUT_POST,'external_os');
        $row->external_os_procedures = filter_input(INPUT_POST,'external_os_procedures');
        $row->cervical_canal = filter_input(INPUT_POST,'cervical_canal');
        $row->cervical_canal_procedures = filter_input(INPUT_POST,'cervical_canal_procedures');
        $row->internal_os= filter_input(INPUT_POST,'internal_os');
        $row->internal_os_procedures= filter_input(INPUT_POST,'internal_os_procedures');
        $row->uterine_cavity= filter_input(INPUT_POST,'uterine_cavity');
        $row->uterine_cavity_procedures= filter_input(INPUT_POST,'uterine_cavity_procedures');
        $row->endometrium = filter_input(INPUT_POST,'endometrium');
        $row->endometrium_procedures = filter_input(INPUT_POST,'endometrium_procedures');
        $row->right_ostium = filter_input(INPUT_POST,'right_ostium');
        $row->right_ostium_procedures = filter_input(INPUT_POST,'right_ostium_procedures');
        $row->left_ostium = filter_input(INPUT_POST,'left_ostium');
        $row->left_ostium_procedures = filter_input(INPUT_POST,'left_ostium_procedures');
        $row->recommendations = filter_input(INPUT_POST,'recommendations');
        $row->other = filter_input(INPUT_POST,'other');
        $row->other_procedures = filter_input(INPUT_POST,'other_procedures');
        try {
            R::store($row);
            header('Location:' . $this->hosturl . '/controllers/' . $this->controllname . '.php?ac=show');
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/error/notadd/' . $this->controllname);
        }
    }

    public function show()
    {
        autho::checkautho($this->hosturl);
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $hystroscopic = R::findAll('hystroscopic');
        $this->smarty->assign('hystroscopic', $hystroscopic);

        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('hystroscopic/show.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function edit()
    {
        autho::checkautho($this->hosturl);
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $id = filter_input(INPUT_GET, 'id');
        $hystroscopic = R::load('hystroscopic', $id);
        $this->smarty->assign('hystroscopic', $hystroscopic);

        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('hystroscopic/edit.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function render()
    {
        autho::checkautho($this->hosturl);

        $id = filter_input(INPUT_POST, 'template_id');
        $hystroscopic = R::getRow('select * from hystroscopic where id = ?', [$id]);

        echo json_encode($hystroscopic);
    }

    public function update()
    {
        autho::checkautho($this->hosturl);
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $id = filter_input(INPUT_POST, 'id');

        $row = R::load('hystroscopic', $id);
        $row->template_name = filter_input(INPUT_POST,'template_name');
        $row->entry = filter_input(INPUT_POST, 'entry');
        $row->entry_procedures = filter_input(INPUT_POST, 'entry_procedures');
        $row->external_os = filter_input(INPUT_POST,'external_os');
        $row->external_os_procedures = filter_input(INPUT_POST,'external_os_procedures');
        $row->cervical_canal = filter_input(INPUT_POST,'cervical_canal');
        $row->cervical_canal_procedures = filter_input(INPUT_POST,'cervical_canal_procedures');
        $row->internal_os= filter_input(INPUT_POST,'internal_os');
        $row->internal_os_procedures= filter_input(INPUT_POST,'internal_os_procedures');
        $row->uterine_cavity= filter_input(INPUT_POST,'uterine_cavity');
        $row->uterine_cavity_procedures= filter_input(INPUT_POST,'uterine_cavity_procedures');
        $row->endometrium = filter_input(INPUT_POST,'endometrium');
        $row->endometrium_procedures = filter_input(INPUT_POST,'endometrium_procedures');
        $row->right_ostium = filter_input(INPUT_POST,'right_ostium');
        $row->right_ostium_procedures = filter_input(INPUT_POST,'right_ostium_procedures');
        $row->left_ostium = filter_input(INPUT_POST,'left_ostium');
        $row->left_ostium_procedures = filter_input(INPUT_POST,'left_ostium_procedures');
        $row->recommendations = filter_input(INPUT_POST,'recommendations');
        $row->other = filter_input(INPUT_POST,'other');
        $row->other_procedures = filter_input(INPUT_POST,'other_procedures');
        try {
            R::store($row);
            header('Location:' . $this->hosturl . '/controllers/' . $this->controllname . '.php?ac=show');
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/error/notupdate/' . $this->controllname);
        }
    }

    public function del()
    {
        autho::checkautho($this->hosturl);
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $id = filter_input(INPUT_POST, 'id');
        try {
            $item = R::findOne('hystroscopic', 'id = ?', [$id]);
            R::trash($item);
            echo 1;
        } catch (Exception $e) {
            echo 0;
        }
    }

    public function __destruct()
    {
        R::close();
    }

}
