<?php

/*
 * awframework from aw.inc present aw controller
 * it will help you develop easy and fast with secure tools
 * you can edit and add what you feel right
 * don't change in structure of file
 */

use RedBeanPHP\RedException;

require_once("imp/_imp.php");

/**
 * @class calendar
 */
class Controllers
{

    //public vars
    public $smarty;
    public $host_url;
    public $controlName;
    public $active;
    public $patientId;

    /**
     * @throws RedException
     */
    public function __construct()
    {
        require_once('../public/aw_config.php');
        require_once("imp/_autho.php"); //general functions
        /** @var $smarty
         * @var $hosturl
         */
        $this->smarty = $smarty;
        $this->host_url = $hosturl;

        require_once("../../_library/plugins/Breadcrumbs/Breadcrumbs.php");
        $action = filter_input(INPUT_GET, 'ac');
        $bc = new breadcrumbs($hosturl, '', '', $action);
        $bc->crumbs();
        $breadcrumbs = $bc->breadcrumbs;
        $smarty->assign('breadcrumbs', $breadcrumbs);

        $this->controlName = 'clinic_visits';
        $shcontrollname = 'Clinic Visits';
        $this->smarty->assign('controllname', $this->controlName);
        $this->smarty->assign('shcontrollname', $shcontrollname);

        $active[0] = $this->controlName;
        $active[1] = 'show';
        $this->active = $active;

        R::ext('xdispense', static function ($type) {
            return R::getRedBean()->dispense($type);
        });

        require_once("_header.php");
        require_once("_sidebar.php");
        require_once("_leftsidebar.php");
        require_once("_footer.php");
    }

    public function index()
    {
        $this->authChecking();

        $rooms = R::findAll('clinic_rooms', 'deleted = 0 and is_active = 1');
        $today = Date('Y-m-d');
        list($weekday, $dayNo) = $this->getTodayNumber($today);
        foreach ($rooms as $room) {
            $reserves = R::getAll('select distinct doctor_id from clinic_reserves where room_id = ? and reserve_day_no = ? and cancel_date is null', [$room->id, $dayNo]);
            foreach ($reserves as &$reserve) {
                $doctorInfo = R::findOne('awusers', 'user_id = ?', [$reserve['doctor_id']]);
                $reserve['name'] = $doctorInfo->name;

                // get hours for doctor
                $hours = R::findAll('clinic_reserves',
                    'room_id = ? and reserve_day_no = ? and cancel_date is null and doctor_id = ?', [
                        $room->id, $dayNo, $reserve['doctor_id']
                    ]);
                $reserve['hours'] = $hours;

                // visits
                $visits = R::findAll('visits',
                    'visitdate = ? and for_doctor = ? and deleted = 0',
                    [$today, $reserve['doctor_id']]);
                foreach ($visits as $visit) {
                    $patientInfo = R::findOne('patients', 'id = ?', [$visit->patientid]);
                    $visit->patient_name = ($visit->for_husband == 1) ? $patientInfo->husdandname : $patientInfo->wifename;
                    $detectionInfo = R::findOne('detections', 'id = ?', [$visit->detectionid]);
                    $visit->detection_name = $detectionInfo->title;
                }
                $reserve['visits'] = $visits;
            }
            $room->reserves = $reserves;
        }

        $this->smarty->assign('rooms', $rooms);

        $this->smartyHtml('clinics/visits.html.tpl');
    }

    public function enter()
    {
        $visitId = filter_input(1, 'visit_id');

        $visit = R::findOne('visits', 'id = ?', [$visitId]);
        $visit->clinic_entered = 1;
        R::store($visit);

        header('location:' . $this->host_url . '/controllers/clinic_visits.php?ac=index');
    }

    public function out()
    {
        $visitId = filter_input(1, 'visit_id');

        $visit = R::findOne('visits', 'id = ?', [$visitId]);
        $visit->clinic_out = 1;
        R::store($visit);

        header('location:' . $this->host_url . '/controllers/clinic_visits.php?ac=index');
    }

    public function __destruct()
    {
        R::close();
    }

    /**
     * @return void
     */
    protected function smartyHtml($file_path)
    {
        header::headershow($this->smarty, $this->host_url);
        sidebar::sidebarshow($this->smarty, $this->host_url, $this->active);
        $this->smarty->display($file_path);
        leftsidebar::leftsidebarshow($this->smarty, $this->host_url);
        footer::footershow($this->smarty, $this->host_url);
    }

    /**
     * @return void
     */
    protected function authChecking($loginCheck = true, $permissionCheck = true)
    {
        !$loginCheck ?: autho::checkautho($this->host_url);
        !$permissionCheck ?: autho::checkauthoize($this->controlName, $this->host_url, $_SESSION['role_id']);
    }

    /**
     * @param $today
     * @return array
     */
    protected function getTodayNumber($today)
    {
        $weekday = date('l', strtotime($today));
        switch ($weekday) {
            case 'Sunday':
                $dayNo = 2;
                break;
            case 'Monday':
                $dayNo = 3;
                break;
            case 'Tuesday':
                $dayNo = 4;
                break;
            case 'Wednesday':
                $dayNo = 5;
                break;
            case 'Thursday':
                $dayNo = 6;
                break;
            case 'Friday':
                $dayNo = 7;
                break;
            default:
                $dayNo = 1;
                break;
        }
        return array($weekday, $dayNo);
    }
}
