<?php

/*
 * awframework from aw.inc present aw controller
 * it will help you develop easy and fast with secure tools
 * you can edit and add what you feel right
 * don't change in structure of file
 */

use RedBeanPHP\RedException;

require_once("imp/_imp.php");

/**
 * @class calendar
 */
class Controllers {

   //public vars
   public $smarty;
   public $host_url;
   public $controlName;
   public $active;

   /**
    * @throws RedException
    */
   public function __construct() {
      require_once('../public/aw_config.php');
      require_once("imp/_autho.php"); //general functions
      /** @var $smarty
       * @var $hosturl
       */
      $this->smarty = $smarty;
      $this->host_url = $hosturl;

      require_once("../../_library/plugins/Breadcrumbs/Breadcrumbs.php");
      $action = filter_input(INPUT_GET, 'ac');
      $bc = new breadcrumbs($hosturl, '', '', $action);
      $bc->crumbs();
      $breadcrumbs = $bc->breadcrumbs;
      $smarty->assign('breadcrumbs', $breadcrumbs);

      $this->controlName = 'beauty_branches';
      $shcontrollname = 'Beauty Branches';
      $this->smarty->assign('controllname', $this->controlName);
      $this->smarty->assign('shcontrollname', $shcontrollname);

      $active[0] = 'beauty';
      $active[1] = $this->controlName;
      $active[2] = 'show';
      $this->active = $active;

      R::ext('xdispense', static function ($type) {
         return R::getRedBean()->dispense($type);
      });

      require_once("_header.php");
      require_once("_sidebar.php");
      require_once("_leftsidebar.php");
      require_once("_footer.php");
   }

   public function index() {
      $this->authChecking();
      $this->smartyHtml('beauty/branches/add.html.tpl');
   }

   public function add() {
      $this->authChecking();

      $branch = R::dispense('branches');
      $branch->name = filter_input(INPUT_POST, 'name');
      $branch->phone1 = filter_input(INPUT_POST, 'phone1');
      $branch->phone2 = filter_input(INPUT_POST, 'phone2');
      $branch->location = filter_input(INPUT_POST, 'location');
      $branch->created_at = date('Y-m-d H:i:s');
      $branch->updated_at = date('Y-m-d H:i:s');

      try {
         R::store($branch);
         //   $this->sendToSite($branch);
         header('Location:' . $this->host_url . '/controllers/' . $this->controlName . '.php?ac=show');
      } catch (Exception $e) {
         header('Location:' . $this->host_url . '/controllers/error?ac=notadd&id=' . $this->controlName);
      }
   }

   function sendToSite($branch) {
      $data = array(
          'branch_id' => $branch->id
          , 'branch_name' => $branch->name
          , 'phone1' => $branch->phone1
          , 'phone2' => $branch->phone2
          , 'location' => $branch->location
      );

      $url = 'https://royal-fc.net/appv/visit_details/branches';

      $curl = curl_init($url);
      curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, FALSE);
      curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, FALSE);
      curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
      curl_setopt($curl, CURLOPT_POST, true);

      curl_setopt($curl, CURLOPT_POSTFIELDS, $data);
      $response = curl_exec($curl);
      curl_close($curl);
      $res = json_decode($response);
   }

   public function show() {

      $this->authChecking();

      $branches = R::findAll('branches');
      $this->smarty->assign('branches', $branches);

      $this->smartyHtml('beauty/branches/show.html.tpl');
   }

   public function edit() {

      $this->authChecking();

      $id = filter_input(INPUT_GET, 'id');
      $branch = R::load('branches', $id);
      $this->smarty->assign('data', $branch);

      $this->smartyHtml('beauty/branches/edit.html.tpl');
   }

   public function update() {
      $this->authChecking();

      $id = filter_input(INPUT_POST, 'id');

      $branch = R::load('branches', $id);
      $branch->name = filter_input(INPUT_POST, 'name');
      $branch->phone1 = filter_input(INPUT_POST, 'phone1');
      $branch->phone2 = filter_input(INPUT_POST, 'phone2');
      $branch->location = filter_input(INPUT_POST, 'location');
      $branch->updated_at = date('Y-m-d H:i:s');

      try {
         R::store($branch);
//            $this->sendToSite($branch);
         header('Location:' . $this->host_url . '/controllers/' . $this->controlName . '.php?ac=show');
      } catch (Exception $e) {
         header('Location:' . $this->host_url . '/controllers/error?ac=notupdate&id=' . $this->controlName);
      }
   }

   public function del() {

      $this->authChecking();

      $item_id = filter_input(INPUT_POST, 'id');
      $from_ajax = filter_input(INPUT_POST, 'fromajax');

      $branch = R::load('branches', $item_id);

      try {
         R::trash($branch);
         echo '1';
      } catch (Exception $e) {
         if (!$from_ajax) {
            header('Location:' . $this->host_url . '/controllers/error?ac=notdel&id=' . $this->controlName);
         } else {
            echo '0';
         }
      }
   }

   public function __destruct() {
      R::close();
   }

   /**
    * @return void
    */
   protected function smartyHtml($file_path) {
      header::headershow($this->smarty, $this->host_url);
      sidebar::sidebarshow($this->smarty, $this->host_url, $this->active);
      $this->smarty->display($file_path);
      leftsidebar::leftsidebarshow($this->smarty, $this->host_url);
      footer::footershow($this->smarty, $this->host_url);
   }

   /**
    * @return void
    */
   protected function authChecking($login_check = true, $permission_check = true) {
      !$login_check ?: autho::checkautho($this->host_url);
      !$permission_check ?: autho::checkauthoize($this->controlName, $this->host_url, $_SESSION['role_id']);
   }
}
