<html>

    <head>
        <meta charset="UTF-8">
        <!-- CSS only -->
        <link href="{$path}/screen_ordering/bootstrap.css" rel="stylesheet">

        <!-- JavaScript Bundle with Popper -->
        <script src="{$path}/screen_ordering/bootstrap.js"></script>
        <style>
            @font-face {
                font-family: "DroidSansArabic";
                src: url('{$path}/screen_ordering/fonts/DroidSansArabic.eot');
                src: url('{$path}/screen_ordering/fonts/DroidSansArabic.woff');
                src: url('{$path}/screen_ordering/fonts/DroidSansArabic.woff2'),
                    url('{$path}/screen_ordering/fonts/DroidSansArabic.svg#DroidSansArabic') format('svg'),
                    url('{$path}/screen_ordering/fonts/DroidSansArabic.ttf') format('truetype');
                font-weight: normal;
                font-style: normal;
            }

            *,
            ion-label {
                font-family: 'DroidSansArabic';
            }

            .card {
                margin: 2px 0;
            }

            h5.card-title {
                background-color: #2c2b4b;
                color: #fff;
                text-align: center;
                padding: 18px 0 10px;
                font-size: 24px;
                border-radius: 5px 5px 0 0;
            }

            .card-title span {
                font-weight: bold;
                width: 30px;
                height: 30px;
                background-color: #ffffff;
                border-radius: 50%;
                display: inline-block;
                color: #2c2b4b;
                margin-left: 9px;
            }

            .card-body {
                padding: 0;
            }

            .col-md-3 {
                padding: 1px 3px;
            }

            h6.card-subtitle.text-muted {
                text-align: center;
                margin: 10px !important;
                font-weight: bold;
                font-size: 20px;
                color: #2c2b4b !important
            }

            body {
                background: #c850c0;
                background: -webkit-linear-gradient(45deg, #4158d0, #c850c0);
                background: -o-linear-gradient(45deg, #4158d0, #c850c0);
                background: -moz-linear-gradient(45deg, #4158d0, #c850c0);
                background: linear-gradient(45deg, #4158d0, #c850c0);
                direction: rtl;
                margin-top: 5px;
            }
        </style>
    </head>

    <body>

        <div class="container-fluid">
            <div class="row justify-content-md-center">

                {foreach $roles as $role}
                    {if $role->visits_count gt 0}
                        <div class="col-md-3">
                            <div class="card">
                                <div class="card-body">
                                    <h5 class="card-title"><span>{$role->visits_count}</span>{$role->name}
                                    </h5>
                                    {foreach $role->visits as $visit}
                                        <h6 class="card-subtitle text-muted">
                                            {$visit->patient_name}
                                            {if  $visit->for_department == 13 }
                                                &nbsp;  ( <span style="color: blue;">{$visit->for_doctor_name} </span> )
                                            {/if}
                                        </h6>
                                    {/foreach}
                                </div>
                            </div>
                        </div>
                    {/if}
                {/foreach}

            </div>
        </div>


    </body>

</html>