<!doctype html>
<html lang="zxx">

<head>
    <!-- REQUIRED META TAGS -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="" content="">
    <!-- DESCRIPTION -->
    <meta name="description" content="">
    <!-- KEYWORDS -->
    <meta name="keywords" content="">
    <!-- PAGE TITLE HERE -->
    <title>مركز رويال للخصوبة</title>
    <!-- MOBILE SPECIFIC -->
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- STYLESHEETS -->
    <link rel="stylesheet" type="text/css" href="{$path}/assets/css/plugins.css">
    <link rel="stylesheet" type="text/css" href="{$path}/assets/css/default.css">
    <link rel="stylesheet" type="text/css" href="{$path}/assets/css/style.css">
    <link rel="stylesheet" type="text/css" href="{$path}/assets/css/responsive.css">
    <link rel="stylesheet" type="text/css" href="{$path}/assets/css/bootstrap-rtl.min.css">
    <link rel="stylesheet" type="text/css" href="{$path}/assets/css/custom-rtl.css">

</head>
<body class="mockup-5">
<input type="hidden" id="hosturl" value="{$hosturl}"/>
<input type="hidden" id="room_id" value="{$room->id}"/>

<!-- ====== Wraper ====== -->
<div class="wraper d-flex align-items-center">
    <div class="container">
        <div class="content text-center">

            <div id="timer" class="timer-5">
                <h1 class="display-6" id="patient_container">
                    {if empty($room->patient_name)}
                        لا يوجد حجز حاليا
                    {else}
                        {$room->patient_name}
                    {/if}
                </h1>
            </div>

            <h2 class="display-5" style="color:#1a315b!important" id="doctor_container">
                {if empty($room->doctor_name)}
                {else}
                    <span class='dr'>الطبيب المعالج</span>
                    {$room->doctor_name}
                {/if}
            </h2>
            <div class="logos mr-0-auto"><img src="{$path}/assets/img/logo-nile.png" alt="logo"></div>

        </div>
    </div>
</div>


</div>
</div>


<!-- JAVASCRIPT FILES ========================================= -->
<script src="{$path}/assets/js/jquery.min.js"></script><!-- JQUERY.MIN JS -->
<script src="{$path}/assets/plugins/bootstrap/js/popper.min.js"></script><!-- POPPER JS -->
<script src="{$path}/assets/plugins/bootstrap/js/bootstrap.min.js"></script><!-- BOOTSTRAP JS -->

<script src="{$path}/assets/js/custom.js"></script><!-- CUSTOM FUCTIONS  -->

{literal}
    <script>
        $(document).ready(function () {
            var host_url = $('#hosturl').val();
            var room_id = $('#room_id').val();

            setInterval(function () {
                $.post(host_url + '/controllers/index1.php?ac=roomInfo', {room_id: room_id}, function (result) {
                    //console.log(result);
                    let patient_name = 'لا يوجد حجز حاليا';
                    if (result.patient_name.length) {
                        patient_name = result.patient_name;
                    }
                    let doctor_name = '';
                    if (result.doctor_name.length) {
                        doctor_name = "<span class='dr'>الطبيب المعالج</span> " + result.doctor_name;
                    }

                    $('#patient_container').html(patient_name);
                    $('#doctor_container').html(doctor_name);
                }, 'json');
            }, 120000); //120000
        });
    </script>
{/literal}

</body>

</html>