<?php

/*
 * awframework from aw.inc present aw controller
 * it will help you develop easy and fast with secure tools
 * you can edit and add what you feel right
 * don't change in strucure of file
 */

use Cassandra\Date;

require_once("../../core/controllers/imp/_imp.php");

class Controllers {

    //public vars
    public $smarty;
    public $hosturl;
    public $controllname;
    public $shcontrollname;
    public $active;

    // it will run in everytime with
    // default requried
    public function __construct() {
        require_once("../public/aw_config.php");
        require_once("../../core/controllers/imp/_autho.php"); //general functions
        $this->smarty = $smarty;
        $this->hosturl = $hosturl;

        //here name of controll to known
        $this->controllname = 'index_dental';
        $this->shcontrollname = 'index_dental';
        $this->smarty->assign('controllname', $this->controllname);
        $this->smarty->assign('shcontrollname', $this->shcontrollname);

        //breadcrumbs
        require_once("../../_library/plugins/Breadcrumbs/Breadcrumbs.php");
        $acty = filter_input(INPUT_GET, 'ac');
        $bc = new breadcrumbs($hosturl, '', '', $acty);
        $bc->crumbs();
        $breadcrumbs = $bc->breadcrumbs;
        $smarty->assign('breadcrumbs', $breadcrumbs);

        # here show the active page in menu
        // array called active[] with level of active element
        $active[0] = 'index'; //controller name or tab name
        $this->active = $active;
    }

    //here the frist page and
    //the frist action in this class
    public function index() {
        $clinic_name = filter_input(INPUT_GET, 'room_id');

        $room = R::findOne('clinic_rooms', 'clinic_no = ?', [$clinic_name]);
        $today = date('Y-m-d');
        $this->smarty->assign('room_name', $room->name);
        $this->smarty->assign('clinic_id', $room->id);

        $room_info = $this->roomDetails($room->id, $today);
        $room_info->emptyMessage = $this->checkRoomName($clinic_name);
        $this->refresh(300);

        $this->smarty->assign('room_info', $room_info);
        $this->smarty->display('dental.html');
    }

    public function roomInfo() {
        $today = date('Y-m-d');
        $room_id = filter_input(INPUT_POST, 'room_id');
        $room_info = $this->roomDetails($room_id, $today);
        $info = ['patient_name' => '', 'doctor_name' => ''];
        if ($room_info) {
            $patient_name = $room_info->patient_name;
            $doctor_name = $room_info->doctor_name;
        } else {
            $room = R::load('clinic_rooms', $room_id);
            $patient_name = $this->checkRoomName($room->clinic_no);
            $doctor_name = '';
        }


        $result = array(
            "doctor_name" => $doctor_name,
            "patient_name" => $patient_name
        );
        echo json_encode($result);
    }

    function checkRoomName($clinic_name) {
        switch ($clinic_name) {
            case 'clin6':
                $emptyMessage = 'CEO';
                break;

            case 'clin7':
                $emptyMessage = 'Dental Studio';
                break;

            case 'clin8':
                $emptyMessage = ' X-RAY';
                break;

            default:
                $emptyMessage = 'لا يوجد حجز حاليا';
                break;
        }

        return $emptyMessage;
    }

    function roomDetails($roomId, $date) {
        //   r::debug(true, 2);
        $theHour = date('H') . ':00';
        if ($theHour === '07') {
            $theHour = '7';
        }

        $room_info = R::findOne('visits', 'in_clinic = ? and today_list_dept = ? and visitdate = "' . $date . '"
        and deleted = 0 order by id desc', [1, $roomId]);
        if ($room_info) {
            $patient_info = R::findOne('patients', 'id = ?', [$room_info->patientid]);
            $room_info->patient_name = ($room_info->for_husband == 1) ? $patient_info->husdandname : $patient_info->wifename;

            list($weekday, $dayNo) = $this->getTodayNumber($date);

            $clinic_reserve = R::findOne('clinic_reserves', 'room_id = ? and reserve_day_no = ?
        and reserve_hour = ? and is_active = 1
        and deleted = 0 order by id desc', [$roomId, $dayNo, $theHour]);

            if ($clinic_reserve) {
                $doctor_info = R::findOne('awusers', 'user_id = ?', [$clinic_reserve->doctor_id]);
                $room_info->doctor_name = $doctor_info->name;
            }
        }

        //   r::debug(false);
        return $room_info;
    }

    public function clinics() {
        $this->showClinicsVisits();
        $this->refresh(300);
        $this->smarty->display('clinics/all/dental.html.tpl');
    }

    public function clinicsInfo() {
        $this->showClinicsVisits();
        $this->smarty->display('clinics/all/loaded_dental.html.tpl');
    }

    // at the end of class call
    public function __destruct() {
        //close connection
        R::close();
    }

    // write the function
    public function refresh($time) {
        $currentUrl = $_SERVER['REQUEST_URI'];
        return header("Refresh: " . $time . "; URL=$currentUrl");
    }

    /**
     * @param $today
     * @return array
     */
    protected function getTodayNumber($today) {
        $weekday = date('l', strtotime($today));
        switch ($weekday) {
            case 'Sunday':
                $dayNo = 2;
                break;
            case 'Monday':
                $dayNo = 3;
                break;
            case 'Tuesday':
                $dayNo = 4;
                break;
            case 'Wednesday':
                $dayNo = 5;
                break;
            case 'Thursday':
                $dayNo = 6;
                break;
            case 'Friday':
                $dayNo = 7;
                break;
            default:
                $dayNo = 1;
                break;
        }
        return array($weekday, $dayNo);
    }

    /**
     * @return void
     */
    protected function showClinicsVisits() {
        $time = date('H', time());
        $programesetting = R::findOne('programesetting');

        $sql = ' and clinic_entered != 1 and detectionid not in (-99, 9999, 999 ) and today_list = 1 and today_list_dept = 0 ';


        if ($time <= $programesetting->addshours) {
            ## iam now at extra time show yesterday visits  also
            $doctors = R::getAll('select distinct for_doctor from visits where visitdate in (?, ? ) and deleted = ? ' . $sql . '
        ORDER BY for_doctor ASC ', [date('Y-m-d'), date('Y-m-d', strtotime("-1 days")), 0]);
        } else {
            $doctors = R::getAll('select distinct for_doctor from visits where visitdate = ? and deleted = ?
        ' . $sql . ' ORDER BY for_doctor ASC ', [date('Y-m-d'), 0]);
        }

        $i = 0;
        foreach ($doctors as $doctor) {
            $dr = R::getRow('select name from awusers where user_id = ?', [$doctor['for_doctor']]);
            $doctors[$i]['for_doctor_name'] = $dr['name'];

            if ($time <= $programesetting->addshours) {
                ## iam now at extra time show yesterday visits  also
                $allvisit = R::findAll('visits', 'visitdate in (?, ? ) and deleted = ? and for_doctor = ? ' . $sql . '
        ORDER BY id ASC ', [date('Y-m-d'), date('Y-m-d', strtotime("-1 days")), 0, $doctor['for_doctor']]);
            } else {
                $allvisit = R::findAll('visits', 'visitdate = ? and deleted = ? and for_doctor = ?
        ' . $sql . ' ORDER BY id ASC ', [date('Y-m-d'), 0, $doctor['for_doctor']]);
            }

            $doctors[$i]['drVisits'] = $this->visitsDetails($allvisit);
            $i++;
        }
//        $allvisit = $this->visitsDetails($allvisit);
        $this->smarty->assign('doctors', $doctors);
        $this->smarty->assign('doctorsCount', count($doctors));

        $roles = R::findAll('clinic_rooms', 'today_list = 1 order by id ');

        foreach ($roles as $role) {
            $sql = ' and clinic_entered != 1 and detectionid not in (-99, 9999, 999 ) and today_list = 1 and today_list_dept = ' . $role->id;
            if ($time <= $programesetting->addshours) {
                ## iam now at extra time show yesterday visits  also
                $allvisit = R::findAll('visits', 'visitdate in (?, ? ) and deleted = ? ' . $sql . '
        ORDER BY id ASC ', [date('Y-m-d'), date('Y-m-d', strtotime("-1 days")), 0]);
            } else {
                $allvisit = R::findAll('visits', 'visitdate = ? and deleted = ?
        ' . $sql . ' ORDER BY id ASC ', [date('Y-m-d'), 0]);
            }

            $role->visits = $this->visitsDetails($allvisit);
            list($doctor_id, $doctor_name) = $this->clinicDoctor($role->id, date('Y-m-d'));
            $role->doctor_name = $doctor_name;

            $role->roleCurrentPatient = $this->current($role->id, date('Y-m-d'));
        }
        $this->smarty->assign('roles', $roles);
    }

    function current($roomId, $date) {
        $patientName = '';
        $room_info = R::findOne('visits', 'in_clinic = ? and today_list_dept = ? and visitdate = "' . $date . '"
        and deleted = 0 order by id desc', [1, $roomId]);

        if ($room_info) {
            $patient_info = R::findOne('patients', 'id = ?', [$room_info->patientid]);
            $patientName = ($room_info->for_husband == 1) ? $patient_info->husdandname : $patient_info->wifename;
        }

        return $patientName;
    }

    public function visitsDetails($allvisit) {
        foreach ($allvisit as $visit) {
            $patientName = R::findOne('patients', 'id = ? ', [$visit->patientid]);

            if ($visit->for_husband == 1) {
                $visit->patientName = $patientName->husdandname;
            } elseif ($visit->for_husband == 2) {

                $child = R::load('patients_childs', $visit->child);

                if (is_null($child->child_name) || $child->child_name == '') {
                    if ($child->gender == 1) {
                        $visit->patientName = 'الطفل / ' . $patientName->wifename;
                    } else {
                        $visit->patientName = 'الطفلة / ' . $patientName->wifename;
                    }
                } else {
                    $visit->patientName = $child->child_name . ' / ' . $patientName->wifename;
                }
            } else {
                $visit->patientName = $patientName->wifename;
            }


            $visit->patientId = $patientName->id;
            $visit->statusno = $patientName->statusno;
            $visit->statusno = $patientName->statusno;
        }

        return $allvisit;
    }

    function clinicDoctor($roomId, $date) {
        $theHour = date('H') . ':00';
        if ($theHour === '07') {
            $theHour = '7';
        }

        list($weekday, $dayNo) = $this->getTodayNumber($date);

        $clinic_reserve = R::findOne('clinic_reserves', 'room_id = ? and reserve_day_no = ?
        and reserve_hour = ? and is_active = 1
        and deleted = 0 order by id desc', [$roomId, $dayNo, $theHour]);

        $doctor_name = ' ';
        $doctor_id = 0;

        if ($clinic_reserve) {
            $doctor_info = R::findOne('awusers', 'user_id = ?', [$clinic_reserve->doctor_id]);
            $doctor_name = $doctor_info->name;
            $doctor_id = $doctor_info->doctor_id;
        }

        return array($doctor_id, $doctor_name);
    }

}
