<?php

/*
 * awframework from aw.inc present aw controller
 * it will help you develop easy and fast with secure tools
 * you can edit and add what you feel right
 * don't change in strucure of file
 */

use Cassandra\Date;

require_once("../../core/controllers/imp/_imp.php");

class Controllers {

    //public vars
    public $smarty;
    public $hosturl;
    public $controllname;
    public $shcontrollname;
    public $active;

    // it will run in everytime with
    // default requried
    public function __construct() {
        require_once("../public/aw_config.php");
        require_once("../../core/controllers/imp/_autho.php"); //general functions
        $this->smarty = $smarty;
        $this->hosturl = $hosturl;

        //here name of controll to known
        $this->controllname = 'index';
        $this->shcontrollname = 'index';
        $this->smarty->assign('controllname', $this->controllname);
        $this->smarty->assign('shcontrollname', $this->shcontrollname);

        //breadcrumbs
        require_once("../../_library/plugins/Breadcrumbs/Breadcrumbs.php");
        $acty = filter_input(INPUT_GET, 'ac');
        $bc = new breadcrumbs($hosturl, '', '', $acty);
        $bc->crumbs();
        $breadcrumbs = $bc->breadcrumbs;
        $smarty->assign('breadcrumbs', $breadcrumbs);

        # here show the active page in menu
        // array called active[] with level of active element
        $active[0] = 'index'; //controller name or tab name
        $this->active = $active;
    }

    //here the frist page and
    //the frist action in this class
    public function index() {
        $roomId = filter_input(INPUT_GET, 'room_id');
        $room = R::findOne('clinic_rooms', 'id = ? and is_active = 1 and deleted = 0', [$roomId]);
        $today = Date('Y-m-d');
        $theHour = Date('H');
        if ($theHour === '07') {
            $theHour = '7';
        }

        if ($room) {
            list($weekday, $dayNo) = $this->getTodayNumber($today);

            // get doctor
            $doctorReserve = R::findOne('clinic_reserves',
                            'room_id = ? and reserve_day_no = ? and reserve_hour = ? order by id desc', [
                        $room->id,
                        $dayNo,
                        $theHour . ':00'
            ]);
            if ($doctorReserve) {
                $doctorInfo = R::findOne('awusers', 'user_id = ?', [$doctorReserve->doctor_id]);
                $room->doctor_name = $doctorInfo->name;

                // get patient
                $visit = R::findOne('visits',
                                'for_doctor = ? and deleted = 0 and visitdate = ? and clinic_entered = 1 and (clinic_out != 1 or clinic_out is null)', [
                            $doctorReserve->doctor_id,
                            $today
                ]);
                if ($visit) {
                    $patientInfo = R::findOne('patients', 'id = ?', [$visit->patientid]);
                    $room->patient_name = ($visit->for_husband == 1) ? $patientInfo->husdandname : $patientInfo->wifename;
                }
            }
        }

        $this->refresh(300);

        $this->smarty->assign('room', $room);
        $this->smarty->display('clinics/single.html.tpl');
    }

    public function roomInfo() {
        $roomId = filter_input(0, 'room_id');
        $room = R::findOne('clinic_rooms', 'id = ? and is_active = 1 and deleted = 0', [$roomId]);
        $today = Date('Y-m-d');
        $theHour = Date('H');
        if ($theHour === '07') {
            $theHour = '7';
        }

        $result = ['patient_name' => '', 'doctor_name' => ''];

        if ($room) {
            list($weekday, $dayNo) = $this->getTodayNumber($today);

            // get doctor
            $doctorReserve = R::findOne('clinic_reserves',
                            'room_id = ? and reserve_day_no = ? and reserve_hour = ? order by id desc', [
                        $room->id,
                        $dayNo,
                        $theHour . ':00'
            ]);
            if ($doctorReserve) {
                $doctorInfo = R::findOne('awusers', 'user_id = ?', [$doctorReserve->doctor_id]);
                $result['doctor_name'] = $doctorInfo->name;

                // get patient
                $visit = R::findOne('visits',
                                'for_doctor = ? and deleted = 0 and visitdate = ? and clinic_entered = 1 and (clinic_out != 1 or clinic_out is null)', [
                            $doctorReserve->doctor_id,
                            $today
                ]);
                if ($visit) {
                    $patientInfo = R::findOne('patients', 'id = ?', [$visit->patientid]);
                    $result['patient_name'] = ($visit->for_husband == 1) ? $patientInfo->husdandname : $patientInfo->wifename;
                }
            }
        }

        echo json_encode($result);
    }

    public function clinics() {
        $this->showClinicsVisits();
        $this->refresh(300);
        $this->smarty->display('clinics/all/index.html.tpl');
    }

    public function clinicsInfo() {
        $this->showClinicsVisits();
        $this->smarty->display('clinics/all/loaded.html.tpl');
    }

    // at the end of class call
    public function __destruct() {
        //close connection
        R::close();
    }

    // write the function
    public function refresh($time) {
        $currentUrl = $_SERVER['REQUEST_URI'];
        return header("Refresh: " . $time . "; URL=$currentUrl");
    }

    /**
     * @param $today
     * @return array
     */
    protected function getTodayNumber($today) {
        $weekday = date('l', strtotime($today));
        switch ($weekday) {
            case 'Sunday':
                $dayNo = 2;
                break;
            case 'Monday':
                $dayNo = 3;
                break;
            case 'Tuesday':
                $dayNo = 4;
                break;
            case 'Wednesday':
                $dayNo = 5;
                break;
            case 'Thursday':
                $dayNo = 6;
                break;
            case 'Friday':
                $dayNo = 7;
                break;
            default:
                $dayNo = 1;
                break;
        }
        return array($weekday, $dayNo);
    }

    /**
     * @return void
     */
    protected function showClinicsVisits() {
        $rooms = R::findAll('clinic_rooms', 'deleted = 0 and is_active = 1');
        $today = Date('Y-m-d');
        $theHour = Date('H');
        if ($theHour === '07') {
            $theHour = '7';
        }
        list($weekday, $dayNo) = $this->getTodayNumber($today);
        foreach ($rooms as $room) {

            $reserve = R::findOne('clinic_reserves', 'room_id = ? and reserve_day_no = ? and cancel_date is null and reserve_hour = ?',
                            [$room->id, $dayNo, $theHour . ':00']);
            if ($reserve) {
                $doctorInfo = R::findOne('awusers', 'user_id = ?', [$reserve->doctor_id]);
                $reserve->name = $doctorInfo->name;

                // visits - check for detections - operation with id = 13 and skip it and fordepartment != 13
                $visits = R::findAll('visits',
                                'visitdate = ? and for_doctor = ? and for_department != 13  and deleted = 0 and (clinic_entered is null or clinic_entered = "") and (clinic_out is null or clinic_out = "")',
                                [$today, $reserve->doctor_id]);

                foreach ($visits as $visit) {
                    $patientInfo = R::findOne('patients', 'id = ?', [$visit->patientid]);
                    $visit->patient_name = ($visit->for_husband == 1) ? $patientInfo->husdandname : $patientInfo->wifename;
                    $detectionInfo = R::findOne('detections', 'id = ?', [$visit->detectionid]);
                    $visit->detection_name = $detectionInfo->title;
                }
                $reserve->visits = $visits;
                $room->reserve = $reserve;
            }
        }
        $this->smarty->assign('rooms', $rooms);
    }

}
