<?php

require_once("imp/_imp.php");

class Controllers
{
    public $smarty;
    public $hosturl;
    public $controllname;
    public $shcontrollname;
    public $active;
    public $time;
    public $today;

    public function __construct()
    {
        require_once("../public/aw_config.php");
        require_once("imp/_autho.php");
        /** @var $smarty
         * @var $hosturl
         */
        $this->smarty = $smarty;
        $this->hosturl = $hosturl;

        $this->controllname = 'vote_devices';
        $this->shcontrollname = 'Vote Devices';
        $this->smarty->assign('controllname', $this->controllname);
        $this->smarty->assign('shcontrollname', $this->shcontrollname);

        require_once("../../_library/plugins/Breadcrumbs/Breadcrumbs.php");
        $acty = filter_input(INPUT_GET, 'ac');
        $bc = new breadcrumbs($hosturl, '', '', $acty);
        $bc->crumbs();
        $breadcrumbs = $bc->breadcrumbs;
        $smarty->assign('breadcrumbs', $breadcrumbs);

        $active[0] = $this->controllname;
        $active[1] = $this->controllname;
        switch ($acty) {
            case '':
                $active[2] = $this->controllname.'add';
                break;
            default :
                $active[2] = $this->controllname.'show';
                break;
        }
        $this->active = $active;

        require_once("_header.php");
        require_once("_patientdata.php");
        require_once("_sidebar.php");
        require_once("_leftsidebar.php");
        require_once("_footer.php");

        R::ext('xdispense', function ($type) {
            return R::getRedBean()->dispense($type);
        });

        $this->time = microtime(true);
        $this->today = date('Y-m-d');
    }

    public function index()
    {
        autho::checkautho($this->hosturl);
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('votes/vote_devices/add.html.tpl');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function add()
    {
        autho::checkautho($this->hosturl);
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $row = R::xdispense('vote_devices');
        $row->name = filter_input(INPUT_POST,'name');
        $row->local_ip = filter_input(INPUT_POST, 'local_ip');
        $row->created_at = date('Y-m-d H:i:s');
        $row->updated_at = date('Y-m-d H:i:s');
        try {
            R::store($row);
            header('Location:' . $this->hosturl . '/controllers/' . $this->controllname . '.php?ac=show');
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/error/notadd/' . $this->controllname);
        }
    }

    public function show()
    {
        autho::checkautho($this->hosturl);
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $vote_devices = R::findAll('vote_devices');
        $this->smarty->assign('vote_devices', $vote_devices);

        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('votes/vote_devices/show.html.tpl');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function edit()
    {
        autho::checkautho($this->hosturl);
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $id = filter_input(INPUT_GET, 'id');
        $vote_device = R::load('vote_devices', $id);
        $this->smarty->assign('vote_device', $vote_device);

        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('votes/vote_devices/edit.html.tpl');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function update()
    {
        autho::checkautho($this->hosturl);
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $id = filter_input(INPUT_POST, 'id');

        $row = R::load('vote_devices', $id);
        $row->name = filter_input(INPUT_POST,'name');
        $row->local_ip = filter_input(INPUT_POST, 'local_ip');
        $row->updated_at = date('Y-m-d H:i:s');
        try {
            R::store($row);
            header('Location:' . $this->hosturl . '/controllers/' . $this->controllname . '.php?ac=show');
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/error/notupdate/' . $this->controllname);
        }
    }

    public function del()
    {
        autho::checkautho($this->hosturl);
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $id = filter_input(INPUT_POST, 'id');
        try {
            $item = R::findOne('vote_devices', 'id = ?', [$id]);
            // check if item exists in vote_questions
            $vote_questions = R::findOne('votes', 'vote_device_id = ?', [$id]);
            if ($vote_questions) {
                echo 0;
                exit();
            }
            R::trash($item);
            echo 1;
        } catch (Exception $e) {
            echo 0;
        }
    }

    public function __destruct()
    {
        R::close();
    }

}
