<?php

require_once("imp/_imp.php");

class Controllers {

    //public vars
    public $smarty;
    public $hosturl;
    public $controllname;
    public $shcontrollname;
    public $active;
    public $time;
    public $today;
    public $patientid;

    // it will run in everytime with
    // default requried
    public function __construct() {
        require_once("../public/aw_config.php");
        require_once("imp/_autho.php"); //general functions
        $this->smarty = $smarty;
        $this->hosturl = $hosturl;

        //here name of controll to known
        $this->controllname = 'spermfreezing';
        $this->shcontrollname = 'spermfreezing';
        $this->smarty->assign('controllname', $this->controllname);
        $this->smarty->assign('shcontrollname', $this->shcontrollname);



        //breadcrumbs
        require_once("../../_library/plugins/Breadcrumbs/Breadcrumbs.php");
        $acty = filter_input(INPUT_GET, 'ac');
        $bc = new breadcrumbs($hosturl, '', '', $acty);
        $bc->crumbs();
        $breadcrumbs = $bc->breadcrumbs;
        $smarty->assign('breadcrumbs', $breadcrumbs);

        # here show the active page in menu
        // array called active[] with level of active element
        $active[0] = 'spermfreezing'; //controller name or tab name
        $active[1] = 'spermfreezing'; //controller name
        // do name  // switch($do)
        switch ($acty) {
            case '':
                $active[2] = 'spermfreezingadd';
                break;
            case 'show':
                $active[2] = 'spermfreezingshow';
                break;
            default:
                $active[2] = 'spermfreezingshow';
                break;
        }
        $this->active = $active;



        //here will call all php pages
        require_once("_header.php");
        require_once("_patientdata.php");
        require_once("_sidebar.php");
        require_once("_leftsidebar.php");
        require_once("_footer.php");

        $this->patientid = patientdata::patientid();

        //find loading time
        $this->time = microtime(true);
        $this->today = date('Y-m-d');
    }

    public function index() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $patientid = filter_input(INPUT_GET, "patientid");
        if (empty($this->patientid)) {
            header('Location:' . $this->hosturl . '/controllers/index.php?empty=1');
            exit();
        }
        $this->smarty->assign('patientId', $patientid);
        //load all parents here
        //        $showElems = R::getAll('SELECT * FROM spermfreezingreport');
        $showElems = R::getAll('SELECT spermfreezingreport.id as spermfreezingreport_id ,spermfreezingreport.patient_id as patientId,
            patients.wifename as wifename ,patients.husdandname as husbandname from spermfreezingreport 
            LEFT JOIN patients ON spermfreezingreport.patient_id =patients.id where spermfreezingreport.patient_id=' . $patientid . '

         ');
        $this->smarty->assign('showElems', $showElems);

        //        $patient = R::load("patients", $patientid);
        //
        //        $wifename = $patient->wifename;
        //        $husdandname = $patient->husdandname;
        //        $this->smarty->assign('wifename', $wifename);
        //        $this->smarty->assign('husdandname', $husdandname);
        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        if ($patientid) {
            patientdata::patientdatashow($this->smarty, $this->hosturl);
        }
        $this->smarty->display('spermfreezing/show.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function add() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        $patientid = filter_input(INPUT_GET, "patientid");
        $this->smarty->assign('patientId', $patientid);
        if (empty($this->patientid)) {
            header('Location:' . $this->hosturl . '/controllers/index.php?empty=1');
            exit();
        }
        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        if ($patientid) {
            patientdata::patientdatashow($this->smarty, $this->hosturl);
        }
        //referred doctors
        $ref_dr_id = R::load('patients', $patientid);
        if (!empty($ref_dr_id->refer_doctor)) {
            $ref_dr = R::getAll("select* from awusers where user_id=$ref_dr_id->refer_doctor");
            $this->smarty->assign('ref_dr', $ref_dr[0]);
        } else {
            $this->smarty->assign('ref_dr', "لايوجد");
        }


        $embryologist = R::getAll("select* from awusers where role_id=11");
        $this->smarty->assign('embryologist', $embryologist);

        $users = R::getAll("select* from awusers");
        $this->smarty->assign('users', $users);


        $freezing_media = R::findAll("freezingmedia");
        $this->smarty->assign('freezing_media', $freezing_media);

        $freezingprotocol = R::findAll("freezingprotocol");
        $this->smarty->assign('freezingprotocol', $freezingprotocol);

        $this->smarty->assign('today', date('Y-m-d'));

        $programesetting = R::findOne('programesetting');
        $this->smarty->assign('programesetting', $programesetting);
        if ($programesetting->tanks_view == 1) {
            $cells = $this->loadCellsDisplay($embryoslab_id);
            $this->smarty->assign('cells', $cells);
        } elseif ($programesetting->tanks_view == 2) {
            $this->tankStyle2();
        }

        $this->smarty->display('spermfreezing/add.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function addit() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //vars here

        $patientid = filter_input(INPUT_GET, "patientid");
        $ref_by_dr_id = filter_input(INPUT_POST, 'ref_by_dr_id');
        $visitdate = filter_input(INPUT_POST, 'visitdate');
        $sysdate = filter_input(INPUT_POST, 'sysdate');
        $sperm_source = filter_input(INPUT_POST, 'sperm_source');
        $count = filter_input(INPUT_POST, 'count');
        $motility = filter_input(INPUT_POST, 'motility');
        $a_plus_b = filter_input(INPUT_POST, 'a_plus_b');
        $morphology = filter_input(INPUT_POST, 'morphology');
        $comment = filter_input(INPUT_POST, 'comment');
        $samples_no = filter_input(INPUT_POST, 'samples_no');
        $media = filter_input(INPUT_POST, 'media');
        $protocol = filter_input(INPUT_POST, 'protocol');
        $purpose = filter_input(INPUT_POST, 'purpose');
        $location = filter_input(INPUT_POST, 'location');
        $color_of_pen = filter_input(INPUT_POST, 'color_of_pen');
        $embryology1 = filter_input(INPUT_POST, 'embryology1');
        $embryology2 = filter_input(INPUT_POST, 'embryology2');

        $this->smarty->assign('patientId', $patientid);

        //here the add
        $report = R::dispense('spermfreezingreport');

        $report->patient_id = $patientid;
        $report->sperm_source = $sperm_source;
        $report->ref_by_dr_id = $ref_by_dr_id;
        $report->count = $count;
        $report->motility = $motility;
        $report->a_plus_b = $a_plus_b;
        $report->morphology_abn = $morphology;
        $report->comment = $comment;
        $report->samples_no = $samples_no;
        $report->freezing_media_id = $media;
        $report->freezing_protocol_id = $protocol;
        $report->purpose_of_freezing = $purpose;
        $report->location = ''; //$location;
        $report->color_of_pen = $color_of_pen;
        $report->embryologist1 = $embryology1;
        $report->embryologist2 = $embryology2;
        $report->date = $visitdate;
        $report->sysdate = $sysdate;

        try {
            $id = R::store($report);
            if (!empty($patientid)) {
                header('Location:' . $this->hosturl . '/controllers/' . $this->controllname . '.php?ac=show&patientid=' . $patientid);
            } else {
                header('Location:' . $this->hosturl . '/controllers/' . $this->controllname . '.php?ac=show');
            }
        } catch (Exception $e) {
            print_r($e);
            // header('Location:' . $this->hosturl . '/error/notadd/' . $this->controllname);
        }
    }

    public function show() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $patientid = filter_input(INPUT_GET, "patientid");
        $this->smarty->assign('patientId', $patientid);
        //load all parents here
        //        $showElems = R::getAll('SELECT * FROM spermfreezingreport');
        $showElems = R::getAll('SELECT spermfreezingreport.id as spermfreezingreport_id ,spermfreezingreport.patient_id as patientId,
            patients.wifename as wifename ,patients.husdandname as husbandname from spermfreezingreport 
            LEFT JOIN patients ON spermfreezingreport.patient_id =patients.id where spermfreezingreport.patient_id=' . $patientid . '

         ');
        $this->smarty->assign('showElems', $showElems);

        //        $patient = R::load("patients", $patientid);
        //
        //        $wifename = $patient->wifename;
        //        $husdandname = $patient->husdandname;
        //        $this->smarty->assign('wifename', $wifename);
        //        $this->smarty->assign('husdandname', $husdandname);
        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        if ($patientid) {
            patientdata::patientdatashow($this->smarty, $this->hosturl);
        }
        $this->smarty->display('spermfreezing/show.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function showallreports() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        $patientid = filter_input(INPUT_GET, "patientid");
        $this->smarty->assign('patientId', $patientid);
        //load all parents here

        $spermfreezingreport = R::getAll('SELECT* spermfreezingreport from where patient_id=' . $patientid . '  ');
        $this->smarty->assign('spermfreezingreport', $spermfreezingreport);

        $embryologyreport = R::getAll('SELECT* embryologyreport from where patient_id=' . $patientid . '  ');
        $this->smarty->assign('embryologyreport', $embryologyreport);

        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        if ($patientid) {
            patientdata::patientdatashow($this->smarty, $this->hosturl);
        }
        $this->smarty->display('spermfreezing/show_all_reports.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function edit() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //get id for item
        $id = filter_input(INPUT_GET, 'id');
        $this->smarty->assign('id', $id);
        $patientid = filter_input(INPUT_GET, "patientid");

        //load all here
        $editElement = R::load('spermfreezingreport', $id);
        $this->smarty->assign('editElement', $editElement);
        $this->smarty->assign('patientId', $patientid);

        //referred doctors
        $ref_dr_id = R::load('patients', $patientid);
        if (!empty($ref_dr_id->refer_doctor)) {
            $ref_dr = R::getAll("select* from awusers where user_id=$ref_dr_id->refer_doctor");
            $this->smarty->assign('ref_dr', $ref_dr[0]);
        } else {
            $this->smarty->assign('ref_dr', "لايوجد");
        }

        $embryologist = R::getAll("select* from awusers where role_id=11");
        $this->smarty->assign('embryologist', $embryologist);

        $users = R::getAll("select* from awusers");
        $this->smarty->assign('users', $users);

        $freezing_media = R::findAll("freezingmedia");
        $this->smarty->assign('freezing_media', $freezing_media);

        $freezingprotocol = R::findAll("freezingprotocol");
        $this->smarty->assign('freezingprotocol', $freezingprotocol);

        $this->smarty->assign('today', date('Y-m-d'));
        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        if ($patientid) {
            patientdata::patientdatashow($this->smarty, $this->hosturl);
        }

        $programesetting = R::findOne('programesetting');
        $this->smarty->assign('programesetting', $programesetting);
        if ($programesetting->tanks_view == 1) {
            $cells = $this->loadCellsDisplay($id);
            $this->smarty->assign('cells', $cells);
        } elseif ($programesetting->tanks_view == 2) {
            $this->tankStyle2();
        }

        $this->smarty->display('spermfreezing/edit.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function updateit() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //vars here
        $patientid = filter_input(INPUT_GET, "patientid");
        $ref_by_dr_id = filter_input(INPUT_POST, 'ref_by_dr_id');
        $visitdate = filter_input(INPUT_POST, 'visitdate');
        $sysdate = filter_input(INPUT_POST, 'sysdate');
        $sperm_source = filter_input(INPUT_POST, 'sperm_source');
        $count = filter_input(INPUT_POST, 'count');
        $motility = filter_input(INPUT_POST, 'motility');
        $a_plus_b = filter_input(INPUT_POST, 'a_plus_b');
        $morphology = filter_input(INPUT_POST, 'morphology');
        $comment = filter_input(INPUT_POST, 'comment');
        $samples_no = filter_input(INPUT_POST, 'samples_no');
        $media = filter_input(INPUT_POST, 'media');
        $protocol = filter_input(INPUT_POST, 'protocol');
        $purpose = filter_input(INPUT_POST, 'purpose');
        $location = filter_input(INPUT_POST, 'location');
        $color_of_pen = filter_input(INPUT_POST, 'color_of_pen');
        $embryology1 = filter_input(INPUT_POST, 'embryology1');
        $embryology2 = filter_input(INPUT_POST, 'embryology2');

        $id = filter_input(INPUT_POST, 'id');

        $this->smarty->assign('patientId', $patientid);


        //here the update
        $report = R::load('spermfreezingreport', $id);

        $report->patient_id = $patientid;
        $report->sperm_source = $sperm_source;
        $report->ref_by_dr_id = $ref_by_dr_id;
        $report->count = $count;
        $report->motility = $motility;
        $report->a_plus_b = $a_plus_b;
        $report->morphology_abn = $morphology;
        $report->comment = $comment;
        $report->samples_no = $samples_no;
        $report->freezing_media_id = $media;
        $report->freezing_protocol_id = $protocol;
        $report->purpose_of_freezing = $purpose;
        $report->location = $location;
        $report->color_of_pen = $color_of_pen;
        $report->embryologist1 = $embryology1;
        $report->embryologist2 = $embryology2;
        $report->date = $visitdate;
        $report->sysdate = $sysdate;


        try {
            R::store($report);
            if (!empty($patientid)) {
                header('Location:' . $this->hosturl . '/controllers/' . $this->controllname . '.php?ac=show&patientid=' . $patientid);
            } else {
                header('Location:' . $this->hosturl . '/controllers/' . $this->controllname . '.php?ac=show');
            }
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/error/notupdate/' . $this->controllname);
        }
    }

    public function del() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $id = filter_input(INPUT_POST, 'id');
        try {
            R::exec('DELETE from spermfreezingreport WHERE id = ' . $id);
            echo 1;
        } catch (Exception $e) {
            
        }
    }

    public function addprotocol() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $protocol = filter_input(INPUT_POST, 'protocol');

        $freezingprotocol = R::dispense('freezingprotocol');
        $freezingprotocol->protocol = $protocol;
        $inserted = R::store($freezingprotocol);
        echo $inserted;
    }

    public function addmedia() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $media = filter_input(INPUT_POST, 'media');

        $freezingmedia = R::dispense('freezingmedia');
        $freezingmedia->media = $media;
        $inserted = R::store($freezingmedia);
        echo $inserted;
    }

    public function getprint() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $patientId = filter_input(INPUT_POST, "patientid");

        $patientData = R::load("patients", $patientId);

        $wifename = $patientData->wifename;
        $husbandname = $patientData->husdandname;
        $husbandage = $patientData->husbandage;

        $this->smarty->assign('wifename', $wifename);
        $this->smarty->assign('husbandname', $husbandname);
        $this->smarty->assign('husbandage', $husbandage);

        $id = filter_input(INPUT_POST, "id");
        $editElement = R::load('spermfreezingreport', $id);

        $editElement->date = date('Y/m/d', strtotime($editElement->date));

        $freezing_media_id = $editElement->freezing_media_id;
        $freezing_protocol_id = $editElement->freezing_protocol_id;
        $ref_by_dr_id = $editElement->ref_by_dr_id;
        $embryologist1 = $editElement->embryologist1;
        $embryologist2 = $editElement->embryologist2;

        $ref_by_dr_name = R::getRow('select name from awusers where user_id = ' . $ref_by_dr_id);
        $this->smarty->assign('ref_by_dr_name', $ref_by_dr_name["name"]);
        $embryologist1_name = R::getRow('select name from awusers where user_id = ' . $embryologist1);
        $this->smarty->assign('embryologist1_name', $embryologist1_name["name"]);

        $embryologist2_name = R::getRow('select name from awusers where user_id = ' . $embryologist2);
        $this->smarty->assign('embryologist2_name', $embryologist2_name["name"]);

        $freezingmedia = R::load('freezingmedia', $freezing_media_id);
        $this->smarty->assign('freezingmedia', $freezingmedia->media);

        $freezingprotocol = R::load('freezingprotocol', $freezing_protocol_id);
        $this->smarty->assign('freezingprotocol', $freezingprotocol->protocol);

        $this->smarty->assign('editElement', $editElement);

        $programesetting = R::findOne('programesetting');
        $this->smarty->assign('programesetting', $programesetting);
        if ($programesetting->tanks_view == 1) {
            $cells = $this->loadCellsDisplay($id);
            $this->smarty->assign('cells', $cells);
        } elseif ($programesetting->tanks_view == 2) {
            $this->tankStyle2();
        }
        $this->smarty->display('spermfreezing/print.html');
    }

    public function editModal() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);


        $tableName = filter_input(INPUT_POST, "tableName");

        $colName = filter_input(INPUT_POST, "colName");


        $alldata = R::findAll($tableName);

        $this->smarty->assign('alldata', $alldata);

        $this->smarty->assign('colName', $colName);

        $this->smarty->assign('tableName', $tableName);


        $this->smarty->display('spermfreezing/editmodel.html');
    }

    public function addNewRow() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //vars here
        $table = filter_input(INPUT_POST, 'tablename');
        $columname = filter_input(INPUT_POST, 'colName');

        ### insert into table
        $newtable = R::dispense($table);
        $newtable->$columname = "";

        $insertid = R::store($newtable);

        echo $insertid;
    }

    //edit the new row of modal
    public function updateModal() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);


        $tableName = filter_input(INPUT_POST, "tablename");
        $value = filter_input(INPUT_POST, "value");
        $id = filter_input(INPUT_POST, "id");

        $colName = filter_input(INPUT_POST, "colName");
        print_r($tableName);

        $mydata = R::load($tableName, $id);
        $mydata->$colName = $value;
        R::store($mydata);
    }

    public function delRowsommedel() {

        $id = filter_input(INPUT_POST, "id");
        $tableName = filter_input(INPUT_POST, "tableName");
        $myData = R::load($tableName, $id);
        R::trash($myData);

        echo 1;
    }

    function loadCellsDisplay($embryosLabId) {

        $cells = R::getAll('select tank_cell , location , btn_no , row_no , col_no  , cell_no 
                                        from embryoslab_tank_cells where deleted = 0 
                                         and embryoslab_id = ?  ', [$embryosLabId]);
        $i = 0;
        foreach ($cells as $cell) {
            $tanks_general = R::findOne('tanks_general', '  location = ?  and btn_no = ?  ', [$cell['location'], $cell['btn_no']]);
            $cells[$i]['rows_letter'] = $tanks_general->rows_letter;
            $i++;
        }
        return $cells;
    }

    public function tankLocation() {
        //check login
        autho::checkautho($this->hosturl);
        $specTabId = filter_input(INPUT_POST, "specTabId");
        $specCanId = filter_input(INPUT_POST, "specCanId");
        $preview = filter_input(INPUT_POST, "preview");

        $this->smarty->assign('specTabId', $specTabId);
        $this->smarty->assign('specCanId', $specCanId);
        $this->smarty->assign('preview', $preview);

        $this->tankLocationSetting();
        $this->smarty->display('spermfreezing/tank_location.html');
    }

    public function tankLocationDisplay() {
        //check login
        autho::checkautho($this->hosturl);
        $embryosLabId = filter_input(INPUT_POST, "embryosLabId");
        $cells = $this->loadCellsDisplay($embryosLabId);
        $this->smarty->assign('cells', $cells);
        $this->smarty->display('embryofreezing/cells.html');
    }

    function tankSetting() {
        //check login
        autho::checkautho($this->hosturl);

        //        $colors = array("#8db3e2", "#c4bc96", "#e5b8b7", "#d6e3bc", "#ccc0d9", "#b6dde8", "#fbd4b4", "#ffff66", "#ffccff");
        //        $this->smarty->assign('colors', $colors);
        $this->tankLocationSetting();

        $tanks_generalsA = R::findAll("tanks_general", '  location = "A"  order by  id asc  ');
        foreach ($tanks_generalsA as $tanks_general) {
            for ($i = 1; $i <= 9; $i++) {
                $col = 'row' . $i . '_color';
                $colLetter = 'color' . $i . '_letter';
                $colName = 'color' . $i . '_name';
                $color = R::load("colors", $tanks_general->$col);
                $tanks_general->$colName = $color->color_name;
                $tanks_general->$colLetter = $color->color_letter;
            }
        }

        $tanks_generalsB = R::findAll("tanks_general", '  location = "B"  order by  id asc  ');
        foreach ($tanks_generalsB as $tanks_general) {
            for ($i = 1; $i <= 9; $i++) {
                $col = 'row' . $i . '_color';
                $colLetter = 'color' . $i . '_letter';
                $colName = 'color' . $i . '_name';
                $color = R::load("colors", $tanks_general->$col);
                $tanks_general->$colName = $color->color_name;
                $tanks_general->$colLetter = $color->color_letter;
            }
        }


        $this->smarty->assign('tanks_generalsA', $tanks_generalsA);
        $this->smarty->assign('tanks_generalsB', $tanks_generalsB);

        $colors = R::findAll("colors");
        $this->smarty->assign('colors', $colors);

        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('embryofreezing/tank_settings.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    function tankLocationSetting() {
        for ($i = 1; $i <= 21; $i++) {
            $tanks_generalA = R::findOne('tanks_general', '  location = "A"  and btn_no = ' . $i);
            if (count($tanks_generalA) <= 0) {
                $tanks_generalA = R::xdispense('tanks_general');
                $tanks_generalA->location = "A";
                $tanks_generalA->btn_no = $i;
                R::store($tanks_generalA);
            }


            $tanks_generalB = R::findOne('tanks_general', '  location = "B"  and btn_no = ' . $i);
            if (count($tanks_generalB) <= 0) {
                $tanks_generalB = R::xdispense('tanks_general');
                $tanks_generalB->location = "B";
                $tanks_generalB->btn_no = $i;
                R::store($tanks_generalB);
            }
        }
    }

    function tankCanSetting($location, $btn_no) {
        $tanks_general = R::findOne('tanks_general', '  location = ?  and btn_no = ?  ', [$location, $btn_no]);
        for ($i = 1; $i <= 9; $i++) {
            $col = 'row' . $i . '_color';
            $colLetter = 'color' . $i . '_letter';
            $colName = 'color' . $i . '_name';
            $color = R::load("colors", $tanks_general->$col);
            $tanks_general->$colName = $color->color_name;
            $tanks_general->$colLetter = $color->color_letter;
        }
        $this->smarty->assign('tanks_general', $tanks_general);
        //   print_r($tanks_general);
    }

    public function tankCan() {
        //check login
        autho::checkautho($this->hosturl);

        $embryosLabId = filter_input(INPUT_POST, "embryosLabId");
        $preview = filter_input(INPUT_POST, "preview");
        $location = filter_input(INPUT_POST, "location");
        $no = filter_input(INPUT_POST, "no");

        $this->tankCanSetting($location, $no);
        if ($preview != 1) {
            $this->tankCanDetails($embryosLabId, $location, $no);
        } else {
            $this->smarty->assign('patCells', array());
            $this->smarty->assign('otherCells', array());
        }

        $this->smarty->assign('no', $no);
        $this->smarty->assign('location', $location);
        $this->smarty->assign('preview', $preview);
        $this->smarty->display('embryofreezing/tank_cans.html');
    }

    function tankCanDetails($embryosLabId) {
        $cells = R::getAll('select tank_cell  from embryoslab_tank_cells where deleted = 0 
                and embryoslab_id = ?  ', [$embryosLabId]);

        $other_cells = R::getAll('select tank_cell  from embryoslab_tank_cells where deleted = 0 
                and embryoslab_id != ?  ', [$embryosLabId]);

        #########################################
        $patCells = array();
        $otherCells = array();

        foreach ($cells as $value) {
            $tank_cell = trim($value['tank_cell']);
            array_push($patCells, $tank_cell);
        }
        $this->smarty->assign('patCells', $patCells);

        foreach ($other_cells as $value) {
            $tank_cell = trim($value['tank_cell']);
            array_push($otherCells, $tank_cell);
        }
        $this->smarty->assign('otherCells', $otherCells);

        #########################################
    }

    public function saveTankLocation() {
        //check login
        autho::checkautho($this->hosturl);
        $embryosLabId = filter_input(INPUT_POST, "embryosLabId");
        $selectedCells = json_decode(stripslashes(filter_input(INPUT_POST, 'selectedCells')));
        $errorMsg = ' ';
        $error = 0;
        $ids = '';
        $location = filter_input(INPUT_POST, "location");
        $btn_no = filter_input(INPUT_POST, "no");

        if (count($selectedCells) > 0) {

            foreach ($selectedCells as $cell) {
                $notEmpty = R::findOne(
                                'embryoslab_tank_cells',
                                'deleted = 0   and location = ?  and btn_no = ?
                and row_no = ?  and col_no = ?  and cell_no = ? and  embryoslab_id != ?  ',
                                [$cell[0], $cell[1], $cell[2], $cell[3], $cell[4], $embryosLabId]
                );
                if (count($notEmpty) > 0) {
                    $errorMsg = $cell[0] . ' _' . $cell[1] . ' _' . $cell[2] . ' _' . $cell[3] . ' _' . $cell[4] . '  reserved to another Patient';
                    $error = 1;
                } else {
                    $resForMe = R::findOne(
                                    'embryoslab_tank_cells',
                                    'deleted = 0   and location = ?  and btn_no = ?
                and row_no = ?  and col_no = ?  and cell_no = ? and  embryoslab_id = ?  ',
                                    [$cell[0], $cell[1], $cell[2], $cell[3], $cell[4], $embryosLabId]
                    );
                    if ($ids != '') {
                        $ids .= ' , ';
                    }
                    if (count($resForMe) > 0) {
                        $ids .= $resForMe->id;
                    } else {
                        $ids .= $this->storeTankCell($cell[0], $cell[1], $cell[2], $cell[3], $cell[4], $embryosLabId);
                    }
                }
            }

            R::exec('update  embryoslab_tank_cells set  deleted = 1  , userid_edit = ' . $_SESSION['user_id'] . ' 
               , date_edit = "' . date('Y-m-d H:i:s') . '"     where id  not in (' . $ids . ')  and embryoslab_id = ' . $embryosLabId . '   
                    and location = "' . $location . '"  and btn_no = "' . $btn_no . '" ');
        } else {
            R::exec('update  embryoslab_tank_cells set  deleted = 1  , userid_edit = ' . $_SESSION['user_id'] . ' 
               , date_edit = "' . date('Y-m-d H:i:s') . '"     where embryoslab_id = ' . $embryosLabId . ' 
                    and location = "' . $location . '"  and btn_no = "' . $btn_no . '" ');
        }

        if ($error != 1) {
            $errorMsg = ' saved Successfully ';
        }
        echo $errorMsg;
    }

    function storeTankCell($location, $btn_no, $row_no, $col_no, $cell_no, $embryoslab_id) {
        $add = R::xdispense('embryoslab_tank_cells');
        $add->embryoslab_id = $embryoslab_id;
        $add->location = $location;
        $add->btn_no = $btn_no;
        $add->row_no = $row_no;
        $add->col_no = $col_no;
        $add->cell_no = $cell_no;
        $add->date_add = date('Y-m-d H:i:s');
        $add->user_id = $_SESSION['user_id'];
        $add->tank_cell = $location . '_' . $btn_no . '_' . $row_no . '_' . $col_no . '_' . $cell_no;
        $add->deleted = 0;
        $id = R::store($add);
        return $id;
    }

    function tankStyle2() {
        $patientId = filter_input(INPUT_GET, "patientid");
        if (!$patientId)
            $patientId = filter_input(INPUT_POST, "patientid");

        // get patient info
        $patient = R::load('patients', $patientId);
        $this->smarty->assign('patientInfo', $patient);

//        $id = filter_input(INPUT_GET, "id");

        $controlName = 'sperm-freezing';

        # tanks
        $tanks = R::findAll('tanks');
        $this->smarty->assign('tanks', $tanks);

        // get tank cell for patient
        /*$tank_cells = R::getAll('select DISTINCT tank_id,up_level_name,cell_name,patient_id,tanks.name ,tanks.tank_type
                from tankcells inner join tanks on tankcells.tank_id = tanks.id where patient_id =  ? and tank_type = 1', [$patientId]);
        $this->smarty->assign('tank_cells', $tank_cells);
        $tank_cells_2 = R::getAll('select DISTINCT tank_id,up_level_name,cell_name,patient_id,tanks.name ,tanks.tank_type,cell_part_name 
                from tankcells inner join tanks on tankcells.tank_id = tanks.id where patient_id =  ? and tank_type = 2', [$patientId]);
        $this->smarty->assign('tank_cells_2', $tank_cells_2);
        $tank_cells_3 = R::getAll('select DISTINCT tank_id,up_level_name,cell_name,patient_id,tanks.name ,tanks.tank_type,cell_part_name 
                from tankcells inner join tanks on tankcells.tank_id = tanks.id where patient_id =  ? and tank_type = 3', [$patientId]);
        $this->smarty->assign('tank_cells_3', $tank_cells_3);*/

        $tank_cells = R::getAll('select DISTINCT tank_id,up_level_name,cell_name,patient_id,tanks.name ,tanks.tank_type
                from tank_cells inner join tanks on tank_cells.tank_id = tanks.id where patient_id =  ? and tank_type = 1', [$patientId]);
        $this->smarty->assign('tank_cells', $tank_cells);
        $tank_cells_2 = R::getAll('select DISTINCT tank_id,up_level_name,cell_name,patient_id,tanks.name ,tanks.tank_type,cell_part_name,tank_txt 
                from tank_cells inner join tanks on tank_cells.tank_id = tanks.id where patient_id =  ? and tank_type = 2', [$patientId]);
        $this->smarty->assign('tank_cells_2', $tank_cells_2);
        $tank_cells_3 = R::getAll(
            'select DISTINCT tank_id,up_level_name,cell_name,patient_id,tanks.name ,tanks.tank_type,tank_cells.id tcId, cell_part_name,tank_txt,cell_color,assign_at 
                from tank_cells inner join tanks on tank_cells.tank_id = tanks.id where patient_id = ? and control_name = ? and tank_type = 3',
            [$patientId, $controlName]
        );
        $this->smarty->assign('tank_cells_3', $tank_cells_3);
    }

    ### insert into table

    // at the end of class call

    public function __destruct() {
        //colse connection
        R::close();
    }

}
