<?php

require_once("imp/_imp.php");

class Controllers {

//public vars
    public $smarty;
    public $hosturl;
    public $controllname;
    public $shcontrollname;
    public $active;
    public $time;
    public $today;

// it will run in everytime with
// default requried
    public function __construct() {
        require_once("../public/aw_config.php");
        require_once("imp/_autho.php"); //general functions
        $this->smarty = $smarty;
        $this->hosturl = $hosturl;

//here name of controll to known
        $this->controllname = 'pharmacy';
        $this->shcontrollname = 'pharmacy';
        $this->smarty->assign('controllname', $this->controllname);
        $this->smarty->assign('shcontrollname', $this->shcontrollname);



//breadcrumbs
        require_once("../../_library/plugins/Breadcrumbs/Breadcrumbs.php");
        $acty = filter_input(INPUT_GET, 'ac');
        $bc = new breadcrumbs($hosturl, '', '', $acty);
        $bc->crumbs();
        $breadcrumbs = $bc->breadcrumbs;
        $smarty->assign('breadcrumbs', $breadcrumbs);

# here show the active page in menu
// array called active[] with level of active element
        $active[0] = 'programesetting'; //controller name or tab name
        $active[1] = 'pharmacy'; //controller name
// do name  // switch($do)
        switch ($acty) {
            case '':$active[2] = 'show';
                break;
            case 'show':$active[2] = 'show';
                break;
            default :$active[2] = 'show';
                break;
        }
        $this->active = $active;

        R::ext('xdispense', function ($type) {
            return R::getRedBean()->dispense($type);
        });

        require_once("pres_common.php");
        require_once("_header.php");
        require_once("_sidebar.php");
        require_once("_leftsidebar.php");
        require_once("_footer.php");

//find loading time
        $this->time = microtime(true);
        $this->today = date('Y-m-d');
    }

    public function index() {
//check login
        autho::checkautho($this->hosturl);
//check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

####################################################################
        $today = date("Y/m/d");
        $this->smarty->assign('today', date('Y/m/d', strtotime($today)));

        $doctors = R::getAll('select awusers.* from awusers
               join  awrole   on awrole.id =   awusers.role_id
                  where awrole.is_doctor =  1 and deleted != 1  ');
        $this->smarty->assign('doctors', $doctors);
####################################################################
//call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('pharmacy/show.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    function presSearch() {
        $findate = filter_input(INPUT_POST, 'findate');
        $todate = filter_input(INPUT_POST, 'todate');
        $doctorId = (filter_input(INPUT_POST, 'doctorId') > 0) ? filter_input(INPUT_POST, 'doctorId') : 0;
        $wId = filter_input(INPUT_POST, 'wId');
        $hId = filter_input(INPUT_POST, 'hId');
        $patientId = 0;
        if ($wId > 0 || $hId > 0) {
            if ($hId > 0) {
                $patientId = $hId;
            } else {
                $patientId = $wId;
            }
        }
        $ext = $this->presSearchEx($doctorId, $patientId);
        $this->presSearchAlll($findate, $todate, $ext);
        $this->smarty->display('pharmacy/pres_result.html');
    }

    function presSearchEx($doctorId, $patientId) {
        $ext = '';
        if (!empty($doctorId) && $doctorId > 0) {
            $ext .= ' and prescription.doctor_id = ' . $doctorId;
        }

        if (!empty($patientId) && $patientId > 0) {
            $ext .= ' and prescription.patient_id = ' . $patientId;
        }

        return $ext;
    }

    function presSearchAlll($dateFrom, $dateTo, $ext) {

        $sql = 'select   prescription.id  , prescription.pres_date  , patients.statusno  , prescription.for_husband
                                , patients.wifename, patients.husdandname ,  awusers.name  as drName 
                                , prescription.patient_id , prescription.prepared , prescription.delivered
                   from    prescription
                             join patients                             on patients.id  = prescription.patient_id
                               left join awusers                    on awusers.user_id = prescription.doctor_id  
                                
                         where    prescription.pres_date >= "' . $dateFrom . '" AND pres_date <= "' . $dateTo . '"    ' . $ext . ' 
                          order by  prescription.pres_date asc      ';

        $pres = R::getAll($sql);
        $this->smarty->assign('pres', $pres);
    }

    public function updatePre() {
        autho::checkautho($this->hosturl);

        $id = filter_input(INPUT_POST, "id");
        $colName = filter_input(INPUT_POST, "colName");

        try {
            $obj = R::load('prescription', $id);
            $obj->$colName = 1;
            $colName2 = $colName . '_userid';
            $obj->$colName2 = $_SESSION['user_id'];
            R::store($obj);

            echo 1;
        } catch (Exception $e) {
            echo -1;
        }
    }

    public function details() {
        //check login
        autho::checkautho($this->hosturl);

####################################################################
        $presId = filter_input(INPUT_GET, "id");
        $pres = preDetails($presId);
        $this->smarty->assign('pres', $pres);
        ####################################################################
        $this->smarty->display('pharmacy/details_all.html');
    }

    ###########################################################
// at the end of class call

    public function __destruct() {
//echo "Time Elapsed: ".(microtime(true) - $this->time)."s";
//close connection
        R::close();
    }

}
