<?php

require_once("imp/_imp.php");

class Controllers {

//public vars
    public $smarty;
    public $hosturl;
    public $controllname;
    public $shcontrollname;
    public $active;
    public $time;
    public $today;
    public $patientid;

// it will run in everytime with
// default requried
    public function __construct() {
        require_once("../public/aw_config.php");
        require_once("imp/_autho.php"); //general functions
        $this->smarty = $smarty;
        $this->hosturl = $hosturl;

//here name of controll to known
        $this->controllname = 'patientdecleration';
        $this->shcontrollname = 'patientdecleration';
        $this->smarty->assign('controllname', $this->controllname);
        $this->smarty->assign('shcontrollname', $this->shcontrollname);



//breadcrumbs
        require_once("../../_library/plugins/Breadcrumbs/Breadcrumbs.php");
        $acty = filter_input(INPUT_GET, 'ac');
        $bc = new breadcrumbs($hosturl, '', '', $acty);
        $bc->crumbs();
        $breadcrumbs = $bc->breadcrumbs;
        $smarty->assign('breadcrumbs', $breadcrumbs);

# here show the active page in menu
// array called active[] with level of active element
        $active[0] = 'patientdecleration'; //controller name or tab name
        $active[1] = 'patientdecleration'; //controller name
// do name  // switch($do)
        switch ($acty) {
            case '':
                $active[2] = 'show';
                break;
            case 'show':
                $active[2] = 'show';
                break;
            default :
                $active[2] = 'show';
                break;
        }
        $this->active = $active;



        #include upload function
        require_once("../../_library/plugins/classupload/uploadfunctions.php");

//here will call all php pages
        require_once("_header.php");
        require_once("_patientdata.php");
        require_once("_sidebar.php");
        require_once("_leftsidebar.php");
        require_once("_footer.php");

        $this->patientid = patientdata::patientid();

        //find loading time
        $this->time = microtime(true);
        $this->today = date('Y-m-d');
    }

    public function index() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $patientid = filter_input(INPUT_GET, "patientid");

        if (empty($patientid)) {
            header('Location:' . $this->hosturl . '/controllers/index.php?empty=1');
            exit();
        }
        //load all declarations for patient here
        $showElems = R::getAll("SELECT patientdecleration.* ,decleration.title FROM patientdecleration join decleration on decleration.id =patientdecleration.decleration_id WHERE patientdecleration.patientid =$patientid order by id asc");
        $this->smarty->assign('showElems', $showElems);

        $this->smarty->assign('patientId', $patientid);

        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        if ($patientid) {
            patientdata::patientdatashow($this->smarty, $this->hosturl);
        }
        $this->smarty->display('patientdecleration/show.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function add() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);



        $patientid = filter_input(INPUT_GET, "patientid");


        if (empty($patientid)) {
            header('Location:' . $this->hosturl . '/controllers/index.php?empty=1');
            exit();
        } else {

            $this->smarty->assign('patientId', $patientid);

            //call other class with other content
            header::headershow($this->smarty, $this->hosturl);
            sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
            if ($patientid) {
                patientdata::patientdatashow($this->smarty, $this->hosturl);
            }
//list declarations
            $decleration = R::getAll('SELECT * FROM decleration');
            $this->smarty->assign('decleration', $decleration);



            $this->smarty->display('patientdecleration/add.html');
            leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
            footer::footershow($this->smarty, $this->hosturl);
        }
    }

    public function addit() {


        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //add declaration for patient
        $decleration_id = filter_input(INPUT_POST, 'decleration_name');
        $patientid = filter_input(INPUT_GET, "patientid");
        $upfile = uploadnew('bgfile', False, 0, 0, 'decleration_files');

        $patientData = R::load("patients", $patientId);
        $this->smarty->assign('patientData', $patientData);

        //here the add
        $patient_decleration = R::dispense('patientdecleration');

        $patient_decleration->decleration_id = $decleration_id;
        $patient_decleration->date = date('Y-m-d h:i:s');
        $patient_decleration->patientid = $patientid;
        $patient_decleration->uploadfile = $upfile;
        $patient_decleration->user_id = $_SESSION['user_id'];

        $this->smarty->assign('patientId', $patientid);

        $patientData = R::load("patients", $patientId);
        $this->smarty->assign('patientData', $patientData);


        try {
            $id = R::store($patient_decleration);
            if (!empty($patientid)) {
                header('Location:' . $this->hosturl . '/controllers/' . $this->controllname . '.php?ac=show&patientid=' . $patientid);
            } else {
                header('Location:' . $this->hosturl . '/controllers/' . $this->controllname . '.php?ac=show');
            }
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/error/notadd/' . $this->controllname);
        }
    }

    public function show() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $patientid = filter_input(INPUT_GET, "patientid");

        if (empty($patientid)) {
            header('Location:' . $this->hosturl . '/controllers/index.php?empty=1');
            exit();
        }
        //load all declarations for patient here
        $showElems = R::getAll("SELECT patientdecleration.* ,decleration.title FROM patientdecleration join decleration on decleration.id =patientdecleration.decleration_id WHERE patientdecleration.patientid =$patientid order by id asc");
        $this->smarty->assign('showElems', $showElems);

        $this->smarty->assign('patientId', $patientid);

        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        if ($patientid) {
            patientdata::patientdatashow($this->smarty, $this->hosturl);
        }
        $this->smarty->display('patientdecleration/show.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function edit() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //get id for item
        $id = filter_input(INPUT_GET, 'id');
        $patientid = filter_input(INPUT_GET, "patientid");

        if (empty($patientid)) {
            header('Location:' . $this->hosturl . '/controllers/index.php?empty=1');
            exit();
        }

        //load all here
        $editElement = R::load('patientdecleration', $id);

        $decleration = R::getAll('SELECT * FROM decleration');
        $this->smarty->assign('decleration', $decleration);

        $decl = R::load('decleration', $editElement->decleration_id);
        $this->smarty->assign('decl', $decl);

        $this->smarty->assign('editElement', $editElement);
        $this->smarty->assign('patientId', $patientid);


        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        if ($patientid) {
            patientdata::patientdatashow($this->smarty, $this->hosturl);
        }
        $this->smarty->display('patientdecleration/edit.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function updateit() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //vars here
        $name = filter_input(INPUT_POST, 'decleration_name');
        $upfile = uploadnew('bgfile', False, 0, 0, 'decleration_files');
        $edit_file = filter_input(INPUT_POST, 'edit_file');
        $id = filter_input(INPUT_POST, 'edit_declar');

        $patientid = filter_input(INPUT_GET, "patientid");

        if (empty($patientid)) {
            header('Location:' . $this->hosturl . '/controllers/index.php?empty=1');
            exit();
        }
        $this->smarty->assign('patientId', $patientid);


        //here the update
        $patient_decleration = R::load('patientdecleration', $id);
        if (!empty($upfile)) {
            $patient_decleration->uploadfile = $upfile;
        } else {
            $patient_decleration->uploadfile = edit_file;
        }
        $patient_decleration->decleration_id = $name;
        $patient_decleration->date = date('Y-m-d h:i:s');
        $patient_decleration->patientid = $patientid;
        $patient_decleration->user_id = $_SESSION['user_id'];



        try {
            R::store($patient_decleration);
            if (!empty($patientid)) {
                header('Location:' . $this->hosturl . '/controllers/' . $this->controllname . '.php?ac=show&patientid=' . $patientid);
            } else {
                header('Location:' . $this->hosturl . '/controllers/' . $this->controllname . '.php?ac=show');
            }
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/error/notupdate/' . $this->controllname);
        }
    }

    public function del() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        $id = filter_input(INPUT_POST, 'id');
        $del = R::load("patientdecleration", $id);
        try {
            R::trash($del);
            echo 1;
        } catch (Exception $e) {
            
        }
    }

    public function showprint() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $patientId = filter_input(INPUT_POST, "patientId");

        $declerationId = filter_input(INPUT_POST, "decleration");

        $decleration = R::load('decleration', $declerationId);

        $this->smarty->assign('date', $this->today);
        $this->smarty->assign('patientId', $patientId);
        $this->smarty->assign('decleration', $decleration);

        $patient_details = R::load('patients', $patientId);
        $this->smarty->assign('patient_details', $patient_details);


        $user_id = $_SESSION['user_id'];

        $ProgramesettingData = R::findone('programesetting');
        $this->smarty->assign('ProgramesettingData', $ProgramesettingData);


        $reception_name = R::findOne('awusers', 'user_id = ? ', [$user_id]);
        $this->smarty->assign('reception_name', $reception_name);

        $doc_name = R::findOne('awusers', 'user_id = ? ', [$decleration['doctor_id']]);
        $this->smarty->assign('doc_name', $doc_name);


        $this->smarty->display('patientdecleration/print.html');
    }

//print declaration in show
    public function getinstdetail() {


        $patientId = filter_input(INPUT_POST, "patientId");

        $patient_decleration_id = filter_input(INPUT_POST, "patient_decleration_id");
        $patientdecleration = R::load('patientdecleration', $patient_decleration_id);
        $decleration = R::load('decleration', $patientdecleration->decleration_id);
//        print_r($decleration);
        $this->smarty->assign('decleration', $decleration);

        $patientId = filter_input(INPUT_POST, "patientId");


        $patient = R::load('patients', $patientId);

        $wifetypes = R::load('wifetypes', $patient->wiftypeid);
        $this->smarty->assign('name', $patient->wifename);

        $doc_name = R::findOne('awusers', 'user_id = ? ', [$decleration['doctor_id']]);
        $this->smarty->assign('doc_name', $doc_name);

        $reception_name = R::findOne('awusers', 'user_id = ? ', [$patientdecleration['user_id']]);
        $this->smarty->assign('reception_name', $reception_name);

        $patient_details = R::load('patients', $patientId);
        $this->smarty->assign('patient_details', $patient_details);

        $this->smarty->assign('date', $this->today);

        $this->smarty->assign('patientId', $patientId);

        $ProgramesettingData = R::findone('programesetting');
        $this->smarty->assign('ProgramesettingData', $ProgramesettingData);


        $this->smarty->display('patientdecleration/print_show.html');
    }

    // at the end of class call
    public function __destruct() {
        //colse connection
        R::close();
    }

}
