<?php

require_once("imp/_imp.php");

class Controllers {

//public vars
    public $smarty;
    public $hosturl;
    public $controllname;
    public $shcontrollname;
    public $active;
    public $time;
    public $today;

// it will run in everytime with
// default requried
    public function __construct() {
        require_once("../public/aw_config.php");
        require_once("imp/_autho.php"); //general functions
        $this->smarty = $smarty;
        $this->hosturl = $hosturl;

//here name of controll to known
        $this->controllname = 'case_summary';
        $this->shcontrollname = 'case_summary';
        $this->smarty->assign('controllname', $this->controllname);
        $this->smarty->assign('shcontrollname', $this->shcontrollname);



//breadcrumbs
        require_once("../../_library/plugins/Breadcrumbs/Breadcrumbs.php");
        $acty = filter_input(INPUT_GET, 'ac');
        $bc = new breadcrumbs($hosturl, '', '', $acty);
        $bc->crumbs();
        $breadcrumbs = $bc->breadcrumbs;
        $smarty->assign('breadcrumbs', $breadcrumbs);

# here show the active page in menu
// array called active[] with level of active element
        $active[0] = 'programesetting'; //controller name or tab name
        $active[1] = 'case_summary'; //controller name
// do name  // switch($do)
        switch ($acty) {
            case '':$active[2] = 'show';
                break;
            case 'show':$active[2] = 'show';
                break;
            default :$active[2] = 'show';
                break;
        }
        $this->active = $active;

        R::ext('xdispense', function ($type) {
            return R::getRedBean()->dispense($type);
        });

        require_once("visits_common.php"); //general functions
//here will call all php pages
        require_once("_header.php");
        require_once("_patientdata.php");
        require_once("_sidebar.php");
        require_once("_leftsidebar.php");
        require_once("_footer.php");

        //find loading time
        $this->time = microtime(true);
        $this->today = date('Y-m-d');
    }

    public function index() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);


        ######################################################################################
        $patientId = filter_input(INPUT_GET, "patientid");
        if (empty($patientId)) {
            header('Location:' . $this->hosturl . '/controllers/index.php?empty=1');
            exit();
        }
        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        patientdata::patientdatashow($this->smarty, $this->hosturl);
        $this->smarty->assign('patientId', $patientId);
        $this->smarty->display('case_summary/head.html');
        ######################################################################################
        $this->patientInfo($patientId);
        $this->personalHistory($patientId);
        $this->menstrualHistory($patientId, 'case_summary');
        $this->obstetricHistory($patientId);
        $this->smarty->display('case_summary/obstetric.html');
        $this->pastMedical($patientId);
        $this->pastSurgical($patientId);
        $this->pastGynecological($patientId);
        $this->smarty->display('case_summary/past.html');
        $this->familyHistory($patientId);
        $this->smarty->display('case_summary/family.html');
        $this->sexualHistory($patientId);
        $this->smarty->display('case_summary/sexual.html');
        $this->investigation($patientId, 0);
        $this->pasrArt($patientId);
        $this->smarty->display('case_summary/art.html');
        $this->finalDiagnosis($patientId);
        ######################################################################################
        $this->smarty->display('case_summary/foot.html');

        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function obstetric() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);


        ######################################################################################
        $patientId = filter_input(INPUT_GET, "patientid");
        if (empty($patientId)) {
            header('Location:' . $this->hosturl . '/controllers/index.php?empty=1');
            exit();
        }
        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        patientdata::patientdatashow($this->smarty, $this->hosturl);
        $this->smarty->assign('patientId', $patientId);
        $this->smarty->display('case_summary_obstetric/head.html');
        ######################################################################################
        $this->patientInfo($patientId);
        $this->personalHistory($patientId);
        $this->obstetricOpHistory($patientId);
        $this->complaint();
        $this->previous_obs($patientId);
        $this->menstrualHistory($patientId, 'case_summary_obstetric');
        $this->smarty->display('case_summary_obstetric/obstetric.html');
        $this->pastMedical($patientId);
        $this->pastSurgical($patientId);
        $this->pastContraception($patientId);
        $this->bloodDrug();
        $this->smarty->display('case_summary_obstetric/past.html');
        $this->smarty->display('case_summary_obstetric/present.html');
        $this->generalExam($patientId);
        $this->smarty->display('case_summary_obstetric/abdominal.html');
        $this->localExam($patientId);
        $this->smarty->display('case_summary_obstetric/obs.html');
        $this->smarty->display('case_summary_obstetric/doppler.html');
        ######################################################################################
        $this->smarty->display('case_summary_obstetric/foot.html');

        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    ##########################################################

    public function update() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $id = filter_input(INPUT_POST, "id");
        $tablename = filter_input(INPUT_POST, "tableName");
        $colname = filter_input(INPUT_POST, "colName");
        $value = filter_input(INPUT_POST, "value");

        $names = array('drug_sensitivity', 'blood_transfusion', 'complaint_analysis', 'symptoms'
            , 'diagnosis', 'recommend', 'complaint');
        if (in_array($colname, $names)) {
            $diagnosis = json_decode($value);
            sort($diagnosis);
            $value = "";
            foreach ($diagnosis as $myname) {
                $value = $value . $myname . ",";
            }
            $value = substr($value, 0, -1);
        }

        try {
            $obj = R::load($tablename, $id);
            $obj->$colname = $value;
            if ($colname == 'phl_mp') {
                $obj->edd = date("Y-m-d", strtotime("+ 7 days", strtotime($obj->phl_mp . ' +9 months ')));
                $data = date("Y/m/d", strtotime($obj->edd));
                $data .= ',' . date("Y/m/d", strtotime($obj->phl_mp));
                echo $data;
            }

            if ($colname == 'edd') {
                $obj->phl_mp = date("Y-m-d", strtotime("- 7 days", strtotime($obj->edd . ' -9 months ')));
                $data = date("Y/m/d", strtotime($obj->edd));
                $data .= ',' . date("Y/m/d", strtotime($obj->phl_mp));
                echo $data;
            }

            R::store($obj);
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/error/notupdate/' . $this->controllname);
        }
    }

    public function del() {

        //check login
        autho::checkautho($this->hosturl);
//        //check authoize
//        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $id = filter_input(INPUT_POST, 'id');
        $tableName = filter_input(INPUT_POST, 'tableName');
        $colName = filter_input(INPUT_POST, 'colName');
        try {
            R::exec('update  ' . $tableName . ' set ' . $colName . ' = 1  WHERE id = ' . $id);
            echo 1;
        } catch (Exception $e) {
            echo $e;
        }
    }

    public function addInvRow() {
        //check login
        autho::checkautho($this->hosturl);

        $doctorid = $_SESSION['user_id'];
        $today = date("Y/m/d");
        $patientid = filter_input(INPUT_POST, "patientId");
        $tableName = filter_input(INPUT_POST, "tableName");
        $for_husband = filter_input(INPUT_POST, "hus");
        $itr = filter_input(INPUT_POST, "itr");

        try {
            $semenData = R::xdispense($tableName);
            $semenData->sdate = date("Y-m-d", strtotime($today));
            $semenData->patientid = $patientid;
            $semenData->doctorid = $doctorid;
            $semenData->del = 0;
            if ($for_husband == 1) {
                $semenData->for_husband = 1;
            }
            $semenid = R::store($semenData);
            $semenData->sdate = date('Y/m/d', strtotime($semenData->sdate));

            $this->smarty->assign('objId', $semenid);
            $this->smarty->assign('sdate', $semenData->sdate);
            $this->smarty->assign('tableName', $tableName);
            $this->smarty->assign('for_husband', $for_husband);
            $this->smarty->assign('itr', $itr);
            $this->smarty->display('case_summary/inv_row.html');
        } catch (Exception $ex) {
            echo -1;
        }
    }

    public function addnewrecord() {
//check login
        autho::checkautho($this->hosturl);

//vars here
        $table = filter_input(INPUT_POST, 'selectId');
        $name = filter_input(INPUT_POST, 'new_name');

        $obj_id = filter_input(INPUT_POST, 'id');
        $tableName = filter_input(INPUT_POST, 'tableName');
        $colName = filter_input(INPUT_POST, 'colName');

        try {

            $record = R::xdispense($table);
            $record->name = $name;
            if ($table = 'diagnosis' || $table = 'recommend' || $table = 'complaint') {
                $record->conditions = 0;
            } else {
                $record->deleted = 0;
            }

            $id = R::store($record);

            if ($obj_id > 0) {

                $obj = R::load($tableName, $obj_id);
                $obj->$colName = $id;
                R::store($obj);
            }


            echo $id;
        } catch (Exception $e) {
            echo $e;
        }
    }

    public function adddiagnosis() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
//        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $name = filter_input(INPUT_POST, "diagnosisName");
        $id = filter_input(INPUT_POST, "id");
        $table = filter_input(INPUT_POST, "table");
        try {
            $diagnosis = R::xdispense($table);
            $diagnosis->name = $name;
            if ($table == 'diagnosis' || $table == 'recommend' || $table == 'complaintant') {
                $diagnosis->conditions = 0;
            } else {
                $diagnosis->deleted = 0;
            }
            $did = R::store($diagnosis);




            if ($table == 'diagnosis') {
                $summary_obstetric = R::load('summary_obstetric', $id);
                if (empty($summary_obstetric->diagnosis)) {
                    $summary_obstetric->diagnosis = $did;
                } else {
                    $summary_obstetric->diagnosis = $summary_obstetric->diagnosis . ',' . $did;
                }
            }
            ##
            elseif ($table == 'recommend') {
                $summary_obstetric = R::load('summary_obstetric', $id);
                if (empty($summary_obstetric->recommend)) {
                    $summary_obstetric->recommend = $did;
                } else {
                    $summary_obstetric->recommend = $summary_obstetric->recommend . ',' . $did;
                }
            }
            ##
            elseif ($table == 'complaintant') {
                $summary_obstetric = R::load('obstetric_case', $id);
                if (empty($summary_obstetric->complaint)) {
                    $summary_obstetric->complaint = $did;
                } else {
                    $summary_obstetric->complaint = $summary_obstetric->complaint . ',' . $did;
                }
            }

            ##
            elseif ($table == 'drug_sensitivity') {
                $summary_obstetric = R::load('obstetric_case', $id);
                if (empty($summary_obstetric->drug_sensitivity)) {
                    $summary_obstetric->drug_sensitivity = $did;
                } else {
                    $summary_obstetric->drug_sensitivity = $summary_obstetric->drug_sensitivity . ',' . $did;
                }
            }

            ##
            elseif ($table == 'blood_transfusion') {
                $summary_obstetric = R::load('obstetric_case', $id);
                if (empty($summary_obstetric->blood_transfusion)) {
                    $summary_obstetric->blood_transfusion = $did;
                } else {
                    $summary_obstetric->blood_transfusion = $summary_obstetric->blood_transfusion . ',' . $did;
                }
            }
            ##
            elseif ($table == 'complaint_analysis') {
                $summary_obstetric = R::load('obstetric_case', $id);
                if (empty($summary_obstetric->complaint_analysis)) {
                    $summary_obstetric->complaint_analysis = $did;
                } else {
                    $summary_obstetric->complaint_analysis = $summary_obstetric->complaint_analysis . ',' . $did;
                }
            }
            ##
            elseif ($table == 'symptoms') {
                $summary_obstetric = R::load('obstetric_case', $id);
                if (empty($summary_obstetric->symptoms)) {
                    $summary_obstetric->symptoms = $did;
                } else {
                    $summary_obstetric->symptoms = $summary_obstetric->symptoms . ',' . $did;
                }
            }
            ##
            elseif ($table == 'pre_history') {
                $summary_obstetric = R::load('pre_anaesthetic', $id);
                if (empty($summary_obstetric->pre_history)) {
                    $summary_obstetric->pre_history = $did;
                } else {
                    $summary_obstetric->pre_history = $summary_obstetric->pre_history . ',' . $did;
                }
            }

            R::store($summary_obstetric);


            echo $did;
        } catch (Exception $e) {
            echo $e;
            //header('Location:' . $this->hosturl . '/error/notupdate/' . $this->controllname);
        }
    }

    public function newRecord() {
//check login
        autho::checkautho($this->hosturl);

//vars here
        $tableName = filter_input(INPUT_POST, 'tableName');
        $colName = filter_input(INPUT_POST, 'colName');
        $isDate = filter_input(INPUT_POST, 'isDate');
        $returnId = filter_input(INPUT_POST, 'returnId');
        $patientId = filter_input(INPUT_POST, 'patientId');
        try {
            $record = R::xdispense($tableName);
            if ($isDate == 1) {
                $record->$colName = date("Y-m-d");
            }
            $record->patientid = $patientId;
            $record->id = R::store($record);

            if ($returnId == 1) {
                echo $record->id;
            } else {
                if ($isDate == 1) {
                    $record->sdate = date('Y/m/d', strtotime($record->sdate));
                }

                $itr = R::count($tableName, ' deleted = ? ', [0]);
                $this->smarty->assign('itr', $itr);
                $this->smarty->assign('sign', $record);
                $this->smarty->assign('tableName', $tableName);
                $this->smarty->display('case_summary_obstetric/rows.html');
            }
        } catch (Exception $e) {
            echo $e;
        }
    }

    ##########################################################

    public function printopcase() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        $patientId = filter_input(INPUT_POST, "patientId");
        $programesetting = R::findOne('programesetting');
        $this->smarty->assign('programesetting', $programesetting);
        $this->patientInfo($patientId);
        $this->personalHistory($patientId, 1);
        $this->obstetricOpHistoryPrint($patientId);
        $this->menstrualHistoryPrint($patientId);
        $this->pastMedicalPrint($patientId);
        $this->pastSurgicalPrint($patientId);
        $this->pastContraceptionPrint($patientId);
        $this->pastPresentPrint($patientId);
        $this->generalExamPrint($patientId);

        $this->smarty->assign('case_summary', 1);
        $this->smarty->display('case_summary_obstetric/printcase.html');
    }

    function complaint() {
        $allcomplaint = R::findall('complaintant', 'conditions = 0 order by name');
        $this->smarty->assign('allcomplaint', $allcomplaint);

        $this->smarty->display('case_summary_obstetric/complaint.html');
    }

    function previous_obs($patientId) {
        $previous_pregnancies = R::findall('previous_pregnancies', 'patientid = ? and deleted = 0 ', [$patientId]);
        $this->smarty->assign('previous_pregnancies', $previous_pregnancies);

        $previous_puerperium = R::findall('previous_puerperium', 'patientid = ? and deleted = 0 ', [$patientId]);
        $this->smarty->assign('previous_puerperium', $previous_puerperium);
    }

    function obstetricOpHistory($patientId) {
        $obstetric_case = R::findOne('obstetric_case', 'patientid = ?', [$patientId]);
        if (count($obstetric_case) < 1) {
            $obstetricData = $this->obstetricData($patientId);
            $obstetric_case = R::xdispense('obstetric_case');
            $obstetric_case->patientid = $patientId;
            $obstetric_case->g = $obstetricData['g'];
            $obstetric_case->p = $obstetricData['p'];
            $obstetric_case->ab = $obstetricData['ab'];
            $obstetric_case->currently = $obstetricData['currently'];
            $obstetric_case->last_delivery = $obstetricData['last_delivery'];
            $obstetric_case->id = R::store($obstetric_case);
        }

        $selectArray = explode(',', $obstetric_case->complaint);
        $obstetric_case->complaint = $selectArray;

        $selectArray = explode(',', $obstetric_case->drug_sensitivity);
        $obstetric_case->drug_sensitivity = $selectArray;

        $selectArray = explode(',', $obstetric_case->blood_transfusion);
        $obstetric_case->blood_transfusion = $selectArray;

        $selectArray = explode(',', $obstetric_case->complaint_analysis);
        $obstetric_case->complaint_analysis = $selectArray;

        $selectArray = explode(',', $obstetric_case->symptoms);
        $obstetric_case->symptoms = $selectArray;
        $this->smarty->assign('obstetric_case', $obstetric_case);

        $tables = array("ftnds", "preterm", "still_birth", "difficults", "cs");
        foreach ($tables as $tableName) {
            $data = R::findAll($tableName, ' deleted = 0 ');
            $this->smarty->assign($tableName, $data);
        }
    }

    function obstetricOpHistoryPrint($patientId) {
        $obstetric_case = R::findOne('obstetric_case', 'patientid = ?', [$patientId]);

        $v = 1;
        $complaint = ' ';
        $selectArray = explode(',', $obstetric_case->complaint);

        foreach ($selectArray as $data) {
            $diag = R::load('complaintant', $data);
            if ($diag->conditions < 1) {
                if ($v > 1) {
                    $complaint .= ' , ';
                }

                $complaint .= $diag->name;

                $v++;
            }
        }
        $this->smarty->assign('complaint', $complaint);

        $v = 1;
        $drug_sensitivity = ' ';
        $selectArray = explode(',', $obstetric_case->drug_sensitivity);

        foreach ($selectArray as $data) {
            $diag = R::load('drug_sensitivity', $data);
            if ($diag->deleted < 1) {
                if ($v > 1) {
                    $drug_sensitivity .= ' , ';
                }

                $drug_sensitivity .= $diag->name;

                $v++;
            }
        }
        $this->smarty->assign('drug_sensitivity', $drug_sensitivity);

        $v = 1;
        $blood_transfusion = ' ';
        $selectArray = explode(',', $obstetric_case->blood_transfusion);

        foreach ($selectArray as $data) {
            $diag = R::load('blood_transfusion', $data);
            if ($diag->deleted < 1) {
                if ($v > 1) {
                    $blood_transfusion .= ' , ';
                }

                $blood_transfusion .= $diag->name;

                $v++;
            }
        }
        $this->smarty->assign('blood_transfusion', $blood_transfusion);

        $v = 1;
        $complaint_analysis = ' ';
        $selectArray = explode(',', $obstetric_case->complaint_analysis);

        foreach ($selectArray as $data) {
            $diag = R::load('complaint_analysis', $data);
            if ($diag->deleted < 1) {
                if ($v > 1) {
                    $complaint_analysis .= ' , ';
                }

                $complaint_analysis .= $diag->name;

                $v++;
            }
        }
        $this->smarty->assign('complaint_analysis', $complaint_analysis);

        if (!empty($obstetric_case->complaint_analysis_note)) {
            $complaint_analysis_note = '( ' . $obstetric_case->complaint_analysis_note . ' )';
        }
        $this->smarty->assign('complaint_analysis_note', $complaint_analysis_note);

        $v = 1;
        $symptoms = ' ';
        $selectArray = explode(',', $obstetric_case->symptoms);

        foreach ($selectArray as $data) {
            $diag = R::load('symptoms', $data);
            if ($diag->deleted < 1) {
                if ($v > 1) {
                    $symptoms .= ' , ';
                }

                $symptoms .= $diag->name;

                $v++;
            }
        }
        $this->smarty->assign('symptoms', $symptoms);

        if (!empty($obstetric_case->symptoms_note)) {
            $symptoms_note = '( ' . $obstetric_case->symptoms_note . ' )';
        }
        $this->smarty->assign('symptoms_note', $symptoms_note);

        $approaching = ' ';
        $x = 1;
        $names = array("Lightening" => "lightening", "Pelvic Pressure Symptoms" => "pelvic_pressure"
            , "Vaginal Discharge" => "vaginal_discharge", "False Labor pains" => "false_labor"
            , "True Labor Pains" => "true_labor", "Passage of Show" => "passage"
        );

        foreach ($names as $showName => $dbName) {
            if ($obstetric_case->$dbName == 1) {
                if ($x > 1) {
                    $approaching .= ' , ';
                }
                $approaching .= $showName;
                $x++;
            }
        }
        $this->smarty->assign('approaching', $approaching);

        $cols = array("ftnds", "preterm", "still_birth", "difficults", "cs", "appearance", "gaint"
            , "contour", "skin", "abdominal", "umbilicus", "subcostal", "divarication", "hair", "superficial"
            , "deep_palpation", "fundal_level", "fundal_grip", "umbilical_grip", "pelvicf", "pelvics");
        foreach ($cols as $name) {
            $data = R::load($name, $obstetric_case->$name);
            $obstetric_case->$name = $data->name;
        }


        $this->smarty->assign('obstetric_case', $obstetric_case);
    }

    function pastContraception($patientId) {
        $allcontract = R::findall('phcontraception', 'del = ? and patientid = ? order by  id DESC', [0, $patientId]);

        $allphcontracttype = R::findall('phcontracttype', 'del = 0 order by name');
        $this->smarty->assign('allphcontracttype', $allphcontracttype);

        $this->smarty->assign('allcontractcount', count($allcontract));
        $this->smarty->assign('allcontract', $allcontract);
    }

    function bloodDrug() {
        $tables = array("drug_sensitivity", "blood_transfusion", "complaint_analysis", "symptoms"
            , "appearance", "gaint", "head", "neck", "breast", "chest", "limbs", "back"
            , "contour", "skin", "abdominal", "umbilicus", "subcostal", "divarication", "hair", "superficial"
            , "deep_palpation", "fundal_level", "fundal_grip", "umbilical_grip", "pelvicf", "pelvics"
            , "obs_no", "viability", "fetal_gender", "presentation", "liquor", "placenta_site", "placenta_abnormalites");
        foreach ($tables as $tableName) {
            $data = R::findAll($tableName, ' deleted = 0 ');
            $this->smarty->assign($tableName, $data);
        }
    }

    function pastContraceptionPrint($patientId) {
        $allcontract = R::findall('phcontraception', 'del = ? and patientid = ? order by  id DESC', [0, $patientId]);
        $contraception = '';

        $i = 1;
        foreach ($allcontract as $obj) {
            if ($obj->contype > 0) {
                $operation = R::load('phcontracttype', $obj->contype);
                if ($i > 1) {
                    $contraception .= ' - ';
                }

                $contraception .= $operation->name;

                if (!empty($obj->contranote)) {
                    $contraception .= '( ' . $obj->contranote . ' )';
                }
                $i++;
            }
        }
        $this->smarty->assign('contraception', $contraception);
    }

    function pastPresentPrint($patientId) {
        $allcontract = R::findall('phcontraception', 'del = ? and patientid = ? order by  id DESC', [0, $patientId]);
        $contraception = '';

        $i = 1;
        foreach ($allcontract as $obj) {
            if ($obj->contype > 0) {
                $operation = R::load('phcontracttype', $obj->contype);
                if ($i > 1) {
                    $contraception .= ' - ';
                }

                $contraception .= $operation->name;

                if (!empty($obj->contranote)) {
                    $contraception .= '( ' . $obj->contranote . ' )';
                }
                $i++;
            }
        }
        $this->smarty->assign('contraception', $contraception);
    }

    function generalExam($patientId) {
        $vital_sign = R::findAll('vital_sign', ' deleted = 0 and patientid = ?   ', [$patientId]);
        foreach ($vital_sign as $record) {
            $record->sdate = date('Y/m/d', strtotime($record->sdate));
        }
        $this->smarty->assign('vital_sign', $vital_sign);
        $this->smarty->display('case_summary_obstetric/general.html');
    }

    function localExam($patientId) {
        $obstetric_case_ex = R::findOne('obstetric_case_ex', 'patientid = ?', [$patientId]);
        if (count($obstetric_case_ex) < 1) {
            $obstetric_case_ex = R::xdispense('obstetric_case_ex');
            $obstetric_case_ex->patientid = $patientId;
            $obstetric_case_ex->id = R::store($obstetric_case_ex);
        }
        $this->smarty->assign('obstetric_case_ex', $obstetric_case_ex);
        $this->smarty->display('case_summary_obstetric/local.html');
    }

    function generalExamPrint($patientId) {
        $vital_sign = R::findOne('vital_sign', ' deleted = 0 and patientid = ? order by sdate desc    ', [$patientId]);
        $vital_sign->sdate = date('Y/m/d', strtotime($vital_sign->sdate));
        $this->smarty->assign('sign', $vital_sign);

        $obstetric_case_ex = R::findOne('obstetric_case_ex', 'patientid = ?', [$patientId]);

        $cols = array("obs_no", "viability", "fetal_gender", "presentation", "liquor"
            , "placenta_site", "placenta_abnormalites");
        foreach ($cols as $name) {
            $data = R::load($name, $obstetric_case_ex->$name);
            $obstetric_case_ex->$name = $data->name;
        }
        $this->smarty->assign('obstetric_case_ex', $obstetric_case_ex);
    }

    ##########################################################

    function patientInfo($patientId) {
        $patient = R::load('patients', $patientId);

        $today1 = new DateTime(date('Y-m-d'));
        $dateHusband = new DateTime($patient->husbanddateofbirth);
        $dateWife = new DateTime($patient->dateofbirth);

        if ($patient->dateofbirth == '0000-00-00' || is_null($patient->dateofbirth)) {
            $this->smarty->assign('wAge', 0);
        } else {
## calculate wife age
            $interva2 = $today1->diff($dateWife);
            $this->smarty->assign('wAge', $interva2->y);
        }

        if ($patient->husbanddateofbirth == '0000-00-00' || is_null($patient->husbanddateofbirth)) {
            $this->smarty->assign('hAge', 0);
            $patient->husbanddateofbirth = '00-00-0000';
        } else {
## calculate husband age
            $interval = $today1->diff($dateHusband);
            $this->smarty->assign('hAge', $interval->y);
            $patient->husbanddateofbirth = date('d-m-Y ', strtotime($patient->husbanddateofbirth));
        }

        if ($patient->mirragefromdate == '0000-00-00' || is_null($patient->mirragefromdate)) {
            $patient->mirragefromdate = '';
        } else {
            $patient->mirragefromdate = date('d/m/Y', strtotime($patient->mirragefromdate));
        }

        if (!empty($patient->wifejob)) {
            $wifeJob = R::findOne('wifejobs', 'id = ? ', [$patient->wifejob]);
            $patient->wifejob = $wifeJob->title;
        }

        if (!empty($patient->husbandjob)) {
            $husbandJob = R::findOne('husbandjobs', 'id = ? ', [$patient->husbandjob]);
            $patient->husbandjob = $husbandJob->title;
        }

        $this->smarty->assign('patient', $patient);
    }

    function personalHistory($patientId, $print = 0) {
        $phpersonal = R::findOne('phpersonal', 'del = ? and patientid = ? order by id DESC', [0, $patientId]);
        if (count($phpersonal) < 1) {
            $phpersonal = R::dispense('phpersonal');
            $phpersonal->patientid = $patientId;
            $phpersonal->doctorid = $_SESSION['user_id'];
            $phpersonal->sysdate = $this->today;
            $phpersonal->personal_habits = '';
            $phpersonal->present_marriage = '';
            $phpersonal->offsprings = '';
            $phpersonal->hus_personal_habits = '';
            $phpersonal->hus_present_marriage = '';
            $phpersonal->hus_offsprings = '';
            $phpersonal->del = 0;
            $phpersonal->id = R::store($phpersonal);
        }
        $this->smarty->assign('phpersonal', $phpersonal);
        if ($print != 1) {
            $this->smarty->display('case_summary/personal.html');
        }
    }

    function menstrualHistory($patientId, $folderName) {
        $phmenstrual = R::findOne('phmenstrual', 'del = ? and patientid = ? order by phl_mp  DESC, id desc', [0, $patientId]);
        if (count($phmenstrual) < 1) {
            $phmenstrual = R::dispense('phmenstrual');
            $phmenstrual->patientid = $patientId;
            $phmenstrual->doctorid = $_SESSION['user_id'];
            $phmenstrual->sysdate = $this->today;
            $phmenstrual->menarche = '';
            $phmenstrual->duration = '';
            $phmenstrual->length = '';
            $phmenstrual->phregularity = '';
            $phmenstrual->phamount = '';
            $phmenstrual->phdysmenorrhoea = '';
            $phmenstrual->phl_mp = $this->today;
            $phmenstrual->edd = date("Y-m-d", strtotime("+ 7 days", strtotime($this->today . ' +9 months ')));
            $phmenstrual->del = 0;
            $phmenstrual->id = R::store($phmenstrual);
        }

        if (!empty($phmenstrual->phl_mp)) {
            $phmenstrual->phl_mp = date('Y/m/d', strtotime($phmenstrual->phl_mp));
        }
        if (!empty($phmenstrual->edd)) {
            $phmenstrual->edd = date('Y/m/d', strtotime($phmenstrual->edd));
        }

        $allphregualrity = R::findall('phregularity', 'del = 0 order by name');
        $this->smarty->assign('allphregualrity', $allphregualrity);

        $allphamount = R::findall('phamount', 'del = 0 order by name');
        $this->smarty->assign('allphamount', $allphamount);

        $allphdysmenorrhoea = R::findall('phdysmenorrhoea', 'del = 0 order by name');
        $this->smarty->assign('allphdysmenorrhoea', $allphdysmenorrhoea);

        $this->smarty->assign('phmenstrual', $phmenstrual);
        $this->smarty->display($folderName . '/menstrual.html');
    }

    function obstetricHistory($patientId) {
        $summaryObstetric = R::findOne('summary_obstetric', 'patientid = ?', [$patientId]);
        if (count($summaryObstetric) < 1) {
            $obstetricData = $this->obstetricData($patientId);
            $summaryObstetric = R::xdispense('summary_obstetric');
            $summaryObstetric->patientid = $patientId;
            $summaryObstetric->g = $obstetricData['g'];
            $summaryObstetric->p = $obstetricData['p'];
            $summaryObstetric->cs = $obstetricData['cs'];
            $summaryObstetric->ab = $obstetricData['ab'];
            $summaryObstetric->ectopicd = $obstetricData['ectopicd'];
            $summaryObstetric->vmole = $obstetricData['vmole'];
            $summaryObstetric->currently = $obstetricData['currently'];
            $summaryObstetric->last_delivery = $obstetricData['last_delivery'];
            $summaryObstetric->other_inv = $this->otherInvs($patientId);
            $summaryObstetric->id = R::store($summaryObstetric);
        } else {
            if (empty($summaryObstetric->other_inv) || $summaryObstetric->other_inv == null) {
                $summaryObstetric->other_inv = $this->otherInvs($patientId);
                R::store($summaryObstetric);
            }
        }
        if (!empty($summaryObstetric->last_delivery)) {
            $summaryObstetric->last_delivery = date('Y/m/d', strtotime($summaryObstetric->last_delivery));
        }

        $selectArray = explode(',', $summaryObstetric->diagnosis);
        $summaryObstetric->diagnosis = $selectArray;

        $selectArray = explode(',', $summaryObstetric->recommend);
        $summaryObstetric->recommend = $selectArray;
        $this->smarty->assign('summaryObstetric', $summaryObstetric);

        $summaryObstetricAbortion = R::findAll('summary_obstetric_abortion', 'patientid = ? and del = 0', [$patientId]);
        foreach ($summaryObstetricAbortion as $abortion) {
            if (!empty($abortion->obsdate)) {
                $abortion->obsdate = date('Y/m/d', strtotime($abortion->obsdate));
            }
        }
        $this->smarty->assign('summaryObstetricAbortion', $summaryObstetricAbortion);
    }

    function obstetricData($patientId) {
        $getAllPatientData = R::getRow("SELECT * FROM patients WHERE id = $patientId");

#### c.s count
        $csdata = R::getAll('select id from phobstetric where obstermination =? and del = 0  and patientid = ?  '
                        , [2, $patientId]);
        $lastCs = R::getRow('select id ,obsdate  from phobstetric where obstermination =? and del = 0  and patientid = ? order by obsdate desc   ', [2, $patientId]);
        $cs = $getAllPatientData['cs'];
        $cscounter = count($csdata) + $cs;
#### p count
        $svddata = R::getAll('select id from phobstetric where obstermination =? and del = 0  and patientid = ?  ', [1, $patientId]);
        $p = $getAllPatientData['pno'];
        $pcounter = count($svddata) + $cscounter + $p;

###AB COUNT
        $Abortiondata = R::getAll('select id ,obsdate , obstrduration from phobstetric where obstermination =? and del = 0  and patientid = ?  ', [4, $patientId]);
//  $lastAbortion = R::getRow('select id ,obsdate , obstrduration  from phobstetric where obstermination =? and del = 0  and patientid = ? order by obsdate desc   ', [4, $patientId]);
        $ab = $getAllPatientData['ab'];
        $abcounter = count($Abortiondata) + $ab;

        foreach ($Abortiondata as $abortion) {
            $summaryObstetricAbortion = R::xdispense('summary_obstetric_abortion');
            $summaryObstetricAbortion->patientid = $patientId;

            if (!empty($abortion['obsdate'])) {
                $summaryObstetricAbortion->obsdate = $abortion['obsdate'];
            }

            if (!empty($abortion['obstrduration'])) {
                $summaryObstetricAbortion->obstrduration = $abortion['obstrduration'];
            }
            R::store($summaryObstetricAbortion);
        }

###Ectopic COUNT
        $Ectopicdata = R::getAll('select id from phobstetric where obstermination =? and del = 0  and patientid = ?  ', [3, $patientId]);
        $Ectopic = $getAllPatientData['ectopic'];
        $Ectopiccounter = count($Ectopicdata) + $Ectopic;

###Vmole COUNT
        $Vmoledata = R::getAll('select id from phobstetric where obstermination =? and del = 0  and patientid = ?  ', [5, $patientId]);
        $vmodel = $getAllPatientData['vmodel'];
        $vmodelcounter = count($Vmoledata) + $vmodel;

        $currently = 0;
        if ($getAllPatientData['currently'] == 1) {
            $currently = 1;
        }

        $obstriccountnew = $currently + $pcounter + $abcounter + $Ectopiccounter + $vmodelcounter;

        $data = array(
            'cs' => $cscounter
            , 'last_delivery' => $lastCs['obsdate']
            , 'p' => $pcounter
            , 'ab' => $abcounter
            , 'ectopicd' => $Ectopiccounter
            , 'vmole' => $vmodelcounter
            , 'currently' => $currently
            , 'g' => $obstriccountnew
        );

        return $data;
    }

    function sumAbortionAdd() {
        $patientId = filter_input(INPUT_POST, "patientId");
        if ($patientId > 0) {
            $summaryObstetricAbortion = R::xdispense('summary_obstetric_abortion');
            $summaryObstetricAbortion->patientid = $patientId;
            $summaryObstetricAbortion->id = R::store($summaryObstetricAbortion);
            echo $summaryObstetricAbortion->id;
        } else {
            echo -1;
        }
    }

    function pastGynecological($patientId) {
        $phpastgynecological = R::findall('phpastgynecological', 'del = ? and patientid = ? order by 
                gynecologicalyear desc,  id DESC', [0, $patientId]);

        $allphpastgynecologicaloperation = R::findall('phpastgynecologicaloperation', 'del = 0 order by name');
        $this->smarty->assign('allphpastgynecologicaloperation', $allphpastgynecologicaloperation);
        $this->smarty->assign('phpastgynecologicalcount', count($phpastgynecological));
        $this->smarty->assign('phpastgynecological', $phpastgynecological);
    }

    function pastMedical($patientId) {
        $mypastmedical = R::findall('phpastmedical', 'del = ? and patientid = ? order by id DESC', [0, $patientId]);

        $allphpastmedicaldisease = R::findall('phpastmedicaldisease', 'del = 0 order by name');
        $this->smarty->assign('allphpastmedicaldisease', $allphpastmedicaldisease);
        $this->smarty->assign('phpastmedicalcount', count($mypastmedical));
        $this->smarty->assign('mypastmedical', $mypastmedical);
    }

    function pastSurgical($patientId) {
        $pastsurgical = R::findall('phpastsurgical', 'del = ? and patientid = ? order by 
                phsurgicalyear desc, id DESC', [0, $patientId]);

        $allphpastsurgicaloperation = R::findall('phpastsurgicaloperation', 'del = 0 order by name');
        $this->smarty->assign('allphpastsurgicaloperation', $allphpastsurgicaloperation);
        $this->smarty->assign('pastsurgicalcount', count($pastsurgical));
        $this->smarty->assign('pastsurgical', $pastsurgical);
    }

    function familyHistory($patientId) {
        $allphfamilydisease = R::findall('phfamilydisease', 'del = 0 order by name');
        $this->smarty->assign('allphfamilydisease', $allphfamilydisease);

        $allphfamilyrelative = R::findall('phfamilyrelative', 'del = 0 order by name');
        $this->smarty->assign('allphfamilyrelative', $allphfamilyrelative);

        $phfamily = R::findall('phfamily', 'del = ? and patientid = ? order by id DESC', [0, $patientId]);
        $this->smarty->assign('phfamilycountx', count($phfamily));
        $this->smarty->assign('phfamily', $phfamily);
    }

    function sexualHistory($patientId) {
        $phsexual = R::findall('phsexual', 'del = ? and patientid = ? order by id DESC', [0, $patientId]);

        $sexual_types = R::findall('phsexualtypes', 'del = 0 order by name');
        $this->smarty->assign('sexual_types', $sexual_types);

        $this->smarty->assign('phsexualcount', count($phsexual));
        $this->smarty->assign('phsexual', $phsexual);
    }

    function investigation($patientId, $print = 0) {
        if ($print != 1) {
            $this->smarty->display('case_summary/investigation_hus.html');
            $this->pastHx($patientId);
            $this->smarty->display('case_summary/pasthx.html');
            $this->semen($patientId, 1, 'semen_hus');
            $this->hormon($patientId, 1, 'hormon_hus');
            $this->smarty->display('case_summary/investigation_foot.html');

            $this->smarty->display('case_summary/investigation_wife.html');
            //  $this->semen($patientId, 0, 'semen_wife');
            $this->hormon($patientId, 0, 'hormon_wife');
            $this->other_hormon($patientId, 0, 'other_hormon_wife');
            $this->hsg($patientId);
            $this->laparoscopy($patientId);
            $this->hysteroscopy($patientId);
            $this->ustv($patientId);
            $this->smarty->display('case_summary/others.html');
            $this->smarty->display('case_summary/investigation_foot.html');
        } else {
            $this->pastHxPrint($patientId);
            $this->semenPrint($patientId);
        }
    }

    function pastHx($patientId) {
        $phpasthx = R::findall('phpasthx', 'del = ? and patientid = ? order by id DESC', [0, $patientId]);
        $phpasthx_types = R::findall('phpasthxtypes', 'del = 0 order by name');
        $this->smarty->assign('phpasthx_types', $phpasthx_types);


        $this->smarty->assign('phpasthxcount', count($phpasthx));
        $this->smarty->assign('phpasthx', $phpasthx);
    }

    function semen($patientId, $for_husband, $objName) {
        $semens = R::findAll('semen', 'patientid = ? and del = 0 and for_husband = ?  order by sdate desc, id desc'
                        , [$patientId, $for_husband]);

        foreach ($semens as $semen) {
            if (!empty($semen->sdate) && $semen->sdate) {
                $semen->sdate = date('Y/m/d', strtotime($semen->sdate));
            }
        }

        $this->smarty->assign($objName, $semens);
        $this->smarty->assign($objName . 'Count', count($semens));
        $this->smarty->display('case_summary/' . $objName . '.html');
    }

    function hormon($patientId, $for_husband, $objName) {
        $hormons = R::findAll('hormon', 'patientid = ? and del = 0 and for_husband = ? order by sdate desc, id desc'
                        , [$patientId, $for_husband]);

        foreach ($hormons as $hormon) {
            if (!empty($hormon->sdate)) {
                $hormon->sdate = date('Y/m/d', strtotime($hormon->sdate));
            }
        }

        $this->smarty->assign($objName, $hormons);
        $this->smarty->assign($objName . 'Count', count($hormons));
        $this->smarty->display('case_summary/' . $objName . '.html');
    }

    function other_hormon($patientId, $for_husband, $objName) {
        $other_hormons = R::findAll('other_hormon', 'patientid = ? and del = 0 and for_husband = ? order by sdate desc, id desc'
                        , [$patientId, $for_husband]);

        foreach ($other_hormons as $other_hormon) {
            if (!empty($other_hormon->sdate)) {
                $other_hormon->sdate = date('Y/m/d', strtotime($other_hormon->sdate));
            }
        }

        $this->smarty->assign($objName, $other_hormons);
        $this->smarty->assign($objName . 'Count', count($other_hormons));
        $this->smarty->display('case_summary/' . $objName . '.html');
    }

    function hsg($patientId) {
        $hsgs = R::findAll('hsg', 'patientid = ? and del = 0 order by sdate desc, id desc', [$patientId]);
        foreach ($hsgs as $hsg) {
            if (!empty($hsg->sdate)) {
                $hsg->sdate = date('Y/m/d', strtotime($hsg->sdate));
            }
        }

        $this->smarty->assign('hsgs', $hsgs);
        $this->smarty->assign('hsgCount', count($hsgs));

        $this->smarty->display('case_summary/hsg.html');
    }

    function laparoscopy($patientId) {
        $laparoscopys = R::findAll('laparoscopy', 'patientid = ? and del = 0 order by sdate desc, id desc', [$patientId]);
        foreach ($laparoscopys as $laparoscopy) {
            if (!empty($laparoscopy->sdate)) {
                $laparoscopy->sdate = date('Y/m/d', strtotime($laparoscopy->sdate));
            }
        }
        $this->smarty->assign('laparoscopys', $laparoscopys);
        $this->smarty->assign('laparoscopyCount', count($laparoscopys));
        $this->smarty->display('case_summary/laparoscopy.html');
    }

    function hysteroscopy($patientId) {
        $hysteroscopys = R::findAll('hysteroscopy', 'patientid = ? and del = 0 order by sdate desc, id desc', [$patientId]);
        foreach ($hysteroscopys as $hysteroscopy) {
            if (!empty($hysteroscopy->sdate)) {
                $hysteroscopy->sdate = date('Y/m/d', strtotime($hysteroscopy->sdate));
            }
        }
        $this->smarty->assign('hysteroscopys', $hysteroscopys);
        $this->smarty->assign('hysteroscopyCount', count($hysteroscopys));
        $this->smarty->display('case_summary/hysteroscopy.html');
    }

    function ustv($patientId) {
        $ustvs = R::findAll('ustv', 'patientid = ? and del = 0 order by sdate desc, id desc', [$patientId]);

        foreach ($ustvs as $ustv) {
            if (!empty($ustv->sdate)) {
                $ustv->sdate = date('Y/m/d', strtotime($ustv->sdate));
            }
        }
        $this->smarty->assign('ustvs', $ustvs);
        $this->smarty->assign('ustvCount', count($ustvs));
        $this->smarty->display('case_summary/ustv.html');
    }

    function otherInvs($patientId) {
        $res = ' ';
        $otherinvest = R::findOne('otherinvestigationsrows', 'patientid = ? and deleted = 0 order by date desc, id desc'
                        , [$patientId]);

        if (!empty($otherinvest->date)) {
            $otherinvest->date = date('Y/m/d', strtotime($otherinvest->date));
            $res .= ' Date  : ' . $otherinvest->date;
        }

        $investValues = R::findAll('otherinvestigationsvalues', 'investrowid = ? ', [$otherinvest->id]);
        foreach ($investValues as $data) {
            $other = R::load('otherinvestigations', $data->investid);
            if (!empty($data->value)) {
                $res .= '  ,  ' . $other->name . '  : ' . $data->value;
            }
        }
        return $res;
    }

    function pasrArt($patientId) {
        $allphpastarttype = R::findall('phpastarttype', 'del = 0 order by name');
        $this->smarty->assign('allphpastarttype', $allphpastarttype);

        $allphpastartcenter = R::findall('phpastartcenter', 'del = 0 order by name');
        $this->smarty->assign('allphpastartcenter', $allphpastartcenter);

        $artResult = R::findall('phpastartresult', 'del = 0 order by name');
        $this->smarty->assign('artResult', $artResult);

        //$allphpastart = R::findall('phpastart', 'del = ? and patientid = ? order by id DESC', [$del, $this->patientid]);
        $phpastart = R::findall('phpastart', 'del = ? and patientid = ? order by artyear desc, id DESC', [0, $patientId]);
        $this->smarty->assign('phpastartcount', count($phpastart));
        $this->smarty->assign('phpastart', $phpastart);
    }

    function finalDiagnosis() {
        $alldiagnosis = R::findall('diagnosis', 'conditions = 0 order by name');
        $this->smarty->assign('alldiagnosis', $alldiagnosis);

        $allrecommends = R::findall('recommend', 'conditions = 0 order by name');
        $this->smarty->assign('allrecommends', $allrecommends);


        $this->smarty->display('case_summary/final.html');
    }

    ##########################################################

    public function printcase() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $patientId = filter_input(INPUT_POST, "patientId");
        $programesetting = R::findOne('programesetting');
        $this->smarty->assign('programesetting', $programesetting);
        $this->patientInfo($patientId);
        $this->personalHistory($patientId, 1);
        $this->menstrualHistoryPrint($patientId);
        $this->obstetricHistoryPrint($patientId);
        $this->pastMedicalPrint($patientId);
        $this->pastSurgicalPrint($patientId);
        $this->pastGynecologicalPrint($patientId);
        $this->familyHistoryPrint($patientId);
        $this->sexualHistoryPrint($patientId);
        $this->investigation($patientId, 1);
        $this->pasrArtPrint($patientId);

        $this->smarty->assign('case_summary', 1);
        $this->smarty->display('patienthistory/printcase.html');
    }

    function obstetricHistoryPrint($patientId) {
        $summaryObstetric = R::findOne('summary_obstetric', 'patientid = ?', [$patientId]);
        $this->smarty->assign('otherInvs', $summaryObstetric->other_inv);

        $v = 1;
        $diagnosis = ' ';
        $selectArray = explode(',', $summaryObstetric->diagnosis);

        foreach ($selectArray as $data) {
            $diag = R::load('diagnosis', $data);
            if ($diag->conditions < 1) {
                if ($v > 1) {
                    $diagnosis .= ' , ';
                }

                $diagnosis .= $diag->name;

                $v++;
            }
        }
        $this->smarty->assign('diagnosis', $diagnosis);

        $v = 1;
        $recommend = ' ';
        $selectArray = explode(',', $summaryObstetric->recommend);

        foreach ($selectArray as $data) {
            $diag = R::load('recommend', $data);
            if ($diag->conditions < 1) {
                if ($v > 1) {
                    $recommend .= ' , ';
                }

                $recommend .= $diag->name;

                $v++;
            }
        }
        $this->smarty->assign('recommend', $recommend);

        $this->smarty->assign('pcounter', $summaryObstetric->p);
        $this->smarty->assign('cscounter', $summaryObstetric->cs);
        $this->smarty->assign('abcounter', $summaryObstetric->ab);
        $this->smarty->assign('Ectopiccounter', $summaryObstetric->ectopicd);
        $this->smarty->assign('vmodelcounter', $summaryObstetric->vmole);
        $obstriccountnew = $summaryObstetric->currently + $summaryObstetric->p + $summaryObstetric->ab +
                $summaryObstetric->ectopicd + $summaryObstetric->vmole;
        $this->smarty->assign('myallobsteric', $obstriccountnew);

        if (!empty($summaryObstetric->last_delivery)) {
            $summaryObstetric->last_delivery = date('Y/m/d', strtotime($summaryObstetric->last_delivery));
        }
        $this->smarty->assign('lastCsDelivery', $summaryObstetric->last_delivery);

        $Abortiondata = R::getAll('select id ,obsdate , obstrduration from summary_obstetric_abortion 
                where patientid = ? and del = 0    ', [$patientId]);
        foreach ($Abortiondata as $abortion) {
            if (!empty($abortion['obsdate'])) {
                $abortion['obsdate'] = date('d/m/Y', strtotime($abortion['obsdate']));
            }

            if (!empty($abortion['obstrduration'])) {
                $abortion['obstrduration'] = $abortion['obstrduration'] . ' W ';
            }
        }

        $this->smarty->assign('Abortiondata', $Abortiondata);
        $this->smarty->assign('AbortiondataCount', count($Abortiondata));
    }

    function pastGynecologicalPrint($patientId) {
        $phpastgynecological = R::findall('phpastgynecological', 'del = ? and patientid = ? order by 
                gynecologicalyear desc,  id DESC', [0, $patientId]);

        $gynecological = '';

        $i = 1;
        foreach ($phpastgynecological as $obj) {
            if ($obj->gynecologicaloperation > 0) {
                $operation = R::load('phpastgynecologicaloperation', $obj->gynecologicaloperation);
                if ($i > 1) {
                    $gynecological .= ' - ';
                }

                $gynecological .= $operation->name;

                if (!empty($obj->gynecologicalnote)) {
                    $gynecological .= '( ' . $obj->gynecologicalnote . ' )';
                }
                $i++;
            }
        }
        $this->smarty->assign('gynecological', $gynecological);
    }

    function pastMedicalPrint($patientId) {
        $mypastmedical = R::findall('phpastmedical', 'del = ? and patientid = ? order by id DESC', [0, $patientId]);

        $hus_medical = '';
        $medical = '';

        $i = 1;
        $j = 1;
        foreach ($mypastmedical as $obj) {
            if ($obj->medicaldisease > 0) {
                $operation = R::load('phpastmedicaldisease', $obj->medicaldisease);
## husband ###############################################
                if ($obj->for_husband == 1) {
                    if ($i > 1) {
                        $hus_medical .= ' - ';
                    }
                    $hus_medical .= $operation->name;

                    if (!empty($obj->medicalnote)) {
                        $hus_medical .= '( ' . $obj->medicalnote . ' )';
                    }

                    $i++;
                }
## wife ###############################################
                else {
                    if ($j > 1) {
                        $medical .= ' - ';
                    }
                    $medical .= $operation->name;

                    if (!empty($obj->medicalnote)) {
                        $medical .= '( ' . $obj->medicalnote . ' )';
                    }

                    $j++;
                }
            }
        }
        $this->smarty->assign('hus_medical', $hus_medical);
        $this->smarty->assign('medical', $medical);
    }

    function pastSurgicalPrint($patientId) {
        $pastsurgical = R::findall('phpastsurgical', 'del = ? and patientid = ? order by 
                phsurgicalyear desc, id DESC', [0, $patientId]);

        $hus_surgical = '';
        $surgical = '';

        $i = 1;
        $j = 1;
        foreach ($pastsurgical as $obj) {
            if ($obj->surgicaloperation > 0) {
                $operation = R::load('phpastsurgicaloperation', $obj->surgicaloperation);

## husband ###############################################
                if ($obj->for_husband == 1) {
                    if ($i > 1) {
                        $hus_surgical .= ' - ';
                    }
                    $hus_surgical .= $operation->name;

                    if (!empty($obj->surgicalnote)) {
                        $hus_surgical .= '( ' . $obj->surgicalnote . ' )';
                    }

                    $i++;
                }
## wife ###############################################
                else {
                    if ($j > 1) {
                        $surgical .= ' - ';
                    }
                    $surgical .= $operation->name;

                    if (!empty($obj->surgicalnote)) {
                        $surgical .= '( ' . $obj->surgicalnote . ' )';
                    }

                    $j++;
                }
            }
        }
        $this->smarty->assign('hus_surgical', $hus_surgical);
        $this->smarty->assign('surgical', $surgical);
    }

    function menstrualHistoryPrint($patientId) {
        $phmenstrual = R::findOne('phmenstrual', 'del = ? and patientid = ? order by phl_mp  DESC, id desc', [0, $patientId]);
        if (count($phmenstrual) < 1) {
            $phmenstrual = R::dispense('phmenstrual');
            $phmenstrual->patientid = $patientId;
            $phmenstrual->doctorid = $_SESSION['user_id'];
            $phmenstrual->sysdate = $this->today;
            $phmenstrual->menarche = '';
            $phmenstrual->duration = '';
            $phmenstrual->length = '';
            $phmenstrual->phregularity = '';
            $phmenstrual->phamount = '';
            $phmenstrual->phdysmenorrhoea = '';
            $phmenstrual->phl_mp = $this->today;
            $phmenstrual->del = 0;
            $phmenstrual->id = R::store($phmenstrual);
        }

        if (!empty($phmenstrual->phl_mp)) {
            $phmenstrual->phl_mp = date('Y/m/d', strtotime($phmenstrual->phl_mp));
        }

        $phregualrity = R::load('phregularity', $phmenstrual->phregularity);
        $phmenstrual->phregularity = $phregualrity->name;

        $phamount = R::load('phamount', $phmenstrual->phamount);
        $phmenstrual->phamount = $phamount->name;

        $phdysmenorrhoea = R::load('phdysmenorrhoea', $phmenstrual->phdysmenorrhoea);
        $phmenstrual->phdysmenorrhoea = $phdysmenorrhoea->name;
        $this->smarty->assign('phmenstrual', $phmenstrual);
    }

    function familyHistoryPrint($patientId) {
        $results = R::findall('phfamily', 'del = ? and patientid = ? 
                order by   id DESC', [0, $patientId]);

        $hus_family = '';
        $family = '';

        $i = 1;
        $j = 1;
        foreach ($results as $obj) {
            $rel = '';
            if ($obj->family_disease > 0) {
                if ($obj->family_relative > 0) {
                    $relative = R::load('phfamilyrelative', $obj->family_relative);
                    $rel = $relative->name . ' : ';
                }
                $operation = R::load('phfamilydisease', $obj->family_disease);
## husband ###############################################
                if ($obj->for_husband == 1) {
                    if ($i > 1) {
                        $hus_family .= ' - ';
                    }
                    $hus_family .= $rel . ' ' . $operation->name;

                    if (!empty($obj->familynote)) {
                        $hus_family .= '( ' . $obj->familynote . ' )';
                    }

                    $i++;
                }
## wife ###############################################
                else {
                    if ($j > 1) {
                        $family .= ' - ';
                    }
                    $family .= $rel . ' ' . $operation->name;

                    if (!empty($obj->familynote)) {
                        $family .= '( ' . $obj->familynote . ' )';
                    }

                    $j++;
                }
            }
        }
        $this->smarty->assign('hus_family', $hus_family);
        $this->smarty->assign('family', $family);
    }

    function sexualHistoryPrint($patientId) {
        $phsexual = R::findOne('phsexual', 'del = ? and patientid = ? order by id DESC', [0, $patientId]);
        $sexual_type = R::load('phsexualtypes', $phsexual->sexual_type);
        $phsexual->sexual_type = $sexual_type->name;
        $this->smarty->assign('phsexual', $phsexual);
    }

    function pastHxPrint($patientId) {
        $phpasthx = R::findall('phpasthx', 'del = ? and patientid = ? order by id DESC', [0, $patientId]);
        $txt = '';

        $i = 1;
        foreach ($phpasthx as $data) {
            $phpasthxtypes = R::load('phpasthxtypes', $data->pasthx_type);
            if ($i > 1) {
                $txt .= ' - ';
            }
            $txt .= $phpasthxtypes->name;

            if (!empty($data->pasthxnote)) {
                $txt .= '( ' . $data->pasthxnote . ' )';
            }


            $i++;
        }
        $this->smarty->assign('phpasthx', $txt);
    }

    function pasrArtPrint($patientId) {

        $iui = R::findall('phpastart', ' arttype = 1  and del = ? and patientid = ? order by artyear desc, id DESC', [0, $patientId]);
        $icsi = R::findall('phpastart', ' arttype = 3  and del = ? and patientid = ? order by artyear desc, id DESC', [0, $patientId]);

        foreach ($iui as $data) {
            $center = R::load('phpastartcenter', $data->artcenter);
            $data->artcenter = $center->name;

            $result = R::load('phpastartresult', $data->result);
            $data->result = $result->name;
        }

        foreach ($icsi as $data) {
            $center = R::load('phpastartcenter', $data->artcenter);
            $data->artcenter = $center->name;

            $result = R::load('phpastartresult', $data->result);
            $data->result = $result->name;
        }
        $this->smarty->assign('iui', $iui);
        $this->smarty->assign('iuiCount', count($iui));
        $this->smarty->assign('icsi', $icsi);
        $this->smarty->assign('icsiCount', count($icsi));
    }

    function semenPrint($patientId) {
        $semen = R::findOne('semen', 'patientid = ? and del = 0 order by sdate desc, id desc', [$patientId]);
        if (!empty($semen->sdate) && $semen->sdate) {
            $semen->sdate = date('Y/m/d', strtotime($semen->sdate));
        }
        $this->smarty->assign('semen', $semen);
        $this->smarty->assign('semenCount', count($semen));

        $hormon = R::findOne('hormon', 'patientid = ? and del = 0 order by sdate desc, id desc', [$patientId]);
        if (!empty($hormon->sdate)) {
            $hormon->sdate = date('Y/m/d', strtotime($hormon->sdate));
        }
        $this->smarty->assign('hormon', $hormon);
        $this->smarty->assign('hormonCount', count($hormon));

        $hsg = R::findOne('hsg', 'patientid = ? and del = 0 order by sdate desc, id desc', [$patientId]);
        if (!empty($hsg->sdate)) {
            $hsg->sdate = date('Y/m/d', strtotime($hsg->sdate));
        }
        $this->smarty->assign('hsg', $hsg);
        $this->smarty->assign('hsgCount', count($hsg));

        $laparoscopy = R::findOne('laparoscopy', 'patientid = ? and del = 0 order by sdate desc, id desc', [$patientId]);
        if (!empty($laparoscopy->sdate)) {
            $laparoscopy->sdate = date('Y/m/d', strtotime($laparoscopy->sdate));
        }
        $this->smarty->assign('laparoscopy', $laparoscopy);
        $this->smarty->assign('laparoscopyCount', count($laparoscopy));

        $hysteroscopy = R::findOne('hysteroscopy', 'patientid = ? and del = 0 order by sdate desc, id desc', [$patientId]);
        if (!empty($hysteroscopy->sdate)) {
            $hysteroscopy->sdate = date('Y/m/d', strtotime($hysteroscopy->sdate));
        }
        $this->smarty->assign('hysteroscopy', $hysteroscopy);
        $this->smarty->assign('hysteroscopyCount', count($hysteroscopy));


        $ustv = R::findOne('ustv', 'patientid = ? and del = 0 order by sdate desc, id desc', [$patientId]);
        if (!empty($ustv->sdate)) {
            $ustv->sdate = date('Y/m/d', strtotime($ustv->sdate));
        }
        $this->smarty->assign('ustv', $ustv);
        $this->smarty->assign('ustvCount', count($ustv));
    }

    ##########################################################

    public
            function __destruct() {
        //echo "Time Elapsed: ".(microtime(true) - $this->time)."s";
//close connection
        R::close();
    }

}
