<?php

##  user allowed branches 
##############################  

function branchInfos($branchesActivate, $smarty) {
   if ($branchesActivate == 1) {
      $showBrancheSelect = 0;
      $selectedBranch = '';
      $showStart = 1;
      $showAll = 1;

      $user = R::getRow('SELECT related_branches FROM awusers 
                    WHERE user_id = ? LIMIT 1', [$_SESSION['user_id']]);

      if ($user['related_branches'] == 0 && $user['related_branches'] != '' && $user['related_branches'] != null) {
         $branches = R::findAll('branches');
         $showBrancheSelect = 1;
         $showStart = 0;
      } else {
         $related_branches = array();
         $relBranches = explode(',', $user['related_branches']);
         foreach ($relBranches as $value) {
            $value = trim($value);
            array_push($related_branches, $value);
         }

         if ($related_branches[0] > 0) {
            if (count($related_branches) == 1) {
               $selectedBranch = $related_branches[0];
            } elseif (count($related_branches) > 1) {
               $showBrancheSelect = 1;
            }
            $showStart = 0;
            $showAll = 0;
            $branches = R::findAll('branches', '  id  in ( ' . $user['related_branches'] . ' ) ');
         } else {
            $showBrancheSelect = 1;
            $showAll = 0;
         }
      }

      $smarty->assign('showStart', $showStart);
      $smarty->assign('showAll', $showAll);
      $smarty->assign('branches', $branches);
      $smarty->assign('selectedBranch', $selectedBranch);
      $smarty->assign('showBrancheSelect', $showBrancheSelect);
   }
}

function branchInfosVisit($branchesActivate, $smarty) {
   if ($branchesActivate == 1) {
      $showBrancheSelect = 0;
      $selectedBranch = '';

      $user = R::getRow('SELECT related_branches FROM awusers 
                    WHERE user_id = ? LIMIT 1', [$_SESSION['user_id']]);

      if ($user['related_branches'] == 0 && $user['related_branches'] != '' && $user['related_branches'] != null) {
         $branches = R::findAll('branches');
         $showBrancheSelect = 1;
      } else {
         $related_branches = array();
         $relBranches = explode(',', $user['related_branches']);
         foreach ($relBranches as $value) {
            $value = trim($value);
            array_push($related_branches, $value);
         }

         if ($related_branches[0] > 0) {
            if (count($related_branches) == 1) {
               $selectedBranch = $related_branches[0];
            } elseif (count($related_branches) > 1) {
               $showBrancheSelect = 1;
            }
            $branches = R::findAll('branches', '  id  in ( ' . $user['related_branches'] . ' ) ');
         } else {
            $branches = R::findAll('branches');
            $showBrancheSelect = 1;
         }
      }

      $allBranches = R::findAll('branches');
      $smarty->assign('allBranches', $allBranches);
      $smarty->assign('branches', $branches);
      $smarty->assign('selectedBranch', $selectedBranch);
      $smarty->assign('showBrancheSelect', $showBrancheSelect);
   }
}

function showBranchCol($branchesActivate) {
   $show = 0;
   if ($branchesActivate == 1) {
      $user = R::getRow('SELECT related_branches FROM awusers 
                    WHERE user_id = ? LIMIT 1', [$_SESSION['user_id']]);

      if ($user['related_branches'] == 0 && $user['related_branches'] != '' && $user['related_branches'] != null) {
         $show = 1;
      } else {
         $related_branches = array();
         $relBranches = explode(',', $user['related_branches']);
         foreach ($relBranches as $value) {
            $value = trim($value);
            array_push($related_branches, $value);
         }

         if ($related_branches[0] > 0 && count($related_branches) > 1) {
            $show = 1;
         }
      }
   }
   return $show;
}

function getPatientInfoAll($patient, $for_husband, $child, $currentDate) {
   $programesetting = R::findOne('programesetting');
   $wifetypes = R::load('wifetypes', $patient->wiftypeid);
   $husbandtypes = R::load('husbandtypes', $patient->husbandtypeid);
   $result = array();
   $title = '';

   if ($programesetting->system_lang == 2) {
      $date = $patient['dateofbirth'];
      $name = $patient['wifename'];
      $sex = $patient['gender'];
      $title = $wifetypes->title;
   } else {
      $age = '';
      $ageUnit = 0;

      if ($for_husband == 1) {
         $date = $patient['husbanddateofbirth'];
         $name = $patient['husdandname'];
         $sex = 1;
         $title = $husbandtypes->title;
      } else if ($for_husband == 2) {
         $child = R::load('patients_childs', $child);
         $sex = $child->gender;
         $date = $child->birth_date;

         if (is_null($child->child_name) || $child->child_name == '') {
            if ($child->gender == 1) {
               $name = 'الطفل / ' . $patient['wifename'];
            } else {
               $name = 'الطفلة / ' . $patient['wifename'];
            }
         } else {
            $name = $child->child_name . '  /  ' . $patient['wifename'];
         }
      } else {
         $date = $patient['dateofbirth'];
         $name = $patient['wifename'];
         $sex = 0;
         $title = $wifetypes->title;
      }
   }

   if ($sex == 1) {
      $gender = 'Male';
      $gen = 'M';
   } else {
      $gender = 'Female';
      $gen = 'F';
   }

   if ($date != '0000-00-00' && $date != '' && $date != Null) {
      $dateN = new DateTime($date);
      $today1 = new DateTime($currentDate);
      $interval = $today1->diff($dateN);
   }

   if ($interval->y > 0) {
      $ageNo = $interval->y;
      $age = $interval->y . ' Years';
      $ageMin = $interval->y . 'Y';
      $ageUnit = 1;
   } elseif ($interval->m > 0) {
      $ageNo = $interval->m;
      $age = $interval->m . ' Months';
      $ageMin = $interval->m . 'M';
      $ageUnit = 2;
   } elseif ($interval->d >= 0) {
      $ageNo = 1 + $interval->d;
      $age = 1 + $interval->d . ' Days';
      $ageMin = $interval->d . 'D';
      $ageUnit = 3;
   }

   $result['name'] = $name;
   $result['gender'] = $gender;
   $result['gen'] = $gen;
   $result['sex'] = $sex;
   $result['age'] = $age;
   $result['ageMin'] = $ageMin;
   $result['ageNo'] = $ageNo;
   $result['ageUnit'] = $ageUnit;
   $result['title'] = $title;
   return $result;
}

function patientLimitPrescriptions($patientId, $presDate, $limit) {
   $presCount = 0;
   $limitReatched = 0;
//    r::debug(true, 2);
   if ($limit > 0) {
      $targetMonth = date("Y-m", strtotime($presDate));

      $presGyna = R::getAll('SELECT DISTINCT recepittmpid  FROM gynadrugs
                WHERE deleted = ? and patientid = ?  and DATE_FORMAT(date,"%Y-%m")  = ? '
                      , [0, $patientId, $targetMonth]);

      $presAnt = R::getAll('SELECT DISTINCT recepittmpid  FROM mainantenentaldrugs
                WHERE deleted = ? and patientid = ?  and DATE_FORMAT(date,"%Y-%m")  = ? '
                      , [0, $patientId, $targetMonth]);

      $presChronic = R::getAll('SELECT DISTINCT pres_id  FROM gynachronicdrugs
                WHERE deleted = ? and patientid = ?  and DATE_FORMAT(date,"%Y-%m")  = ? '
                      , [0, $patientId, $targetMonth]);

      $presCount = count($presGyna) + count($presAnt) + count($presChronic);
      // print_r($visitsCount);
      if ($presCount >= $limit) {
         return 1;
      }
   }
   return $limitReatched;
}

function patientLimitVisits($patientId, $visitDate, $limit) {
//    r::debug(true, 2);
   if ($limit > 0) {
      $targetMonth = date("Y-m", strtotime($visitDate));
      $visitsCount = R::count('visits', ' patientid = ?  and deleted != 1 and for_department != 12 
             and DATE_FORMAT(visitdate,"%Y-%m")  = ?  ', [$patientId, $targetMonth]);
      // print_r($visitsCount);
      if ($visitsCount >= $limit) {
         return 1;
      } else {
         return 0;
      }
   } else {
      return 0;
   }
}

function visitDept($visitId) {
   $visit = R::load('visits', $visitId);
   $payVisits = R::getRow('SELECT COALESCE(SUM(detectionvalue_cash),0)   as paid_cash
                                                                 , COALESCE(SUM(detectionvalue_visa),0)   as paid_visa
                                                                  , COALESCE(SUM(discount),0)   as paid_discount
                                                                 , 0 as paid
                                    FROM visits   where   deleted != ? and detectionid = 999 and visitid = ?   ', [1, $visitId]);
   $totalDept = 0;

   ## what pt paid after  creating visit
   $payVisits['paid'] = $payVisits['paid_cash'] + $payVisits['paid_visa'];
   if ($visit->restdetectionvalue > ($payVisits['paid'] + $payVisits['paid_discount'])) {
      $totalDept = $visit->restdetectionvalue - $payVisits['paid'] - $payVisits['paid_discount'];
   }
   return $totalDept;
}

function patientPrescriptions($findate, $todate, $ext) {
   $sql = '   SELECT DISTINCT recepittmpid as presId  , 1 as presType , date as presDate   , " دورى "  as presTypeTxt   
                        , patientid   as patientId , "" as drName , doctorid  as doctorId   FROM gynadrugs
                       WHERE deleted = ?     and date   between  ? and ?  ' . $ext . '   
          union 
               SELECT DISTINCT recepittmpid as presId  , 2 as presType , date as presDate   , " دورى "  as presTypeTxt   
                           , patientid   as patientId  , "" as drName  , doctorid  as doctorId   FROM mainantenentaldrugs
                      WHERE deleted = ?     and date   between  ? and ?  ' . $ext . '   
          union
             SELECT DISTINCT pres_id as presId  , 3 as presType , date as presDate    , " شهرى "  as presTypeTxt  
                           , patientid   as patientId  , "" as drName , doctorid  as doctorId    FROM gynachronicdrugs
                       WHERE deleted = ?     and date   between  ? and ?  ' . $ext . '   
           ';

   $pres = R::getAll($sql, [0, $findate, $todate, 0, $findate, $todate, 0, $findate, $todate]);
   $pres = presData($pres);
   return $pres;
}

function patientPrescriptionsAll($ext) {
   $sql = '   SELECT DISTINCT recepittmpid as presId  , 1 as presType , date as presDate   , " دورى "  as presTypeTxt
                        , patientid   as patientId , "" as drName , doctorid  as doctorId   FROM gynadrugs
                       WHERE deleted = ?        ' . $ext . '   
          union 
               SELECT DISTINCT recepittmpid as presId  , 2 as presType , date as presDate     , " دورى "  as presTypeTxt 
                           , patientid   as patientId  , "" as drName  , doctorid  as doctorId   FROM mainantenentaldrugs
                      WHERE deleted = ?        ' . $ext . '   
          union
             SELECT DISTINCT pres_id as presId  , 3 as presType , date as presDate   , " شهرى "  as presTypeTxt
                           , patientid   as patientId  , "" as drName , doctorid  as doctorId    FROM gynachronicdrugs
                       WHERE deleted = ?        ' . $ext . '   
           ';

   $pres = R::getAll($sql, [0, 0, 0]);
   $pres = presData($pres);
   return $pres;
}

function presData($pres) {
   $i = 0;
   foreach ($pres as $pre) {
      $patient = R::load('patients', $pre['patientId']);
      if ($pre['doctorId'] > 0) {
         $doctor = R::getRow('SELECT name FROM awusers WHERE user_id = ? ', [$pre['doctorId']]);
         $pres[$i]['drName'] = $doctor['name'];
      }

      $printedCount = R::getRow('SELECT count(id) as printedCount  FROM pres_printed  where  pres_id = ? and pres_type = ?   '
                      , [$pre['presId'], $pre['presType']]);

      $pres[$i]['statusno'] = $patient->statusno;
      $pres[$i]['for_husband'] = $patient->for_husband;
      $pres[$i]['wifename'] = $patient->wifename;
      $pres[$i]['husdandname'] = $patient->husdandname;
      $pres[$i]['printedCount'] = $printedCount['printedCount'];
      $i++;
   }
   return $pres;
}

function archiveOldData($oldObj, $tableName) {
   date_default_timezone_set('Africa/Cairo');
   $archiveTableName = $tableName . '_updates';
   $archive = R::xdispense($archiveTableName);
   $colums = R::getAll('DESCRIBE ' . $tableName);

   foreach ($colums as $col) {
      $colName = $col['Field'];
      if ($colName != id) {
         $archive->$colName = $oldObj->$colName;
      }
   }

   $archive->userid_edit = $_SESSION['user_id'];
   $archive->date_edit = date('Y-m-d H:i:s'); //$this->today;
   $archive->patientid_edit = $oldObj->id;
   R::store($archive);
}

function archiveDrugRecord($oldObj, $tableName) {
   date_default_timezone_set('Africa/Cairo');
   $archiveTableName = $tableName . '_updates';
   $archive = R::xdispense($archiveTableName);

   $archive->patientid = $oldObj->patientid;
   $archive->date = $oldObj->date;
   $archive->drugid = $oldObj->drugid;
   $archive->drugtype = $oldObj->drugtype;
   $archive->drugdos = $oldObj->drugdos;
   $archive->doctorid = $oldObj->doctorid;
   $archive->forhusband = $oldObj->forhusband;
   $archive->quantity = $oldObj->quantity;
   $archive->deleted = $oldObj->deleted;
   $archive->userid_edit = $_SESSION['user_id'];
   $archive->date_edit = date('Y-m-d H:i:s'); //$this->today;
   $archive->patientid_edit = $oldObj->id;
   R::store($archive);
}

function presDoctorsAll($tableName, $patientId, $date, $preFor) {
   $doctors = ' ';
//   R::debug(true, 2);
   $presByDate = R::getAll('select distinct    ' . $tableName . ' .doctorid   , awusers.name as doctorName
                        from     ' . $tableName . '     
                        left join awusers    on   awusers.user_id =      ' . $tableName . ' .doctorid 
                      where    ' . $tableName . ' .deleted = 0 and    ' . $tableName . ' .patientid = ? and    ' . $tableName . ' .date = ? 
                    and    ' . $tableName . ' .forhusband = ?   and    ' . $tableName . ' .drugid  != ""  and    ' . $tableName . ' .drugid  >   0   
               ', [$patientId, $date, $preFor]);
   //  print_r($presByDate);

   $j = 0;
   foreach ($presByDate as $pres) {
      if ($j > 0) {
         $doctors .= " </br>";
      }
      $doctors .= $pres['doctorName'];

      $j++;
   }

   return $doctors;
}

function presDoctors($tableName, $patientId, $date, $preFor) {
   $presByDate = R::getRow('select distinct    ' . $tableName . ' .doctorid   , awusers.name as doctorName
                        from     ' . $tableName . '     
                        left join awusers    on   awusers.user_id =      ' . $tableName . ' .doctorid 
                      where    ' . $tableName . ' .deleted = 0 and    ' . $tableName . ' .patientid = ? and    ' . $tableName . ' .date = ? 
                    and    ' . $tableName . ' .forhusband = ?   and    ' . $tableName . ' .drugid  != ""  and    ' . $tableName . ' .drugid  >   0   
                     order by    ' . $tableName . ' .id    desc          ', [$patientId, $date, $preFor]);

   return $presByDate['doctorName'];
}

############################################################

function ageLimitExceed() {
   $startYear = date('Y-m-d', strtotime('-60 years'));
//   $pats = R::count('patients', 'organization_id > 0  and dateofbirth != ? and dateofbirth != ? and dateofbirth is not null 
//            and dateofbirth < ?  ', ['0000-00-00', '', $startYear]);

   $pats = R::exec('update patients set  organization_id = 0  where organization_id > 0  and dateofbirth != ? and dateofbirth != ? and dateofbirth is not null 
            and dateofbirth < ?  ', ['0000-00-00', '', $startYear]);
   //  print_r($pats);
}
