<?php

require_once("imp/_imp.php");

class Controllers {

//public vars
    public $smarty;
    public $hosturl;
    public $controllname;
    public $shcontrollname;
    public $active;
    public $time;
    public $today;

// it will run in everytime with
// default requried
    public function __construct() {
        require_once("../public/aw_config.php");
        require_once("imp/_autho.php"); //general functions
        $this->smarty = $smarty;
        $this->hosturl = $hosturl;

//here name of controll to known
        $this->controllname = 'addrays';
        $this->shcontrollname = 'addrays';
        $this->smarty->assign('controllname', $this->controllname);
        $this->smarty->assign('shcontrollname', $this->shcontrollname);



//breadcrumbs
        require_once("../../_library/plugins/Breadcrumbs/Breadcrumbs.php");
        $acty = filter_input(INPUT_GET, 'ac');
        $bc = new breadcrumbs($hosturl, '', '', $acty);
        $bc->crumbs();
        $breadcrumbs = $bc->breadcrumbs;
        $smarty->assign('breadcrumbs', $breadcrumbs);

# here show the active page in menu
// array called active[] with level of active element
        $active[0] = 'programesetting'; //controller name or tab name
        $active[1] = 'addrays'; //controller name
// do name  // switch($do)
        switch ($acty) {
            case '':$active[2] = 'show';
                break;
            case 'show':$active[2] = 'show';
                break;
            default :$active[2] = 'show';
                break;
        }
        $this->active = $active;



//here will call all php pages
        require_once("_header.php");
        require_once("_sidebar.php");
        require_once("_leftsidebar.php");
        require_once("_footer.php");

        //find loading time
        $this->time = microtime(true);
        $this->today = date('Y-m-d');
    }

    public function index() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        #################################################################### Heba : ## get all rays category ##############################################################################
        $allRays = R::findall('rayscats', 'deleted = ? and displayorder != ?', [0, -1]);
        $this->smarty->assign('allRays', $allRays);
        ################################################################################################################################################################################
        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('addrays/show.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function addnewcat() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        #################################################################### Heba : ## add investigation cat  #############################################################################
        $last = R::getAll('select max(displayorder) from rayscats');
        $lastOrder = $last[0]['max(displayorder)'];
        $newOrder = $lastOrder + 1;
        $newcat = R::dispense('rayscats');
        $newcat->name = "";
        $newcat->displayorder = $newOrder;
        try {
            $id = R::store($newcat);
            echo $id;
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/error/notupdate/' . $this->controllname);
        }
        ################################################################################################################################################################################
    }

    public function addnewray() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        #################################################################### Heba : ## add investigation cat  #############################################################################
        $catId = filter_input(INPUT_POST, "catId");
        $price = filter_input(INPUT_POST, "price");

        $newRay = R::dispense('rays');
        $newRay->name = "";
        $newRay->rayscatid = $catId;
        $newRay->price = $price;
        try {
            $id = R::store($newRay);
            echo $id;
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/error/notupdate/' . $this->controllname);
        }
        ################################################################################################################################################################################
    }

    public function update() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $id = filter_input(INPUT_POST, "id");
        $tablename = filter_input(INPUT_POST, "tableName");
        $colname = filter_input(INPUT_POST, "colName");
        $value = filter_input(INPUT_POST, "value");

        try {
            $obj = R::load($tablename, $id);

            $obj->$colname = $value;
            R::store($obj);

            //header('Location:' . $this->hosturl . '/controllers/' . $this->controllname.'.php?ac=index' );
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/error/notupdate/' . $this->controllname);
        }
    }

    public function del() {      ## delete row from investcat table 
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $id = filter_input(INPUT_POST, "id");
        $tableName = filter_input(INPUT_POST, "tableName");

        $ogj = R::load($tableName, $id);
        $ogj->deleted = 1;

        try {
            R::store($ogj);
            echo 1;
        } catch (Exception $e) {
            echo 22;
        }
    }

    public function getraybycatid() {      ## get all rays in certain category
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $catId = filter_input(INPUT_POST, "catId");

        $rays = R::findall('rays', 'rayscatid = ? and deleted = ?', [$catId, 0]);
        foreach ($rays as $value) {
            $value->range = str_ireplace('<br />', "\r\n", $value->range);
        }

        $this->smarty->assign('rays', $rays);
        $this->smarty->display('addrays/rays.html');
    }

    public function addtofavorite() {      ## get all investigation in certain category
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $rayId = filter_input(INPUT_POST, "rayId");
        $value = filter_input(INPUT_POST, "value");

        try {
            $ray = R::load('rays', $rayId);

            $ray->favorite = $value;
            R::store($ray);
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/error/notupdate/' . $this->controllname);
        }
    }

// at the end of class call
    public function __destruct() {
        //echo "Time Elapsed: ".(microtime(true) - $this->time)."s";
//close connection
        R::close();
    }

}
