<?php

/*
 * awframework from aw.inc present aw controller
 * it will help you develop easy and fast with secure tools
 * you can edit and add what you feel right
 * don't change in structure of file
 */

require_once("../../core/controllers/imp/_imp.php");

class Controllers
{
    public $smarty;
    public $active;

    public function __construct()
    {
        require_once("../public/aw_config.php");
        require_once("../../core/controllers/imp/_autho.php"); //general functions
        /** @var Smarty $smarty */
        $this->smarty = $smarty;
        /** @var string $hosturl */
        $this->hosturl = $hosturl;

        $this->smarty->assign('control_name', 'index');

        R::ext('xdispense', function ($type) {
            return R::getRedBean()->dispense($type);
        });
    }

    public function index(){
        $device = filter_input(INPUT_GET, 'device', FILTER_SANITIZE_STRING);
        $this->smarty->assign('device', $device);
        $this->smarty->display('start.html.tpl');
    }

    public function thank(){
        $device = filter_input(INPUT_GET, 'device', FILTER_SANITIZE_STRING);
        $this->smarty->assign('device', $device);
        $this->smarty->display('thank_you.html.tpl');
    }

    public function vote()
    {
        $device = filter_input(INPUT_GET, 'device', FILTER_SANITIZE_STRING);
        $this->smarty->assign('device', $device);
        if (!$device) {
            $this->smarty->assign('message', 'لم يتم اختيار أي جهاز');
            $this->smarty->display('empty.html.tpl');
            return;
        }

        //check if device is existed
        $device_exist = R::findOne('vote_devices', 'id = ?', [$device]);
        if (!$device_exist) {
            $this->smarty->assign('message', 'لم يتم العثور علي الجهاز');
            $this->smarty->display('empty.html.tpl');
            return;
        }

        // get login user by local ip
        $login_user = R::findOne('login_tacking', 'login_ip = ? and status = 1 order by id desc', [$device_exist->local_ip]);
        if (!$login_user) {
            $this->smarty->assign('message', 'أنت لم تقم بتسجيل الدخول');
            $this->smarty->display('empty.html.tpl');
            return;
        }

        $user = R::findOne('awusers', 'user_id = ?', [$login_user->user_id]);
        $this->smarty->assign('user', $user);

        // show votes
        $vote = R::findOne('votes','vote_device_id = ?',[$device]);
        if (!$vote) {
            $this->smarty->assign('message', 'لم يتم العثور على تصويت');
            $this->smarty->display('empty.html.tpl');
            return;
        }

        $questions = R::find('vote_questions','vote_id = ?',[$vote->id]);
        foreach ($questions as $question) {
            $answers = R::find('vote_answers','vote_question_id = ?',[$question->id]);
            $question->answers = $answers;
        }
        $this->smarty->assign('questions',$questions);
        $this->smarty->assign('vote', $vote);



        $this->smarty->display('index.html.tpl');
    }

    public function submit(){
        // check if device id is existed
        $device_id = filter_input(INPUT_POST, 'vote_device_id', FILTER_SANITIZE_STRING);
        $vote_id = filter_input(INPUT_POST, 'vote_id', FILTER_SANITIZE_STRING);
        $user_id = filter_input(INPUT_POST, 'user_id', FILTER_SANITIZE_STRING);

        // voter name and phone
        $voter_name = filter_input(INPUT_POST, 'name', FILTER_SANITIZE_STRING);
        $voter_phone = filter_input(INPUT_POST, 'phone', FILTER_SANITIZE_STRING);

        // get question post array
        $questions = filter_input(INPUT_POST, 'questions', FILTER_DEFAULT, FILTER_REQUIRE_ARRAY);

        $this->smarty->assign('device', $device_id);

        try {
            $client_vote = R::xdispense('clients_votes');
            $client_vote->vote_device_id = $device_id;
            $client_vote->vote_id = $vote_id;
            $client_vote->user_id = $user_id;
            $client_vote->voter_name = $voter_name;
            $client_vote->voter_phone = $voter_phone;
            $client_vote->created_at = date('Y-m-d H:i:s');
            $client_vote->ip = $_SERVER['REMOTE_ADDR'];
            $client_vote->user_agent = $_SERVER['HTTP_USER_AGENT'];
            $client_vote->local_ip = $_SERVER['SERVER_ADDR'];
            $client_vote->remote_ip = $_SERVER['REMOTE_ADDR'];

            $client_vote_id = R::store($client_vote);

            // save answers
            foreach ($questions as $answer) {
                $client_vote_answer = R::xdispense('clients_votes_answers');
                $client_vote_answer->client_vote_id = $client_vote_id;
                $client_vote_answer->question_id = $answer['question_id'];
                $client_vote_answer->answer_id = $answer['answer_id'];
                $client_vote_answer->answer_face = $answer['answer_face'];
                $client_vote_answer->answer_text = $answer['answer_text'];
                $client_vote_answer->user_id = $user_id;
                $client_vote_answer->created_at = date('Y-m-d H:i:s');
                R::store($client_vote_answer);
            }

            header('Location: '.$this->hosturl.'/controllers/index.php?ac=thank&device='.$device_id);
            return;

        }catch (Exception $e){
            $this->smarty->assign('message', 'حدث خطأ أثناء تسجيل التصويت');
            $this->smarty->display('empty.html.tpl');
            return;
        }

    }

    public function __destruct()
    {
        R::close();
    }

}
