<!DOCTYPE html>
<html dir="rtl">
    <head>
        <meta charset="utf-8" > 
        <title> Clinics </title>
        <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
        <link rel="stylesheet"
              href="https://fonts.googleapis.com/css?family=Tajawal">
        <link rel="stylesheet" href="../views/screen/clinics/all/bootstrap.min.css">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <script src="../views/screen/clinics/all/jquery.js"></script>
        <style>

            body {
                font-family: 'Tajawal', sans-serif;
                color: black;
                font-size: 22px;
                font-weight: bold;

            }

            table th, table td {
                text-align: center;
            }

            table th, table td {
                text-align: center;
            }

            .danger {
                color: red
            }

            .table-bordered > tbody > tr > td, .table-bordered > tbody > tr > th, .table-bordered > tfoot > tr > td, .table-bordered > tfoot > tr > th, .table-bordered > thead > tr > td, .table-bordered > thead > tr > th {
                border: 1px solid #656565;
            }

            .table-dark td, .table-dark th, .table-dark thead th {
                border-color: transparent;
            }

            .bt {
                border-top: 2px solid #000 !important;
            }

            .bl {
                border-left: 2px solid #000 !important;

            }

            .table {
                margin: 0px 5px 5px 5px;
                border: 1px solid #ddd;
                float: right;
            }

            .table thead th, .table td {
                border: 0 !important;
            }

            thead {
                background-color: #173f5f;
                color: #fff;
            }

            thead th {
                color: #black
            }

            .bg-red {
                background-color: #53cbda;
                color: #000;
                font-weight: bold;
            }

            .table td, .table th {
                vertical-align: middle !important;
                padding: 0.25rem !important;
            }


            @media (min-width: 767px) and (max-width: 1080px) {
                .table {
                    width: 50%;
                    float: right;
                }
            }

            @media (max-width: 767px) {
                .table {
                    width: 100%;
                    float: right;
                }
            }

            .col-md-12,.col-sm-4{
                padding:0}

            li {
                text-align: right;
            }

            .row {
                margin-left: 0px;
                margin-right: 15px;
            }

            #todayTable {
                margin: 0px 5px 5px 5px;
                border: 1px solid #ddd;
                width: 100%;
                float: right;
            }
            .bg-info{
                background-color:rgba(108, 117, 125, 1) !important
            }
            .bg-blue-chambray{
                background-color:#11115e
            }
        </style>

    </head>
    <body>
        <input type="hidden" id="hosturl" value="{$hosturl}"/>
        <input type="hidden" id="path" value="{$path}"/>
        <div class="full-container table-responsive" id="operation_container">

            <div class="row">
                {if $doctorsCount > 0 }
                    <div class="col-sm-4">
                        {assign var=i value=1}
                        {foreach $doctors as $doctor}
                            <table class="table table-striped table-hover " id="todayTable">
                                <thead>
                                    <tr class=" bg-info">  <th>{$doctor.for_doctor_name} </th> </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>
                                            <ul>
                                                {foreach $doctor.drVisits as $value}
                                                    <li>  {$value->patientName}  </li>
                                                    {/foreach}
                                            </ul>
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        {capture assign=i}{$i+1}{/capture}
                    {/foreach}
                </div>
            {else}
                <div class="col-sm-4">
                    <table class="table table-striped table-hover " id="todayTable">
                        <thead>
                            <tr class=" bg-info">  <th> Today's List </th> </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td>
                                    <ul>

                                    </ul>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div> 

            {/if}

            <div class="col-sm-8">
                {assign var=i value=1}
                {foreach $roles as $role}
                    <table class="table table-striped table-hover ">
                        <thead>
                            <tr  class=" bg-blue-chambray">  
                                <th style="width:50%; text-align: right; padding-right: 5% !important;" > {$role->doctor_name} </th>
                                <th  style="width:50%; text-align: left; padding-left: 5% !important;"> {$role->name} </th>
                            </tr>
                            <tr colspan="2" style=" background-color: #bdd5e8;">  <th colspan="2" style="color: black;"> {$role->roleCurrentPatient} </th> </tr>
                        </thead>

                        <tbody>
                            <tr  colspan="2">
                                <td  colspan="2">
                                    <ul>
                                        {foreach $role->visits as $value}
                                            <li>  {$value->patientName}  </li>
                                            {/foreach}
                                    </ul>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                {capture assign=i}{$i+1}{/capture}
            {/foreach}
        </div>
    </div>

</div>

</div>
{literal}
    <script>
        $(document).ready(function () {
            var host_url = $('#hosturl').val();

            setInterval(function () {
                $.post(host_url + '/controllers/index_dental.php?ac=clinicsInfo', function (result) {
                    //console.log(result);
                    $('#operation_container').html(result);
                });
            }, 30000); //120000
        });
    </script>
{/literal}


</body>
</html>

