<?php

/*
 * awframework from aw.inc present aw controller
 * it will help you develop easy and fast with secure tools
 * you can edit and add what you feel right
 * don't change in strucure of file
 */

require_once("../../core/controllers/imp/_imp.php");

class Controllers {

    //public vars
    public $smarty;
    public $hosturl;
    public $controllname;
    public $shcontrollname;
    public $active;

    // it will run in everytime with
    // default requried
    public function __construct() {
        require_once("../public/aw_config.php");
        require_once("../../core/controllers/imp/_autho.php"); //general functions
        $this->smarty = $smarty;
        $this->hosturl = $hosturl;

        //here name of controll to known
        $this->controllname = 'op';
        $this->shcontrollname = 'op';
        $this->smarty->assign('controllname', $this->controllname);
        $this->smarty->assign('shcontrollname', $this->shcontrollname);

        //breadcrumbs
        require_once("../../_library/plugins/Breadcrumbs/Breadcrumbs.php");
        $acty = filter_input(INPUT_GET, 'ac');
        $bc = new breadcrumbs($hosturl, '', '', $acty);
        $bc->crumbs();
        $breadcrumbs = $bc->breadcrumbs;
        $smarty->assign('breadcrumbs', $breadcrumbs);

        # here show the active page in menu
        // array called active[] with level of active element
        $active[0] = 'index'; //controller name or tab name
        $this->active = $active;
    }

    public function index() {
        $time_now = date('H:i');
		$today = date('Y-m-d');
//and TIME(enterance) <= TIME("'.$time_now.'")
        /*$rooms_info = R::find('visits','visitdate = "'.$today.'"
        and TIME(p_exit) >= TIME("'.$time_now.'") and room_no IN (4,5,6,7) and deleted = 0 order by Time(enterance)');*/

        $rooms_info = R::find('visits','visitdate = "'.$today.'" 
        and TIME(p_exit) is null and room_no IN (4,5,6,7) and deleted = 0 order by Time(enterance)');
        foreach ($rooms_info as $room_info){
            $patient_info = R::findOne('patients', 'id = ?', [$room_info->patientid]);
            $doctor_info = R::findOne('awusers', 'user_id = ?', [$room_info->for_doctor]);
            $room_info->patient_name = ($room_info->for_husband == 1) ? $patient_info->husdandname :$patient_info->wifename;
            $room_info->doctor_name = $doctor_info->name;

            // get res room
            $res_room_info = R::findOne('residence_rooms','id = ?',[$room_info->res_room_no]);
            $room_info->res_room_name = $res_room_info->name;

            $operation_info = R::findOne('detections','id = ?',[$room_info->detectionid]);
            $room_info->operation_name = $operation_info->title;
        }

        $this->refresh(300);

        $this->smarty->assign('rooms_info', $rooms_info);
        $this->smarty->display('op/index.html');
    }

    public function roominfo() {

        $time_now = date('H:i');
        $today = date('Y-m-d');
//and TIME(enterance) <= TIME("'.$time_now.'") 
        /*$rooms_info = R::find('visits','visitdate = "'.$today.'"
        and TIME(p_exit) >= TIME("'.$time_now.'") and room_no IN (4,5,6,7) and deleted = 0 order by Time(enterance) ');*/
        $rooms_info = R::find('visits','visitdate = "'.$today.'" 
        and TIME(p_exit) is null and room_no IN (4,5,6,7) and deleted = 0 order by Time(enterance)');
        foreach ($rooms_info as $room_info){
            $patient_info = R::findOne('patients', 'id = ?', [$room_info->patientid]);
            $doctor_info = R::findOne('awusers', 'user_id = ?', [$room_info->for_doctor]);
            $room_info->patient_name = ($room_info->for_husband == 1) ? $patient_info->husdandname :$patient_info->wifename;
            $room_info->doctor_name = $doctor_info->name;

            // get res room
            $res_room_info = R::findOne('residence_rooms','id = ?',[$room_info->res_room_no]);
            $room_info->res_room_name = $res_room_info->name;

            $operation_info = R::findOne('detections','id = ?',[$room_info->detectionid]);
            $room_info->operation_name = $operation_info->title;
        }

        $this->smarty->assign('rooms_info', $rooms_info);
        $this->smarty->display('op/result.html');
    }

    // at the end of class call
    public function __destruct() {
        //close connection
        R::close();
    }

    // write the function
    public function refresh($time) {
        $current_url = $_SERVER['REQUEST_URI'];
        return header("Refresh: " . $time . "; URL=$current_url");
    }

}
