<?php

require_once("../../core/controllers/imp/_imp.php");

class Controllers {

//public vars
    public $smarty;
    public $hosturl;
    public $controllname;
    public $shcontrollname;
    public $active;

// it will run in everytime with
// default requried
    public function __construct() {
        require_once("../public/aw_config.php");
        require_once("../../core/controllers/imp/_autho.php"); //general functions
        $this->smarty = $smarty;
        $this->hosturl = $hosturl;

//here name of controll to known
        $this->controllname = 'receipt';
        $this->shcontrollname = 'Receipt';
        $this->smarty->assign('controllname', $this->controllname);
        $this->smarty->assign('shcontrollname', $this->shcontrollname);

//breadcrumbs
        require_once("../../_library/plugins/Breadcrumbs/Breadcrumbs.php");
        $acty = filter_input(INPUT_GET, 'ac');
        $bc = new breadcrumbs($hosturl, '', '', $acty);
        $bc->crumbs();
        $breadcrumbs = $bc->breadcrumbs;
        $smarty->assign('breadcrumbs', $breadcrumbs);

# here show the active page in menu
// array called active[] with level of active element
        $active[0] = 'pharmacy'; //controller name or tab name
        $active[1] = 'Receipt'; //controller name
// do name  // switch($do)
        switch ($acty) {
            case '':$active[2] = 'show';
                break;
            case 'show':$active[2] = 'show';
                break;
            default :$active[2] = 'show';
                break;
        }
        $this->active = $active;



//here will call all php pages
        require_once("../../core/controllers/_header.php");
        require_once("../../core/controllers/_sidebar.php");
        require_once("../../core/controllers/_leftsidebar.php");
        require_once("../../core/controllers/_footer.php");
    }

    public function index() {
//check login
        autho::checkautho($this->hosturl . "/../core");
//check authoize
        autho::checkauthoize($this->controllname, $this->hosturl . "/../core", $_SESSION['role_id']);

        ##########################################################################
        $doctors = R::getAll('SELECT user_id , user_name FROM awusers WHERE role_id  in ( 1 , 4 , 8 ) ');
        $this->smarty->assign('doctors', $doctors);

        $allMed = R::findAll('phdrugs', 'order by drugname asc');
        $this->smarty->assign('allMed', $allMed);

        $stores = R::getAll('SELECT id , name FROM stores WHERE deleted  = 0 ');
        $this->smarty->assign('stores', $stores);

        $allPatients = R::findAll('patients', 'deleted = ? and done = ?', [0, 1]);
        $this->smarty->assign('allPatients', $allPatients);

        $this->smarty->assign('today', date('Y-m-d'));

        #########################################################################

        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('receipt/external.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function show() {

//check login
        autho::checkautho($this->hosturl . "/../core");
//check authoize
        autho::checkauthoize($this->controllname, $this->hosturl . "/../core", $_SESSION['role_id']);

        $today = date('Y-m-d');
//call All Receipt
        $allreceipt = R::findAll('recepittmp', '  receiptdate  between "' . $today . '"  AND  "' . $today . '" order by receiptdate desc');
        foreach ($allreceipt as $data) {

##  doctor name
            if ($data->doctorid != 0) {
                $docName = R::getRow('SELECT user_name FROM awusers WHERE user_id = ? ', [$data->doctorid]);
                $data->doctorname = $docName['user_name'];
            }

##  patient name
            if ($data->patientid != 0) {
                $patientName = R::load('patients', $data->patientid);
                if ($data->forhusband == 1) {
                    $data->patientname = $patientName->husdandname;
                } else {
                    $data->patientname = $patientName->wifename;
                }
            }
        }

        $this->smarty->assign('today', $today);

// calling html files
        $this->smarty->assign('allreceipt', $allreceipt);
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('receipt/show.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

## Show all details receipt to cash

    public function showdetails() {

//check login
        autho::checkautho($this->hosturl . "/../core");
//check authoize
        autho::checkauthoize($this->controllname, $this->hosturl . "/../core", $_SESSION['role_id']);
//get receipt by id
        $recepitTmpId = filter_input(INPUT_GET, 'id');
        $recepitTmp = R::load('recepittmp', $recepitTmpId);

        $stores = R::getAll('SELECT id , name FROM stores WHERE deleted  = 0 ');
        $this->smarty->assign('stores', $stores);



## get doctor name in this receipt
        if ($recepitTmp->doctorid != 0) {
            $docName = R::getRow('SELECT user_name FROM awusers WHERE user_id = ? ', [$recepitTmp->doctorid]);
            $recepitTmp->doctorname = $docName['user_name'];
        }

##  get patient name in this receipt
        if ($recepitTmp->patientid != 0) {
            $patientName = R::load('patients', $recepitTmp->patientid);
            if ($recepitTmp->forhusband == 1) {
                $recepitTmp->patientname = $patientName->husdandname;
            } else {
                $recepitTmp->patientname = $patientName->wifename;
            }
        }


// get all drugs in this receipt
        $prescriptionDurgs = R::findAll($recepitTmp->prescriptiontable, 'recepittmpid = ? and deleted = 0 and drugid != ?  ', [$recepitTmpId, ""]);

        $this->smarty->assign('durgs', $prescriptionDurgs);
        $this->smarty->assign('allreceipt', $recepitTmp);

//calling html files
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('receipt/showdetails.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function checkamounts() {
## check login
        autho::checkautho($this->hosturl);
## check authoize
//autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $recepitTmpId = filter_input(INPUT_POST, 'recepitTmpId');
        $storeId = filter_input(INPUT_POST, 'storeId');

        $recepitTmp = R::load('recepittmp', $recepitTmpId);

        $cache = 0;
        $i = 1;
        $res = '<thead><tr><th>#</th><th>Drug Name</th><th>Drug Type</th><th>valid to </th><th style="width: 11%;">Available</th><th style="width: 11%;">Amount</th> </tr></thead><tbody>';

        $prescriptionDurgs = R::findAll($recepitTmp->prescriptiontable, 'recepittmpid = ? and deleted = 0 and drugid != ?  ', [$recepitTmpId, ""]);
        foreach ($prescriptionDurgs as $data) {

            $drug = R::getRow('select id from phdrugs where drugname = "' . $data->drugname . '" and drugtype = "' . $data->drugtype . '" ');
            $available = 1;

            if (count($drug) > 0) {
                $drugId = $drug['id'];
                $storeDrugs = R::findOne('storedrugs', ' deleted = 0 and  storeid = ' . $storeId . ' and drugid = ' . $drugId);
                if (count($storeDrugs) > 0) {
                    $storeDrugsId = $storeDrugs->id;
                    $storedrugsvalidation = R::findAll('storedrugsvalidation', '  storedrugid = ' . $storeDrugsId . ' and currentbalance > 0 ');
                    if (count($storedrugsvalidation) > 0) {
                        $ii = 1;
                        foreach ($storedrugsvalidation as $data1) {
                            $res .= '<tr>';
                            if ($ii == 1) {
                                $res .= '<td rowspan="' . count($storedrugsvalidation) . '">';
                                $res .= $i;
                                $res .= '</td><td rowspan="' . count($storedrugsvalidation) . '">';
                                $res .= $data->drugname;
                                $res .= '</td><td rowspan="' . count($storedrugsvalidation) . '">';
                                $res .= $data->drugtype;
                                $res .= '</td>';
                            }
                            $res .= '<td>';
                            $res .= $data1->validateto . '<input type = "hidden" value= "' . $data1->validateto . '"  id = "validto' . $data1->id . '"  name= "validto' . $data1->id . '"/>';
                            $res .= '</td><td>';
                            $res .= $data1->currentbalance;
                            $res .= '</td><td>';
                            $res .= '<input type = "text" class = "form-control" style = "text-align: center;" id = "amount' . $data1->id . '' . $data->id . '"  name= "amount' . $data1->id . '' . $data->id . '"  data-id = "' . $data1->id . '"/>';
                            $res .= '</td>';
                            $res .= '</tr>';
                            $cache = 1;
                            $ii++;
                        }
                        $res .= '</tbody>';
                    } else {
                        $available = 0;
                    }
                } else {
                    $available = 0;
                }
            } else {
                $available = 0;
            }

            if ($available == 0) {
                $res .= '<tr><td>';
                $res .= $i;
                $res .= '</td><td>';
                $res .= $data->drugname;
                $res .= '</td><td>';
                $res .= $data->drugtype;
                $res .= '</td><td colspan="3">';
                $res .= 'not available';
                $res .= '</td></tr></tbody>';
            }

            $i++;
        }


        $result = array(
            "cache" => $cache,
            "res" => $res
        );

        echo json_encode($result);
    }

    public function getdrugavailable() {
## check login
        autho::checkautho($this->hosturl);
## check authoize
//autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $drugId = filter_input(INPUT_POST, 'drugId');
        $storeId = filter_input(INPUT_POST, 'storeId');
        $itr = filter_input(INPUT_POST, 'itr');

        $cache = 0;
        $res = '<table class="table  table-hover">';
        $available = 1;

        $storeDrugs = R::findOne('storedrugs', ' deleted = 0 and  storeid = ' . $storeId . ' and drugid = ' . $drugId);
        if (count($storeDrugs) > 0) {
            $storeDrugsId = $storeDrugs->id;
            $storedrugsvalidation = R::findAll('storedrugsvalidation', '  storedrugid = ' . $storeDrugsId . ' and currentbalance > 0 ');

            if (count($storedrugsvalidation) > 0) {
                foreach ($storedrugsvalidation as $data1) {
                    $res .= '<tr>';
                    $res .= '<td class="wds30">';
                    $res .= $data1->validateto;
                    $res .= '</td><td class="wds30">';
                    $res .= $data1->currentbalance;
                    $res .= '</td><td>';
                    $res .= '<input type = "number" class = "form-control" style = "text-align: center;" id = "amount' . $data1->id . '' . $itr . '"  name= "amount' . $data1->id . '' . $itr . '"  data-id = "' . $data1->id . '"/>';
                    $res .= '</td>';
                    $res .= '</tr>';
                    $cache = 1;
                }
            } else {
                $available = 0;
            }
        } else {
            $available = 0;
        }

        if ($available == 0) {
            $res .= '<tr>';
            $res .= '<td colspan="3">';
            $res .= 'not available';
            $res .= '</td>';
            $res .= '</tr>';
        }

        $res .= '</table>';
        $result = array(
            "cache" => $cache,
            "res" => $res
        );

        echo json_encode($result);
    }

    ## This function to update drugs that cashing and minus it from drugs tbl

    public function updatereceipt() {
        //check login
        autho::checkautho($this->hosturl . "/../core");
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl . "/../core", $_SESSION['role_id']);

        $type = filter_input(INPUT_POST, 'type');
        switch ($type) {
            case 'internal':
                $this->saveInternalReceipt();
                break;

            case 'external':
                $this->saveExternalReceipt();
                break;
        }
    }

    private function saveExternalReceipt() {
        $doctorId = filter_input(INPUT_POST, 'doctorId');
        $doctorName = filter_input(INPUT_POST, 'doctorName');
        $patientId = filter_input(INPUT_POST, 'patientId');
        $patientName = filter_input(INPUT_POST, 'patientName');
        $receiptDate = filter_input(INPUT_POST, 'receiptDate');
        $storeId = filter_input(INPUT_POST, 'storeId');
        $itr = filter_input(INPUT_POST, 'itr');
        $chached = 0;

        if ($itr > 0) {

            if ($doctorId != "") {
                $docName = R::getRow('SELECT user_name FROM awusers WHERE user_id = ? ', [$doctorId]);
                $doctorName = $docName['user_name'];
            }

            if ($patientId != "") {
                $patient = R::load('patients', $patientId);
                $patientName = $patient->wifename;
            }

            $recepittmp = R::dispense('recepittmp');
            $recepittmp->doctorid = $doctorId;
            $recepittmp->doctorname = $doctorName;
            $recepittmp->patientid = $patientId;
            $recepittmp->patientname = $patientName;
            $recepittmp->receiptdate = $receiptDate;
            $recepittmp->userid = $_SESSION['user_id'];
            $recepittmp->status = 0;
            $recepittmp->type = 1;
            $recepittmp->prescriptiontable = '';
            $recepittmp->forhusband = 0;
            $recepittmp->storeid = $storeId;
            try {
                $recepitTmpId = R::store($recepittmp);

                for ($x = 1; $x <= $itr; $x++) {
                    $drugId = filter_input(INPUT_POST, 'drug' . $x);

                    if (!empty($drugId) && $drugId != "") {
                        $ddd = R::load('phdrugs', $drugId);
                        $storeDrugs = R::findOne('storedrugs', ' deleted = 0 and  storeid = ' . $storeId . ' and drugid = ' . $drugId);
                        if (count($storeDrugs) > 0) {
                            $storeDrugsId = $storeDrugs->id;
                            $storedrugsvalidation = R::findAll('storedrugsvalidation', '  storedrugid = ' . $storeDrugsId . ' and currentbalance > 0 ');
                            foreach ($storedrugsvalidation as $validate) {
                                $drudamount = filter_input(INPUT_POST, 'amount' . $validate->id . '' . $x);
                                if (!empty($drudamount) && $drudamount > 0 && ($validate->currentbalance >= $drudamount )) {
                                    $before = $validate->currentbalance;
                                    $validate->currentbalance = $validate->currentbalance - $drudamount;
                                    R::store($validate);
                                    //here the add in tbl drugmovements
                                    $receiptdrugs = R::dispense('receiptdrugs');
                                    $receiptdrugs->receiptid = $recepitTmpId;
                                    $receiptdrugs->prescriptiondrugsid = 0;
                                    $receiptdrugs->validateto = $validate->validateto;
                                    $receiptdrugs->storedrugsvalidationid = $validate->id;
                                    $receiptdrugs->amount = $drudamount;
                                    $receiptdrugs->drugname = $ddd->drugname;
                                    $receiptdrugs->drugtype = $ddd->drugtype;
                                    R::store($receiptdrugs);

                                    //here the add in tbl drugmovements
                                    $drugMovement = R::dispense('drugmovements');
                                    $drugMovement->drugid = $drugId;
                                    $drugMovement->amountbefore = $before;
                                    $drugMovement->amountafter = $before - $drudamount;
                                    $drugMovement->amount = $drudamount;
                                    $drugMovement->operationdate = date('Y-m-d H:i:s');
                                    $drugMovement->operationtype = 1;
                                    $drugMovement->storeidfrom = $storeId;
                                    $drugMovement->storeidto = 0;
                                    $drugMovement->relatedid = $recepitTmpId;     ## bill id if import , or receipt id for export , 0 for transfer
                                    $drugMovement->comment = 'cash receipt';
                                    $drugMovement->userid = $_SESSION['user_id'];
                                    R::store($drugMovement);

                                    $chached = 1;
                                }
                            }
                        }
                    }
                }

                if ($chached == 1) {
                    $recepittmp->status = 1;
                    R::store($recepittmp);
                } else {
                    R::trash($recepittmp);
                }
                echo $chached;
            } catch (Exception $ex) {
                echo $ex;
            }
        } else {
            echo -1;
        }
    }

    private function saveInternalReceipt() {
        $recepitTmpId = filter_input(INPUT_POST, 'id');
        $storeId = filter_input(INPUT_POST, 'newStoreId');
        $recepitTmp = R::load('recepittmp', $recepitTmpId);

        $chached = 0;
        $prescriptionDurgs = R::findAll($recepitTmp->prescriptiontable, 'recepittmpid = ? and deleted = 0 and drugid != ?  ', [$recepitTmpId, ""]);

        try {
            foreach ($prescriptionDurgs as $data) {

                $drug = R::getRow('select id from phdrugs where drugname = "' . $data->drugname . '" and drugtype = "' . $data->drugtype . '" ');
                if (count($drug) > 0) {
                    $drugId = $drug['id'];
                    $storeDrugs = R::findOne('storedrugs', ' deleted = 0 and  storeid = ' . $storeId . ' and drugid = ' . $drugId);
                    if (count($storeDrugs) > 0) {
                        $storeDrugsId = $storeDrugs->id;
                        $storedrugsvalidation = R::findAll('storedrugsvalidation', '  storedrugid = ' . $storeDrugsId . ' and currentbalance > 0 ');
                        foreach ($storedrugsvalidation as $validate) {
                            $drudamount = filter_input(INPUT_POST, 'amount' . $validate->id . '' . $data->id);
                            if (!empty($drudamount) && $drudamount > 0 && ($validate->currentbalance >= $drudamount )) {
                                $before = $validate->currentbalance;
                                $validate->currentbalance = $validate->currentbalance - $drudamount;
                                R::store($validate);
                                //here the add in tbl drugmovements
                                $receiptdrugs = R::dispense('receiptdrugs');
                                $receiptdrugs->receiptid = $recepitTmpId;
                                $receiptdrugs->prescriptiondrugsid = $data->id;
                                $receiptdrugs->validateto = $validate->validateto;
                                $receiptdrugs->storedrugsvalidationid = $validate->id;
                                $receiptdrugs->amount = $drudamount;
                                $receiptdrugs->drugname = $data->drugname;
                                $receiptdrugs->drugtype = $data->drugtype;
                                $receiptdrugsId = R::store($receiptdrugs);

                                $data->recepitdrugid = $receiptdrugsId;
                                R::store($data);


                                //here the add in tbl drugmovements
                                $drugMovement = R::dispense('drugmovements');
                                $drugMovement->drugid = $drugId;
                                $drugMovement->amountbefore = $before;
                                $drugMovement->amountafter = $before - $drudamount;
                                $drugMovement->amount = $drudamount;
                                $drugMovement->operationdate = date('Y-m-d H:i:s');
                                $drugMovement->operationtype = 1;
                                $drugMovement->storeidfrom = $storeId;
                                $drugMovement->storeidto = 0;
                                $drugMovement->relatedid = $recepitTmpId;     ## bill id if import , or receipt id for export , 0 for transfer
                                $drugMovement->comment = 'cash receipt';
                                $drugMovement->userid = $_SESSION['user_id'];
                                R::store($drugMovement);

                                $chached = 1;
                            }
                        }
                    }
                }
            }

            if ($chached == 1) {
                $recepitTmp->status = 1;
                $recepitTmp->storeid = $storeId;
                R::store($recepitTmp);
            }
            echo $chached;
        } catch (Exception $ex) {
            echo -1;
        }
    }

    # Show all details receipt to cash

    public function details() {

//check login
        autho::checkautho($this->hosturl . "/../core");
//check authoize
        autho::checkauthoize($this->controllname, $this->hosturl . "/../core", $_SESSION['role_id']);
//get receipt by id
        $recepitTmpId = filter_input(INPUT_GET, 'id');
        $recepitTmp = R::load('recepittmp', $recepitTmpId);

        switch ($recepitTmp->type) {
            case 0:
                $this->internalDetails();
                break;
            default:
                $this->externalDetails();
                break;
        }

        $this->smarty->assign('recepitTmpType', $recepitTmp->type);
//calling html files
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('receipt/details.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    private function internalDetails() {

        $recepitTmpId = filter_input(INPUT_GET, 'id');
        $recepitTmp = R::load('recepittmp', $recepitTmpId);


        if ($recepitTmp->storeid != 0) {
            $stores = R::load('stores', $recepitTmp->storeid);
            $recepitTmp->storeName = $stores->name;
        }

## get doctor name in this receipt
        if ($recepitTmp->doctorid != 0) {
            $docName = R::getRow('SELECT user_name FROM awusers WHERE user_id = ? ', [$recepitTmp->doctorid]);
            $recepitTmp->doctorname = $docName['user_name'];
        }

##  get patient name in this receipt
        if ($recepitTmp->patientid != 0) {
            $patientName = R::load('patients', $recepitTmp->patientid);
            if ($recepitTmp->forhusband == 1) {
                $recepitTmp->patientname = $patientName->husdandname;
            } else {
                $recepitTmp->patientname = $patientName->wifename;
            }
        }


// get all drugs in this receipt
        $prescriptionDurgs = R::findAll($recepitTmp->prescriptiontable, 'recepittmpid = ? and deleted = 0 and drugid != ?  ', [$recepitTmpId, ""]);

        foreach ($prescriptionDurgs as $data) {
            if ($data->recepitdrugid == 0) {
                $data->amountcached = "Not Cached";
            } else {
                //$receiptdrugs = R::findAll('receiptdrugs', ' prescriptiondrugsid = ' . $data->id);
                $receiptdrugs = R::getAll('select receiptdrugs.* ,recepittmp.prescriptiontable  from receiptdrugs
                                join recepittmp  on  recepittmp.id =  receiptdrugs.receiptid
                                where receiptdrugs.prescriptiondrugsid = ' . $data->id);

                $data->amountcached = 0;
                $data->receiptdrugs = $receiptdrugs;
                $data->receiptdrugscount = count($receiptdrugs);
                foreach ($receiptdrugs as $single) {
                    $data->amountcached = $data->amountcached + $single['amount'];
                }
            }
        }

        $this->smarty->assign('durgs', $prescriptionDurgs);
        $this->smarty->assign('allreceipt', $recepitTmp);
    }

    private function externalDetails() {

        $recepitTmpId = filter_input(INPUT_GET, 'id');
        $recepitTmp = R::load('recepittmp', $recepitTmpId);

        if ($recepitTmp->storeid != 0) {
            $stores = R::load('stores', $recepitTmp->storeid);
            $recepitTmp->storeName = $stores->name;
        }

        ## get doctor name in this receipt
        if ($recepitTmp->doctorid != 0) {
            $docName = R::getRow('SELECT user_name FROM awusers WHERE user_id = ? ', [$recepitTmp->doctorid]);
            $recepitTmp->doctorname = $docName['user_name'];
        }

        ##  get patient name in this receipt
        if ($recepitTmp->patientid != 0) {
            $patientName = R::load('patients', $recepitTmp->patientid);
            $recepitTmp->patientname = $patientName->wifename;
        }

        $receiptdrugs = R::findAll('receiptdrugs', ' receiptid = ' . $recepitTmpId);
        $storedrugsIds = array();
        foreach ($receiptdrugs as $data) {
            $sql = ' select storedrugid
                from        storedrugsvalidation
                where  id =  ' . $data->storedrugsvalidationid;

            $storedrugsId = R::getRow($sql);
            array_push($storedrugsIds, $storedrugsId['storedrugid']);
        }

        $res = array();
        $storedrugsIds = array_values(array_unique($storedrugsIds));
        $i = 0;
        foreach ($storedrugsIds as $data) {
            $storedrugsvalidation = R::findAll('storedrugsvalidation', '  storedrugid = ' . $data);
            $res[$i]['amountcached'] = 0;

            foreach ($storedrugsvalidation as $valid) {
                $sql = ' select sum(receiptdrugs.amount) as currentsum
                from        receiptdrugs
                where  receiptdrugs.receiptid =  ' . $recepitTmpId . ' and receiptdrugs.storedrugsvalidationid =  ' . $valid->id;

                $currentsum = R::getRow($sql);
                $res[$i]['amountcached'] = $res[$i]['amountcached'] + $currentsum['currentsum'];
            }
            $storedrugs = R::load('storedrugs', $data);
            $drug = R::load('phdrugs', $storedrugs->drugid);
            $res[$i]['drugname'] = $drug->drugname;
            $res[$i]['drugtype'] = $drug->drugtype;
            $i++;
        }

        $this->smarty->assign('durgs', $res);
        $this->smarty->assign('allreceipt', $recepitTmp);
    }

##############################################################################

    public function searchreceipt() {
//check login
        autho::checkautho($this->hosturl . "/../core");
//check authoize
// autho::checkauthoize($this->controllname, $this->hosturl . "/../core", $_SESSION['role_id']);
        $searchValues = json_decode(stripslashes(filter_input(INPUT_POST, 'jsonString')));
        $searchType = $searchValues[0];

        switch ($searchType) {
            case 'new':
                $dateFrom = $searchValues[1];
                $dateTo = $searchValues[2];
                $this->getReceiptByDate($searchType, $dateFrom, $dateTo, 0);
                break;

            case 'cached':
                $dateFrom = $searchValues[3];
                $dateTo = $searchValues[4];
                $this->getReceiptByDate($searchType, $dateFrom, $dateTo, 1);
                break;

            default:
                break;
        }
    }

    private function getReceiptByDate($searchType, $dateFrom, $dateTo, $status) {
        $newRlreceipt = R::findAll('recepittmp', ' status = ' . $status . '  and  receiptdate  between "' . $dateFrom . '"  AND  "' . $dateTo . '"    order by receiptdate desc');
        foreach ($newRlreceipt as $data) {

##  doctor name
            if ($data->doctorid != 0) {
                $docName = R::getRow('SELECT user_name FROM awusers WHERE user_id = ? ', [$data->doctorid]);
                $data->doctorname = $docName['user_name'];
            }

##  patient name
            if ($data->patientid != 0) {
                $patientName = R::load('patients', $data->patientid);
                if ($data->forhusband == 1) {
                    $data->patientname = $patientName->husdandname;
                } else {
                    $data->patientname = $patientName->wifename;
                }
            }
        }

        $this->smarty->assign('reportType', $searchType);
        $this->smarty->assign('res', $newRlreceipt);
        $this->smarty->assign('rescount', count($newRlreceipt));
        $this->smarty->display('receipt/result.html');
    }

//here the frist page and
//the frist action in this class

    public function update() {
## check login
        autho::checkautho($this->hosturl);
## check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $id = filter_input(INPUT_POST, "id");
        $tablename = filter_input(INPUT_POST, "tableName");
        $colname = filter_input(INPUT_POST, "colName");
        $value = filter_input(INPUT_POST, "value");

        $obj = R::load($tablename, $id);
        $obj->$colname = $value;
        R::store($obj);
    }

// at the end of class call
    public function __destruct() {
//close connection
        R::close();
    }

}
