var invests = function () {

    var hosturl = $('#hosturl').val();
    var cbcDirection = 1;     ///// 1    down    ,   2   up  

    $('#invCheckAll').on('click', function () {
        if (this.checked) {
            // Iterate each checkbox
            $('.checkGroup').each(function () {
                $(this).attr('checked', 'checked');
                $(this).parent().addClass('checked');
            });
        } else {
            // Iterate each checkbox
            $(".checkGroup").each(function () {
                $(this).removeAttr('checked');
                $(this).parent().removeClass('checked');
            });
        }
    });

    function updateOne(id, colName, tableName, value) {
        var controllName = $('#controllName').val();
        $.post(hosturl + '/controllers/' + controllName + '.php?ac=update', {
            id: id,
            value: value,
            tableName: tableName,
            colName: colName
        }, function (res) {
            console.log(res);
        });
    }

    function updateArray(id, tableName, updatedArray) {
        var controllName = $('#controllName').val();
        var jsonString = JSON.stringify(updatedArray);
        $.post(hosturl + '/controllers/' + controllName + '.php?ac=updatearray', {
            id: id,
            tableName: tableName,
            data: jsonString
        }, function (res) {
            console.log(res);
        });
    }

    function checkRange(id, colName, tableName, value, element, text) {
        var controllName = $('#controllName').val();
        if (element.is('select')) {
            value = text;
        }


        $.post(hosturl + '/controllers/' + controllName + '.php?ac=checkRange', {
            id: id,
            value: value,
            tableName: tableName,
            colName: colName
        }, function (res) {
            if (Number(res) == 1) {
                if (element.is('input')) {
                    element.css(
                            {
                                "background-color": "#FFFF99"
                                , "border": "1px solid red"
                                , "animation": " fadein 6s"
                                , "transition": "opacity 0.5s"
                            });
                }

                if (element.is('select')) {
                    element.parent().css(
                            {
                                "background-color": "#FFFF99"
                                , "border": "1px solid red"
                                , "animation": " fadein 6s"
                                , "transition": "opacity 0.5s"
                            });
                }
            } else {

                if (element.is('input')) {
                    element.css({'background-color': '#fff', "border": "1px solid #000000"});
                }

                if (element.is('select')) {
                    element.parent().css({'background-color': '#fff', "border": "none"});
                }

            }
        });
    }

    var forAll = function () {
        $('body').on('change', '.updateInvest', function () {

            var id = $(this).attr("data-id");
            var colName = $(this).attr("data-colName");
            var tableName = $(this).attr("data-tableName");
            var value = $(this).val();
            var element = $(this);
            var text = '';
            if (element.is('select') && value > 0) {
                text = $(this).select2('data').text;
            }

            checkRange(id, colName, tableName, value, element, text);
            updateOne(id, colName, tableName, value);

            //   var myArr = tableName.split("_");
            if (tableName == 'investigationresults') {
                var filled = $('#invFilled' + id).attr('data-val');
                if (filled == 1) {
                    $('#invFilled' + id).trigger('click');
                }
            }

            if (element.hasClass("motilityCal")) {
                var invResId = $(this).attr("data-invResId");
                var A = Number($('#semen_mobility_a' + invResId).val());
                var B = Number($('#semen_mobility_c' + invResId).val());
                var C = Number($('#semen_mobility_sluggish' + invResId).val());
                var sum = 0;
                if (A >= 0) {
                    sum = sum + A;
                }

                if (B >= 0) {
                    sum = sum + B;
                }

                if (C >= 0) {
                    sum = sum + C;
                }

                $('#semen_mobility_b' + invResId).val(sum).trigger('change');
            }


            if (element.hasClass("totalCount")) {
                var invResId = $(this).attr("data-invResId");
                var sperm_count = Number($('#semen_sperm_count' + invResId).val());
                var semen_volume = Number($('#semen_volume' + invResId).val());
                var res = '';
                if (sperm_count >= 0 && semen_volume >= 0) {
                    res = (sperm_count * semen_volume).toFixed(1);
                }

                $('#semen_total_count' + invResId).val(res).trigger('change');
            }

            if (element.hasClass("totalMotility")) {
                var invResId = $(this).attr("data-invResId");
                var totalCount = Number($('#semen_mobility_b' + invResId).val());
                var sum = 0;
                if (totalCount >= 0) {
                    sum = 100 - totalCount;
                }

                $('#semen_mobility_d' + invResId).val(sum).trigger('change');
            }


            if (element.hasClass("sperms")) {
                var invResId = $(this).attr("data-invResId");
                var normal = Number($('#semen_normal_form' + invResId).val());
                var abNormal = '';
                if (normal >= 0) {
                    abNormal = 100 - normal;
                }
                $('#semen_ab_form' + invResId).val(abNormal).trigger('change');
            }


        });
        // pdf
        $('body').on('change', '.addInvPdf', function () {
            var id = $(this).attr("data-id");
            var no = $(this).attr("data-no");
            $('#talks-loading' + id + '_' + no).show();
            var files = $('#invPdf' + no + '_' + id)[0].files;
            var isValid = 2;
            for (var i = 0; i < files.length; i++) {
                //alert(files[i].name);
                var valid = checkFile(files[i].name, id);
                if (valid == 2) {

                } else if (valid == 1) {
                    isValid = 1;
                }
            }

            if (isValid == 2) {
                var myformdata = new FormData();
                myformdata.append("type", "All");
                myformdata.append("name", 'invPdf');
                myformdata.append("id", id);
                myformdata.append("no", no);
                myformdata.append("imgCount", files.length);
                jQuery.each(jQuery('#invPdf' + no + '_' + id)[0].files, function (i, file) {
                    myformdata.append('file-' + i, file);
                });
                $.ajax({
                    url: hosturl + '/controllers/invsdept.php?ac=uploadone', // Url to which the request is send
                    type: "POST", // Type of request to be send, called as method
                    data: myformdata, // Data sent to server, a set of key/value pairs representing form fields and values
                    contentType: false, // The content type used when sending data to the server. Default is: "application/x-www-form-urlencoded"
                    cache: false, // To unable request pages to be cached
                    processData: false, // To send DOMDocument or non processed data file it is set to false (i.e. data should not be in the form of string)
                    success: function (data)  		// A function to be called if request succeeds
                    {
                        if (data != -1 && data != 'no image') {
                            var patientNo = $('#patientNo').val();
                            $('#pdf' + no + 'Download' + id).attr('href', hosturl + '/../upload/inv_pdf/' + patientNo + '/' + data);
                            $('#pdf' + no + 'Download' + id).show('');
                        } else {
                            alert('error while uploading ');
                        }

                        $('#talks-loading' + id + '_' + no).hide();
                    }
                });
            }

        });
        function checkFile(filename, id) {
            filename = filename.replace(/C:\\fakepath\\/i, '');
            if (filename != "") {
                var ext = filename;
                var extindex = ext.lastIndexOf(".") + 1;
                ext = ext.slice(extindex, ext.length);
                ext = ext.toLowerCase();
                if ($.inArray(ext, ['doc', 'docx', 'pdf']) == -1) {
                    alert("pictures only allowed ( doc , docx , pdf )");
                    $('#talks-loading' + id).hide();
                    return 1;
                } else {
                    return 2;
                }
            } else {
                return 1;
            }
        }

        $('select').on('change', function () {
            var select = $(this);
            var colName = select.attr("select-colName");
            //            var delColName = select.attr("select-delColName");
            var delColName = 'deleted';
            var tableName = select.attr("select-tableName");
            var defaultValue = select.attr("select-default");
            var value = select.val();
            if (value == '-2') {
                $.post(hosturl + '/controllers/invsdept.php?ac=editModal', {
                    tableName: tableName, delColName: delColName, selectClass: tableName
                    , colName: colName, defaultValue: defaultValue
                }, function (data) {
                    select.select2("val", "");
                    $("#editModalDiv").html(data);
                    $("#edit_model").modal('show');
                });
            }

        });

    };

    var urineInvest = function () {

        $("#urine_volume").select2({
            placeholder: "Select",
            width: '240px',
            allowClear: true,
            formatNoMatches: function (term) {
                /* customize the no matches output */
                return "<input class='form-control' id='newTerm_urine_volume' value='" + term + "'><a href='#' id='addNew_urine_volume' class='btn blue custombtnstyle'>إضافة جديد</a>"
            }
        }).parent().find('.select2-with-searchbox').on('click', '#addNew_urine_volume', function () {
            /* add the new term */
            var new_name = $('#newTerm_urine_volume').val();
            var id = $("#urine_volume").attr('data-id');
            var tableName = $("#urine_volume").attr('data-tableName');
            var colName = $("#urine_volume").attr('data-colName');
            $.post(hosturl + "/controllers/invsdept.php?ac=addnewrecord", {
                selectId: 'urine_volume',
                new_name: new_name,
                id: id,
                tableName: tableName,
                colName: colName
            }, function (data) {


                $('#urine_volume > .deleteoptincompo').before('<option value="' + Number(data) + '" >' + new_name + '</option>');
                $('#urine_volume').select2('val', Number(data)); // select the new term
                $("#urine_volume").select2('close'); // close the dropdown

            });
        });
        $("#urine_color").select2({
            placeholder: "Select",
            width: '240px',
            allowClear: true,
            formatNoMatches: function (term) {
                /* customize the no matches output */
                return "<input class='form-control' id='newTerm_urine_color' value='" + term + "'><a href='#' id='addNew_urine_color' class='btn blue custombtnstyle'>إضافة جديد</a>"
            }
        }).parent().find('.select2-with-searchbox').on('click', '#addNew_urine_color', function () {
            /* add the new term */
            var new_name = $('#newTerm_urine_color').val();
            var id = $("#urine_color").attr('data-id');
            var tableName = $("#urine_color").attr('data-tableName');
            var colName = $("#urine_color").attr('data-colName');
            $.post(hosturl + "/controllers/invsdept.php?ac=addnewrecord", {
                selectId: 'urine_color',
                new_name: new_name,
                id: id,
                tableName: tableName,
                colName: colName
            }, function (data) {


                $('#urine_color > .deleteoptincompo').before('<option value="' + Number(data) + '" >' + new_name + '</option>');
                $('#urine_color').select2('val', Number(data)); // select the new term
                $("#urine_color").select2('close'); // close the dropdown

            });
        });
        $("#urine_odor").select2({
            placeholder: "Select",
            width: '240px',
            allowClear: true,
            formatNoMatches: function (term) {
                /* customize the no matches output */
                return "<input class='form-control' id='newTerm_urine_odor' value='" + term + "'><a href='#' id='addNew_urine_odor' class='btn blue custombtnstyle'>إضافة جديد</a>"
            }
        }).parent().find('.select2-with-searchbox').on('click', '#addNew_urine_odor', function () {
            /* add the new term */
            var new_name = $('#newTerm_urine_odor').val();
            var id = $("#urine_odor").attr('data-id');
            var tableName = $("#urine_odor").attr('data-tableName');
            var colName = $("#urine_odor").attr('data-colName');
            $.post(hosturl + "/controllers/invsdept.php?ac=addnewrecord", {
                selectId: 'urine_odor',
                new_name: new_name,
                id: id,
                tableName: tableName,
                colName: colName
            }, function (data) {


                $('#urine_odor > .deleteoptincompo').before('<option value="' + Number(data) + '" >' + new_name + '</option>');
                $('#urine_odor').select2('val', Number(data)); // select the new term
                $("#urine_odor").select2('close'); // close the dropdown

            });
        });
        $("#urine_ova").select2({
            placeholder: "Select",
            width: '240px',
            allowClear: true,
            formatNoMatches: function (term) {
                /* customize the no matches output */
                return "<input class='form-control' id='newTerm_urine_ova' value='" + term + "'><a href='#' id='addNew_urine_ova' class='btn blue custombtnstyle'>إضافة جديد</a>"
            }
        }).parent().find('.select2-with-searchbox').on('click', '#addNew_urine_ova', function () {
            /* add the new term */
            var new_name = $('#newTerm_urine_ova').val();
            var id = $("#urine_ova").attr('data-id');
            var tableName = $("#urine_ova").attr('data-tableName');
            var colName = $("#urine_ova").attr('data-colName');
            $.post(hosturl + "/controllers/invsdept.php?ac=addnewrecord", {
                selectId: 'urine_ova',
                new_name: new_name,
                id: id,
                tableName: tableName,
                colName: colName
            }, function (data) {


                $('#urine_ova > .deleteoptincompo').before('<option value="' + Number(data) + '" >' + new_name + '</option>');
                $('#urine_ova').select2('val', Number(data)); // select the new term
                $("#urine_ova").select2('close'); // close the dropdown

            });
        });
        $("#urine_bacteria").select2({
            placeholder: "Select",
            width: '240px',
            allowClear: true,
            formatNoMatches: function (term) {
                /* customize the no matches output */
                return "<input class='form-control' id='newTerm_urine_bacteria' value='" + term + "'><a href='#' id='addNew_urine_bacteria' class='btn blue custombtnstyle'>إضافة جديد</a>"
            }
        }).parent().find('.select2-with-searchbox').on('click', '#addNew_urine_bacteria', function () {
            /* add the new term */
            var new_name = $('#newTerm_urine_bacteria').val();
            var id = $("#urine_bacteria").attr('data-id');
            var tableName = $("#urine_bacteria").attr('data-tableName');
            var colName = $("#urine_bacteria").attr('data-colName');
            $.post(hosturl + "/controllers/invsdept.php?ac=addnewrecord", {
                selectId: 'urine_bacteria',
                new_name: new_name,
                id: id,
                tableName: tableName,
                colName: colName
            }, function (data) {


                $('#urine_bacteria > .deleteoptincompo').before('<option value="' + Number(data) + '" >' + new_name + '</option>');
                $('#urine_bacteria').select2('val', Number(data)); // select the new term
                $("#urine_bacteria").select2('close'); // close the dropdown

            });
        });
        $("#urine_mucus").select2({
            placeholder: "Select",
            width: '240px',
            allowClear: true,
            formatNoMatches: function (term) {
                /* customize the no matches output */
                return "<input class='form-control' id='newTerm_urine_mucus' value='" + term + "'><a href='#' id='addNew_urine_mucus' class='btn blue custombtnstyle'>إضافة جديد</a>"
            }
        }).parent().find('.select2-with-searchbox').on('click', '#addNew_urine_mucus', function () {
            /* add the new term */
            var new_name = $('#newTerm_urine_mucus').val();
            var id = $("#urine_mucus").attr('data-id');
            var tableName = $("#urine_mucus").attr('data-tableName');
            var colName = $("#urine_mucus").attr('data-colName');
            $.post(hosturl + "/controllers/invsdept.php?ac=addnewrecord", {
                selectId: 'urine_mucus',
                new_name: new_name,
                id: id,
                tableName: tableName,
                colName: colName
            }, function (data) {


                $('#urine_mucus > .deleteoptincompo').before('<option value="' + Number(data) + '" >' + new_name + '</option>');
                $('#urine_mucus').select2('val', Number(data)); // select the new term
                $("#urine_mucus").select2('close'); // close the dropdown

            });
        });
        $("#urine_trophazite").select2({
            placeholder: "Select",
            width: '240px',
            allowClear: true,
            formatNoMatches: function (term) {
                /* customize the no matches output */
                return "<input class='form-control' id='newTerm_urine_trophazite' value='" + term + "'><a href='#' id='addNew_urine_trophazite' class='btn blue custombtnstyle'>إضافة جديد</a>"
            }
        }).parent().find('.select2-with-searchbox').on('click', '#addNew_urine_trophazite', function () {
            /* add the new term */
            var new_name = $('#newTerm_urine_trophazite').val();
            var id = $("#urine_trophazite").attr('data-id');
            var tableName = $("#urine_trophazite").attr('data-tableName');
            var colName = $("#urine_trophazite").attr('data-colName');
            $.post(hosturl + "/controllers/invsdept.php?ac=addnewrecord", {
                selectId: 'urine_trophazite',
                new_name: new_name,
                id: id,
                tableName: tableName,
                colName: colName
            }, function (data) {


                $('#urine_trophazite > .deleteoptincompo').before('<option value="' + Number(data) + '" >' + new_name + '</option>');
                $('#urine_trophazite').select2('val', Number(data)); // select the new term
                $("#urine_trophazite").select2('close'); // close the dropdown

            });
        });

        $("#urine_reaction").select2({
            placeholder: "Select",
            width: '240px',
            allowClear: true,
            formatNoMatches: function (term) {
                /* customize the no matches output */
                return "<input class='form-control' id='newTerm_urine_reaction' value='" + term + "'><a href='#' id='addNew_urine_reaction' class='btn blue custombtnstyle'>إضافة جديد</a>"
            }
        }).parent().find('.select2-with-searchbox').on('click', '#addNew_urine_reaction', function () {
            /* add the new term */
            var new_name = $('#newTerm_urine_reaction').val();
            var id = $("#urine_reaction").attr('data-id');
            var tableName = $("#urine_reaction").attr('data-tableName');
            var colName = $("#urine_reaction").attr('data-colName');
            $.post(hosturl + "/controllers/invsdept.php?ac=addnewrecord", {
                selectId: 'urine_reaction',
                new_name: new_name,
                id: id,
                tableName: tableName,
                colName: colName
            }, function (data) {


                $('#urine_reaction > .deleteoptincompo').before('<option value="' + Number(data) + '" >' + new_name + '</option>');
                $('#urine_reaction').select2('val', Number(data)); // select the new term
                $("#urine_reaction").select2('close'); // close the dropdown

            });
        });
        $("#urine_casts").select2({
            placeholder: "Select",
            width: '240px',
            allowClear: true,
            formatNoMatches: function (term) {
                /* customize the no matches output */
                return "<input class='form-control' id='newTerm_urine_casts' value='" + term + "'><a href='#' id='addNew_urine_casts' class='btn blue custombtnstyle'>إضافة جديد</a>"
            }
        }).parent().find('.select2-with-searchbox').on('click', '#addNew_urine_casts', function () {
            /* add the new term */
            var new_name = $('#newTerm_urine_casts').val();
            var id = $("#urine_casts").attr('data-id');
            var tableName = $("#urine_casts").attr('data-tableName');
            var colName = $("#urine_casts").attr('data-colName');
            $.post(hosturl + "/controllers/invsdept.php?ac=addnewrecord", {
                selectId: 'urine_casts',
                new_name: new_name,
                id: id,
                tableName: tableName,
                colName: colName
            }, function (data) {


                $('#urine_casts > .deleteoptincompo').before('<option value="' + Number(data) + '" >' + new_name + '</option>');
                $('#urine_casts').select2('val', Number(data)); // select the new term
                $("#urine_casts").select2('close'); // close the dropdown

            });
        });
        $("#urine_sugar").select2({
            placeholder: "Select",
            width: '240px',
            allowClear: true,
            formatNoMatches: function (term) {
                /* customize the no matches output */
                return "<input class='form-control' id='newTerm_urine_sugar' value='" + term + "'><a href='#' id='addNew_urine_sugar' class='btn blue custombtnstyle'>إضافة جديد</a>"
            }
        }).parent().find('.select2-with-searchbox').on('click', '#addNew_urine_sugar', function () {
            /* add the new term */
            var new_name = $('#newTerm_urine_sugar').val();
            var id = $("#urine_sugar").attr('data-id');
            var tableName = $("#urine_sugar").attr('data-tableName');
            var colName = $("#urine_sugar").attr('data-colName');
            $.post(hosturl + "/controllers/invsdept.php?ac=addnewrecord", {
                selectId: 'urine_sugar',
                new_name: new_name,
                id: id,
                tableName: tableName,
                colName: colName
            }, function (data) {


                $('#urine_sugar > .deleteoptincompo').before('<option value="' + Number(data) + '" >' + new_name + '</option>');
                $('#urine_sugar').select2('val', Number(data)); // select the new term
                $("#urine_sugar").select2('close'); // close the dropdown

            });
        });

        $("#urine_blood").select2({
            placeholder: "Select",
            width: '240px',
            allowClear: true,
            formatNoMatches: function (term) {
                /* customize the no matches output */
                return "<input class='form-control' id='newTerm_urine_blood' value='" + term + "'><a href='#' id='addNew_urine_blood' class='btn blue custombtnstyle'>إضافة جديد</a>"
            }
        }).parent().find('.select2-with-searchbox').on('click', '#addNew_urine_blood', function () {
            /* add the new term */
            var new_name = $('#newTerm_urine_blood').val();
            var id = $("#urine_blood").attr('data-id');
            var tableName = $("#urine_blood").attr('data-tableName');
            var colName = $("#urine_blood").attr('data-colName');
            $.post(hosturl + "/controllers/invsdept.php?ac=addnewrecord", {
                selectId: 'urine_blood',
                new_name: new_name,
                id: id,
                tableName: tableName,
                colName: colName
            }, function (data) {


                $('#urine_blood > .deleteoptincompo').before('<option value="' + Number(data) + '" >' + new_name + '</option>');
                $('#urine_blood').select2('val', Number(data)); // select the new term
                $("#urine_blood").select2('close'); // close the dropdown

            });
        });
        $("#urine_leucocytes").select2({
            placeholder: "Select",
            width: '240px',
            allowClear: true,
            formatNoMatches: function (term) {
                /* customize the no matches output */
                return "<input class='form-control' id='newTerm_urine_leucocytes' value='" + term + "'><a href='#' id='addNew_urine_leucocytes' class='btn blue custombtnstyle'>إضافة جديد</a>"
            }
        }).parent().find('.select2-with-searchbox').on('click', '#addNew_urine_leucocytes', function () {
            /* add the new term */
            var new_name = $('#newTerm_urine_leucocytes').val();
            var id = $("#urine_leucocytes").attr('data-id');
            var tableName = $("#urine_leucocytes").attr('data-tableName');
            var colName = $("#urine_leucocytes").attr('data-colName');
            $.post(hosturl + "/controllers/invsdept.php?ac=addnewrecord", {
                selectId: 'urine_leucocytes',
                new_name: new_name,
                id: id,
                tableName: tableName,
                colName: colName
            }, function (data) {


                $('#urine_leucocytes > .deleteoptincompo').before('<option value="' + Number(data) + '" >' + new_name + '</option>');
                $('#urine_leucocytes').select2('val', Number(data)); // select the new term
                $("#urine_leucocytes").select2('close'); // close the dropdown

            });
        });
        $("#urine_aspect").select2({
            placeholder: "Select",
            width: '240px',
            allowClear: true,
            formatNoMatches: function (term) {
                /* customize the no matches output */
                return "<input class='form-control' id='newTerm_urine_aspect' value='" + term + "'><a href='#' id='addNew_urine_aspect' class='btn blue custombtnstyle'>إضافة جديد</a>"
            }
        }).parent().find('.select2-with-searchbox').on('click', '#addNew_urine_aspect', function () {
            /* add the new term */
            var new_name = $('#newTerm_urine_aspect').val();
            var id = $("#urine_aspect").attr('data-id');
            var tableName = $("#urine_aspect").attr('data-tableName');
            var colName = $("#urine_aspect").attr('data-colName');
            $.post(hosturl + "/controllers/invsdept.php?ac=addnewrecord", {
                selectId: 'urine_aspect',
                new_name: new_name,
                id: id,
                tableName: tableName,
                colName: colName
            }, function (data) {


                $('#urine_aspect > .deleteoptincompo').before('<option value="' + Number(data) + '" >' + new_name + '</option>');
                $('#urine_aspect').select2('val', Number(data)); // select the new term
                $("#urine_aspect").select2('close'); // close the dropdown

            });
        });
        $("#urine_protein").select2({
            placeholder: "Select",
            width: '240px',
            allowClear: true,
            formatNoMatches: function (term) {
                /* customize the no matches output */
                return "<input class='form-control' id='newTerm_urine_protein' value='" + term + "'><a href='#' id='addNew_urine_protein' class='btn blue custombtnstyle'>إضافة جديد</a>"
            }
        }).parent().find('.select2-with-searchbox').on('click', '#addNew_urine_protein', function () {
            /* add the new term */
            var new_name = $('#newTerm_urine_protein').val();
            var id = $("#urine_protein").attr('data-id');
            var tableName = $("#urine_protein").attr('data-tableName');
            var colName = $("#urine_protein").attr('data-colName');
            $.post(hosturl + "/controllers/invsdept.php?ac=addnewrecord", {
                selectId: 'urine_protein',
                new_name: new_name,
                id: id,
                tableName: tableName,
                colName: colName
            }, function (data) {


                $('#urine_protein > .deleteoptincompo').before('<option value="' + Number(data) + '" >' + new_name + '</option>');
                $('#urine_protein').select2('val', Number(data)); // select the new term
                $("#urine_protein").select2('close'); // close the dropdown

            });
        });
        $("#urine_epithelial").select2({
            placeholder: "Select",
            width: '240px',
            allowClear: true,
            formatNoMatches: function (term) {
                /* customize the no matches output */
                return "<input class='form-control' id='newTerm_urine_epithelial' value='" + term + "'><a href='#' id='addNew_urine_epithelial' class='btn blue custombtnstyle'>إضافة جديد</a>"
            }
        }).parent().find('.select2-with-searchbox').on('click', '#addNew_urine_epithelial', function () {
            /* add the new term */
            var new_name = $('#newTerm_urine_epithelial').val();
            var id = $("#urine_epithelial").attr('data-id');
            var tableName = $("#urine_epithelial").attr('data-tableName');
            var colName = $("#urine_epithelial").attr('data-colName');
            $.post(hosturl + "/controllers/invsdept.php?ac=addnewrecord", {
                selectId: 'urine_epithelial',
                new_name: new_name,
                id: id,
                tableName: tableName,
                colName: colName
            }, function (data) {


                $('#urine_epithelial > .deleteoptincompo').before('<option value="' + Number(data) + '" >' + new_name + '</option>');
                $('#urine_epithelial').select2('val', Number(data)); // select the new term
                $("#urine_epithelial").select2('close'); // close the dropdown

            });
        });
        $("#urine_bacteria2").select2({
            placeholder: "Select",
            width: '240px',
            allowClear: true,
            formatNoMatches: function (term) {
                /* customize the no matches output */
                return "<input class='form-control' id='newTerm_urine_bacteria2' value='" + term + "'><a href='#' id='addNew_urine_bacteria2' class='btn blue custombtnstyle'>إضافة جديد</a>"
            }
        }).parent().find('.select2-with-searchbox').on('click', '#addNew_urine_bacteria2', function () {
            /* add the new term */
            var new_name = $('#newTerm_urine_bacteria2').val();
            var id = $("#urine_bacteria2").attr('data-id');
            var tableName = $("#urine_bacteria2").attr('data-tableName');
            var colName = $("#urine_bacteria2").attr('data-colName');
            $.post(hosturl + "/controllers/invsdept.php?ac=addnewrecord", {
                selectId: 'urine_bacteria2',
                new_name: new_name,
                id: id,
                tableName: tableName,
                colName: colName
            }, function (data) {


                $('#urine_bacteria2 > .deleteoptincompo').before('<option value="' + Number(data) + '" >' + new_name + '</option>');
                $('#urine_bacteria2').select2('val', Number(data)); // select the new term
                $("#urine_bacteria2").select2('close'); // close the dropdown

            });
        });
        $("#urine_fungi").select2({
            placeholder: "Select",
            width: '240px',
            allowClear: true,
            formatNoMatches: function (term) {
                /* customize the no matches output */
                return "<input class='form-control' id='newTerm_urine_fungi' value='" + term + "'><a href='#' id='addNew_urine_fungi' class='btn blue custombtnstyle'>إضافة جديد</a>"
            }
        }).parent().find('.select2-with-searchbox').on('click', '#addNew_urine_fungi', function () {
            /* add the new term */
            var new_name = $('#newTerm_urine_fungi').val();
            var id = $("#urine_fungi").attr('data-id');
            var tableName = $("#urine_fungi").attr('data-tableName');
            var colName = $("#urine_fungi").attr('data-colName');
            $.post(hosturl + "/controllers/invsdept.php?ac=addnewrecord", {
                selectId: 'urine_fungi',
                new_name: new_name,
                id: id,
                tableName: tableName,
                colName: colName
            }, function (data) {


                $('#urine_fungi > .deleteoptincompo').before('<option value="' + Number(data) + '" >' + new_name + '</option>');
                $('#urine_fungi').select2('val', Number(data)); // select the new term
                $("#urine_fungi").select2('close'); // close the dropdown

            });
        });
        $("#urine_urobilinigen").select2({
            placeholder: "Select",
            width: '240px',
            allowClear: true,
            formatNoMatches: function (term) {
                /* customize the no matches output */
                return "<input class='form-control' id='newTerm_urine_urobilinigen' value='" + term + "'><a href='#' id='addNew_urine_urobilinigen' class='btn blue custombtnstyle'>إضافة جديد</a>"
            }
        }).parent().find('.select2-with-searchbox').on('click', '#addNew_urine_urobilinigen', function () {
            /* add the new term */
            var new_name = $('#newTerm_urine_urobilinigen').val();
            var id = $("#urine_urobilinigen").attr('data-id');
            var tableName = $("#urine_urobilinigen").attr('data-tableName');
            var colName = $("#urine_urobilinigen").attr('data-colName');
            $.post(hosturl + "/controllers/invsdept.php?ac=addnewrecord", {
                selectId: 'urine_urobilinigen',
                new_name: new_name,
                id: id,
                tableName: tableName,
                colName: colName
            }, function (data) {


                $('#urine_urobilinigen > .deleteoptincompo').before('<option value="' + Number(data) + '" >' + new_name + '</option>');
                $('#urine_urobilinigen').select2('val', Number(data)); // select the new term
                $("#urine_urobilinigen").select2('close'); // close the dropdown

            });
        });
        $("#urine_amorphous2").select2({
            placeholder: "Select",
            width: '240px',
            allowClear: true,
            formatNoMatches: function (term) {
                /* customize the no matches output */
                return "<input class='form-control' id='newTerm_urine_amorphous2' value='" + term + "'><a href='#' id='addNew_urine_amorphous2' class='btn blue custombtnstyle'>إضافة جديد</a>"
            }
        }).parent().find('.select2-with-searchbox').on('click', '#addNew_urine_amorphous2', function () {
            /* add the new term */
            var new_name = $('#newTerm_urine_amorphous2').val();
            var id = $("#urine_amorphous2").attr('data-id');
            var tableName = $("#urine_amorphous2").attr('data-tableName');
            var colName = $("#urine_amorphous2").attr('data-colName');
            $.post(hosturl + "/controllers/invsdept.php?ac=addnewrecord", {
                selectId: 'urine_amorphous2',
                new_name: new_name,
                id: id,
                tableName: tableName,
                colName: colName
            }, function (data) {


                $('#urine_amorphous2 > .deleteoptincompo').before('<option value="' + Number(data) + '" >' + new_name + '</option>');
                $('#urine_amorphous2').select2('val', Number(data)); // select the new term
                $("#urine_amorphous2").select2('close'); // close the dropdown

            });
        });
        $("#urine_deposit").select2({
            placeholder: "Select",
            width: '240px',
            allowClear: true,
            formatNoMatches: function (term) {
                /* customize the no matches output */
                return "<input class='form-control' id='newTerm_urine_deposit' value='" + term + "'><a href='#' id='addNew_urine_deposit' class='btn blue custombtnstyle'>إضافة جديد</a>"
            }
        }).parent().find('.select2-with-searchbox').on('click', '#addNew_urine_deposit', function () {
            /* add the new term */
            var new_name = $('#newTerm_urine_deposit').val();
            var id = $("#urine_deposit").attr('data-id');
            var tableName = $("#urine_deposit").attr('data-tableName');
            var colName = $("#urine_deposit").attr('data-colName');
            $.post(hosturl + "/controllers/invsdept.php?ac=addnewrecord", {
                selectId: 'urine_deposit',
                new_name: new_name,
                id: id,
                tableName: tableName,
                colName: colName
            }, function (data) {


                $('#urine_deposit > .deleteoptincompo').before('<option value="' + Number(data) + '" >' + new_name + '</option>');
                $('#urine_deposit').select2('val', Number(data)); // select the new term
                $("#urine_deposit").select2('close'); // close the dropdown

            });
        });
        $("#urine_artifacts").select2({
            placeholder: "Select",
            width: '240px',
            allowClear: true,
            formatNoMatches: function (term) {
                /* customize the no matches output */
                return "<input class='form-control' id='newTerm_urine_artifacts' value='" + term + "'><a href='#' id='addNew_urine_artifacts' class='btn blue custombtnstyle'>إضافة جديد</a>"
            }
        }).parent().find('.select2-with-searchbox').on('click', '#addNew_urine_artifacts', function () {
            /* add the new term */
            var new_name = $('#newTerm_urine_artifacts').val();
            var id = $("#urine_artifacts").attr('data-id');
            var tableName = $("#urine_artifacts").attr('data-tableName');
            var colName = $("#urine_artifacts").attr('data-colName');
            $.post(hosturl + "/controllers/invsdept.php?ac=addnewrecord", {
                selectId: 'urine_artifacts',
                new_name: new_name,
                id: id,
                tableName: tableName,
                colName: colName
            }, function (data) {


                $('#urine_artifacts > .deleteoptincompo').before('<option value="' + Number(data) + '" >' + new_name + '</option>');
                $('#urine_artifacts').select2('val', Number(data)); // select the new term
                $("#urine_artifacts").select2('close'); // close the dropdown

            });
        });
        $("#urine_acetone").select2({
            placeholder: "Select",
            width: '240px',
            allowClear: true,
            formatNoMatches: function (term) {
                /* customize the no matches output */
                return "<input class='form-control' id='newTerm_urine_acetone' value='" + term + "'><a href='#' id='addNew_urine_acetone' class='btn blue custombtnstyle'>إضافة جديد</a>"
            }
        }).parent().find('.select2-with-searchbox').on('click', '#addNew_urine_acetone', function () {
            /* add the new term */
            var new_name = $('#newTerm_urine_acetone').val();
            var id = $("#urine_acetone").attr('data-id');
            var tableName = $("#urine_acetone").attr('data-tableName');
            var colName = $("#urine_acetone").attr('data-colName');
            $.post(hosturl + "/controllers/invsdept.php?ac=addnewrecord", {
                selectId: 'urine_acetone',
                new_name: new_name,
                id: id,
                tableName: tableName,
                colName: colName
            }, function (data) {


                $('#urine_acetone > .deleteoptincompo').before('<option value="' + Number(data) + '" >' + new_name + '</option>');
                $('#urine_acetone').select2('val', Number(data)); // select the new term
                $("#urine_acetone").select2('close'); // close the dropdown

            });
        });
        $("#urine_casts2").select2({
            placeholder: "Select",
            width: '240px',
            allowClear: true,
            formatNoMatches: function (term) {
                /* customize the no matches output */
                return "<input class='form-control' id='newTerm_urine_casts2' value='" + term + "'><a href='#' id='addNew_urine_casts2' class='btn blue custombtnstyle'>إضافة جديد</a>"
            }
        }).parent().find('.select2-with-searchbox').on('click', '#addNew_urine_casts2', function () {
            /* add the new term */
            var new_name = $('#newTerm_urine_casts2').val();
            var id = $("#urine_casts2").attr('data-id');
            var tableName = $("#urine_casts2").attr('data-tableName');
            var colName = $("#urine_casts2").attr('data-colName');
            $.post(hosturl + "/controllers/invsdept.php?ac=addnewrecord", {
                selectId: 'urine_casts2',
                new_name: new_name,
                id: id,
                tableName: tableName,
                colName: colName
            }, function (data) {


                $('#urine_casts2 > .deleteoptincompo').before('<option value="' + Number(data) + '" >' + new_name + '</option>');
                $('#urine_casts2').select2('val', Number(data)); // select the new term
                $("#urine_casts2").select2('close'); // close the dropdown

            });
        });
        $("#urine_nitrite").select2({
            placeholder: "Select",
            width: '240px',
            allowClear: true,
            formatNoMatches: function (term) {
                /* customize the no matches output */
                return "<input class='form-control' id='newTerm_urine_nitrite' value='" + term + "'><a href='#' id='addNew_urine_nitrite' class='btn blue custombtnstyle'>إضافة جديد</a>"
            }
        }).parent().find('.select2-with-searchbox').on('click', '#addNew_urine_nitrite', function () {
            /* add the new term */
            var new_name = $('#newTerm_urine_nitrite').val();
            var id = $("#urine_nitrite").attr('data-id');
            var tableName = $("#urine_nitrite").attr('data-tableName');
            var colName = $("#urine_nitrite").attr('data-colName');
            $.post(hosturl + "/controllers/invsdept.php?ac=addnewrecord", {
                selectId: 'urine_nitrite',
                new_name: new_name,
                id: id,
                tableName: tableName,
                colName: colName
            }, function (data) {


                $('#urine_nitrite > .deleteoptincompo').before('<option value="' + Number(data) + '" >' + new_name + '</option>');
                $('#urine_nitrite').select2('val', Number(data)); // select the new term
                $("#urine_nitrite").select2('close'); // close the dropdown

            });
        });

        $("#urine_gravity").select2({
            placeholder: "Select",
            width: '240px',
            allowClear: true,
            formatNoMatches: function (term) {
                /* customize the no matches output */
                return "<input class='form-control' id='newTerm_urine_gravity' value='" + term + "'><a href='#' id='addNew_urine_gravity' class='btn blue custombtnstyle'>إضافة جديد</a>"
            }
        }).parent().find('.select2-with-searchbox').on('click', '#addNew_urine_gravity', function () {
            /* add the new term */
            var new_name = $('#newTerm_urine_gravity').val();
            var id = $("#urine_gravity").attr('data-id');
            var tableName = $("#urine_gravity").attr('data-tableName');
            var colName = $("#urine_gravity").attr('data-colName');
            $.post(hosturl + "/controllers/invsdept.php?ac=addnewrecord", {
                selectId: 'urine_gravity',
                new_name: new_name,
                id: id,
                tableName: tableName,
                colName: colName
            }, function (data) {


                $('#urine_gravity > .deleteoptincompo').before('<option value="' + Number(data) + '" >' + new_name + '</option>');
                $('#urine_gravity').select2('val', Number(data)); // select the new term
                $("#urine_gravity").select2('close'); // close the dropdown

            });
        });
        $("#urine_crystal2").select2({
            placeholder: "Select",
            width: '240px',
            allowClear: true,
            formatNoMatches: function (term) {
                /* customize the no matches output */
                return "<input class='form-control' id='newTerm_urine_crystal2' value='" + term + "'><a href='#' id='addNew_urine_crystal2' class='btn blue custombtnstyle'>إضافة جديد</a>"
            }
        }).parent().find('.select2-with-searchbox').on('click', '#addNew_urine_crystal2', function () {
            /* add the new term */
            var new_name = $('#newTerm_urine_crystal2').val();
            var id = $("#urine_crystal2").attr('data-id');
            var tableName = $("#urine_crystal2").attr('data-tableName');
            var colName = $("#urine_crystal2").attr('data-colName');
            $.post(hosturl + "/controllers/invsdept.php?ac=addnewrecord", {
                selectId: 'urine_crystal2',
                new_name: new_name,
                id: id,
                tableName: tableName,
                colName: colName
            }, function (data) {


                $('#urine_crystal2 > .deleteoptincompo').before('<option value="' + Number(data) + '" >' + new_name + '</option>');
                $('#urine_crystal2').select2('val', Number(data)); // select the new term
                $("#urine_crystal2").select2('close'); // close the dropdown

            });
        });
        $("#urine_crystal").select2({
            placeholder: "Select",
            width: '240px',
            allowClear: true,
            formatNoMatches: function (term) {
                /* customize the no matches output */
                return "<input class='form-control' id='newTerm_urine_crystal' value='" + term + "'><a href='#' id='addNew_urine_crystal' class='btn blue custombtnstyle'>إضافة جديد</a>"
            }
        }).parent().find('.select2-with-searchbox').on('click', '#addNew_urine_crystal', function () {
            /* add the new term */
            var new_name = $('#newTerm_urine_crystal').val();
            var id = $("#urine_crystal").attr('data-id');
            var tableName = $("#urine_crystal").attr('data-tableName');
            var colName = $("#urine_crystal").attr('data-colName');
            $.post(hosturl + "/controllers/invsdept.php?ac=addnewrecord", {
                selectId: 'urine_crystal',
                new_name: new_name,
                id: id,
                tableName: tableName,
                colName: colName
            }, function (data) {


                $('#urine_crystal > .deleteoptincompo').before('<option value="' + Number(data) + '" >' + new_name + '</option>');
                $('#urine_crystal').select2('val', Number(data)); // select the new term
                $("#urine_crystal").select2('close'); // close the dropdown

            });
        });
        $("#urine_bilirubin").select2({
            placeholder: "Select",
            width: '240px',
            allowClear: true,
            formatNoMatches: function (term) {
                /* customize the no matches output */
                return "<input class='form-control' id='newTerm_urine_bilirubin' value='" + term + "'><a href='#' id='addNew_urine_bilirubin' class='btn blue custombtnstyle'>إضافة جديد</a>"
            }
        }).parent().find('.select2-with-searchbox').on('click', '#addNew_urine_bilirubin', function () {
            /* add the new term */
            var new_name = $('#newTerm_urine_bilirubin').val();
            var id = $("#urine_bilirubin").attr('data-id');
            var tableName = $("#urine_bilirubin").attr('data-tableName');
            var colName = $("#urine_bilirubin").attr('data-colName');
            $.post(hosturl + "/controllers/invsdept.php?ac=addnewrecord", {
                selectId: 'urine_bilirubin',
                new_name: new_name,
                id: id,
                tableName: tableName,
                colName: colName
            }, function (data) {


                $('#urine_bilirubin > .deleteoptincompo').before('<option value="' + Number(data) + '" >' + new_name + '</option>');
                $('#urine_bilirubin').select2('val', Number(data)); // select the new term
                $("#urine_bilirubin").select2('close'); // close the dropdown

            });
        });
        $("#urine_amorphous").select2({
            placeholder: "Select",
            width: '240px',
            allowClear: true,
            formatNoMatches: function (term) {
                /* customize the no matches output */
                return "<input class='form-control' id='newTerm_urine_amorphous' value='" + term + "'><a href='#' id='addNew_urine_amorphous' class='btn blue custombtnstyle'>إضافة جديد</a>"
            }
        }).parent().find('.select2-with-searchbox').on('click', '#addNew_urine_amorphous', function () {
            /* add the new term */
            var new_name = $('#newTerm_urine_amorphous').val();
            var id = $("#urine_amorphous").attr('data-id');
            var tableName = $("#urine_amorphous").attr('data-tableName');
            var colName = $("#urine_amorphous").attr('data-colName');
            $.post(hosturl + "/controllers/invsdept.php?ac=addnewrecord", {
                selectId: 'urine_amorphous',
                new_name: new_name,
                id: id,
                tableName: tableName,
                colName: colName
            }, function (data) {


                $('#urine_amorphous > .deleteoptincompo').before('<option value="' + Number(data) + '" >' + new_name + '</option>');
                $('#urine_amorphous').select2('val', Number(data)); // select the new term
                $("#urine_amorphous").select2('close'); // close the dropdown

            });
        });
    };

    var stoolInvest = function () {

        $("#stool_color").select2({
            placeholder: "Select",
            width: '240px',
            allowClear: true,
            formatNoMatches: function (term) {
                /* customize the no matches output */
                return "<input class='form-control' id='newTerm_stool_color' value='" + term + "'><a href='#' id='addNew_stool_color' class='btn blue custombtnstyle'>إضافة جديد</a>"
            }
        }).parent().find('.select2-with-searchbox').on('click', '#addNew_stool_color', function () {
            /* add the new term */
            var new_name = $('#newTerm_stool_color').val();
            var id = $("#stool_color").attr('data-id');
            var tableName = $("#stool_color").attr('data-tableName');
            var colName = $("#stool_color").attr('data-colName');
            $.post(hosturl + "/controllers/invsdept.php?ac=addnewrecord", {
                selectId: 'stool_color',
                new_name: new_name,
                id: id,
                tableName: tableName,
                colName: colName
            }, function (data) {


                $('#stool_color > .deleteoptincompo').before('<option value="' + Number(data) + '" >' + new_name + '</option>');
                $('#stool_color').select2('val', Number(data)); // select the new term
                $("#stool_color").select2('close'); // close the dropdown

            });
        });
        $("#stool_blood").select2({
            placeholder: "Select",
            width: '240px',
            allowClear: true,
            formatNoMatches: function (term) {
                /* customize the no matches output */
                return "<input class='form-control' id='newTerm_stool_blood' value='" + term + "'><a href='#' id='addNew_stool_blood' class='btn blue custombtnstyle'>إضافة جديد</a>"
            }
        }).parent().find('.select2-with-searchbox').on('click', '#addNew_stool_blood', function () {
            /* add the new term */
            var new_name = $('#newTerm_stool_blood').val();
            var id = $("#stool_blood").attr('data-id');
            var tableName = $("#stool_blood").attr('data-tableName');
            var colName = $("#stool_blood").attr('data-colName');
            $.post(hosturl + "/controllers/invsdept.php?ac=addnewrecord", {
                selectId: 'stool_blood',
                new_name: new_name,
                id: id,
                tableName: tableName,
                colName: colName
            }, function (data) {


                $('#stool_blood > .deleteoptincompo').before('<option value="' + Number(data) + '" >' + new_name + '</option>');
                $('#stool_blood').select2('val', Number(data)); // select the new term
                $("#stool_blood").select2('close'); // close the dropdown

            });
        });
        $("#stool_ciliate").select2({
            placeholder: "Select",
            width: '240px',
            allowClear: true,
            formatNoMatches: function (term) {
                /* customize the no matches output */
                return "<input class='form-control' id='newTerm_stool_ciliate' value='" + term + "'><a href='#' id='addNew_stool_ciliate' class='btn blue custombtnstyle'>إضافة جديد</a>"
            }
        }).parent().find('.select2-with-searchbox').on('click', '#addNew_stool_ciliate', function () {
            /* add the new term */
            var new_name = $('#newTerm_stool_ciliate').val();
            var id = $("#stool_ciliate").attr('data-id');
            var tableName = $("#stool_ciliate").attr('data-tableName');
            var colName = $("#stool_ciliate").attr('data-colName');
            $.post(hosturl + "/controllers/invsdept.php?ac=addnewrecord", {
                selectId: 'stool_ciliate',
                new_name: new_name,
                id: id,
                tableName: tableName,
                colName: colName
            }, function (data) {


                $('#stool_ciliate > .deleteoptincompo').before('<option value="' + Number(data) + '" >' + new_name + '</option>');
                $('#stool_ciliate').select2('val', Number(data)); // select the new term
                $("#stool_ciliate").select2('close'); // close the dropdown

            });
        });
        $("#stool_consistency").select2({
            placeholder: "Select",
            width: '240px',
            allowClear: true,
            formatNoMatches: function (term) {
                /* customize the no matches output */
                return "<input class='form-control' id='newTerm_stool_consistency' value='" + term + "'><a href='#' id='addNew_stool_consistency' class='btn blue custombtnstyle'>إضافة جديد</a>"
            }
        }).parent().find('.select2-with-searchbox').on('click', '#addNew_stool_consistency', function () {
            /* add the new term */
            var new_name = $('#newTerm_stool_consistency').val();
            var id = $("#stool_consistency").attr('data-id');
            var tableName = $("#stool_consistency").attr('data-tableName');
            var colName = $("#stool_consistency").attr('data-colName');
            $.post(hosturl + "/controllers/invsdept.php?ac=addnewrecord", {
                selectId: 'stool_consistency',
                new_name: new_name,
                id: id,
                tableName: tableName,
                colName: colName
            }, function (data) {


                $('#stool_consistency > .deleteoptincompo').before('<option value="' + Number(data) + '" >' + new_name + '</option>');
                $('#stool_consistency').select2('val', Number(data)); // select the new term
                $("#stool_consistency").select2('close'); // close the dropdown

            });
        });
        $("#stool_cysts").select2({
            placeholder: "Select",
            width: '240px',
            allowClear: true,
            formatNoMatches: function (term) {
                /* customize the no matches output */
                return "<input class='form-control' id='newTerm_stool_cysts' value='" + term + "'><a href='#' id='addNew_stool_cysts' class='btn blue custombtnstyle'>إضافة جديد</a>"
            }
        }).parent().find('.select2-with-searchbox').on('click', '#addNew_stool_cysts', function () {
            /* add the new term */
            var new_name = $('#newTerm_stool_cysts').val();
            var id = $("#stool_cysts").attr('data-id');
            var tableName = $("#stool_cysts").attr('data-tableName');
            var colName = $("#stool_cysts").attr('data-colName');
            $.post(hosturl + "/controllers/invsdept.php?ac=addnewrecord", {
                selectId: 'stool_cysts',
                new_name: new_name,
                id: id,
                tableName: tableName,
                colName: colName
            }, function (data) {


                $('#stool_cysts > .deleteoptincompo').before('<option value="' + Number(data) + '" >' + new_name + '</option>');
                $('#stool_cysts').select2('val', Number(data)); // select the new term
                $("#stool_cysts").select2('close'); // close the dropdown

            });
        });
        $("#stool_flagellates").select2({
            placeholder: "Select",
            width: '240px',
            allowClear: true,
            formatNoMatches: function (term) {
                /* customize the no matches output */
                return "<input class='form-control' id='newTerm_stool_flagellates' value='" + term + "'><a href='#' id='addNew_stool_flagellates' class='btn blue custombtnstyle'>إضافة جديد</a>"
            }
        }).parent().find('.select2-with-searchbox').on('click', '#addNew_stool_flagellates', function () {
            /* add the new term */
            var new_name = $('#newTerm_stool_flagellates').val();
            var id = $("#stool_flagellates").attr('data-id');
            var tableName = $("#stool_flagellates").attr('data-tableName');
            var colName = $("#stool_flagellates").attr('data-colName');
            $.post(hosturl + "/controllers/invsdept.php?ac=addnewrecord", {
                selectId: 'stool_flagellates',
                new_name: new_name,
                id: id,
                tableName: tableName,
                colName: colName
            }, function (data) {


                $('#stool_flagellates > .deleteoptincompo').before('<option value="' + Number(data) + '" >' + new_name + '</option>');
                $('#stool_flagellates').select2('val', Number(data)); // select the new term
                $("#stool_flagellates").select2('close'); // close the dropdown

            });
        });
        $("#stool_parasitology").select2({
            placeholder: "Select",
            width: '240px',
            allowClear: true,
            formatNoMatches: function (term) {
                /* customize the no matches output */
                return "<input class='form-control' id='newTerm_stool_parasitology' value='" + term + "'><a href='#' id='addNew_stool_parasitology' class='btn blue custombtnstyle'>إضافة جديد</a>"
            }
        }).parent().find('.select2-with-searchbox').on('click', '#addNew_stool_parasitology', function () {
            /* add the new term */
            var new_name = $('#newTerm_stool_parasitology').val();
            var id = $("#stool_parasitology").attr('data-id');
            var tableName = $("#stool_parasitology").attr('data-tableName');
            var colName = $("#stool_parasitology").attr('data-colName');
            $.post(hosturl + "/controllers/invsdept.php?ac=addnewrecord", {
                selectId: 'stool_parasitology',
                new_name: new_name,
                id: id,
                tableName: tableName,
                colName: colName
            }, function (data) {


                $('#stool_parasitology > .deleteoptincompo').before('<option value="' + Number(data) + '" >' + new_name + '</option>');
                $('#stool_parasitology').select2('val', Number(data)); // select the new term
                $("#stool_parasitology").select2('close'); // close the dropdown

            });
        });
        $("#stool_larva").select2({
            placeholder: "Select",
            width: '240px',
            allowClear: true,
            formatNoMatches: function (term) {
                /* customize the no matches output */
                return "<input class='form-control' id='newTerm_stool_larva' value='" + term + "'><a href='#' id='addNew_stool_larva' class='btn blue custombtnstyle'>إضافة جديد</a>"
            }
        }).parent().find('.select2-with-searchbox').on('click', '#addNew_stool_larva', function () {
            /* add the new term */
            var new_name = $('#newTerm_stool_larva').val();
            var id = $("#stool_larva").attr('data-id');
            var tableName = $("#stool_larva").attr('data-tableName');
            var colName = $("#stool_larva").attr('data-colName');
            $.post(hosturl + "/controllers/invsdept.php?ac=addnewrecord", {
                selectId: 'stool_larva',
                new_name: new_name,
                id: id,
                tableName: tableName,
                colName: colName
            }, function (data) {


                $('#stool_larva > .deleteoptincompo').before('<option value="' + Number(data) + '" >' + new_name + '</option>');
                $('#stool_larva').select2('val', Number(data)); // select the new term
                $("#stool_larva").select2('close'); // close the dropdown

            });
        });
        $("#stool_odor").select2({
            placeholder: "Select",
            width: '240px',
            allowClear: true,
            formatNoMatches: function (term) {
                /* customize the no matches output */
                return "<input class='form-control' id='newTerm_stool_odor' value='" + term + "'><a href='#' id='addNew_stool_odor' class='btn blue custombtnstyle'>إضافة جديد</a>"
            }
        }).parent().find('.select2-with-searchbox').on('click', '#addNew_stool_odor', function () {
            /* add the new term */
            var new_name = $('#newTerm_stool_odor').val();
            var id = $("#stool_odor").attr('data-id');
            var tableName = $("#stool_odor").attr('data-tableName');
            var colName = $("#stool_odor").attr('data-colName');
            $.post(hosturl + "/controllers/invsdept.php?ac=addnewrecord", {
                selectId: 'stool_odor',
                new_name: new_name,
                id: id,
                tableName: tableName,
                colName: colName
            }, function (data) {


                $('#stool_odor > .deleteoptincompo').before('<option value="' + Number(data) + '" >' + new_name + '</option>');
                $('#stool_odor').select2('val', Number(data)); // select the new term
                $("#stool_odor").select2('close'); // close the dropdown

            });
        });
        $("#stool_mucus").select2({
            placeholder: "Select",
            width: '240px',
            allowClear: true,
            formatNoMatches: function (term) {
                /* customize the no matches output */
                return "<input class='form-control' id='newTerm_stool_mucus' value='" + term + "'><a href='#' id='addNew_stool_mucus' class='btn blue custombtnstyle'>إضافة جديد</a>"
            }
        }).parent().find('.select2-with-searchbox').on('click', '#addNew_stool_mucus', function () {
            /* add the new term */
            var new_name = $('#newTerm_stool_mucus').val();
            var id = $("#stool_mucus").attr('data-id');
            var tableName = $("#stool_mucus").attr('data-tableName');
            var colName = $("#stool_mucus").attr('data-colName');
            $.post(hosturl + "/controllers/invsdept.php?ac=addnewrecord", {
                selectId: 'stool_mucus',
                new_name: new_name,
                id: id,
                tableName: tableName,
                colName: colName
            }, function (data) {


                $('#stool_mucus > .deleteoptincompo').before('<option value="' + Number(data) + '" >' + new_name + '</option>');
                $('#stool_mucus').select2('val', Number(data)); // select the new term
                $("#stool_mucus").select2('close'); // close the dropdown

            });
        });
        $("#stool_reaction").select2({
            placeholder: "Select",
            width: '240px',
            allowClear: true,
            formatNoMatches: function (term) {
                /* customize the no matches output */
                return "<input class='form-control' id='newTerm_stool_reaction' value='" + term + "'><a href='#' id='addNew_stool_reaction' class='btn blue custombtnstyle'>إضافة جديد</a>"
            }
        }).parent().find('.select2-with-searchbox').on('click', '#addNew_stool_reaction', function () {
            /* add the new term */
            var new_name = $('#newTerm_stool_reaction').val();
            var id = $("#stool_reaction").attr('data-id');
            var tableName = $("#stool_reaction").attr('data-tableName');
            var colName = $("#stool_reaction").attr('data-colName');
            $.post(hosturl + "/controllers/invsdept.php?ac=addnewrecord", {
                selectId: 'stool_reaction',
                new_name: new_name,
                id: id,
                tableName: tableName,
                colName: colName
            }, function (data) {


                $('#stool_reaction > .deleteoptincompo').before('<option value="' + Number(data) + '" >' + new_name + '</option>');
                $('#stool_reaction').select2('val', Number(data)); // select the new term
                $("#stool_reaction").select2('close'); // close the dropdown

            });
        });
        $("#stool_trophozoite").select2({
            placeholder: "Select",
            width: '240px',
            allowClear: true,
            formatNoMatches: function (term) {
                /* customize the no matches output */
                return "<input class='form-control' id='newTerm_stool_trophozoite' value='" + term + "'><a href='#' id='addNew_stool_trophozoite' class='btn blue custombtnstyle'>إضافة جديد</a>"
            }
        }).parent().find('.select2-with-searchbox').on('click', '#addNew_stool_trophozoite', function () {
            /* add the new term */
            var new_name = $('#newTerm_stool_trophozoite').val();
            var id = $("#stool_trophozoite").attr('data-id');
            var tableName = $("#stool_trophozoite").attr('data-tableName');
            var colName = $("#stool_trophozoite").attr('data-colName');
            $.post(hosturl + "/controllers/invsdept.php?ac=addnewrecord", {
                selectId: 'stool_trophozoite',
                new_name: new_name,
                id: id,
                tableName: tableName,
                colName: colName
            }, function (data) {


                $('#stool_trophozoite > .deleteoptincompo').before('<option value="' + Number(data) + '" >' + new_name + '</option>');
                $('#stool_trophozoite').select2('val', Number(data)); // select the new term
                $("#stool_trophozoite").select2('close'); // close the dropdown

            });
        });
        $("#stool_undigested").select2({
            placeholder: "Select",
            width: '240px',
            allowClear: true,
            formatNoMatches: function (term) {
                /* customize the no matches output */
                return "<input class='form-control' id='newTerm_stool_undigested' value='" + term + "'><a href='#' id='addNew_stool_undigested' class='btn blue custombtnstyle'>إضافة جديد</a>"
            }
        }).parent().find('.select2-with-searchbox').on('click', '#addNew_stool_undigested', function () {
            /* add the new term */
            var new_name = $('#newTerm_stool_undigested').val();
            var id = $("#stool_undigested").attr('data-id');
            var tableName = $("#stool_undigested").attr('data-tableName');
            var colName = $("#stool_undigested").attr('data-colName');
            $.post(hosturl + "/controllers/invsdept.php?ac=addnewrecord", {
                selectId: 'stool_undigested',
                new_name: new_name,
                id: id,
                tableName: tableName,
                colName: colName
            }, function (data) {


                $('#stool_undigested > .deleteoptincompo').before('<option value="' + Number(data) + '" >' + new_name + '</option>');
                $('#stool_undigested').select2('val', Number(data)); // select the new term
                $("#stool_undigested").select2('close'); // close the dropdown

            });
        });
        $("#stool_ova").select2({
            placeholder: "Select",
            width: '240px',
            allowClear: true,
            formatNoMatches: function (term) {
                /* customize the no matches output */
                return "<input class='form-control' id='newTerm_stool_ova' value='" + term + "'><a href='#' id='addNew_stool_ova' class='btn blue custombtnstyle'>إضافة جديد</a>"
            }
        }).parent().find('.select2-with-searchbox').on('click', '#addNew_stool_ova', function () {
            /* add the new term */
            var new_name = $('#newTerm_stool_ova').val();
            var id = $("#stool_ova").attr('data-id');
            var tableName = $("#stool_ova").attr('data-tableName');
            var colName = $("#stool_ova").attr('data-colName');
            $.post(hosturl + "/controllers/invsdept.php?ac=addnewrecord", {
                selectId: 'stool_ova',
                new_name: new_name,
                id: id,
                tableName: tableName,
                colName: colName
            }, function (data) {


                $('#stool_ova > .deleteoptincompo').before('<option value="' + Number(data) + '" >' + new_name + '</option>');
                $('#stool_ova').select2('val', Number(data)); // select the new term
                $("#stool_ova").select2('close'); // close the dropdown

            });
        });

        $("#stool_food").select2({
            placeholder: "Select",
            width: '240px',
            allowClear: true,
            formatNoMatches: function (term) {
                /* customize the no matches output */
                return "<input class='form-control' id='newTerm_stool_food' value='" + term + "'><a href='#' id='addNew_stool_food' class='btn blue custombtnstyle'>إضافة جديد</a>"
            }
        }).parent().find('.select2-with-searchbox').on('click', '#addNew_stool_food', function () {
            /* add the new term */
            var new_name = $('#newTerm_stool_food').val();
            var id = $("#stool_food").attr('data-id');
            var tableName = $("#stool_food").attr('data-tableName');
            var colName = $("#stool_food").attr('data-colName');
            $.post(hosturl + "/controllers/invsdept.php?ac=addnewrecord", {
                selectId: 'stool_food',
                new_name: new_name,
                id: id,
                tableName: tableName,
                colName: colName
            }, function (data) {


                $('#stool_food > .deleteoptincompo').before('<option value="' + Number(data) + '" >' + new_name + '</option>');
                $('#stool_food').select2('val', Number(data)); // select the new term
                $("#stool_food").select2('close'); // close the dropdown

            });
        });

        $("#stool_prog2").select2({
            placeholder: "Select",
            width: '240px',
            allowClear: true,
            formatNoMatches: function (term) {
                /* customize the no matches output */
                return "<input class='form-control' id='newTerm_stool_prog2' value='" + term + "'><a href='#' id='addNew_stool_prog2' class='btn blue custombtnstyle'>إضافة جديد</a>"
            }
        }).parent().find('.select2-with-searchbox').on('click', '#addNew_stool_prog2', function () {
            /* add the new term */
            var new_name = $('#newTerm_stool_prog2').val();
            var id = $("#stool_prog2").attr('data-id');
            var tableName = $("#stool_prog2").attr('data-tableName');
            var colName = $("#stool_prog2").attr('data-colName');
            $.post(hosturl + "/controllers/invsdept.php?ac=addnewrecord", {
                selectId: 'stool_prog2',
                new_name: new_name,
                id: id,
                tableName: tableName,
                colName: colName
            }, function (data) {


                $('#stool_prog2 > .deleteoptincompo').before('<option value="' + Number(data) + '" >' + new_name + '</option>');
                $('#stool_prog2').select2('val', Number(data)); // select the new term
                $("#stool_prog2").select2('close'); // close the dropdown

            });
        });
        $("#stool_prog").select2({
            placeholder: "Select",
            width: '240px',
            allowClear: true,
            formatNoMatches: function (term) {
                /* customize the no matches output */
                return "<input class='form-control' id='newTerm_stool_prog' value='" + term + "'><a href='#' id='addNew_stool_prog' class='btn blue custombtnstyle'>إضافة جديد</a>"
            }
        }).parent().find('.select2-with-searchbox').on('click', '#addNew_stool_prog', function () {
            /* add the new term */
            var new_name = $('#newTerm_stool_prog').val();
            var id = $("#stool_prog").attr('data-id');
            var tableName = $("#stool_prog").attr('data-tableName');
            var colName = $("#stool_prog").attr('data-colName');
            $.post(hosturl + "/controllers/invsdept.php?ac=addnewrecord", {
                selectId: 'stool_prog',
                new_name: new_name,
                id: id,
                tableName: tableName,
                colName: colName
            }, function (data) {


                $('#stool_prog > .deleteoptincompo').before('<option value="' + Number(data) + '" >' + new_name + '</option>');
                $('#stool_prog').select2('val', Number(data)); // select the new term
                $("#stool_prog").select2('close'); // close the dropdown

            });
        });
        $("#stool_trophozoite2").select2({
            placeholder: "Select",
            width: '240px',
            allowClear: true,
            formatNoMatches: function (term) {
                /* customize the no matches output */
                return "<input class='form-control' id='newTerm_stool_trophozoite2' value='" + term + "'><a href='#' id='addNew_stool_trophozoite2' class='btn blue custombtnstyle'>إضافة جديد</a>"
            }
        }).parent().find('.select2-with-searchbox').on('click', '#addNew_stool_trophozoite2', function () {
            /* add the new term */
            var new_name = $('#newTerm_stool_trophozoite2').val();
            var id = $("#stool_trophozoite2").attr('data-id');
            var tableName = $("#stool_trophozoite2").attr('data-tableName');
            var colName = $("#stool_trophozoite2").attr('data-colName');
            $.post(hosturl + "/controllers/invsdept.php?ac=addnewrecord", {
                selectId: 'stool_trophozoite2',
                new_name: new_name,
                id: id,
                tableName: tableName,
                colName: colName
            }, function (data) {


                $('#stool_trophozoite2 > .deleteoptincompo').before('<option value="' + Number(data) + '" >' + new_name + '</option>');
                $('#stool_trophozoite2').select2('val', Number(data)); // select the new term
                $("#stool_trophozoite2").select2('close'); // close the dropdown

            });
        });
        $("#stool_trophozoite3").select2({
            placeholder: "Select",
            width: '240px',
            allowClear: true,
            formatNoMatches: function (term) {
                /* customize the no matches output */
                return "<input class='form-control' id='newTerm_stool_trophozoite3' value='" + term + "'><a href='#' id='addNew_stool_trophozoite3' class='btn blue custombtnstyle'>إضافة جديد</a>"
            }
        }).parent().find('.select2-with-searchbox').on('click', '#addNew_stool_trophozoite3', function () {
            /* add the new term */
            var new_name = $('#newTerm_stool_trophozoite3').val();
            var id = $("#stool_trophozoite3").attr('data-id');
            var tableName = $("#stool_trophozoite3").attr('data-tableName');
            var colName = $("#stool_trophozoite3").attr('data-colName');
            $.post(hosturl + "/controllers/invsdept.php?ac=addnewrecord", {
                selectId: 'stool_trophozoite3',
                new_name: new_name,
                id: id,
                tableName: tableName,
                colName: colName
            }, function (data) {


                $('#stool_trophozoite3 > .deleteoptincompo').before('<option value="' + Number(data) + '" >' + new_name + '</option>');
                $('#stool_trophozoite3').select2('val', Number(data)); // select the new term
                $("#stool_trophozoite3").select2('close'); // close the dropdown

            });
        });
        $("#stool_flagellates2").select2({
            placeholder: "Select",
            width: '240px',
            allowClear: true,
            formatNoMatches: function (term) {
                /* customize the no matches output */
                return "<input class='form-control' id='newTerm_stool_flagellates2' value='" + term + "'><a href='#' id='addNew_stool_flagellates2' class='btn blue custombtnstyle'>إضافة جديد</a>"
            }
        }).parent().find('.select2-with-searchbox').on('click', '#addNew_stool_flagellates2', function () {
            /* add the new term */
            var new_name = $('#newTerm_stool_flagellates2').val();
            var id = $("#stool_flagellates2").attr('data-id');
            var tableName = $("#stool_flagellates2").attr('data-tableName');
            var colName = $("#stool_flagellates2").attr('data-colName');
            $.post(hosturl + "/controllers/invsdept.php?ac=addnewrecord", {
                selectId: 'stool_flagellates2',
                new_name: new_name,
                id: id,
                tableName: tableName,
                colName: colName
            }, function (data) {


                $('#stool_flagellates2 > .deleteoptincompo').before('<option value="' + Number(data) + '" >' + new_name + '</option>');
                $('#stool_flagellates2').select2('val', Number(data)); // select the new term
                $("#stool_flagellates2").select2('close'); // close the dropdown

            });
        });
        $("#stool_undigested2").select2({
            placeholder: "Select",
            width: '240px',
            allowClear: true,
            formatNoMatches: function (term) {
                /* customize the no matches output */
                return "<input class='form-control' id='newTerm_stool_undigested2' value='" + term + "'><a href='#' id='addNew_stool_undigested2' class='btn blue custombtnstyle'>إضافة جديد</a>"
            }
        }).parent().find('.select2-with-searchbox').on('click', '#addNew_stool_undigested2', function () {
            /* add the new term */
            var new_name = $('#newTerm_stool_undigested2').val();
            var id = $("#stool_undigested2").attr('data-id');
            var tableName = $("#stool_undigested2").attr('data-tableName');
            var colName = $("#stool_undigested2").attr('data-colName');
            $.post(hosturl + "/controllers/invsdept.php?ac=addnewrecord", {
                selectId: 'stool_undigested2',
                new_name: new_name,
                id: id,
                tableName: tableName,
                colName: colName
            }, function (data) {


                $('#stool_undigested2 > .deleteoptincompo').before('<option value="' + Number(data) + '" >' + new_name + '</option>');
                $('#stool_undigested2').select2('val', Number(data)); // select the new term
                $("#stool_undigested2").select2('close'); // close the dropdown

            });
        });
        $("#stool_cysts2").select2({
            placeholder: "Select",
            width: '240px',
            allowClear: true,
            formatNoMatches: function (term) {
                /* customize the no matches output */
                return "<input class='form-control' id='newTerm_stool_cysts2' value='" + term + "'><a href='#' id='addNew_stool_cysts2' class='btn blue custombtnstyle'>إضافة جديد</a>"
            }
        }).parent().find('.select2-with-searchbox').on('click', '#addNew_stool_cysts2', function () {
            /* add the new term */
            var new_name = $('#newTerm_stool_cysts2').val();
            var id = $("#stool_cysts2").attr('data-id');
            var tableName = $("#stool_cysts2").attr('data-tableName');
            var colName = $("#stool_cysts2").attr('data-colName');
            $.post(hosturl + "/controllers/invsdept.php?ac=addnewrecord", {
                selectId: 'stool_cysts2',
                new_name: new_name,
                id: id,
                tableName: tableName,
                colName: colName
            }, function (data) {


                $('#stool_cysts2 > .deleteoptincompo').before('<option value="' + Number(data) + '" >' + new_name + '</option>');
                $('#stool_cysts2').select2('val', Number(data)); // select the new term
                $("#stool_cysts2").select2('close'); // close the dropdown

            });
        });
        $("#stool_undigested3").select2({
            placeholder: "Select",
            width: '240px',
            allowClear: true,
            formatNoMatches: function (term) {
                /* customize the no matches output */
                return "<input class='form-control' id='newTerm_stool_undigested3' value='" + term + "'><a href='#' id='addNew_stool_undigested3' class='btn blue custombtnstyle'>إضافة جديد</a>"
            }
        }).parent().find('.select2-with-searchbox').on('click', '#addNew_stool_undigested3', function () {
            /* add the new term */
            var new_name = $('#newTerm_stool_undigested3').val();
            var id = $("#stool_undigested3").attr('data-id');
            var tableName = $("#stool_undigested3").attr('data-tableName');
            var colName = $("#stool_undigested3").attr('data-colName');
            $.post(hosturl + "/controllers/invsdept.php?ac=addnewrecord", {
                selectId: 'stool_undigested3',
                new_name: new_name,
                id: id,
                tableName: tableName,
                colName: colName
            }, function (data) {


                $('#stool_undigested3 > .deleteoptincompo').before('<option value="' + Number(data) + '" >' + new_name + '</option>');
                $('#stool_undigested3').select2('val', Number(data)); // select the new term
                $("#stool_undigested3").select2('close'); // close the dropdown

            });
        });
        $("#stool_ova2").select2({
            placeholder: "Select",
            width: '240px',
            allowClear: true,
            formatNoMatches: function (term) {
                /* customize the no matches output */
                return "<input class='form-control' id='newTerm_stool_ova2' value='" + term + "'><a href='#' id='addNew_stool_ova2' class='btn blue custombtnstyle'>إضافة جديد</a>"
            }
        }).parent().find('.select2-with-searchbox').on('click', '#addNew_stool_ova2', function () {
            /* add the new term */
            var new_name = $('#newTerm_stool_ova2').val();
            var id = $("#stool_ova2").attr('data-id');
            var tableName = $("#stool_ova2").attr('data-tableName');
            var colName = $("#stool_ova2").attr('data-colName');
            $.post(hosturl + "/controllers/invsdept.php?ac=addnewrecord", {
                selectId: 'stool_ova2',
                new_name: new_name,
                id: id,
                tableName: tableName,
                colName: colName
            }, function (data) {


                $('#stool_ova2 > .deleteoptincompo').before('<option value="' + Number(data) + '" >' + new_name + '</option>');
                $('#stool_ova2').select2('val', Number(data)); // select the new term
                $("#stool_ova2").select2('close'); // close the dropdown

            });
        });
        $("#stool_parasitology2").select2({
            placeholder: "Select",
            width: '240px',
            allowClear: true,
            formatNoMatches: function (term) {
                /* customize the no matches output */
                return "<input class='form-control' id='newTerm_stool_parasitology2' value='" + term + "'><a href='#' id='addNew_stool_parasitology2' class='btn blue custombtnstyle'>إضافة جديد</a>"
            }
        }).parent().find('.select2-with-searchbox').on('click', '#addNew_stool_parasitology2', function () {
            /* add the new term */
            var new_name = $('#newTerm_stool_parasitology2').val();
            var id = $("#stool_parasitology2").attr('data-id');
            var tableName = $("#stool_parasitology2").attr('data-tableName');
            var colName = $("#stool_parasitology2").attr('data-colName');
            $.post(hosturl + "/controllers/invsdept.php?ac=addnewrecord", {
                selectId: 'stool_parasitology2',
                new_name: new_name,
                id: id,
                tableName: tableName,
                colName: colName
            }, function (data) {


                $('#stool_parasitology2 > .deleteoptincompo').before('<option value="' + Number(data) + '" >' + new_name + '</option>');
                $('#stool_parasitology2').select2('val', Number(data)); // select the new term
                $("#stool_parasitology2").select2('close'); // close the dropdown

            });
        });
        $("#stool_larva2").select2({
            placeholder: "Select",
            width: '240px',
            allowClear: true,
            formatNoMatches: function (term) {
                /* customize the no matches output */
                return "<input class='form-control' id='newTerm_stool_larva2' value='" + term + "'><a href='#' id='addNew_stool_larva2' class='btn blue custombtnstyle'>إضافة جديد</a>"
            }
        }).parent().find('.select2-with-searchbox').on('click', '#addNew_stool_larva2', function () {
            /* add the new term */
            var new_name = $('#newTerm_stool_larva2').val();
            var id = $("#stool_larva2").attr('data-id');
            var tableName = $("#stool_larva2").attr('data-tableName');
            var colName = $("#stool_larva2").attr('data-colName');
            $.post(hosturl + "/controllers/invsdept.php?ac=addnewrecord", {
                selectId: 'stool_larva2',
                new_name: new_name,
                id: id,
                tableName: tableName,
                colName: colName
            }, function (data) {


                $('#stool_larva2 > .deleteoptincompo').before('<option value="' + Number(data) + '" >' + new_name + '</option>');
                $('#stool_larva2').select2('val', Number(data)); // select the new term
                $("#stool_larva2").select2('close'); // close the dropdown

            });
        });
        $("#stool_undigested4").select2({
            placeholder: "Select",
            width: '240px',
            allowClear: true,
            formatNoMatches: function (term) {
                /* customize the no matches output */
                return "<input class='form-control' id='newTerm_stool_undigested4' value='" + term + "'><a href='#' id='addNew_stool_undigested4' class='btn blue custombtnstyle'>إضافة جديد</a>"
            }
        }).parent().find('.select2-with-searchbox').on('click', '#addNew_stool_undigested4', function () {
            /* add the new term */
            var new_name = $('#newTerm_stool_undigested4').val();
            var id = $("#stool_undigested4").attr('data-id');
            var tableName = $("#stool_undigested4").attr('data-tableName');
            var colName = $("#stool_undigested4").attr('data-colName');
            $.post(hosturl + "/controllers/invsdept.php?ac=addnewrecord", {
                selectId: 'stool_undigested4',
                new_name: new_name,
                id: id,
                tableName: tableName,
                colName: colName
            }, function (data) {


                $('#stool_undigested4 > .deleteoptincompo').before('<option value="' + Number(data) + '" >' + new_name + '</option>');
                $('#stool_undigested4').select2('val', Number(data)); // select the new term
                $("#stool_undigested4").select2('close'); // close the dropdown

            });
        });
    };

    var bPictureInvest = function () {

        var all_levels = ['hgb_blood', 'rbc_blood', 'hct_blood', 'rdw_blood', 'wbc_blood'
                    , 'neutrophil_r_blood', 'segmented_blood', 'band_blood', 'lymphocytes_r_blood', 'monocytes_r_blood'
                    , 'eosinophils_r_blood', 'basophils_r_blood', 'plt_blood'];


        $('body').on('change', '.blood', function () {

            var element = $(this).attr('data-target');
            var value = $('#' + element + '_blood').val();
            var rangeid = $('#' + element + '_rangeid').val();
            var bloodId = $(this).attr('data-id');
            $.post(hosturl + '/controllers/invsdept.php?ac=invlevel', {
                value: value,
                rangeid: rangeid,
                element: element,
                bloodId: bloodId
            }, function (res) {

                var obj = res.split("-");
                $('#' + element + '_level').val(obj[0]);
                $('#' + element + '_unit').val(obj[1]);
            });
        });
        $('body').on('change', '.bloodCalc', function () {

            var hgb = $('#hgb_blood').val();
            var rbc = $('#rbc_blood').val();
            var hct = $('#hct_blood').val();
            var bloodId = $(this).attr('data-id');
            var mcvCalc = mcv_calc(hct, rbc);
            var mchCalc = mch_calc(hgb, rbc);
            var mchcCalc = mchc_calc(hct, hgb);
            $('#mcv_calc').val(mcvCalc);
            $('#mch_calc').val(mchCalc);
            $('#mchc_calc').val(mchcCalc);
            if (bloodId > 0) {
                var data = [['mcv_calc', mcvCalc], ['mch_calc', mchCalc], ['mchc_calc', mchcCalc]];
                updateArray(bloodId, 'investigationresults_blood', data);
            }
        });
        function mchc_calc(hct, hgb) {
            var res = '';
            if (hct > 0 && hgb >= 0) {
                res = (100 * hgb) / hct;
                res = Math.round(res * 10) / 10;
            }
            return res;
        }

        function mch_calc(hgb, rbc) {
            var res = '';
            if (rbc > 0 && hgb >= 0) {
                res = (10 * hgb) / rbc;
                res = Math.round(res * 10) / 10;
            }
            return res;
        }

        function mcv_calc(hct, rbc) {
            var res = '';
            if (rbc > 0 && hct >= 0) {
                res = (10 * hct) / rbc;
                res = Math.round(res * 10) / 10;
            }

            return res;
        }

        $('body').on('change', '.absCalc', function () {

            var colName = $(this).attr("data-colName");
            var element = $(this).attr('data-target');
            var value = $(this).val();
            var bloodId = $(this).attr('data-id');
            var wbc = $('#wbc_blood').val();
            var elem = $(this);
            var absCalc = abs_calc(wbc, value);
            $('#' + element + '_blood').val(absCalc);
            if (bloodId > 0) {
                checkRange(bloodId, colName, 'investigationresults_blood', value, elem, '');
                var data = [[colName, value], [element, absCalc]];
                updateArray(bloodId, 'investigationresults_blood', data);
            }


        });
        function abs_calc(wbc, value) {
            var res = '';
            if (wbc >= 0 && value >= 0) {
                res = (value * wbc) / 100;
                res = Math.round(res * 100) / 100;
            }

            return res;
        }

        $('body').on('change', '.absCalcAllPreview ,  .absCalcAll', function () {
            var bloodId = $(this).attr('data-id');
            var wbc = $('#wbc_blood').val();
            absCalcAll(wbc, bloodId);
        });
        $('body').on('change', '.cells_calc', function () {
            var elementId = $(this).attr('id');
            var colName = $(this).attr("data-colName");
            var tableName = $(this).attr("data-tableName");
            var id = $(this).attr("data-id");
            var sum = checkSum();
            var diff;
            if (sum > 100) {
                $('#' + elementId).val(0);
                updateOne(id, colName, tableName, 0);
                sum = checkSum();
            }

            diff = 100 - sum;
            diff = Math.round(diff * 100) / 100;
            $('#othercells_blood').val(diff);
            var bloodId = $('#wbc_blood').attr('data-id');
            var wbc = $('#wbc_blood').val();
            //     absCalcAll(wbc, bloodId);

            updateOne($('#othercells_blood').attr('data-id'), $('#othercells_blood').attr('data-colName')
                    , $('#othercells_blood').attr('data-tableName'), diff);
        });
        $('body').on('change', '#neutrophil_r_blood , #segmented_blood , #band_blood', function () {
            var elementId = $(this).attr('id');
            var neutrophil_r = Number($('#neutrophil_r_blood').val());
            var id = $(this).attr("data-id");
            switch (elementId) {
                case 'neutrophil_r_blood':
                    var segmented = neutrophil_r - 2;
                    var band = 2;
                    $('#segmented_blood').val(segmented);
                    $('#band_blood').val(band);
                    break;
                case 'segmented_blood':
                    var segmented = Number($('#segmented_blood').val());
                    var band = neutrophil_r - segmented;
                    $('#band_blood').val(band);
                    break;
                case 'band_blood':
                    var band = Number($('#band_blood').val());
                    var segmented = neutrophil_r - band;
                    $('#segmented_blood').val(segmented);
                    break;
            }

            if (id > 0) {
                var data = [[$('#band_blood').attr('data-colName'), band], [$('#segmented_blood').attr('data-colName'), segmented]];
                updateArray(id, $('#band_blood').attr('data-tableName'), data);
            }
        });
        $('body').on('keydown', 'input', function (e) {
            if (e.keyCode == 13) {

                if (cbcDirection == 1) {
                    var level = Number($(this).attr("data-level"));
                } else {
                    var level = Number($(this).attr("data-level_d"));
                }


                if (level == 13) {
                    cbcDirection = 2;
                    level = 11;
                }

                if (level == 0 && cbcDirection == 2) {
                    cbcDirection = 1;
                    level = 0;
                }




                if (level >= 0 && level < 13) {
                    var new_id = all_levels[level];
                    $('#' + new_id).focus();
                    $('#' + new_id).select();
                }
            }
        });
        function checkSum() {
            var neutrophil_r_blood = Number($('#neutrophil_r_blood').val());
            var lymphocytes_r_blood = Number($('#lymphocytes_r_blood').val());
            var monocytes_r_blood = Number($('#monocytes_r_blood').val());
            var eosinophils_r_blood = Number($('#eosinophils_r_blood').val());
            var basophils_r_blood = Number($('#basophils_r_blood').val());
            var sum = neutrophil_r_blood + lymphocytes_r_blood + monocytes_r_blood
                    + eosinophils_r_blood + basophils_r_blood;
            return sum;
        }

        function absCalcAll(wbc, bloodId) {
            var inputs = ["neutrophil", "lymphocytes", "monocytes", "eosinophils", "basophils"];
            var nameR = '';
            var nameAbs = '';
            var value = '';
            var absCalc = '';
            var one;
            var data = [];
            for (var i = 0; i < inputs.length; i++) {
                nameR = inputs[i] + '_r_blood';
                nameAbs = inputs[i] + '_abs_blood';
                value = $('#' + nameR).val();
                absCalc = abs_calc(wbc, value);
                $('#' + nameAbs).val(absCalc);
                one = [inputs[i] + '_abs', absCalc];
                data[i] = one;
            }

            if (bloodId > 0) {
                updateArray(bloodId, 'investigationresults_blood', data);
            }
        }

    };

    var esrInvest = function () {

        $("#esr_hour1").select2({
            placeholder: "Select",
            width: '240px',
            allowClear: true,
            formatNoMatches: function (term) {
                /* customize the no matches output */
                return "<input class='form-control' id='newTerm_esr_hour1' value='" + term + "'><a href='#' id='addNew_esr_hour1' class='btn blue custombtnstyle'>إضافة جديد</a>"
            }
        }).parent().find('.select2-with-searchbox').on('click', '#addNew_esr_hour1', function () {
            /* add the new term */
            var new_name = $('#newTerm_esr_hour1').val();
            var id = $("#esr_hour1").attr('data-id');
            var tableName = $("#esr_hour1").attr('data-tableName');
            var colName = $("#esr_hour1").attr('data-colName');
            $.post(hosturl + "/controllers/invsdept.php?ac=addnewrecord", {
                selectId: 'esr_hour1',
                new_name: new_name,
                id: id,
                tableName: tableName,
                colName: colName
            }, function (data) {


                $('#esr_hour1 > .deleteoptincompo').before('<option value="' + Number(data) + '" >' + new_name + '</option>');
                $('#esr_hour1').select2('val', Number(data)); // select the new term
                $("#esr_hour1").select2('close'); // close the dropdown

            });
        });

        $("#esr_hour2").select2({
            placeholder: "Select",
            width: '240px',
            allowClear: true,
            formatNoMatches: function (term) {
                /* customize the no matches output */
                return "<input class='form-control' id='newTerm_esr_hour2' value='" + term + "'><a href='#' id='addNew_esr_hour2' class='btn blue custombtnstyle'>إضافة جديد</a>"
            }
        }).parent().find('.select2-with-searchbox').on('click', '#addNew_esr_hour2', function () {
            /* add the new term */
            var new_name = $('#newTerm_esr_hour2').val();
            var id = $("#esr_hour2").attr('data-id');
            var tableName = $("#esr_hour2").attr('data-tableName');
            var colName = $("#esr_hour2").attr('data-colName');
            $.post(hosturl + "/controllers/invsdept.php?ac=addnewrecord", {
                selectId: 'esr_hour2',
                new_name: new_name,
                id: id,
                tableName: tableName,
                colName: colName
            }, function (data) {


                $('#esr_hour2 > .deleteoptincompo').before('<option value="' + Number(data) + '" >' + new_name + '</option>');
                $('#esr_hour2').select2('val', Number(data)); // select the new term
                $("#esr_hour2").select2('close'); // close the dropdown

            });
        });

        $('body').on('change', '.esr', function () {
            var element = $(this).attr('data-target');
            var hour = $('#esr_' + element).val();
            var rangeid = $('#' + element + '_rangeid').val();
            $.post(hosturl + '/controllers/invsdept.php?ac=esrchange', {
                hour: hour,
                rangeid: rangeid,
                element: element
            }, function (res) {

                var obj = res.split("-");
                $('#' + element + '_unit').val(obj[0]);
                $('#' + element + '_level').val(obj[1]);
            });
        });
    };

    var cultureInvest = function () {
        $(".culture_sample").select2({
            width: '240px',
            allowClear: true,
            formatNoMatches: function (term) {
                /* customize the no matches output */
                var elemId = $(this).attr("id");
                var id = $(this).attr("data-id");
                return "<input class='form-control' id='newculture_sampleTerm' value='" + term + "'>\n\
                               <a href='#' id='addNewculture_sampleRow' data-elemId='" + elemId + "'  data-id='" + id + "'   \n\
                                  class='btn blue custombtnstyle'>ADD</a>"
            }
        }).parent().find('.select2-with-searchbox').on('click', '#addNewculture_sampleRow', function () {
            /* add the new term */
            var newTerm = $('#newculture_sampleTerm').val();
            var id = $(this).attr("data-id");
            var elemId = $(this).attr("data-elemId");
            $.post(hosturl + "/controllers/invsdept.php?ac=addnewrecord", {
                selectId: 'culture_sample', new_name: newTerm, id: id,
                tableName: $('#' + elemId + '').attr('data-tableName'),
                colName: $('#' + elemId + '').attr('data-colName')
            }, function (data) {

                $('.culture_sample > .deleteoptincompo').before('<option value="' + Number(data) + '" >' + newTerm + '</option>');
                $('#' + elemId + '').select2('val', Number(data)); // select the new term
                $('.culture_sample').select2('close'); // close the dropdown
            });
        });

        $(".culture_organism_a").select2({
            width: '240px',
            allowClear: true,
            formatNoMatches: function (term) {
                /* customize the no matches output */
                var elemId = $(this).attr("id");
                var id = $(this).attr("data-id");
                return "<input class='form-control' id='newculture_organism_aTerm' value='" + term + "'>\n\
                               <a href='#' id='addNewculture_organism_aRow' data-elemId='" + elemId + "'  data-id='" + id + "'   \n\
                                  class='btn blue custombtnstyle'>ADD</a>"
            }
        }).parent().find('.select2-with-searchbox').on('click', '#addNewculture_organism_aRow', function () {
            /* add the new term */
            var newTerm = $('#newculture_organism_aTerm').val();
            var id = $(this).attr("data-id");
            var elemId = $(this).attr("data-elemId");
            $.post(hosturl + "/controllers/invsdept.php?ac=addnewrecord", {
                selectId: 'culture_organism_a', new_name: newTerm, id: id,
                tableName: $('#' + elemId + '').attr('data-tableName'),
                colName: $('#' + elemId + '').attr('data-colName')
            }, function (data) {

                $('.culture_organism_a > .deleteoptincompo').before('<option value="' + Number(data) + '" >' + newTerm + '</option>');
                $('#' + elemId + '').select2('val', Number(data)); // select the new term
                $('.culture_organism_a').select2('close'); // close the dropdown
            });
        });

        $(".culture_organism_b").select2({
            width: '240px',
            allowClear: true,
            formatNoMatches: function (term) {
                /* customize the no matches output */
                var elemId = $(this).attr("id");
                var id = $(this).attr("data-id");
                return "<input class='form-control' id='newculture_organism_bTerm' value='" + term + "'>\n\
                               <a href='#' id='addNewculture_organism_bRow' data-elemId='" + elemId + "'  data-id='" + id + "'   \n\
                                  class='btn blue custombtnstyle'>ADD</a>"
            }
        }).parent().find('.select2-with-searchbox').on('click', '#addNewculture_organism_bRow', function () {
            /* add the new term */
            var newTerm = $('#newculture_organism_bTerm').val();
            var id = $(this).attr("data-id");
            var elemId = $(this).attr("data-elemId");
            $.post(hosturl + "/controllers/invsdept.php?ac=addnewrecord", {
                selectId: 'culture_organism_b', new_name: newTerm, id: id,
                tableName: $('#' + elemId + '').attr('data-tableName'),
                colName: $('#' + elemId + '').attr('data-colName')
            }, function (data) {

                $('.culture_organism_b > .deleteoptincompo').before('<option value="' + Number(data) + '" >' + newTerm + '</option>');
                $('#' + elemId + '').select2('val', Number(data)); // select the new term
                $('.culture_organism_b').select2('close'); // close the dropdown
            });
        });

        $(".culture_organism_c").select2({
            width: '240px',
            allowClear: true,
            formatNoMatches: function (term) {
                /* customize the no matches output */
                var elemId = $(this).attr("id");
                var id = $(this).attr("data-id");
                return "<input class='form-control' id='newculture_organism_cTerm' value='" + term + "'>\n\
                               <a href='#' id='addNewculture_organism_cRow' data-elemId='" + elemId + "'  data-id='" + id + "'   \n\
                                  class='btn blue custombtnstyle'>ADD</a>"
            }
        }).parent().find('.select2-with-searchbox').on('click', '#addNewculture_organism_cRow', function () {
            /* add the new term */
            var newTerm = $('#newculture_organism_cTerm').val();
            var id = $(this).attr("data-id");
            var elemId = $(this).attr("data-elemId");
            $.post(hosturl + "/controllers/invsdept.php?ac=addnewrecord", {
                selectId: 'culture_organism_c', new_name: newTerm, id: id,
                tableName: $('#' + elemId + '').attr('data-tableName'),
                colName: $('#' + elemId + '').attr('data-colName')
            }, function (data) {

                $('.culture_organism_c > .deleteoptincompo').before('<option value="' + Number(data) + '" >' + newTerm + '</option>');
                $('#' + elemId + '').select2('val', Number(data)); // select the new term
                $('.culture_organism_c').select2('close'); // close the dropdown
            });
        });

        $(".culture_condition").select2({
            width: '240px',
            allowClear: true,
            formatNoMatches: function (term) {
                /* customize the no matches output */
                var elemId = $(this).attr("id");
                var id = $(this).attr("data-id");
                return "<input class='form-control' id='newculture_conditionTerm' value='" + term + "'>\n\
                               <a href='#' id='addNewculture_conditionRow' data-elemId='" + elemId + "'  data-id='" + id + "'   \n\
                                  class='btn blue custombtnstyle'>ADD</a>"
            }
        }).parent().find('.select2-with-searchbox').on('click', '#addNewculture_conditionRow', function () {
            /* add the new term */
            var newTerm = $('#newculture_conditionTerm').val();
            var id = $(this).attr("data-id");
            var elemId = $(this).attr("data-elemId");
            $.post(hosturl + "/controllers/invsdept.php?ac=addnewrecord", {
                selectId: 'culture_condition', new_name: newTerm, id: id,
                tableName: $('#' + elemId + '').attr('data-tableName'),
                colName: $('#' + elemId + '').attr('data-colName')
            }, function (data) {

                $('.culture_condition > .deleteoptincompo').before('<option value="' + Number(data) + '" >' + newTerm + '</option>');
                $('#' + elemId + '').select2('val', Number(data)); // select the new term
                $('.culture_condition').select2('close'); // close the dropdown
            });
        });

        $(".culture_condition1").select2({
            width: '240px',
            allowClear: true,
            formatNoMatches: function (term) {
                /* customize the no matches output */
                var elemId = $(this).attr("id");
                var id = $(this).attr("data-id");
                return "<input class='form-control' id='newculture_condition1Term' value='" + term + "'>\n\
                               <a href='#' id='addNewculture_condition1Row' data-elemId='" + elemId + "'  data-id='" + id + "'   \n\
                                  class='btn blue custombtnstyle'>ADD</a>"
            }
        }).parent().find('.select2-with-searchbox').on('click', '#addNewculture_condition1Row', function () {
            /* add the new term */
            var newTerm = $('#newculture_condition1Term').val();
            var id = $(this).attr("data-id");
            var elemId = $(this).attr("data-elemId");
            $.post(hosturl + "/controllers/invsdept.php?ac=addnewrecord", {
                selectId: 'culture_condition1', new_name: newTerm, id: id,
                tableName: $('#' + elemId + '').attr('data-tableName'),
                colName: $('#' + elemId + '').attr('data-colName')
            }, function (data) {

                $('.culture_condition1 > .deleteoptincompo').before('<option value="' + Number(data) + '" >' + newTerm + '</option>');
                $('#' + elemId + '').select2('val', Number(data)); // select the new term
                $('.culture_condition1').select2('close'); // close the dropdown
            });
        });

        $(".culture_colony_count").select2({
            width: '240px',
            allowClear: true,
            formatNoMatches: function (term) {
                /* customize the no matches output */
                var elemId = $(this).attr("id");
                var id = $(this).attr("data-id");
                return "<input class='form-control' id='newculture_colony_countTerm' value='" + term + "'>\n\
                               <a href='#' id='addNewculture_colony_countRow' data-elemId='" + elemId + "'  data-id='" + id + "'   \n\
                                  class='btn blue custombtnstyle'>ADD</a>"
            }
        }).parent().find('.select2-with-searchbox').on('click', '#addNewculture_colony_countRow', function () {
            /* add the new term */
            var newTerm = $('#newculture_colony_countTerm').val();
            var id = $(this).attr("data-id");
            var elemId = $(this).attr("data-elemId");
            $.post(hosturl + "/controllers/invsdept.php?ac=addnewrecord", {
                selectId: 'culture_colony_count', new_name: newTerm, id: id,
                tableName: $('#' + elemId + '').attr('data-tableName'),
                colName: $('#' + elemId + '').attr('data-colName')
            }, function (data) {

                $('.culture_colony_count > .deleteoptincompo').before('<option value="' + Number(data) + '" >' + newTerm + '</option>');
                $('#' + elemId + '').select2('val', Number(data)); // select the new term
                $('.culture_colony_count').select2('close'); // close the dropdown
            });
        });

        $(".culture_sensitivity_cat").select2({
            width: '240px',
            allowClear: true,
            formatNoMatches: function (term) {
                /* customize the no matches output */
                var elemId = $(this).attr("id");
                var id = $(this).attr("data-id");
                return "<input class='form-control' id='newculture_sensitivity_catTerm' value='" + term + "'>\n\
                               <a href='#' id='addNewculture_sensitivity_catRow' data-elemId='" + elemId + "'  data-id='" + id + "'   \n\
                                  class='btn blue custombtnstyle'>ADD</a>"
            }
        }).parent().find('.select2-with-searchbox').on('click', '#addNewculture_sensitivity_catRow', function () {
            /* add the new term */
            var newTerm = $('#newculture_sensitivity_catTerm').val();
            var id = $(this).attr("data-id");
            var elemId = $(this).attr("data-elemId");
            $.post(hosturl + "/controllers/invsdept.php?ac=addnewrecord", {
                selectId: 'culture_sensitivity_cat', new_name: newTerm, id: id,
                tableName: $('#' + elemId + '').attr('data-tableName'),
                colName: $('#' + elemId + '').attr('data-colName')
            }, function (data) {

                $('.culture_sensitivity_cat > .deleteoptincompo').before('<option value="' + Number(data) + '" >' + newTerm + '</option>');
                $('#' + elemId + '').select2('val', Number(data)); // select the new term
                $('.culture_sensitivity_cat').select2('close'); // close the dropdown
            });
        });

        $(".culture_reaction").select2({
            width: '240px',
            allowClear: true,
            formatNoMatches: function (term) {
                /* customize the no matches output */
                var elemId = $(this).attr("id");
                var id = $(this).attr("data-id");
                return "<input class='form-control' id='newculture_reactionTerm' value='" + term + "'>\n\
                               <a href='#' id='addNewculture_reactionRow' data-elemId='" + elemId + "'  data-id='" + id + "'   \n\
                                  class='btn blue custombtnstyle'>ADD</a>"
            }
        }).parent().find('.select2-with-searchbox').on('click', '#addNewculture_reactionRow', function () {
            /* add the new term */
            var newTerm = $('#newculture_reactionTerm').val();
            var id = $(this).attr("data-id");
            var elemId = $(this).attr("data-elemId");
            $.post(hosturl + "/controllers/invsdept.php?ac=addnewrecord", {
                selectId: 'culture_reaction', new_name: newTerm, id: id,
                tableName: $('#' + elemId + '').attr('data-tableName'),
                colName: $('#' + elemId + '').attr('data-colName')
            }, function (data) {

                $('.culture_reaction > .deleteoptincompo').before('<option value="' + Number(data) + '" >' + newTerm + '</option>');
                $('#' + elemId + '').select2('val', Number(data)); // select the new term
                $('.culture_reaction').select2('close'); // close the dropdown
            });
        });

        $(".culture_pus").select2({
            width: '240px',
            allowClear: true,
            formatNoMatches: function (term) {
                /* customize the no matches output */
                var elemId = $(this).attr("id");
                var id = $(this).attr("data-id");
                return "<input class='form-control' id='newculture_pusTerm' value='" + term + "'>\n\
                               <a href='#' id='addNewculture_pusRow' data-elemId='" + elemId + "'  data-id='" + id + "'   \n\
                                  class='btn blue custombtnstyle'>ADD</a>"
            }
        }).parent().find('.select2-with-searchbox').on('click', '#addNewculture_pusRow', function () {
            /* add the new term */
            var newTerm = $('#newculture_pusTerm').val();
            var id = $(this).attr("data-id");
            var elemId = $(this).attr("data-elemId");
            $.post(hosturl + "/controllers/invsdept.php?ac=addnewrecord", {
                selectId: 'culture_pus', new_name: newTerm, id: id,
                tableName: $('#' + elemId + '').attr('data-tableName'),
                colName: $('#' + elemId + '').attr('data-colName')
            }, function (data) {

                $('.culture_pus > .deleteoptincompo').before('<option value="' + Number(data) + '" >' + newTerm + '</option>');
                $('#' + elemId + '').select2('val', Number(data)); // select the new term
                $('.culture_pus').select2('close'); // close the dropdown
            });
        });

        $(".culture_pus2").select2({
            width: '240px',
            allowClear: true,
            formatNoMatches: function (term) {
                /* customize the no matches output */
                var elemId = $(this).attr("id");
                var id = $(this).attr("data-id");
                return "<input class='form-control' id='newculture_pus2Term' value='" + term + "'>\n\
                               <a href='#' id='addNewculture_pus2Row' data-elemId='" + elemId + "'  data-id='" + id + "'   \n\
                                  class='btn blue custombtnstyle'>ADD</a>"
            }
        }).parent().find('.select2-with-searchbox').on('click', '#addNewculture_pus2Row', function () {
            /* add the new term */
            var newTerm = $('#newculture_pus2Term').val();
            var id = $(this).attr("data-id");
            var elemId = $(this).attr("data-elemId");
            $.post(hosturl + "/controllers/invsdept.php?ac=addnewrecord", {
                selectId: 'culture_pus2', new_name: newTerm, id: id,
                tableName: $('#' + elemId + '').attr('data-tableName'),
                colName: $('#' + elemId + '').attr('data-colName')
            }, function (data) {

                $('.culture_pus2 > .deleteoptincompo').before('<option value="' + Number(data) + '" >' + newTerm + '</option>');
                $('#' + elemId + '').select2('val', Number(data)); // select the new term
                $('.culture_pus2').select2('close'); // close the dropdown
            });
        });

        $(".culture_pbcs").select2({
            width: '240px',
            allowClear: true,
            formatNoMatches: function (term) {
                /* customize the no matches output */
                var elemId = $(this).attr("id");
                var id = $(this).attr("data-id");
                return "<input class='form-control' id='newculture_pbcsTerm' value='" + term + "'>\n\
                               <a href='#' id='addNewculture_pbcsRow' data-elemId='" + elemId + "'  data-id='" + id + "'   \n\
                                  class='btn blue custombtnstyle'>ADD</a>"
            }
        }).parent().find('.select2-with-searchbox').on('click', '#addNewculture_pbcsRow', function () {
            /* add the new term */
            var newTerm = $('#newculture_pbcsTerm').val();
            var id = $(this).attr("data-id");
            var elemId = $(this).attr("data-elemId");
            $.post(hosturl + "/controllers/invsdept.php?ac=addnewrecord", {
                selectId: 'culture_pbcs', new_name: newTerm, id: id,
                tableName: $('#' + elemId + '').attr('data-tableName'),
                colName: $('#' + elemId + '').attr('data-colName')
            }, function (data) {

                $('.culture_pbcs > .deleteoptincompo').before('<option value="' + Number(data) + '" >' + newTerm + '</option>');
                $('#' + elemId + '').select2('val', Number(data)); // select the new term
                $('.culture_pbcs').select2('close'); // close the dropdown
            });
        });

        $(".culture_pbcs2").select2({
            width: '240px',
            allowClear: true,
            formatNoMatches: function (term) {
                /* customize the no matches output */
                var elemId = $(this).attr("id");
                var id = $(this).attr("data-id");
                return "<input class='form-control' id='newculture_pbcs2Term' value='" + term + "'>\n\
                               <a href='#' id='addNewculture_pbcs2Row' data-elemId='" + elemId + "'  data-id='" + id + "'   \n\
                                  class='btn blue custombtnstyle'>ADD</a>"
            }
        }).parent().find('.select2-with-searchbox').on('click', '#addNewculture_pbcs2Row', function () {
            /* add the new term */
            var newTerm = $('#newculture_pbcs2Term').val();
            var id = $(this).attr("data-id");
            var elemId = $(this).attr("data-elemId");
            $.post(hosturl + "/controllers/invsdept.php?ac=addnewrecord", {
                selectId: 'culture_pbcs2', new_name: newTerm, id: id,
                tableName: $('#' + elemId + '').attr('data-tableName'),
                colName: $('#' + elemId + '').attr('data-colName')
            }, function (data) {

                $('.culture_pbcs2 > .deleteoptincompo').before('<option value="' + Number(data) + '" >' + newTerm + '</option>');
                $('#' + elemId + '').select2('val', Number(data)); // select the new term
                $('.culture_pbcs2').select2('close'); // close the dropdown
            });
        });

        $(".culture_epithelial").select2({
            width: '240px',
            allowClear: true,
            formatNoMatches: function (term) {
                /* customize the no matches output */
                var elemId = $(this).attr("id");
                var id = $(this).attr("data-id");
                return "<input class='form-control' id='newculture_epithelialTerm' value='" + term + "'>\n\
                               <a href='#' id='addNewculture_epithelialRow' data-elemId='" + elemId + "'  data-id='" + id + "'   \n\
                                  class='btn blue custombtnstyle'>ADD</a>"
            }
        }).parent().find('.select2-with-searchbox').on('click', '#addNewculture_epithelialRow', function () {
            /* add the new term */
            var newTerm = $('#newculture_epithelialTerm').val();
            var id = $(this).attr("data-id");
            var elemId = $(this).attr("data-elemId");
            $.post(hosturl + "/controllers/invsdept.php?ac=addnewrecord", {
                selectId: 'culture_epithelial', new_name: newTerm, id: id,
                tableName: $('#' + elemId + '').attr('data-tableName'),
                colName: $('#' + elemId + '').attr('data-colName')
            }, function (data) {

                $('.culture_epithelial > .deleteoptincompo').before('<option value="' + Number(data) + '" >' + newTerm + '</option>');
                $('#' + elemId + '').select2('val', Number(data)); // select the new term
                $('.culture_epithelial').select2('close'); // close the dropdown
            });
        });

        $(".culture_crystal").select2({
            width: '240px',
            allowClear: true,
            formatNoMatches: function (term) {
                /* customize the no matches output */
                var elemId = $(this).attr("id");
                var id = $(this).attr("data-id");
                return "<input class='form-control' id='newculture_crystalTerm' value='" + term + "'>\n\
                               <a href='#' id='addNewculture_crystalRow' data-elemId='" + elemId + "'  data-id='" + id + "'   \n\
                                  class='btn blue custombtnstyle'>ADD</a>"
            }
        }).parent().find('.select2-with-searchbox').on('click', '#addNewculture_crystalRow', function () {
            /* add the new term */
            var newTerm = $('#newculture_crystalTerm').val();
            var id = $(this).attr("data-id");
            var elemId = $(this).attr("data-elemId");
            $.post(hosturl + "/controllers/invsdept.php?ac=addnewrecord", {
                selectId: 'culture_crystal', new_name: newTerm, id: id,
                tableName: $('#' + elemId + '').attr('data-tableName'),
                colName: $('#' + elemId + '').attr('data-colName')
            }, function (data) {

                $('.culture_crystal > .deleteoptincompo').before('<option value="' + Number(data) + '" >' + newTerm + '</option>');
                $('#' + elemId + '').select2('val', Number(data)); // select the new term
                $('.culture_crystal').select2('close'); // close the dropdown
            });
        });

        $(".culture_fungi").select2({
            width: '240px',
            allowClear: true,
            formatNoMatches: function (term) {
                /* customize the no matches output */
                var elemId = $(this).attr("id");
                var id = $(this).attr("data-id");
                return "<input class='form-control' id='newculture_fungiTerm' value='" + term + "'>\n\
                               <a href='#' id='addNewculture_fungiRow' data-elemId='" + elemId + "'  data-id='" + id + "'   \n\
                                  class='btn blue custombtnstyle'>ADD</a>"
            }
        }).parent().find('.select2-with-searchbox').on('click', '#addNewculture_fungiRow', function () {
            /* add the new term */
            var newTerm = $('#newculture_fungiTerm').val();
            var id = $(this).attr("data-id");
            var elemId = $(this).attr("data-elemId");
            $.post(hosturl + "/controllers/invsdept.php?ac=addnewrecord", {
                selectId: 'culture_fungi', new_name: newTerm, id: id,
                tableName: $('#' + elemId + '').attr('data-tableName'),
                colName: $('#' + elemId + '').attr('data-colName')
            }, function (data) {

                $('.culture_fungi > .deleteoptincompo').before('<option value="' + Number(data) + '" >' + newTerm + '</option>');
                $('#' + elemId + '').select2('val', Number(data)); // select the new term
                $('.culture_fungi').select2('close'); // close the dropdown
            });
        });

        $(".culture_bacteria").select2({
            width: '240px',
            allowClear: true,
            formatNoMatches: function (term) {
                /* customize the no matches output */
                var elemId = $(this).attr("id");
                var id = $(this).attr("data-id");
                return "<input class='form-control' id='newculture_bacteriaTerm' value='" + term + "'>\n\
                               <a href='#' id='addNewculture_bacteriaRow' data-elemId='" + elemId + "'  data-id='" + id + "'   \n\
                                  class='btn blue custombtnstyle'>ADD</a>"
            }
        }).parent().find('.select2-with-searchbox').on('click', '#addNewculture_bacteriaRow', function () {
            /* add the new term */
            var newTerm = $('#newculture_bacteriaTerm').val();
            var id = $(this).attr("data-id");
            var elemId = $(this).attr("data-elemId");
            $.post(hosturl + "/controllers/invsdept.php?ac=addnewrecord", {
                selectId: 'culture_bacteria', new_name: newTerm, id: id,
                tableName: $('#' + elemId + '').attr('data-tableName'),
                colName: $('#' + elemId + '').attr('data-colName')
            }, function (data) {

                $('.culture_bacteria > .deleteoptincompo').before('<option value="' + Number(data) + '" >' + newTerm + '</option>');
                $('#' + elemId + '').select2('val', Number(data)); // select the new term
                $('.culture_bacteria').select2('close'); // close the dropdown
            });
        });

        $(".culture_other").select2({
            width: '240px',
            allowClear: true,
            formatNoMatches: function (term) {
                /* customize the no matches output */
                var elemId = $(this).attr("id");
                var id = $(this).attr("data-id");
                return "<input class='form-control' id='newculture_otherTerm' value='" + term + "'>\n\
                               <a href='#' id='addNewculture_otherRow' data-elemId='" + elemId + "'  data-id='" + id + "'   \n\
                                  class='btn blue custombtnstyle'>ADD</a>"
            }
        }).parent().find('.select2-with-searchbox').on('click', '#addNewculture_otherRow', function () {
            /* add the new term */
            var newTerm = $('#newculture_otherTerm').val();
            var id = $(this).attr("data-id");
            var elemId = $(this).attr("data-elemId");
            $.post(hosturl + "/controllers/invsdept.php?ac=addnewrecord", {
                selectId: 'culture_other', new_name: newTerm, id: id,
                tableName: $('#' + elemId + '').attr('data-tableName'),
                colName: $('#' + elemId + '').attr('data-colName')
            }, function (data) {

                $('.culture_other > .deleteoptincompo').before('<option value="' + Number(data) + '" >' + newTerm + '</option>');
                $('#' + elemId + '').select2('val', Number(data)); // select the new term
                $('.culture_other').select2('close'); // close the dropdown
            });
        });

        $(".culture_other1").select2({
            width: '240px',
            allowClear: true,
            formatNoMatches: function (term) {
                /* customize the no matches output */
                var elemId = $(this).attr("id");
                var id = $(this).attr("data-id");
                return "<input class='form-control' id='newculture_other1Term' value='" + term + "'>\n\
                               <a href='#' id='addNewculture_other1Row' data-elemId='" + elemId + "'  data-id='" + id + "'   \n\
                                  class='btn blue custombtnstyle'>ADD</a>"
            }
        }).parent().find('.select2-with-searchbox').on('click', '#addNewculture_other1Row', function () {
            /* add the new term */
            var newTerm = $('#newculture_other1Term').val();
            var id = $(this).attr("data-id");
            var elemId = $(this).attr("data-elemId");
            $.post(hosturl + "/controllers/invsdept.php?ac=addnewrecord", {
                selectId: 'culture_other1', new_name: newTerm, id: id,
                tableName: $('#' + elemId + '').attr('data-tableName'),
                colName: $('#' + elemId + '').attr('data-colName')
            }, function (data) {

                $('.culture_other1 > .deleteoptincompo').before('<option value="' + Number(data) + '" >' + newTerm + '</option>');
                $('#' + elemId + '').select2('val', Number(data)); // select the new term
                $('.culture_other1').select2('close'); // close the dropdown
            });
        });

        $(".culture_other2").select2({
            width: '240px',
            allowClear: true,
            formatNoMatches: function (term) {
                /* customize the no matches output */
                var elemId = $(this).attr("id");
                var id = $(this).attr("data-id");
                return "<input class='form-control' id='newculture_other2Term' value='" + term + "'>\n\
                               <a href='#' id='addNewculture_other2Row' data-elemId='" + elemId + "'  data-id='" + id + "'   \n\
                                  class='btn blue custombtnstyle'>ADD</a>"
            }
        }).parent().find('.select2-with-searchbox').on('click', '#addNewculture_other2Row', function () {
            /* add the new term */
            var newTerm = $('#newculture_other2Term').val();
            var id = $(this).attr("data-id");
            var elemId = $(this).attr("data-elemId");
            $.post(hosturl + "/controllers/invsdept.php?ac=addnewrecord", {
                selectId: 'culture_other2', new_name: newTerm, id: id,
                tableName: $('#' + elemId + '').attr('data-tableName'),
                colName: $('#' + elemId + '').attr('data-colName')
            }, function (data) {

                $('.culture_other2 > .deleteoptincompo').before('<option value="' + Number(data) + '" >' + newTerm + '</option>');
                $('#' + elemId + '').select2('val', Number(data)); // select the new term
                $('.culture_other2').select2('close'); // close the dropdown
            });
        });

        $(".culture_other3").select2({
            width: '240px',
            allowClear: true,
            formatNoMatches: function (term) {
                /* customize the no matches output */
                var elemId = $(this).attr("id");
                var id = $(this).attr("data-id");
                return "<input class='form-control' id='newculture_other3Term' value='" + term + "'>\n\
                               <a href='#' id='addNewculture_other3Row' data-elemId='" + elemId + "'  data-id='" + id + "'   \n\
                                  class='btn blue custombtnstyle'>ADD</a>"
            }
        }).parent().find('.select2-with-searchbox').on('click', '#addNewculture_other3Row', function () {
            /* add the new term */
            var newTerm = $('#newculture_other3Term').val();
            var id = $(this).attr("data-id");
            var elemId = $(this).attr("data-elemId");
            $.post(hosturl + "/controllers/invsdept.php?ac=addnewrecord", {
                selectId: 'culture_other3', new_name: newTerm, id: id,
                tableName: $('#' + elemId + '').attr('data-tableName'),
                colName: $('#' + elemId + '').attr('data-colName')
            }, function (data) {

                $('.culture_other3 > .deleteoptincompo').before('<option value="' + Number(data) + '" >' + newTerm + '</option>');
                $('#' + elemId + '').select2('val', Number(data)); // select the new term
                $('.culture_other3').select2('close'); // close the dropdown
            });
        });

        $(".culture_other4").select2({
            width: '240px',
            allowClear: true,
            formatNoMatches: function (term) {
                /* customize the no matches output */
                var elemId = $(this).attr("id");
                var id = $(this).attr("data-id");
                return "<input class='form-control' id='newculture_other4Term' value='" + term + "'>\n\
                               <a href='#' id='addNewculture_other4Row' data-elemId='" + elemId + "'  data-id='" + id + "'   \n\
                                  class='btn blue custombtnstyle'>ADD</a>"
            }
        }).parent().find('.select2-with-searchbox').on('click', '#addNewculture_other4Row', function () {
            /* add the new term */
            var newTerm = $('#newculture_other4Term').val();
            var id = $(this).attr("data-id");
            var elemId = $(this).attr("data-elemId");
            $.post(hosturl + "/controllers/invsdept.php?ac=addnewrecord", {
                selectId: 'culture_other4', new_name: newTerm, id: id,
                tableName: $('#' + elemId + '').attr('data-tableName'),
                colName: $('#' + elemId + '').attr('data-colName')
            }, function (data) {

                $('.culture_other4 > .deleteoptincompo').before('<option value="' + Number(data) + '" >' + newTerm + '</option>');
                $('#' + elemId + '').select2('val', Number(data)); // select the new term
                $('.culture_other4').select2('close'); // close the dropdown
            });
        });

        $(".culture_gram").select2({
            width: '240px',
            allowClear: true,
            formatNoMatches: function (term) {
                /* customize the no matches output */
                var elemId = $(this).attr("id");
                var id = $(this).attr("data-id");
                return "<input class='form-control' id='newculture_gramTerm' value='" + term + "'>\n\
                               <a href='#' id='addNewculture_gramRow' data-elemId='" + elemId + "'  data-id='" + id + "'   \n\
                                  class='btn blue custombtnstyle'>ADD</a>"
            }
        }).parent().find('.select2-with-searchbox').on('click', '#addNewculture_gramRow', function () {
            /* add the new term */
            var newTerm = $('#newculture_gramTerm').val();
            var id = $(this).attr("data-id");
            var elemId = $(this).attr("data-elemId");
            $.post(hosturl + "/controllers/invsdept.php?ac=addnewrecord", {
                selectId: 'culture_gram', new_name: newTerm, id: id,
                tableName: $('#' + elemId + '').attr('data-tableName'),
                colName: $('#' + elemId + '').attr('data-colName')
            }, function (data) {

                $('.culture_gram > .deleteoptincompo').before('<option value="' + Number(data) + '" >' + newTerm + '</option>');
                $('#' + elemId + '').select2('val', Number(data)); // select the new term
                $('.culture_gram').select2('close'); // close the dropdown
            });
        });

        $(".culture_zn_film").select2({
            width: '240px',
            allowClear: true,
            formatNoMatches: function (term) {
                /* customize the no matches output */
                var elemId = $(this).attr("id");
                var id = $(this).attr("data-id");
                return "<input class='form-control' id='newculture_zn_filmTerm' value='" + term + "'>\n\
                               <a href='#' id='addNewculture_zn_filmRow' data-elemId='" + elemId + "'  data-id='" + id + "'   \n\
                                  class='btn blue custombtnstyle'>ADD</a>"
            }
        }).parent().find('.select2-with-searchbox').on('click', '#addNewculture_zn_filmRow', function () {
            /* add the new term */
            var newTerm = $('#newculture_zn_filmTerm').val();
            var id = $(this).attr("data-id");
            var elemId = $(this).attr("data-elemId");
            $.post(hosturl + "/controllers/invsdept.php?ac=addnewrecord", {
                selectId: 'culture_zn_film', new_name: newTerm, id: id,
                tableName: $('#' + elemId + '').attr('data-tableName'),
                colName: $('#' + elemId + '').attr('data-colName')
            }, function (data) {

                $('.culture_zn_film > .deleteoptincompo').before('<option value="' + Number(data) + '" >' + newTerm + '</option>');
                $('#' + elemId + '').select2('val', Number(data)); // select the new term
                $('.culture_zn_film').select2('close'); // close the dropdown
            });
        });

        $('body').on('click', '.AddAbbr', function () {
            var culture_id = $(this).attr('data-culture');
            var abbr = $('#abbr_' + culture_id).val();
            var scientific_name = $('#scientific_name_' + culture_id).val();
            var sensitivity = $('#sensitivity_' + culture_id).val();

            $.post(hosturl + '/controllers/invsdept.php?ac=addabbr', {
                abbr: abbr,
                culture_id: culture_id,
                scientific_name: scientific_name,
                sensitivity: sensitivity
            }, function (res) {

                if (res != -1) {
                    $('#abbr_' + culture_id + '_Container').html('');
                    $('#abbr_' + culture_id + '_Container').html(res);
                }
            });
        });

        $('body').on('click', '.activeTab', function () {
            var tab = $(this).attr('data-tab');
            var id = $(this).attr('data-id');
            $('#activeTab_' + id).val(tab);
        });


        $('body').on('click', '.moveAbbr', function () {
            var abbr_id = $(this).attr('data-id');
            var culture_id = $(this).attr('data-culture');
            var activeTab = $('#activeTab_' + culture_id).val();
            var tr = $(this).parent().parent();
            $.post(hosturl + '/controllers/invsdept.php?ac=moveabbr', {
                abbr_id: abbr_id,
                culture_id: culture_id,
                activeTab: activeTab
            }, function (res) {

                if (Number(res) == 1) {
                    tr.remove();
                    $.post(hosturl + '/controllers/invsdept.php?ac=loadtabcontent', {
                        culture_id: culture_id,
                        activeTab: activeTab
                    }, function (dat) {

                        $('#' + activeTab + 'Container').html('');
                        $('#' + activeTab + 'Container').html(dat);
                    });
                }
            });
        });

        $('body').on('click', '.deleteMAbbr', function () {
            var id = $(this).attr('data-id');
            var tableName = $(this).attr('data-tableName');
            var culture_id = $(this).attr('data-culture');
            var activeTab = $('#activeTab_' + culture_id).val();
            var tr = $(this).parent().parent();
            $.post(hosturl + '/controllers/invsdept.php?ac=tabdeleteabbr', {
                id: id,
                tableName: tableName
            }, function (res) {

                if (Number(res) == 1) {
                    tr.remove();
                    $.post(hosturl + '/controllers/invsdept.php?ac=loadtabcontent', {
                        culture_id: culture_id,
                        activeTab: activeTab
                    }, function (dat) {

                        $('#' + activeTab + 'Container').html('');
                        $('#' + activeTab + 'Container').html(dat);
                    });
                    $.post(hosturl + '/controllers/invsdept.php?ac=getallabbr', {
                        culture_id: culture_id
                    }, function (dat) {

                        $('#abbr_' + culture_id + '_Container').html('');
                        $('#abbr_' + culture_id + '_Container').html(dat);
                    });
                }
            });
        });
    };

    var crossInvest = function () {
        $("#cross_abo").select2({
            placeholder: "Select",
            width: '240px',
            allowClear: true,
            formatNoMatches: function (term) {
                /* customize the no matches output */
                return "<input class='form-control' id='newTerm_cross_abo' value='" + term + "'><a href='#' id='addNew_cross_abo' class='btn blue custombtnstyle'>إضافة جديد</a>"
            }
        }).parent().find('.select2-with-searchbox').on('click', '#addNew_cross_abo', function () {
            /* add the new term */
            var new_name = $('#newTerm_cross_abo').val();
            var id = $("#cross_abo").attr('data-id');
            var tableName = $("#cross_abo").attr('data-tableName');
            var colName = $("#cross_abo").attr('data-colName');
            $.post(hosturl + "/controllers/invsdept.php?ac=addnewrecord", {
                selectId: 'cross_abo',
                new_name: new_name,
                id: id,
                tableName: tableName,
                colName: colName
            }, function (data) {

                $('.cross_abo').each(function () {
                    var sId = $(this).attr("id");
                    $('#' + sId + ' > .deleteoptincompo').before('<option value="' + Number(data) + '" >' + new_name + '</option>');
                });
                $('#cross_abo').select2('val', Number(data)); // select the new term
                $("#cross_abo").select2('close'); // close the dropdown

            });
        });
        $("#cross_rh").select2({
            placeholder: "Select",
            width: '240px',
            allowClear: true,
            formatNoMatches: function (term) {
                /* customize the no matches output */
                return "<input class='form-control' id='newTerm_cross_rh' value='" + term + "'><a href='#' id='addNew_cross_rh' class='btn blue custombtnstyle'>إضافة جديد</a>"
            }
        }).parent().find('.select2-with-searchbox').on('click', '#addNew_cross_rh', function () {
            /* add the new term */
            var new_name = $('#newTerm_cross_rh').val();
            var id = $("#cross_rh").attr('data-id');
            var tableName = $("#cross_rh").attr('data-tableName');
            var colName = $("#cross_rh").attr('data-colName');
            $.post(hosturl + "/controllers/invsdept.php?ac=addnewrecord", {
                selectId: 'cross_rh',
                new_name: new_name,
                id: id,
                tableName: tableName,
                colName: colName
            }, function (data) {

                $('.cross_rh').each(function () {
                    var sId = $(this).attr("id");
                    $('#' + sId + ' > .deleteoptincompo').before('<option value="' + Number(data) + '" >' + new_name + '</option>');
                });
                $('#cross_rh').select2('val', Number(data)); // select the new term
                $("#cross_rh").select2('close'); // close the dropdown

            });
        });
        var crossDonnersItr = $('#crossDonnersItr').val();
        for (var x = 1; x <= crossDonnersItr; x++) {

            loadSelect(x);
        }

        $('body').on('click', '#AddDonor', function () {

            var cross_id = $(this).attr('data-cross');
            var crossDonnersItr = $('#crossDonnersItr').val();
            var new_itr = crossDonnersItr + 1;
            $('#crossDonnersItr').val(new_itr);
            $.post(hosturl + '/controllers/invsdept.php?ac=addnewdonner', {
                cross_id: cross_id,
                new_itr: new_itr
            }, function (res) {

                if (res != -1) {
                    $('#donorsDiv').append(res);
                    loadSelect(new_itr)
                }
            });
        });
    };

    function loadSelect(i) {

        $('#donner_abo' + i).select2({
            placeholder: "Select",
            width: '240px',
            allowClear: true,
            formatNoMatches: function (term) {
                /* customize the no matches output */
                var itr = $(this).attr('data-itr');
                var id = $(this).attr('data-id');
                var tableName = $(this).attr('data-tableName');
                var colName = $(this).attr('data-colName');
                return "<input class='form-control' id='newTerm_donner_abo" + itr + "' value='" + term + "' data-itr='" + itr + "' data-id='" + id + "' ><a href='#' id='addNew_donner_abo" + itr + "' data-itr='" + itr + "' data-id='" + id + "'  data-tableName='" + tableName + "' data-colName='" + colName + "' class='btn blue addNew_donner_abo'>إضافة جديد</a>"
            }
        }).parent().find('.select2-with-searchbox').on('click', '.addNew_donner_abo', function () {
            /* add the new term */
            var itr = $(this).attr('data-itr');
            var new_name = $('#newTerm_donner_abo' + itr).val();
            var id = $(this).attr('data-id');
            var tableName = $(this).attr('data-tableName');
            var colName = $(this).attr('data-colName');
            $.post(hosturl + "/controllers/invsdept.php?ac=addnewrecord", {
                selectId: 'cross_abo',
                new_name: new_name,
                id: id,
                tableName: tableName,
                colName: colName
            }, function (data) {

                $('.cross_abo > .deleteoptincompo').before('<option value="' + Number(data) + '" >' + new_name + '</option>');
                $('#donner_abo' + itr).select2('val', Number(data)); // select the new term
                $('#donner_abo' + itr).select2('close'); // close the dropdown

            });
        });
        $('#donner_rh' + i).select2({
            placeholder: "Select",
            width: '240px',
            allowClear: true,
            formatNoMatches: function (term) {
                /* customize the no matches output */
                var itr = $(this).attr('data-itr');
                var id = $(this).attr('data-id');
                var tableName = $(this).attr('data-tableName');
                var colName = $(this).attr('data-colName');
                return "<input class='form-control' id='newTerm_donner_rh" + itr + "' value='" + term + "' data-itr='" + itr + "' data-id='" + id + "' ><a href='#' id='addNew_donner_rh" + itr + "' data-itr='" + itr + "' data-id='" + id + "'  data-tableName='" + tableName + "' data-colName='" + colName + "' class='btn blue addNew_donner_rh'>إضافة جديد</a>"
            }
        }).parent().find('.select2-with-searchbox').on('click', '.addNew_donner_rh', function () {
            /* add the new term */
            var itr = $(this).attr('data-itr');
            var new_name = $('#newTerm_donner_rh' + itr).val();
            var id = $(this).attr('data-id');
            var tableName = $(this).attr('data-tableName');
            var colName = $(this).attr('data-colName');
            $.post(hosturl + "/controllers/invsdept.php?ac=addnewrecord", {
                selectId: 'cross_rh',
                new_name: new_name,
                id: id,
                tableName: tableName,
                colName: colName
            }, function (data) {

                $('.cross_rh > .deleteoptincompo').before('<option value="' + Number(data) + '" >' + new_name + '</option>');
                $('#donner_rh' + itr).select2('val', Number(data)); // select the new term
                $('#donner_rh' + itr).select2('close'); // close the dropdown

            });
        });
        $('#cross_compatibility' + i).select2({
            placeholder: "Select",
            width: '240px',
            allowClear: true,
            formatNoMatches: function (term) {
                /* customize the no matches output */
                var itr = $(this).attr('data-itr');
                var id = $(this).attr('data-id');
                var tableName = $(this).attr('data-tableName');
                var colName = $(this).attr('data-colName');
                return "<input class='form-control' id='newTerm_cross_compatibility" + itr + "' value='" + term + "' data-itr='" + itr + "' data-id='" + id + "' ><a href='#' id='addNew_cross_compatibility" + itr + "' data-itr='" + itr + "' data-id='" + id + "'  data-tableName='" + tableName + "' data-colName='" + colName + "' class='btn blue addNew_cross_compatibility'>إضافة جديد</a>"
            }
        }).parent().find('.select2-with-searchbox').on('click', '.addNew_cross_compatibility', function () {
            /* add the new term */
            var itr = $(this).attr('data-itr');
            var new_name = $('#newTerm_cross_compatibility' + itr).val();
            var id = $(this).attr('data-id');
            var tableName = $(this).attr('data-tableName');
            var colName = $(this).attr('data-colName');
            $.post(hosturl + "/controllers/invsdept.php?ac=addnewrecord", {
                selectId: 'cross_compatibility',
                new_name: new_name,
                id: id,
                tableName: tableName,
                colName: colName
            }, function (data) {

                $('.cross_compatibility > .deleteoptincompo').before('<option value="' + Number(data) + '" >' + new_name + '</option>');
                $('#cross_compatibility' + itr).select2('val', Number(data)); // select the new term
                $('#cross_compatibility' + itr).select2('close'); // close the dropdown

            });
        });
        $('#cross_hcv' + i).select2({
            placeholder: "Select",
            width: '240px',
            allowClear: true,
            formatNoMatches: function (term) {
                /* customize the no matches output */
                var itr = $(this).attr('data-itr');
                var id = $(this).attr('data-id');
                var tableName = $(this).attr('data-tableName');
                var colName = $(this).attr('data-colName');
                return "<input class='form-control' id='newTerm_cross_hcv" + itr + "' value='" + term + "' data-itr='" + itr + "' data-id='" + id + "' ><a href='#' id='addNew_cross_hcv" + itr + "' data-itr='" + itr + "' data-id='" + id + "'  data-tableName='" + tableName + "' data-colName='" + colName + "' class='btn blue addNew_cross_hcv'>إضافة جديد</a>"
            }
        }).parent().find('.select2-with-searchbox').on('click', '.addNew_cross_hcv', function () {
            /* add the new term */
            var itr = $(this).attr('data-itr');
            var new_name = $('#newTerm_cross_hcv' + itr).val();
            var id = $(this).attr('data-id');
            var tableName = $(this).attr('data-tableName');
            var colName = $(this).attr('data-colName');
            $.post(hosturl + "/controllers/invsdept.php?ac=addnewrecord", {
                selectId: 'cross_hcv',
                new_name: new_name,
                id: id,
                tableName: tableName,
                colName: colName
            }, function (data) {

                $('.cross_hcv > .deleteoptincompo').before('<option value="' + Number(data) + '" >' + new_name + '</option>');
                $('#cross_hcv' + itr).select2('val', Number(data)); // select the new term
                $('#cross_hcv' + itr).select2('close'); // close the dropdown

            });
        });
        $('#cross_hbsag' + i).select2({
            placeholder: "Select",
            width: '240px',
            allowClear: true,
            formatNoMatches: function (term) {
                /* customize the no matches output */
                var itr = $(this).attr('data-itr');
                var id = $(this).attr('data-id');
                var tableName = $(this).attr('data-tableName');
                var colName = $(this).attr('data-colName');
                return "<input class='form-control' id='newTerm_cross_hbsag" + itr + "' value='" + term + "' data-itr='" + itr + "' data-id='" + id + "' ><a href='#' id='addNew_cross_hbsag" + itr + "' data-itr='" + itr + "' data-id='" + id + "'  data-tableName='" + tableName + "' data-colName='" + colName + "' class='btn blue addNew_cross_hbsag'>إضافة جديد</a>"
            }
        }).parent().find('.select2-with-searchbox').on('click', '.addNew_cross_hbsag', function () {
            /* add the new term */
            var itr = $(this).attr('data-itr');
            var new_name = $('#newTerm_cross_hbsag' + itr).val();
            var id = $(this).attr('data-id');
            var tableName = $(this).attr('data-tableName');
            var colName = $(this).attr('data-colName');
            $.post(hosturl + "/controllers/invsdept.php?ac=addnewrecord", {
                selectId: 'cross_hbsag',
                new_name: new_name,
                id: id,
                tableName: tableName,
                colName: colName
            }, function (data) {

                $('.cross_hbsag > .deleteoptincompo').before('<option value="' + Number(data) + '" >' + new_name + '</option>');
                $('#cross_hbsag' + itr).select2('val', Number(data)); // select the new term
                $('#cross_hbsag' + itr).select2('close'); // close the dropdown

            });
        });
        $('#cross_hv' + i).select2({
            placeholder: "Select",
            width: '240px',
            allowClear: true,
            formatNoMatches: function (term) {
                /* customize the no matches output */
                var itr = $(this).attr('data-itr');
                var id = $(this).attr('data-id');
                var tableName = $(this).attr('data-tableName');
                var colName = $(this).attr('data-colName');
                return "<input class='form-control' id='newTerm_cross_hv" + itr + "' value='" + term + "' data-itr='" + itr + "' data-id='" + id + "' ><a href='#' id='addNew_cross_hv" + itr + "' data-itr='" + itr + "' data-id='" + id + "'  data-tableName='" + tableName + "' data-colName='" + colName + "' class='btn blue addNew_cross_hv'>إضافة جديد</a>"
            }
        }).parent().find('.select2-with-searchbox').on('click', '.addNew_cross_hv', function () {
            /* add the new term */
            var itr = $(this).attr('data-itr');
            var new_name = $('#newTerm_cross_hv' + itr).val();
            var id = $(this).attr('data-id');
            var tableName = $(this).attr('data-tableName');
            var colName = $(this).attr('data-colName');
            $.post(hosturl + "/controllers/invsdept.php?ac=addnewrecord", {
                selectId: 'cross_hv',
                new_name: new_name,
                id: id,
                tableName: tableName,
                colName: colName
            }, function (data) {

                $('.cross_hv > .deleteoptincompo').before('<option value="' + Number(data) + '" >' + new_name + '</option>');
                $('#cross_hv' + itr).select2('val', Number(data)); // select the new term
                $('#cross_hv' + itr).select2('close'); // close the dropdown

            });
        });
    }

    var hbsagInvest = function () {

    };

    var clothingInvest = function () {

        $('body').on('change', '.clothing', function () {

            var element = $(this).attr('data-target');
            var value = $('#' + element + '_clothing').val();
            var rangeid = $('#' + element + '_rangeid').val();
            $.post(hosturl + '/controllers/invsdept.php?ac=invlevel', {
                value: value,
                rangeid: rangeid
            }, function (res) {

                var obj = res.split("-");
                $('#' + element + '_level').val(obj[0]);
                $('#' + element + '_unit').val(obj[1]);
            });
        });
    };

    var ptInvest = function () {
        $('body').on('change', '.pt', function () {

            var element = $(this).attr('data-target');
            ptChange(element);
        });

        function ptChange(element) {

            var value = $('#' + element + '_pt').val();
            var rangeid = $('#' + element + '_rangeid').val();
            $.post(hosturl + '/controllers/invsdept.php?ac=invlevel', {
                value: value,
                rangeid: rangeid
            }, function (res) {

                var obj = res.split("-");
                $('#' + element + '_level').val(obj[0]);
                $('#' + element + '_unit').val(obj[1]);
            });
        }

        $('body').on('keyup', '#patient_time_pt', function () {

            var pt_patient = Number($('#patient_time_pt').val());
            var id = $(this).attr('data-id');
            $.post(hosturl + '/controllers/invsdept.php?ac=inrcalc', {pt_patient: pt_patient, id: id}, function (res) {
                var obj = res.split("-");
                $('#inr_pt').val(obj[0]);
                var element = $('#inr_pt').attr('data-target');
                ptChange(element);
                $('#concentration_pt').val(obj[1]);
                var element = $('#concentration_pt').attr('data-target');
                ptChange(element);
            });
        });

        $('body').on('click', '#calculator', function () {
            $.post(hosturl + '/controllers/invsdept.php?ac=calculator', function (res) {
                $('#calculatorDiv').html('');
                $('#calculatorDiv').html(res);
                $("#calculatorModal").modal('show');
            });
        });

        $('body').on('click', '#newCalculation', function () {
            $.post(hosturl + '/controllers/invsdept.php?ac=newcalculation', function (res) {
                $('#calculationContainer').prepend(res);
            });
        });
    };

    var lipidInvest = function () {
        $('body').on('change', '.lipid', function () {

            var id = $(this).attr('data-id');
            var tg = Number($('#triglycerides_' + id).val());
            var cho = Number($('#cholesterol_' + id).val());
            var hdl = Number($('#hdl_' + id).val());

            var vldl = tg / 5;
            var ldl = cho - hdl - vldl;
            var nonhdl = cho - hdl;
            if (hdl > 0) {
                var riskratio1 = tg / hdl;
                var riskratio2 = ldl / hdl;
                var riskratio3 = cho / hdl;
            } else {
                var riskratio1 = '';
                var riskratio2 = '';
                var riskratio3 = '';
            }
            $('#ldl_' + id).val(ldl.toFixed(2));
            $('#vldl_' + id).val(vldl.toFixed(2));
            $('#nonhdl_' + id).val(nonhdl.toFixed(2));
            $('#riskratio1_' + id).val(riskratio1.toFixed(2));
            $('#riskratio2_' + id).val(riskratio2.toFixed(2));
            $('#riskratio3_' + id).val(riskratio3.toFixed(2));

            var data = [['triglycerides', tg.toFixed(2)], ['cholesterol', cho.toFixed(2)], ['hdl', hdl.toFixed(2)], ['ldl', ldl.toFixed(2)]
                        , ['vldl', vldl.toFixed(2)], ['nonhdl', nonhdl.toFixed(2)], ['riskratio1', riskratio1.toFixed(2)]
                        , ['riskratio2', riskratio2.toFixed(2)], ['riskratio3', riskratio3.toFixed(2)]];
            updateArray(id, $('#triglycerides_' + id).attr('data-tableName'), data);
        });
    };

    var egfrInvest = function () {
        $('body').on('change', '.egfr', function () {

            var id = $(this).attr('data-id');
            var cr = Number($('#cr_' + id).val());
            var age = Number($('#patAge').val());
            var gender = Number($('#patGender').val());
            var egfr = 175;

            if (cr > 0) {
                if (gender != 1) {
                    egfr = 0.742 * egfr;
                }

                if (age > 0) {
                    egfr = (Math.pow(age, -0.203)) * egfr;
                }

                egfr = (Math.pow(cr, -1.154)) * egfr;
            } else {
                egfr = 0;
            }

            $('#gfr_' + id).val(egfr.toFixed(2));

            var data = [['gfr', egfr.toFixed(2)]];
            updateArray(id, $('#gfr_' + id).attr('data-tableName'), data);
        });
    };

    var aborhInvest = function () {
        $("#aborh_abo").select2({
            placeholder: "Select",
            width: '240px',
            allowClear: true,
            formatNoMatches: function (term) {
                /* customize the no matches output */
                return "<input class='form-control' id='newTerm_aborh_abo' value='" + term + "'><a href='#' id='addNew_aborh_abo' class='btn blue custombtnstyle'>إضافة جديد</a>"
            }
        }).parent().find('.select2-with-searchbox').on('click', '#addNew_aborh_abo', function () {
            /* add the new term */
            var new_name = $('#newTerm_aborh_abo').val();
            var id = $("#aborh_abo").attr('data-id');
            var tableName = $("#aborh_abo").attr('data-tableName');
            var colName = $("#aborh_abo").attr('data-colName');
            $.post(hosturl + "/controllers/invsdept.php?ac=addnewrecord", {
                selectId: 'cross_abo',
                new_name: new_name,
                id: id,
                tableName: tableName,
                colName: colName
            }, function (data) {

                $('.cross_abo').each(function () {
                    var sId = $(this).attr("id");
                    $('#' + sId + ' > .deleteoptincompo').before('<option value="' + Number(data) + '" >' + new_name + '</option>');
                });
                $('#aborh_abo').select2('val', Number(data)); // select the new term
                $("#aborh_abo").select2('close'); // close the dropdown

            });
        });
        $("#aborh_rh").select2({
            placeholder: "Select",
            width: '240px',
            allowClear: true,
            formatNoMatches: function (term) {
                /* customize the no matches output */
                return "<input class='form-control' id='newTerm_aborh_rh' value='" + term + "'><a href='#' id='addNew_aborh_rh' class='btn blue custombtnstyle'>إضافة جديد</a>"
            }
        }).parent().find('.select2-with-searchbox').on('click', '#addNew_aborh_rh', function () {
            /* add the new term */
            var new_name = $('#newTerm_aborh_rh').val();
            var id = $("#aborh_rh").attr('data-id');
            var tableName = $("#aborh_rh").attr('data-tableName');
            var colName = $("#aborh_rh").attr('data-colName');
            $.post(hosturl + "/controllers/invsdept.php?ac=addnewrecord", {
                selectId: 'cross_rh',
                new_name: new_name,
                id: id,
                tableName: tableName,
                colName: colName
            }, function (data) {

                $('.cross_rh').each(function () {
                    var sId = $(this).attr("id");
                    $('#' + sId + ' > .deleteoptincompo').before('<option value="' + Number(data) + '" >' + new_name + '</option>');
                });
                $('#aborh_rh').select2('val', Number(data)); // select the new term
                $("#aborh_rh").select2('close'); // close the dropdown

            });
        });
    };

    var semenInvest = function () {
        $(".semen_color").select2({
            width: '240px',
            allowClear: true,
            formatNoMatches: function (term) {
                /* customize the no matches output */
                var elemId = $(this).attr("id");
                var id = $(this).attr("data-id");
                return "<input class='form-control' id='newsemen_colorTerm' value='" + term + "'>\n\
                               <a href='#' id='addNewsemen_colorRow' data-elemId='" + elemId + "'  data-id='" + id + "'   \n\
                                  class='btn blue custombtnstyle'>ADD</a>"
            }
        }).parent().find('.select2-with-searchbox').on('click', '#addNewsemen_colorRow', function () {
            /* add the new term */
            var newTerm = $('#newsemen_colorTerm').val();
            var id = $(this).attr("data-id");
            var elemId = $(this).attr("data-elemId");
            $.post(hosturl + "/controllers/invsdept.php?ac=addnewrecord", {
                selectId: 'semen_color', new_name: newTerm, id: id,
                tableName: $('#' + elemId + '').attr('data-tableName'),
                colName: $('#' + elemId + '').attr('data-colName')
            }, function (data) {

                $('.semen_color > .deleteoptincompo').before('<option value="' + Number(data) + '" >' + newTerm + '</option>');
                $('#' + elemId + '').select2('val', Number(data)); // select the new term
                $('.semen_color').select2('close'); // close the dropdown
            });
        });

        $(".semen_viscosity").select2({
            width: '240px',
            allowClear: true,
            formatNoMatches: function (term) {
                /* customize the no matches output */
                var elemId = $(this).attr("id");
                var id = $(this).attr("data-id");
                return "<input class='form-control' id='newsemen_viscosityTerm' value='" + term + "'>\n\
                               <a href='#' id='addNewsemen_viscosityRow' data-elemId='" + elemId + "'  data-id='" + id + "'   \n\
                                  class='btn blue custombtnstyle'>ADD</a>"
            }
        }).parent().find('.select2-with-searchbox').on('click', '#addNewsemen_viscosityRow', function () {
            /* add the new term */
            var newTerm = $('#newsemen_viscosityTerm').val();
            var id = $(this).attr("data-id");
            var elemId = $(this).attr("data-elemId");
            $.post(hosturl + "/controllers/invsdept.php?ac=addnewrecord", {
                selectId: 'semen_viscosity', new_name: newTerm, id: id,
                tableName: $('#' + elemId + '').attr('data-tableName'),
                colName: $('#' + elemId + '').attr('data-colName')
            }, function (data) {

                $('.semen_viscosity > .deleteoptincompo').before('<option value="' + Number(data) + '" >' + newTerm + '</option>');
                $('#' + elemId + '').select2('val', Number(data)); // select the new term
                $('.semen_viscosity').select2('close'); // close the dropdown
            });
        });

        $(".semen_apperance").select2({
            width: '240px',
            allowClear: true,
            formatNoMatches: function (term) {
                /* customize the no matches output */
                var elemId = $(this).attr("id");
                var id = $(this).attr("data-id");
                return "<input class='form-control' id='newsemen_apperanceTerm' value='" + term + "'>\n\
                               <a href='#' id='addNewsemen_apperanceRow' data-elemId='" + elemId + "'  data-id='" + id + "'   \n\
                                  class='btn blue custombtnstyle'>ADD</a>"
            }
        }).parent().find('.select2-with-searchbox').on('click', '#addNewsemen_apperanceRow', function () {
            /* add the new term */
            var newTerm = $('#newsemen_apperanceTerm').val();
            var id = $(this).attr("data-id");
            var elemId = $(this).attr("data-elemId");
            $.post(hosturl + "/controllers/invsdept.php?ac=addnewrecord", {
                selectId: 'semen_apperance', new_name: newTerm, id: id,
                tableName: $('#' + elemId + '').attr('data-tableName'),
                colName: $('#' + elemId + '').attr('data-colName')
            }, function (data) {

                $('.semen_apperance > .deleteoptincompo').before('<option value="' + Number(data) + '" >' + newTerm + '</option>');
                $('#' + elemId + '').select2('val', Number(data)); // select the new term
                $('.semen_apperance').select2('close'); // close the dropdown
            });
        });

        $(".semen_sperm_cells").select2({
            width: '240px',
            allowClear: true,
            formatNoMatches: function (term) {
                /* customize the no matches output */
                var elemId = $(this).attr("id");
                var id = $(this).attr("data-id");
                return "<input class='form-control' id='newsemen_sperm_cellsTerm' value='" + term + "'>\n\
                               <a href='#' id='addNewsemen_sperm_cellsRow' data-elemId='" + elemId + "'  data-id='" + id + "'   \n\
                                  class='btn blue custombtnstyle'>ADD</a>"
            }
        }).parent().find('.select2-with-searchbox').on('click', '#addNewsemen_sperm_cellsRow', function () {
            /* add the new term */
            var newTerm = $('#newsemen_sperm_cellsTerm').val();
            var id = $(this).attr("data-id");
            var elemId = $(this).attr("data-elemId");
            $.post(hosturl + "/controllers/invsdept.php?ac=addnewrecord", {
                selectId: 'semen_sperm_cells', new_name: newTerm, id: id,
                tableName: $('#' + elemId + '').attr('data-tableName'),
                colName: $('#' + elemId + '').attr('data-colName')
            }, function (data) {

                $('.semen_sperm_cells > .deleteoptincompo').before('<option value="' + Number(data) + '" >' + newTerm + '</option>');
                $('#' + elemId + '').select2('val', Number(data)); // select the new term
                $('.semen_sperm_cells').select2('close'); // close the dropdown
            });
        });

        $(".semen_agg").select2({
            width: '240px',
            allowClear: true,
            formatNoMatches: function (term) {
                /* customize the no matches output */
                var elemId = $(this).attr("id");
                var id = $(this).attr("data-id");
                return "<input class='form-control' id='newsemen_aggTerm' value='" + term + "'>\n\
                               <a href='#' id='addNewsemen_aggRow' data-elemId='" + elemId + "'  data-id='" + id + "'   \n\
                                  class='btn blue custombtnstyle'>ADD</a>"
            }
        }).parent().find('.select2-with-searchbox').on('click', '#addNewsemen_aggRow', function () {
            /* add the new term */
            var newTerm = $('#newsemen_aggTerm').val();
            var id = $(this).attr("data-id");
            var elemId = $(this).attr("data-elemId");
            $.post(hosturl + "/controllers/invsdept.php?ac=addnewrecord", {
                selectId: 'semen_agg', new_name: newTerm, id: id,
                tableName: $('#' + elemId + '').attr('data-tableName'),
                colName: $('#' + elemId + '').attr('data-colName')
            }, function (data) {

                $('.semen_agg > .deleteoptincompo').before('<option value="' + Number(data) + '" >' + newTerm + '</option>');
                $('#' + elemId + '').select2('val', Number(data)); // select the new term
                $('.semen_agg').select2('close'); // close the dropdown
            });
        });

        $(".semen_epith_cells").select2({
            width: '240px',
            allowClear: true,
            formatNoMatches: function (term) {
                /* customize the no matches output */
                var elemId = $(this).attr("id");
                var id = $(this).attr("data-id");
                return "<input class='form-control' id='newsemen_epith_cellsTerm' value='" + term + "'>\n\
                               <a href='#' id='addNewsemen_epith_cellsRow' data-elemId='" + elemId + "'  data-id='" + id + "'   \n\
                                  class='btn blue custombtnstyle'>ADD</a>"
            }
        }).parent().find('.select2-with-searchbox').on('click', '#addNewsemen_epith_cellsRow', function () {
            /* add the new term */
            var newTerm = $('#newsemen_epith_cellsTerm').val();
            var id = $(this).attr("data-id");
            var elemId = $(this).attr("data-elemId");
            $.post(hosturl + "/controllers/invsdept.php?ac=addnewrecord", {
                selectId: 'semen_epith_cells', new_name: newTerm, id: id,
                tableName: $('#' + elemId + '').attr('data-tableName'),
                colName: $('#' + elemId + '').attr('data-colName')
            }, function (data) {

                $('.semen_epith_cells > .deleteoptincompo').before('<option value="' + Number(data) + '" >' + newTerm + '</option>');
                $('#' + elemId + '').select2('val', Number(data)); // select the new term
                $('.semen_epith_cells').select2('close'); // close the dropdown
            });
        });

        $(".semen_aggregation").select2({
            width: '240px',
            allowClear: true,
            formatNoMatches: function (term) {
                /* customize the no matches output */
                var elemId = $(this).attr("id");
                var id = $(this).attr("data-id");
                return "<input class='form-control' id='newsemen_aggregationTerm' value='" + term + "'>\n\
                               <a href='#' id='addNewsemen_aggregationRow' data-elemId='" + elemId + "'  data-id='" + id + "'   \n\
                                  class='btn blue custombtnstyle'>ADD</a>"
            }
        }).parent().find('.select2-with-searchbox').on('click', '#addNewsemen_aggregationRow', function () {
            /* add the new term */
            var newTerm = $('#newsemen_aggregationTerm').val();
            var id = $(this).attr("data-id");
            var elemId = $(this).attr("data-elemId");
            $.post(hosturl + "/controllers/invsdept.php?ac=addnewrecord", {
                selectId: 'semen_aggregation', new_name: newTerm, id: id,
                tableName: $('#' + elemId + '').attr('data-tableName'),
                colName: $('#' + elemId + '').attr('data-colName')
            }, function (data) {

                $('.semen_aggregation > .deleteoptincompo').before('<option value="' + Number(data) + '" >' + newTerm + '</option>');
                $('#' + elemId + '').select2('val', Number(data)); // select the new term
                $('.semen_aggregation').select2('close'); // close the dropdown
            });
        });

    };

    return {
        //main function to initiate the module
        init: function () {
            if ($('#controllName').val() == 'invsdept') {
                forAll();
            }
            if ($('#urineInvest').val() == 1) {
                urineInvest();
            }
            if ($('#stoolInvest').val() == 1) {
                stoolInvest();
            }
            if ($('#bPictureInvest').val() == 1) {
                bPictureInvest();
            }
            if ($('#esrInvest').val() == 1) {
                esrInvest();
            }
            if ($('#cultureInvest').val() == 1) {
                cultureInvest();
            }
            if ($('#crossInvest').val() == 1) {
                crossInvest();
            }
            if ($('#hbsagInvest').val() == 1) {
                hbsagInvest();
            }
            if ($('#clothingInvest').val() == 1) {
                clothingInvest();
            }
            if ($('#ptInvest').val() == 1) {
                ptInvest();
            }
            if ($('#lipidInvest').val() == 1) {
                lipidInvest();
            }
            if ($('#egfrInvest').val() == 1) {
                egfrInvest();
            }
            if ($('#aborhInvest').val() == 1) {
                aborhInvest();
            }
            if ($('#semenInvest').val() == 1) {
                semenInvest();
            }
        }

    };
}();
