<?php

/*
 * awframework from aw.inc present aw controller
 * it will help you develop easy and fast with secure tools
 * you can edit and add what you feel right
 * don't change in strucure of file
 */
require_once("imp/_imp.php");

class Controllers {

    //public vars
    public $smarty;
    public $hosturl;
    public $controllname;
    public $shcontrollname;
    public $active;
    public $patientid;

    // it will run in everytime with
    // default requried
    public function __construct() {
	require_once("../public/aw_config.php");
	require_once("imp/_autho.php"); //general functions
	$this->smarty = $smarty;
	$this->hosturl = $hosturl;

	//here name of controll to known
	$this->controllname = 'ultrasound';
	$this->shcontrollname = 'ultrasound';
	$this->smarty->assign('controllname', $this->controllname);
	$this->smarty->assign('shcontrollname', $this->shcontrollname);

	//breadcrumbs
	require_once("../../_library/plugins/Breadcrumbs/Breadcrumbs.php");
	$acty = filter_input(INPUT_GET, 'ac');
	$bc = new breadcrumbs($hosturl, '', '', $acty);
	$bc->crumbs();
	$breadcrumbs = $bc->breadcrumbs;
	$smarty->assign('breadcrumbs', $breadcrumbs);

	# here show the active page in menu
	// array called active[] with level of active element
	$active[0] = 'Investigations'; //controller name or tab name
	$this->active = $active;


	//here will call all php pages
	require_once("_header.php");
	require_once("_patientdata.php");
	require_once("_sidebar.php");
	require_once("_leftsidebar.php");
	require_once("_footer.php");
	$this->patientid = patientdata::patientid();
    }

    //here the frist page and
    //the frist action in this class
    public function index() {
	//check login
	autho::checkautho($this->hosturl);
	//check authoize
	autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
	//here will load the menu show
	$doctorid = $_SESSION['user_id'];
	$doctorData = R::getRow('select * from awusers where user_id = ' . $doctorid);
	$this->smarty->assign('doctorData', $doctorData);

	$ProgramesettingData = R::findone('programesetting');
	$this->smarty->assign('ProgramesettingData', $ProgramesettingData);

	$today = date("Y-m-d");
	$this->smarty->assign('today', $today);

	$patientid = filter_input(INPUT_GET, "patientid");
	if (empty($this->patientid)) {
	    header('Location:' . $this->hosturl . '/controllers/index.php?empty=1');
	    exit();
	}

	$allultra = R::findAll('ultrasound', 'patientid = ? and del = 0 and done = 1', [$patientid]);
	foreach ($allultra as $data) {
	    $patientData = R::load("patients", $data->patientid);
	    $data->pname = $patientData->wifename;
	}

	//$patientid = 1;
	$this->smarty->assign('allultra', $allultra);
	$this->smarty->assign('patientid', $this->patientid);

	$patientData = R::load("patients", $patientid);


	header::headershow($this->smarty, $this->hosturl);
	sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
	patientdata::patientdatashow($this->smarty, $this->hosturl);
	$this->smarty->display('ultrasound/show.html');
	leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
	footer::footershow($this->smarty, $this->hosturl);
    }

    public function show() {
	//check login
	autho::checkautho($this->hosturl);
	//check authoize
	autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

	$patientId = filter_input(INPUT_GET, "patientid");

	$patientData = R::load("patients", $patientId);
	$patientData->dateofbirth = date("Y/m/d", strtotime($patientData->dateofbirth));
	$this->smarty->assign('patientData', $patientData);

	$id = filter_input(INPUT_GET, "id");

	$allSono = R::getAll('select * from awusers where positionid = 4');
	//$allSup = R::getAll('select * from awusers where positionid = 5');

	$ultrasoundData = R::load('ultrasound', $id);
	$ultrasoundDetail = R::findAll('ultrasounddetail', 'ultrasoundid = ? and del = 0', [$ultrasoundData->id]);

	$ultrasoundData->edate = date('Y/m/d', strtotime($ultrasoundData->edate));
	/* if ($ultrasoundData->stype == 0) {
	  $this->smarty->assign('allSname', $allSono);
	  } else {
	  $this->smarty->assign('allSname', $allSup);
	  } */

	$this->smarty->assign('allSname', $allSono);
	$this->smarty->assign('ultrasoundData', $ultrasoundData);
	$this->smarty->assign('ultrasoundDetail', $ultrasoundDetail);
	$this->smarty->assign('detailCount', count($ultrasoundDetail));

	header::headershow($this->smarty, $this->hosturl);
	sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
	patientdata::patientdatashow($this->smarty, $this->hosturl);
	$this->smarty->display('ultrasound/add.html');
	leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
	footer::footershow($this->smarty, $this->hosturl);
    }

    public function add() {
	//check login
	autho::checkautho($this->hosturl);
	//check authoize
	autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

	$patientId = filter_input(INPUT_GET, "patientid");

	$patientData = R::load("patients", $patientId);
	$patientData->dateofbirth = date("Y/m/d", strtotime($patientData->dateofbirth));
	$this->smarty->assign('patientData', $patientData);

	$allSono = R::getAll('select * from awusers where positionid = 4');
	//$allSup = R::getAll('select * from awusers where positionid = 5');

	$ultrasoundData = R::findOne('ultrasound', 'patientid = ? and del = 0 order by id desc limit 1', [$patientId]);
	$ultrasoundDetail;
	if (empty($ultrasoundData) || $ultrasoundData->done == 1) {
	    $today = date("Y-m-d");

	    $ultrasound = R::dispense('ultrasound');

	    $ultrasound->patientid = $patientId;
	    $ultrasound->del = 0;
	    $ultrasound->done = 0;
	    $ultrasound->edate = $today;
	    $ultrasound->stype = 0;
	    $ultrasound->sid = 0;
	    $ultrasound->based = 0;
	    $ultrasound->tcondition = 0;
	    $ultrasound->babyno = 1;

	    $id = R::store($ultrasound);

	    $ultrasoundData = R::load('ultrasound', $id);

	    $ultrasoundDetail = R::dispense("ultrasounddetail");

	    $ultrasoundDetail->del = 0;
	    $ultrasoundDetail->ultrasoundid = $id;
	    $ultrasoundDetail->relationc = 0;
	    $ultrasoundDetail->appearance = 0;
	    $ultrasoundDetail->fluid = 0;
	    $ultrasoundDetail->movement = 0;
	    $ultrasoundDetail->shape = 0;
	    $ultrasoundDetail->cavum = 0;
	    $ultrasoundDetail->falx = 0;
	    $ultrasoundDetail->thalami = 0;
	    $ultrasoundDetail->ventricle = 0;
	    $ultrasoundDetail->cerebellum = 0;
	    $ultrasoundDetail->magna = 0;
	    $ultrasoundDetail->uLip = 0;
	    $ultrasoundDetail->profile = 0;
	    $ultrasoundDetail->orbits = 0;
	    $ultrasoundDetail->nose = 0;
	    $ultrasoundDetail->nostrils = 0;
	    $ultrasoundDetail->neck = 0;
	    $ultrasoundDetail->thoraxshape = 0;
	    $ultrasoundDetail->mass = 0;
	    $ultrasoundDetail->heart = 0;
	    $ultrasoundDetail->heartactivity = 0;
	    $ultrasoundDetail->hsize = 0;
	    $ultrasoundDetail->haxix = 0;
	    $ultrasoundDetail->chamberview = 0;
	    $ultrasoundDetail->loutflow = 0;
	    $ultrasoundDetail->routflow = 0;
	    $ultrasoundDetail->stomach = 0;
	    $ultrasoundDetail->bowel = 0;
	    $ultrasoundDetail->kidney = 0;
	    $ultrasoundDetail->bladder = 0;
	    $ultrasoundDetail->cordinsertion = 0;
	    $ultrasoundDetail->cordvessels = 0;
	    $ultrasoundDetail->spine = 0;
	    $ultrasoundDetail->rarm = 0;
	    $ultrasoundDetail->rleg = 0;
	    $ultrasoundDetail->larm = 0;
	    $ultrasoundDetail->lleg = 0;
	    $ultrasoundDetail->gender = -1;
	    $ultrasoundDetail->gendern = 0;
	    $ultrasoundDetail->conclusion = 0;
	    $ultrasoundDetail->plans = 0;

	    $detailid = R::store($ultrasoundDetail);

	    $ultrasoundDetail = R::findAll('ultrasounddetail', 'ultrasoundid = ? and del = 0', [$id]);
	} else {
	    $ultrasoundData = R::findOne('ultrasound', 'patientid = ? and del =0 order by id desc limit 1', [$patientId]);
	    $ultrasoundDetail = R::findAll('ultrasounddetail', 'ultrasoundid = ? and del = 0', [$ultrasoundData->id]);
	}

	$ultrasoundData->edate = date('Y/m/d', strtotime($ultrasoundData->edate));
	/* if ($ultrasoundData->stype == 0) {
	  $this->smarty->assign('allSname', $allSono);
	  } else {
	  $this->smarty->assign('allSname', $allSup);
	  } */

	$this->smarty->assign('allSname', $allSono);
	$this->smarty->assign('ultrasoundData', $ultrasoundData);
	$this->smarty->assign('ultrasoundDetail', $ultrasoundDetail);
	$this->smarty->assign('detailCount', count($ultrasoundDetail));

	header::headershow($this->smarty, $this->hosturl);
	sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
	patientdata::patientdatashow($this->smarty, $this->hosturl);
	$this->smarty->display('ultrasound/add.html');
	leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
	footer::footershow($this->smarty, $this->hosturl);
    }

    public function update() {
	//check login
	autho::checkautho($this->hosturl);
	//check authoize
	autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

	$id = filter_input(INPUT_POST, "id");
	$value = filter_input(INPUT_POST, "value");
	$tableName = filter_input(INPUT_POST, "tableName");
	$colName = filter_input(INPUT_POST, "colName");
	$patientId = filter_input(INPUT_POST, "patientId");
	$dated = filter_input(INPUT_POST, "dated");

	if ($dated == 1) {
	    $value = date("Y-m-d", strtotime($value));
	}
	if ($tableName == "ultrasounddetail") {
	    $mydata = R::load($tableName, $id);
	} else {
	    $mydata = R::findone($tableName, 'id = ? and patientid = ?', [$id, $patientId]);
	}
	$mydata->$colName = $value;
	R::store($mydata);
    }

    public function showdetails() {
	//check login
	autho::checkautho($this->hosturl);
	//check authoize
	autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

	$id = filter_input(INPUT_POST, "id");

	$ultrasoundDetail = R::load('ultrasounddetail', $id);
	$this->smarty->assign('ultrasoundDetail', $ultrasoundDetail);
	$this->smarty->display('ultrasound/babymodel.html');
    }

    public function updateradio() {
	//check login
	autho::checkautho($this->hosturl);
	//check authoize
	autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

	$id = filter_input(INPUT_POST, "id");
	$value = filter_input(INPUT_POST, "value");
	$tableName = filter_input(INPUT_POST, "tableName");
	$colName = filter_input(INPUT_POST, "colName");


	$mydata = R::load($tableName, $id);
	$mydata->$colName = $value;
	R::store($mydata);

	/* if ($colName == "stype") {
	  $mydata = R::load($tableName, $id);
	  $mydata->sid = 0;
	  R::store($mydata);

	  $position;
	  if ($value == 0) {
	  $positin = 4;
	  }
	  if ($value == 1) {
	  $positin = 5;
	  }
	  $allSname = R::getAll('select * from awusers where positionid = ' . $positin);
	  }
	  $this->smarty->assign('allSname', $allSname);
	  $this->smarty->assign('id', $id);
	  $this->smarty->display('ultrasound/selects.html'); */
    }

    public function addDeteail() {
	//check login
	autho::checkautho($this->hosturl);
	//check authoize
	autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

	$id = filter_input(INPUT_POST, "id");

	$ultrasoundDetail = R::dispense("ultrasounddetail");

	$ultrasoundDetail->del = 0;
	$ultrasoundDetail->ultrasoundid = $id;
	$ultrasoundDetail->relationc = 0;
	$ultrasoundDetail->appearance = 0;
	$ultrasoundDetail->fluid = 0;
	$ultrasoundDetail->movement = 0;
	$ultrasoundDetail->shape = 0;
	$ultrasoundDetail->cavum = 0;
	$ultrasoundDetail->falx = 0;
	$ultrasoundDetail->thalami = 0;
	$ultrasoundDetail->ventricle = 0;
	$ultrasoundDetail->cerebellum = 0;
	$ultrasoundDetail->magna = 0;
	$ultrasoundDetail->uLip = 0;
	$ultrasoundDetail->profile = 0;
	$ultrasoundDetail->orbits = 0;
	$ultrasoundDetail->nose = 0;
	$ultrasoundDetail->nostrils = 0;
	$ultrasoundDetail->neck = 0;
	$ultrasoundDetail->thoraxshape = 0;
	$ultrasoundDetail->mass = 0;
	$ultrasoundDetail->heart = 0;
	$ultrasoundDetail->heartactivity = 0;
	$ultrasoundDetail->hsize = 0;
	$ultrasoundDetail->haxix = 0;
	$ultrasoundDetail->chamberview = 0;
	$ultrasoundDetail->loutflow = 0;
	$ultrasoundDetail->routflow = 0;
	$ultrasoundDetail->stomach = 0;
	$ultrasoundDetail->bowel = 0;
	$ultrasoundDetail->kidney = 0;
	$ultrasoundDetail->bladder = 0;
	$ultrasoundDetail->cordinsertion = 0;
	$ultrasoundDetail->cordvessels = 0;
	$ultrasoundDetail->spine = 0;
	$ultrasoundDetail->rarm = 0;
	$ultrasoundDetail->rleg = 0;
	$ultrasoundDetail->larm = 0;
	$ultrasoundDetail->lleg = 0;
	$ultrasoundDetail->gender = -1;
	$ultrasoundDetail->gendern = 0;
	$ultrasoundDetail->conclusion = 0;
	$ultrasoundDetail->plans = 0;

	$detailid = R::store($ultrasoundDetail);
	echo $detailid;
    }

    public function delData() {
	//check login
	autho::checkautho($this->hosturl);
	//check authoize
	autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

	$id = filter_input(INPUT_GET, "id");
	$tableName = filter_input(INPUT_GET, "tableName");
	$patientid = filter_input(INPUT_GET, "patientid");

	$myData = R::load($tableName, $id);
	$myData->del = 1;
	$myid = R::store($myData);

	$ultrasound = R::load('ultrasound', $myData->ultrasoundid);
	$no = $ultrasound->babyno;
	$no = --$no;
	$ultrasound->babyno = $no;
	R::store($ultrasound);

	if ($ultrasound->done == 0)
	    header('Location:' . $this->hosturl . '/controllers/' . $this->controllname . '.php?ac=add&patientid=' . $patientid);
	else
	    header('Location:' . $this->hosturl . '/controllers/' . $this->controllname . '.php?ac=show&patientid=' . $patientid . '&id=' . $ultrasound->id);
    }

    public function delRow() {
	//check login
	autho::checkautho($this->hosturl);
	//check authoize
	autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

	$id = filter_input(INPUT_GET, "id");
	$patientid = filter_input(INPUT_GET, "patientid");

	$myData = R::load('ultrasound', $id);
	$myData->del = 1;
	$myid = R::store($myData);

	header('Location:' . $this->hosturl . '/controllers/' . $this->controllname . '.php?patientid=' . $patientid);
    }

    public function showprint() {

	//check login
	autho::checkautho($this->hosturl);
	//check authoize
	autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

	$doctorid = $_SESSION['user_id'];
	$doctorData = R::getRow('select * from awusers where user_id = ' . $doctorid);
	$this->smarty->assign('doctorData', $doctorData);


	$id = filter_input(INPUT_POST, "id");
	$patientid = filter_input(INPUT_POST, "patientid");

	$ultrasoundDetail = R::load('ultrasounddetail', $id);
	$this->smarty->assign('ultrasoundDetail', $ultrasoundDetail);
	$ultrasoundData = R::load('ultrasound', $ultrasoundDetail->ultrasoundid);
	$this->smarty->assign('ultrasoundData', $ultrasoundData);

	$ProgramesettingData = R::findone('programesetting');
	$this->smarty->assign('ProgramesettingData', $ProgramesettingData);

	$patientData = R::load("patients", $patientid);
	$patientData->dateofbirth = date("Y/m/d", strtotime($patientData->dateofbirth));
	$this->smarty->assign('patientData', $patientData);

	$allSono = R::getAll('select * from awusers where positionid = 4');
	//$allSup = R::getAll('select * from awusers where positionid = 5');

	$ultrasoundData->edate = date('Y/m/d', strtotime($ultrasoundData->edate));
	/* if ($ultrasoundData->stype == 0) {
	  $this->smarty->assign('allSname', $allSono);
	  } else {
	  $this->smarty->assign('allSname', $allSup);
	  } */

	$mydata = R::load('ultrasound', $ultrasoundData->id);

	$mydata->done = 1;
	R::store($mydata);

	$this->smarty->assign('allSname', $allSono);
	$this->smarty->display('ultrasound/print.html');
    }

    public function onesetup() {

	//check login
	autho::checkautho($this->hosturl);

	try {
	    //delete all but with only default
	    #1 clean roles only managment
	    #2 clean menu only default
	    #3 clean controls only default
	    #4 users clean users
	    #delete all menus
	    $menus = R::findAll('awmenu', 'id > 15');
	    #delete from awrolemenu
	    foreach ($menus as $one) {
		//get propes
		$rolemenu = R::findAll('awrolemenu', 'menu_id = ?', [$one->id]);
		R::trashAll($rolemenu);
	    }
	    R::trashAll($menus);
	    #delete controles
	    $controlls = R::findAll('awcontroll', 'id > 4 and id < 18');
	    foreach ($controlls as $one) {
		//get propes
		$inprop = R::findAll('awcontrollprop', 'awcontroll_id = ?', [$one->id]);
		#delete from awrolecontroleprop
		foreach ($inprop as $one) {
		    //get propes
		    $roleprop = R::findAll('awrolecontrollprop', 'controllprop_id = ?', [$one->id]);
		    R::trashAll($roleprop);
		}
		R::trashAll($inprop);
	    }
	    R::trashAll($controlls);
	    #delete othre roles
	    $roles = R::findAll('awrole', 'id > 1');
	    R::trashAll($roles);
	    #delete other users
	    //$users = R::findAll('awusers', 'user_id > 1');
	    //R::exec('Delete from awusers where user_id > 1');
	    //R::trashAll($users);
	    ############################
	    //new one
	    $menusx = R::findAll('awmenu', ' id = 4 or id = 5 or id = 7 or id = 8 or id = 10 or id = 11 or id = 13 or id = 14 or id = 15 ');
	    #delete from awrolemenu
	    foreach ($menusx as $one) {
		//get propes
		$rolemenu = R::findAll('awrolemenu', 'menu_id = ?', [$one->id]);
		R::trashAll($rolemenu);
	    }
	    R::trashAll($menusx);

	    print_r('trash all , install is good');
	} catch (Exception $ex) {
	    print_r('something go wrong  , try again');
	}
    }

    // at the end of class call
    public function __destruct() {
	//close connection
	R::close();
    }

}
