<?php

/*
 * awframework from aw.inc present aw controller
 * it will help you develop easy and fast with secure tools
 * you can edit and add what you feel right
 * don't change in structure of file
 */

require_once("imp/_imp.php");

class Controllers {

   public $smarty;
   public $hosturl;
   public $controllname;
   public $shcontrollname;
   public $active;

   public function __construct() {
      require_once("../public/aw_config.php");
      require_once("imp/_autho.php"); //general functions
      $this->smarty = $smarty;
      $this->hosturl = $hosturl;

      $this->controllname = 'roomsreport';
      $this->shcontrollname = 'roomsreport';
      $this->smarty->assign('controllname', $this->controllname);
      $this->smarty->assign('shcontrollname', $this->shcontrollname);

      require_once("../../_library/plugins/Breadcrumbs/Breadcrumbs.php");
      $acty = filter_input(INPUT_GET, 'ac');
      $bc = new breadcrumbs($hosturl, '', '', $acty);
      $bc->crumbs();
      $breadcrumbs = $bc->breadcrumbs;
      $smarty->assign('breadcrumbs', $breadcrumbs);

      $active[0] = 'roomsreport'; //controller name or tab name
      $this->active = $active;

      R::ext('xdispense', function ($type) {
         return R::getRedBean()->dispense($type);
      });

      //   require_once("invsdept_common.php"); //general functions

      require_once("_header.php");
      require_once("_patientdata.php");
      require_once("_sidebar.php");
      require_once("_leftsidebar.php");
      require_once("_footer.php");
   }

   public function index() {
      //check login
      autho::checkautho($this->hosturl);
      //check authoize
      autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

      $time_now = date('H:i');
      $today = date('Y-m-d');

      //and (TIME(res_enterance_date) <= DATE_FORMAT("' . $today . ' ' . $time_now . '","%Y-%m-%d %H:%i"))
      //(DATE_FORMAT(res_p_exit,"%Y-%m-%d %H:%i") >= DATE_FORMAT("' . $today . ' ' . $time_now . '","%Y-%m-%d %H:%i"))

      $residenceRooms = R::findAll('residence_rooms', ' deleted != 1 ');

      // get ids of rooms from residence_rooms
      $roomsIds = array_map(static function ($room) {
         return $room->id;
      }, $residenceRooms);
      $roomsIds = implode(',', $roomsIds);
      // get rooms info from visits by ids

      $roomsInfo = R::getAll('select id , patientid , for_doctor , res_room_no   ,  for_husband  
         ,  res_enterance_date  , res_p_exit   , enterance   ,  p_exit  ,  detectionid  
                from visits where res_room_no in (' . $roomsIds . ')  and  for_department = 13 
                and res_enterance_date is not null and res_p_exit is null and deleted = 0 order by id desc');

//      $roomsInfo = R::findAll('visits', 'res_room_no in (' . $roomsIds . ') and  for_department = 13 
//                and res_enterance_date is not null and res_p_exit is null and deleted = 0 order by id desc');
      // get patients ids from rooms info
      $patientsIds = array_map(static function ($room) {
         return $room['patientid'];
      }, $roomsInfo);

      $patientsIdsCount = count($patientsIds);

      $patientsIds = implode(',', $patientsIds);
      // get patients info from patients by ids
      //  print_r($patientsIdsCount);
      if ($patientsIdsCount > 0) {
         $patientsInfo = R::findAll('patients', 'id in (' . $patientsIds . ')');
      }
      // get doctors ids from rooms info
      $doctorsIds = array_map(static function ($room) {
         return $room['for_doctor'];
      }, $roomsInfo);

      $doctorsIds = array_filter($doctorsIds, static function ($element) {
         return $element !== "";
      });

      $doctorsIdsCount = count($patientsIds);

      $doctorsIds = implode(',', $doctorsIds);
      // get doctors info from awusers by ids

      if ($doctorsIds > 0) {
         $doctorsInfo = R::getAll('select user_id,name from awusers where user_id in (' . $doctorsIds . ')');
      }

      foreach ($residenceRooms as $residenceRoom) {
         // old code
         //$roomInfo = R::findOne('visits', 'res_room_no = ? and res_enterance_date is not null and res_p_exit is null and deleted = 0 order by id desc', [$residenceRoom->id]);
         // get room info from rooms info
         $roomInfo = array_filter($roomsInfo, static function ($room) use ($residenceRoom) {
            return $room['res_room_no'] === $residenceRoom->id;
         });
         $roomInfo = reset($roomInfo);

         if ($roomInfo) {

            // get patient info from patients info
            $patientInfo = array_filter($patientsInfo, static function ($patient) use ($roomInfo) {
               return $patient->id === $roomInfo['patientid'];
            });
            $patientInfo = reset($patientInfo);

            // get doctor info from doctors info
            $doctorInfo = array_filter($doctorsInfo, static function ($doctor) use ($roomInfo) {
               return $doctor['user_id'] === $roomInfo['for_doctor'];
            });
            $doctorInfo = reset($doctorInfo);     //   

            $residenceRoom->patient_id = $roomInfo['patientid'];
            $residenceRoom->patient_name = ($roomInfo['for_husband'] == 1) ? $patientInfo->husdandname : $patientInfo->wifename;
            $residenceRoom->statusno = $patientInfo->statusno;
            $residenceRoom->doctor_name = $doctorInfo['name'];
            $enter_date = explode(' ', $roomInfo['res_enterance_date']);
            $enter_day = explode('/', $enter_date[0]);
            if (!empty($enter_date[1])) {
               $enter_time = new DateTime($enter_date[1]);
               $residenceRoom->enter_time = str_replace(['pm', 'am'], ['مساءً', 'صباحا'], $enter_time->format('h:i a')) . ' (' . $enter_day[2] . ') ';
            } else {
               $residenceRoom->enter_time = $enter_date[1];
            }

            $exit_date = explode(' ', $roomInfo['res_p_exit']);
            $exit_day = explode('/', $exit_date[0]);
            if (!empty($exit_date[1])) {
               $exit_time = new DateTime($exit_date[1]);
               $residenceRoom->exit_time = str_replace(['pm', 'am'], ['مساءً', 'صباحا'], $exit_time->format('h:i a')) . ' (' . $exit_day[2] . ') ';
            } else {
               $residenceRoom->exit_time = $exit_date[1];
            }


            if (!empty($roomInfo['enterance'])) {
               $op_enter_time = new DateTime($roomInfo['enterance']);
               $residenceRoom->op_enter_time = str_replace(['pm', 'am'], ['مساءً', 'صباحا'], $op_enter_time->format('h:i a'));
            } else {
               $residenceRoom->op_enter_time = $roomInfo['enterance'];
            }

            if (!empty($roomInfo['p_exit'])) {
               $op_exit_time = new DateTime($roomInfo['p_exit']);
               $residenceRoom->op_exit_time = str_replace(['pm', 'am'], ['مساءً', 'صباحا'], $op_exit_time->format('h:i a'));
            } else {
               $residenceRoom->op_exit_time = $roomInfo['p_exit'];
            }

            // detection id
            $detections = R::findOne('detections', 'id = ?', [$roomInfo['detectionid']]);
            $residenceRoom->op_type = $detections ? $detections->title : '';
         }
      }
      $this->smarty->assign('residence_rooms', $residenceRooms);

      header::headershow($this->smarty, $this->hosturl);
      sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
      $this->smarty->display('reports/rooms_report.tpl');
      leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
      footer::footershow($this->smarty, $this->hosturl);
   }

   public function show() {
      $room_id = filter_input(1, 'room_id');
      if (!$room_id) {
         $room_id = 6;
      }

      $time_now = date('H:i');
      $today = date('Y-m-d');
      //(TIME(res_enterance_date) <= DATE_FORMAT("' . $today . ' ' . $time_now . '","%Y-%m-%d %H:%i"))  and
      //(DATE_FORMAT(res_p_exit,"%Y-%m-%d %H:%i") >= DATE_FORMAT("' . $today . ' ' . $time_now . '","%Y-%m-%d %H:%i"))

      $residence_rooms = R::findAll('residence_rooms', 'floor_no = ? and deleted != 1 ', [$room_id]);
      foreach ($residence_rooms as $residence_room) {
         $room_info = R::findOne('visits', 'res_room_no = ? and  for_department = 13   and
        res_enterance_date is not null and res_p_exit is null and deleted = 0 order by id desc', [$residence_room->id]);
         if ($room_info) {
            $patient_info = R::findOne('patients', 'id = ?', [$room_info->patientid]);
            $doctor_info = R::findOne('awusers', 'user_id = ?', [$room_info->for_doctor]);
            $residence_room->patient_id = $patient_info->statusno;
            $residence_room->patient_name = ($room_info->for_husband == 1) ? $patient_info->husdandname : $patient_info->wifename;
            $residence_room->statusno = $patient_info->statusno;
            $residence_room->doctor_name = $doctor_info->name;
            $enter_date = explode(' ', $room_info->res_enterance_date);
            $enter_day = explode('/', $enter_date[0]);
            if (!empty($enter_date[1])) {
               $enter_time = new DateTime($enter_date[1]);
               $residence_room->enter_time = str_replace(['pm', 'am'], ['مساءً', 'صباحا'], $enter_time->format('h:i a')) . ' (' . $enter_day[2] . ') ';
            } else {
               $residence_room->enter_time = $enter_date[1];
            }

            $exit_date = explode(' ', $room_info->res_p_exit);
            $exit_day = explode('/', $exit_date[0]);
            if (!empty($exit_date[1])) {
               $exit_time = new DateTime($exit_date[1]);
               $residence_room->exit_time = str_replace(['pm', 'am'], ['مساءً', 'صباحا'], $exit_time->format('h:i a')) . ' (' . $exit_day[2] . ') ';
            } else {
               $residence_room->exit_time = $exit_date[1];
            }


            if (!empty($room_info->enterance)) {
               $op_enter_time = new DateTime($room_info->enterance);
               $residence_room->op_enter_time = str_replace(['pm', 'am'], ['مساءً', 'صباحا'], $op_enter_time->format('h:i a'));
            } else {
               $residence_room->op_enter_time = $room_info->enterance;
            }

            if (!empty($room_info->p_exit)) {
               $op_exit_time = new DateTime($room_info->p_exit);
               $residence_room->op_exit_time = str_replace(['pm', 'am'], ['مساءً', 'صباحا'], $op_exit_time->format('h:i a'));
            } else {
               $residence_room->op_exit_time = $room_info->p_exit;
            }


            // detection id
            $detections = R::findOne('detections', 'id = ?', [$room_info->detectionid]);
            $residence_room->op_type = $detections ? $detections->title : '';
         }
      }
      $this->smarty->assign('residence_rooms', $residence_rooms);

      $this->smarty->display('room_rp/rooms_rp_display.tpl');
   }

   // at the end of class call
   public function __destruct() {
      //close connection
      R::close();
   }
}
