<?php

// generate json web token
include_once '../../_public/api_config.php';
include_once '../../_library/php-jwt-master/src/BeforeValidException.php';
include_once '../../_library/php-jwt-master/src/ExpiredException.php';
include_once '../../_library/php-jwt-master/src/SignatureInvalidException.php';
include_once '../../_library/php-jwt-master/src/JWT.php';

use \Firebase\JWT\JWT;

$jwt = null;
foreach (getallheaders() as $name => $value) {
   if ($name == "Key") {
      $jwt = $value;
   }
}

try {
   $decoded_key = JWT::decode($jwt, getenv('api_key'), array('HS256'));
   if ($decoded_key->username === getenv('api_user')) {
      if ($decoded_key->password === getenv('api_password')) {
         //continue below
      } elseif ($decoded_key->password !== getenv('api_password')) {
         //echo "e1";
         header("HTTP/1.1 405 Method not NotAllowed");
         exit();
      }
   } else {
      //echo "e2";
      header("HTTP/1.1 405 Method not NotAllowed");
      exit();
   }
} catch (Exception $e) {
   //echo "e3";
   //echo $e->getTraceAsString();
   header("HTTP/1.1 405 Method not NotAllowed");
   exit();
}


$do = $_GET["ac"];

switch ($do) {
   case "onlineTests":
      onlineTests();
      break;

   case "onlineOffers":
      onlineOffers();
      break;

   case "onlineVisits":
      onlineVisits();
      break;

   default:
      break;
}



######################################################

function onlineTests() {
   $result = array("success" => 0, "error" => 0, "errorMsg" => '', "tests" => array());

   try {
      $result = loadOnlineTests($result);
      $result['error'] = 0;
      $result['success'] = 1;
      $result['errorMsg'] = "";
   } catch (Exception $ex) {
      $result['success'] = 0;
      $result['error'] = 1;
      $result['errorMsg'] = "Error !!!!!!!!!!!!!!!";
   }

   //print_r($result);
   echo json_encode($result);
}

function loadOnlineTests($result) {
   //    r::debug(true, 2);

   $invests = R::getAll('select invests.id ,  invests.name   ,  invests.name_ar  
                                                    from invests
                                                   join  investcats      on    investcats.id = invests.investcatid
                                                 where   invests.deleted = 0 and investcats.deleted = 0 
                                                           and invests.active_online = 1
                                                 order by   invests.periority  desc  , invests.name asc ');

   //  r::debug(false);
//    print_r($invests);

   $result['tests'] = $invests;
   return $result;
}

######################################################

function onlineOffers() {
   $result = array("success" => 0, "error" => 0, "errorMsg" => '', "offers" => array());

   try {
      $result = loadOnlineOffers($result);
      $result['error'] = 0;
      $result['success'] = 1;
      $result['errorMsg'] = "";
   } catch (Exception $ex) {
      $result['success'] = 0;
      $result['error'] = 1;
      $result['errorMsg'] = "Error !!!!!!!!!!!!!!!";
   }

   //print_r($result);
   echo json_encode($result);
}

function loadOnlineOffers($result) {
   //    r::debug(true, 2);

   $offers = R::getAll('select invoffer.id ,  invoffer.name     ,  invoffer.name_ar  
                                                    from invoffer
                                                 where   del = 0 and active = 1    and active_online = 1 ');

   $i = 0;
   foreach ($offers as $offer) {
      $invs = R::getRow('SELECT  sum(price) as price   FROM  invofferdetails where invoffer_id = ? and  del = ?  ', [$offer['id'], 0]);

      $offerInvests = R::getAll('select  invofferdetails.id , invests.name , invests.name_ar , invofferdetails.price  
                                                    from invofferdetails
                                                   join  invests            on    invests.id = invofferdetails.inv_id
                                                 where    invofferdetails.invoffer_id = ? and  invofferdetails.del = ? ', [$offer['id'], 0]);

      $offers[$i]['price'] = $invs['price'];
      $offers[$i]['offerInvests'] = $offerInvests;
      $i++;
   }

   //  r::debug(false);


   $result['offers'] = $offers;
   return $result;
}

######################################################

function onlineVisits() {
   $result = array("success" => 0, "error" => 0, "errorMsg" => '', "offers" => array());

   try {
      $result = addOnlineVisits($result);
      $result['error'] = 0;
      $result['success'] = 1;
      $result['errorMsg'] = "";
   } catch (Exception $ex) {
      $result['success'] = 0;
      $result['error'] = 1;
      $result['errorMsg'] = "Error !!!!!!!!!!!!!!!";
   }

   //print_r($result);
//   echo json_encode($result);
}

function addOnlineVisits() {
   $visitRequest = json_decode(file_get_contents("php://input"));
   print_r('<pre>');
   print_r($visitRequest);
   print_r('</pre>');
}
