<?php

require_once("imp/_imp.php");

class Controllers {

   //public vars
   public $smarty;
   public $hosturl;
   public $controllname;
   public $shcontrollname;
   public $active;
   public $time;
   public $today;
   public $patientid;

   // it will run in everytime with
   // default requried
   public function __construct() {
      require_once("../public/aw_config.php");
      require_once("imp/_autho.php"); //general functions
      $this->smarty = $smarty;
      $this->hosturl = $hosturl;

      //here name of controll to known
      $this->controllname = 'heart_reports';
      $this->shcontrollname = 'heart_reports';
      $this->smarty->assign('controllname', $this->controllname);
      $this->smarty->assign('shcontrollname', $this->shcontrollname);

      require_once("../../_library/plugins/classupload/uploadfunctions.php");

      //breadcrumbs
      require_once("../../_library/plugins/Breadcrumbs/Breadcrumbs.php");
      $acty = filter_input(INPUT_GET, 'ac');
      $bc = new breadcrumbs($hosturl, '', '', $acty);
      $bc->crumbs();
      $breadcrumbs = $bc->breadcrumbs;
      $smarty->assign('breadcrumbs', $breadcrumbs);

      # here show the active page in menu
      // array called active[] with level of active element
      $active[0] = 'heart_reports'; //controller name or tab name
      $active[1] = 'heart_reports'; //controller name
      // do name  // switch($do)
      switch ($acty) {
         case '':
            $active[2] = 'heart_reportsadd';
            break;
         case 'show':
            $active[2] = 'heart_reportsshow';
            break;
         default:
            $active[2] = 'heart_reportsshow';
            break;
      }
      $this->active = $active;

      R::ext('xdispense', function ($type) {
         return R::getRedBean()->dispense($type);
      });

      //here will call all php pages
      require_once("_header.php");
      require_once("_patientdata.php");
      require_once("_sidebar.php");
      require_once("_leftsidebar.php");
      require_once("_footer.php");
      require_once("fn_common.php"); //general functions

      $this->patientid = patientdata::patientid();

      //find loading time
      $this->time = microtime(true);
      $this->today = date('Y-m-d');
   }

   //======================Entry_data version 2=========================
   public function entryp_show() {
      //check login
      autho::checkautho($this->hosturl);
      //check authoize
      autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

      $patientid = filter_input(INPUT_GET, "patientid");
      $this->smarty->assign('patientId', $patientid);
      if (empty($this->patientid)) {
         header('Location:' . $this->hosturl . '/controllers/index.php?empty=1');
         exit();
      }


      $entry_data = R::getAll('select entry_data2.id  , entry_data2.entry_date  
                            from  entry_data2 
                            where entry_data2.deleted != 1 and entry_data2.completed =  1 
                            and patient_id = ' . $patientid);
      $this->smarty->assign('entry_data', $entry_data);

      //call other class with other content
      header::headershow($this->smarty, $this->hosturl);
      sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
      if ($patientid) {
         patientdata::patientdatashow($this->smarty, $this->hosturl);
      }

      $this->smarty->display('entry_data/entryp_show.html');
      leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
      footer::footershow($this->smarty, $this->hosturl);
   }

   public function entryp_add() {
      //check login
      autho::checkautho($this->hosturl);
      //check authoize
      autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

      $patientid = filter_input(INPUT_GET, "patientid");
      $visitId = (filter_input(INPUT_GET, 'visitId') > 0) ? filter_input(INPUT_GET, 'visitId') : 0;

      if (empty($patientid)) {
         header('Location:' . $this->hosturl . '/controllers/index.php?empty=1');
         exit();
      }


      if ($visitId > 0) {
         $entry_data = R::findOne('entry_data2', 'patient_id = ? and visit_id = ?', [$patientid, $visitId]);
         $visit = R::load('visits', $visitId);
         if (count($entry_data) <= 0) {
            $entry_data = R::xdispense('entry_data2');
            $entry_data->patient_id = $patientid;
            $entry_data->visit_id = $visitId;
            $entry_data->entry_date = $visit->visitdate;
            $entry_data->completed = 1;
            $entry_data->deleted = 0;
            $entry_data->user_id = $_SESSION['user_id'];

            $entry_data_id = R::store($entry_data);
         } else {
            $entry_data_id = $entry_data->id;
         }
      } else {

         $entry_data = R::findOne('entry_data2', 'patient_id = ? and completed = 0', [$patientid]);
         if (count($entry_data) <= 0) {
            $entry_data = R::xdispense('entry_data2');
            $entry_data->patient_id = $patientid;
            $entry_data->visit_id = 0;
            $entry_data->entry_date = $this->today;
            $entry_data->completed = 0;
            $entry_data->deleted = 0;
            $entry_data->user_id = $_SESSION['user_id'];

            $entry_data_id = R::store($entry_data);
         } else {
            $entry_data_id = $entry_data->id;
         }
      }

      $this->smarty->assign('is_add', 1);
      $this->smarty->assign('tableName', 'entry_data2');
      $this->smarty->assign('show', 'entryp_show');

      $this->loadEntryP($entry_data_id);

      header::headershow($this->smarty, $this->hosturl);
      sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
      if ($patientid) {
         patientdata::patientdatashow($this->smarty, $this->hosturl);
      }
      $this->smarty->display('entry_data/entryp_add.html');
      leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
      footer::footershow($this->smarty, $this->hosturl);
   }

   public function entryp_edit() {
      //check login
      autho::checkautho($this->hosturl);
      //check authoize
      autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

      $id = filter_input(INPUT_GET, "id");
      $patientid = filter_input(INPUT_GET, "patientid");

      $this->loadEntryP($id);

      header::headershow($this->smarty, $this->hosturl);
      sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
      if ($patientid) {
         patientdata::patientdatashow($this->smarty, $this->hosturl);
      }
      $this->smarty->display('entry_data/entryp_add.html');
      leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
      footer::footershow($this->smarty, $this->hosturl);
   }

   public function entryp_print() {
      //check login
      autho::checkautho($this->hosturl);
      //check authoize
      autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

      $id = filter_input(INPUT_POST, "id");
      $this->loadEntryPPrint($id);
      $this->smarty->assign('date', date("Y-m-d"));
      $this->smarty->display('entry_data/entryp_print.html');
   }

   function loadEntryP($entry_data_id) {

      $entry_data = R::getRow('select entry_data2.*   
                from entry_data2 
                where id = ' . $entry_data_id);

      $visit_id = $entry_data['visit_id'];

      if ($entry_data['visit_id'] == 0) {
         $visit_id = $this->patientLastVisit($entry_data['patient_id']);
         R::exec(' update entry_data2 set visit_id = ?   where id = ?  ', [$visit_id, $entry_data_id]);
      }


      if ($visit_id > 0) {
         $entry_data = $this->getVisitDetails($visit_id, $entry_data);
      }

      if (!empty($entry_data['entry_date']) && trim($entry_data['entry_date']) != '' && $entry_data['entry_date'] != null) {
         $entry_data['entry_date'] = date('Y/m/d', strtotime($entry_data['entry_date']));
      }


      $selectArray = explode(',', $entry_data['diagnosis']);
      $entry_data['diagnosis'] = $selectArray;

      $entry_types = R::getAll('select * from entry_type  where deleted = 0 ');
      $this->smarty->assign('entry_types', $entry_types);

      $entry_relations = R::getAll('select * from entry_relation  where deleted = 0 ');
      $this->smarty->assign('entry_relations', $entry_relations);

      $entry_exits = R::getAll('select * from entry_exit  where deleted = 0 ');
      $this->smarty->assign('entry_exits', $entry_exits);

      $entry_exit_cases = R::getAll('select * from entry_exit_case  where deleted = 0 ');
      $this->smarty->assign('entry_exit_cases', $entry_exit_cases);

      $this->getPatientData($entry_data['patient_id'], $entry_data['entry_date']);

      $this->smarty->assign('entry_data', $entry_data);
      $this->smarty->assign('patientId', $entry_data['patient_id']);

      $entryCount = R::getAll('select id   from entry_data2 
                where patient_id = ' . $entry_data['patient_id'] . '  and completed = 1 
              and deleted  = 0  and entry_date <  ' . $entry_data['entry_date']);
      if (count($entryCount) > 0) {
         $this->smarty->assign('entryBefore', 'Yes');
      } else {
         $this->smarty->assign('entryBefore', 'No');
      }

      $alldiagnosis = R::findall('diagnosis', 'conditions = 0 order by name');
      $this->smarty->assign('alldiagnosis', $alldiagnosis);

      $py_all_doc = R::getAll('select awusers.* from awusers
               join  awrole   on awrole.id =   awusers.role_id
                where awrole.is_doctor =  1 and deleted != 1  ');
      $this->smarty->assign('py_all_doc', $py_all_doc);
   }

   function loadEntryPPrint($entry_data_id) {
//      r::debug(true, 2);
      $entry_data = R::getRow('select entry_data2.*   , entry_type.name as entry_type 
          , entry_relation.name as entry_relation  , entry_exit.name as entry_exit  , entry_exit_case.name as entry_exit_case 
          , res.name as res_doctor 
                from entry_data2  
                 left join  entry_type                               on entry_data2.entry_type =   entry_type.id  
                 left join  entry_relation                           on entry_data2.entry_relation =   entry_relation.id 
                 left join  entry_exit                                 on entry_data2.entry_exit =   entry_exit.id 
                 left join  entry_exit_case                        on entry_data2.entry_exit_case =   entry_exit_case.id 
                 left join  awusers     res                         on entry_data2.res_doctor =   res.user_id 
                where entry_data2.id = ' . $entry_data_id);

      if ($entry_data['visit_id'] > 0) {
         $entry_data = $this->getVisitDetails($entry_data['visit_id'], $entry_data);
      }

      if (!empty($entry_data['entry_date']) && trim($entry_data['entry_date']) != '' && $entry_data['entry_date'] != null) {
         $entry_data['entry_date'] = date('Y/m/d', strtotime($entry_data['entry_date']));
      }

      $this->getPatientData($entry_data['patient_id'], $entry_data['entry_date']);

      $entry_data['diagnosis'] = $this->multiValues($entry_data['diagnosis'], 'diagnosis', 'id');

      $entryCount = R::getAll('select id   from entry_data2 
                where patient_id = ' . $entry_data['patient_id'] . '  and completed = 1 
              and deleted  = 0  and entry_date <  ' . $entry_data['entry_date']);
      if (count($entryCount) > 0) {
         $this->smarty->assign('entryBefore', 'Yes');
      } else {
         $this->smarty->assign('entryBefore', 'No');
      }

      $this->smarty->assign('entry_data', $entry_data);
   }

   function getPatientData($patientId, $endDate) {
      $patient = R::getRow('select patients.*  , wifestatus.title  as marriageStatus  , wifejobs.title  as wifeJob  
                from patients 
                left join  wifestatus                       on patients.statuesid =   wifestatus.id 
                left join  wifejobs                          on patients.wifejob =   wifejobs.id
                where patients.id = ' . $patientId);

      $this->getPatientAge($patient['dateofbirth'], $endDate);
      $this->smarty->assign('patient', $patient);
      $refDr = getReferredDrName($patient['refer_doctor'], $patient['refer_doctor_tb']);
      $this->smarty->assign('refDr', $refDr);
   }

   function getPatientAge($birthDate, $endDate) {
      $endDate = date('Y-m-d', strtotime($endDate));
      $date = new DateTime($date);

      if ($birthDate == '0000-00-00' || is_null($birthDate)) {
         $patAge = 0;
      } else {
         $dateWife = new DateTime($birthDate);
         $interva2 = $date->diff($dateWife);
         $patAge = $interva2->y;
      }
      $this->smarty->assign('patAge', $patAge);
      return $patAge;
   }

   //======================Adult Assessment ========================
   public function adult_show() {
      //check login
      autho::checkautho($this->hosturl);
      //check authoize
      autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
      $patientid = filter_input(INPUT_GET, "patientid");
      $this->smarty->assign('patientId', $patientid);
      if (empty($this->patientid)) {
         header('Location:' . $this->hosturl . '/controllers/index.php?empty=1');
         exit();
      }


      $adult_assessment = R::getAll('select adult_assessment.id  , adult_assessment.assessment_date  
                                from  adult_assessment 
                                where adult_assessment.deleted != 1 and adult_assessment.completed =  1 
                                and patient_id = ' . $patientid);
      $this->smarty->assign('adult_assessment', $adult_assessment);

      //call other class with other content
      header::headershow($this->smarty, $this->hosturl);
      sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
      if ($patientid) {
         patientdata::patientdatashow($this->smarty, $this->hosturl);
      }

      $this->smarty->display('heart_reports/adult_show.html');
      leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
      footer::footershow($this->smarty, $this->hosturl);
   }

   public function adult_add() {
      //check login
      autho::checkautho($this->hosturl);
      //check authoize
      autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

      $patientid = filter_input(INPUT_GET, "patientid");

      if (empty($patientid)) {
         header('Location:' . $this->hosturl . '/controllers/index.php?empty=1');
         exit();
      }

      $adult_assessment = R::findOne('adult_assessment', 'patient_id = ? and completed = 0', [$patientid]);
      if (count($adult_assessment) <= 0) {
         $adult_assessment = R::xdispense('adult_assessment');
         $adult_assessment->patient_id = $patientid;
         $adult_assessment->assessment_date = $this->today;
         $adult_assessment->completed = 0;
         $adult_assessment->deleted = 0;
         $adult_assessment->user_id = $_SESSION['user_id'];
         $adult_assessment_id = R::store($adult_assessment);
      } else {
         $adult_assessment_id = $adult_assessment->id;
      }

      $this->smarty->assign('is_add', 1);
      $this->smarty->assign('tableName', 'adult_assessment');
      $this->smarty->assign('show', 'adult_show');

      $this->loadadult($adult_assessment_id);

      header::headershow($this->smarty, $this->hosturl);
      sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
      if ($patientid) {
         patientdata::patientdatashow($this->smarty, $this->hosturl);
      }
      $this->smarty->display('heart_reports/adult_add.html');
      leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
      footer::footershow($this->smarty, $this->hosturl);
   }

   public function adult_edit() {
      //check login
      autho::checkautho($this->hosturl);
      //check authoize
      autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

      $adult_assessment_id = filter_input(INPUT_GET, "id");
      $patientid = filter_input(INPUT_GET, "patientid");

      $this->loadadult($adult_assessment_id);

      header::headershow($this->smarty, $this->hosturl);
      sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
      if ($patientid) {
         patientdata::patientdatashow($this->smarty, $this->hosturl);
      }
      $this->smarty->display('heart_reports/adult_add.html');
      leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
      footer::footershow($this->smarty, $this->hosturl);
   }

   public function adult_print() {
      //check login
      autho::checkautho($this->hosturl);
      //check authoize
      autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

      $adult_assessment_id = filter_input(INPUT_POST, "id");
      $this->loadadultPrint($adult_assessment_id);
      $this->smarty->assign('date', date("Y-m-d"));
      $this->smarty->display('heart_reports/adult_print.html');
   }

   function loadadult($adult_assessment_id) {

      $adult_assessment = R::getRow('select adult_assessment.*   
                    from adult_assessment 
                    where id = ' . $adult_assessment_id);

      if ($adult_assessment['visit_id'] == 0) {
         $visit_id = $this->patientLastVisit($adult_assessment['patient_id']);
         R::exec(' update adult_assessment set visit_id = ? where id = ?  ', [$visit_id, $adult_assessment_id]);
      }

      if (!empty($adult_assessment['assessment_date']) && trim($adult_assessment['assessment_date']) != '' && $adult_assessment['assessment_date'] != null) {
         $adult_assessment['assessment_date'] = date('Y/m/d', strtotime($adult_assessment['assessment_date']));
      }
      $selectArray = explode(',', $adult_assessment['present_history']);
      $adult_assessment['present_history'] = $selectArray;

      $selectArray = explode(',', $adult_assessment['present_illness']);
      $adult_assessment['present_illness'] = $selectArray;

      $selectArray = explode(',', $adult_assessment['comorbidities']);
      $adult_assessment['comorbidities'] = $selectArray;

      $selectArray = explode(',', $adult_assessment['prev_surgeries']);
      $adult_assessment['prev_surgeries'] = $selectArray;

      $selectArray = explode(',', $adult_assessment['allergies']);
      $adult_assessment['allergies'] = $selectArray;

      $selectArray = explode(',', $adult_assessment['vaccinations']);
      $adult_assessment['vaccinations'] = $selectArray;

      $selectArray = explode(',', $adult_assessment['family_history']);
      $adult_assessment['family_history'] = $selectArray;

      $this->smarty->assign('adult_assessment', $adult_assessment);
      $this->smarty->assign('patientId', $adult_assessment['patient_id']);

      $doctors = R::getAll('select awusers.* from awusers
                   join  awrole   on awrole.id =   awusers.role_id
                    where awrole.is_doctor =  1 and deleted != 1  ');
      $this->smarty->assign('doctors', $doctors);

      $allPresentHistory = R::getAll("select * from present_history where conditions = 0");
      $this->smarty->assign('allPresentHistory', $allPresentHistory);

      $allPresentIllness = R::getAll("select * from present_illness where conditions = 0");
      $this->smarty->assign('allPresentIllness', $allPresentIllness);

      $allComorbidities = R::getAll("select * from comorbidities where conditions = 0");
      $this->smarty->assign('allComorbidities', $allComorbidities);

      $allPrevSurgeries = R::getAll("select * from prev_surgeries where conditions = 0");
      $this->smarty->assign('allPrevSurgeries', $allPrevSurgeries);

      $allAllergies = R::getAll("select * from allergies where conditions = 0");
      $this->smarty->assign('allAllergies', $allAllergies);

      $allVaccinations = R::getAll("select * from vaccinations where conditions = 0");
      $this->smarty->assign('allVaccinations', $allVaccinations);

      $allFamilyhistory = R::getAll("select * from family_history where conditions = 0");
      $this->smarty->assign('allFamilyhistory', $allFamilyhistory);

      $this->loadDrugsData();
      $this->loadMed($adult_assessment_id, 'adult');
      $this->loadCarePlan($adult_assessment_id, 'adult');
   }

   function loadadultPrint($adult_assessment_id) {
      $adult_assessment = R::getRow('select adult_assessment.* from adult_assessment  where id = ' . $adult_assessment_id);
      if ($adult_assessment['visit_id'] == 0) {
         $visit_id = $this->patientLastVisit($adult_assessment['patient_id']);
         if ($visit_id > 0) {
            R::exec(' update adult_assessment set visit_id = ? where id = ?  ', [$visit_id, $adult_assessment_id]);
            $adult_assessment['visit_id'] = $visit_id;
         }
      }

      $this->patientInfo($adult_assessment['patient_id'], $adult_assessment['visit_id']);
      if (!empty($adult_assessment['assessment_date']) && trim($adult_assessment['assessment_date']) != '' && $adult_assessment['assessment_date'] != null) {
         $adult_assessment['assessment_date'] = date('Y/m/d', strtotime($adult_assessment['assessment_date']));
      }

      $adult_assessment['present_history'] = $this->multiValues($adult_assessment['present_history'], 'present_history', 'id');
      $adult_assessment['present_illness'] = $this->multiValues($adult_assessment['present_illness'], 'present_illness', 'id');
      $adult_assessment['comorbidities'] = $this->multiValues($adult_assessment['comorbidities'], 'comorbidities', 'id');
      $adult_assessment['prev_surgeries'] = $this->multiValues($adult_assessment['prev_surgeries'], 'prev_surgeries', 'id');
      $adult_assessment['vaccinations'] = $this->multiValues($adult_assessment['vaccinations'], 'vaccinations', 'id');
      $adult_assessment['family_history'] = $this->multiValues($adult_assessment['family_history'], 'family_history', 'id');
      $adult_assessment['allergies'] = $this->multiValues($adult_assessment['allergies'], 'allergies', 'id');
      if ($adult_assessment['allergies'] == ' ')
         $adult_assessment['allergies'] = "None";
      $this->smarty->assign('adult_assessment', $adult_assessment);

      $this->loadDrugsData();
      $this->loadMed($adult_assessment_id, 'adult');
      $this->loadCarePlan($adult_assessment_id, 'adult');
   }

   //======================Pediatric Assessment ========================
   public function ped_show() {
      //check login
      autho::checkautho($this->hosturl);
      //check authoize
      autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
      $patientid = filter_input(INPUT_GET, "patientid");
      $this->smarty->assign('patientId', $patientid);
      if (empty($this->patientid)) {
         header('Location:' . $this->hosturl . '/controllers/index.php?empty=1');
         exit();
      }


      $ped_assessment = R::getAll('select ped_assessment.id  , ped_assessment.assessment_date  
                                from  ped_assessment 
                                where ped_assessment.deleted != 1 and ped_assessment.completed =  1 
                                and patient_id = ' . $patientid);
      $this->smarty->assign('ped_assessment', $ped_assessment);

      //call other class with other content
      header::headershow($this->smarty, $this->hosturl);
      sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
      if ($patientid) {
         patientdata::patientdatashow($this->smarty, $this->hosturl);
      }

      $this->smarty->display('heart_reports/ped_show.html');
      leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
      footer::footershow($this->smarty, $this->hosturl);
   }

   public function ped_add() {
      //check login
      autho::checkautho($this->hosturl);
      //check authoize
      autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

      $patientid = filter_input(INPUT_GET, "patientid");

      if (empty($patientid)) {
         header('Location:' . $this->hosturl . '/controllers/index.php?empty=1');
         exit();
      }

      $ped_assessment = R::findOne('ped_assessment', 'patient_id = ? and completed = 0', [$patientid]);
      if (count($ped_assessment) <= 0) {
         $ped_assessment = R::xdispense('ped_assessment');
         $ped_assessment->patient_id = $patientid;
         $ped_assessment->assessment_date = $this->today;
         $ped_assessment->completed = 0;
         $ped_assessment->deleted = 0;
         $ped_assessment->user_id = $_SESSION['user_id'];
         $ped_assessment_id = R::store($ped_assessment);
      } else {
         $ped_assessment_id = $ped_assessment->id;
      }

      $this->smarty->assign('is_add', 1);
      $this->smarty->assign('tableName', 'ped_assessment');
      $this->smarty->assign('show', 'ped_show');

      $this->loadPed($ped_assessment_id);

      header::headershow($this->smarty, $this->hosturl);
      sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
      if ($patientid) {
         patientdata::patientdatashow($this->smarty, $this->hosturl);
      }
      $this->smarty->display('heart_reports/ped_add.html');
      leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
      footer::footershow($this->smarty, $this->hosturl);
   }

   public function ped_edit() {
      //check login
      autho::checkautho($this->hosturl);
      //check authoize
      autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

      $ped_assessment_id = filter_input(INPUT_GET, "id");
      $patientid = filter_input(INPUT_GET, "patientid");

      $this->loadPed($ped_assessment_id);

      header::headershow($this->smarty, $this->hosturl);
      sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
      if ($patientid) {
         patientdata::patientdatashow($this->smarty, $this->hosturl);
      }
      $this->smarty->display('heart_reports/ped_add.html');
      leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
      footer::footershow($this->smarty, $this->hosturl);
   }

   public function ped_print() {
      //check login
      autho::checkautho($this->hosturl);
      //check authoize
      autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

      $ped_assessment_id = filter_input(INPUT_POST, "id");
      $this->loadPedPrint($ped_assessment_id);
      $this->smarty->assign('date', date("Y-m-d"));
      $this->smarty->display('heart_reports/ped_print.html');
   }

   function loadPed($ped_assessment_id) {

      $ped_assessment = R::getRow('select ped_assessment.*   
                    from ped_assessment 
                    where id = ' . $ped_assessment_id);

      if ($ped_assessment['visit_id'] == 0) {
         $visit_id = $this->patientLastVisit($ped_assessment['patient_id']);
         R::exec(' update ped_assessment set visit_id = ? where id = ?  ', [$visit_id, $ped_assessment_id]);
      }

      if (!empty($ped_assessment['assessment_date']) && trim($ped_assessment['assessment_date']) != '' && $ped_assessment['assessment_date'] != null) {
         $ped_assessment['assessment_date'] = date('Y/m/d', strtotime($ped_assessment['assessment_date']));
      }

      $selectArray = explode(',', $ped_assessment['allergies']);
      $ped_assessment['allergies'] = $selectArray;

      $this->smarty->assign('ped_assessment', $ped_assessment);
      $this->smarty->assign('patientId', $ped_assessment['patient_id']);

      $doctors = R::getAll('select awusers.* from awusers
                   join  awrole   on awrole.id =   awusers.role_id
                    where awrole.is_doctor =  1 and deleted != 1  ');
      $this->smarty->assign('doctors', $doctors);

      $allCyanotic = R::getAll("select * from cyanotic where conditions = 0");
      $this->smarty->assign('allCyanotic', $allCyanotic);

      $allChestInfection = R::getAll("select * from chest_infection where conditions = 0");
      $this->smarty->assign('allChestInfection', $allChestInfection);

      $allExerciseTolerance = R::getAll("select * from exercise_tolerance where conditions = 0");
      $this->smarty->assign('allExerciseTolerance', $allExerciseTolerance);

      $allChestPain = R::getAll("select * from chest_pain where conditions = 0");
      $this->smarty->assign('allChestPain', $allChestPain);

      $allPalpitations = R::getAll("select * from palpitations where conditions = 0");
      $this->smarty->assign('allPalpitations', $allPalpitations);

      $allHospitalization = R::getAll("select * from hospitalization where conditions = 0");
      $this->smarty->assign('allHospitalization', $allHospitalization);

      $allEdema = R::getAll("select * from edema where conditions = 0");
      $this->smarty->assign('allEdema', $allEdema);

      $allPedCompOthers = R::getAll("select * from ped_comp_others where conditions = 0");
      $this->smarty->assign('allPedCompOthers', $allPedCompOthers);

      $allAllergies = R::getAll("select * from allergies where conditions = 0");
      $this->smarty->assign('allAllergies', $allAllergies);

      $this->loadDrugsData();
      $this->loadMed($ped_assessment_id, 'ped');
      $this->loadCarePlan($ped_assessment_id, 'ped');
   }

   function loadPedPrint($ped_assessment_id) {
      $ped_assessment = R::getRow('select ped_assessment.* from ped_assessment  where id = ' . $ped_assessment_id);
      if ($ped_assessment['visit_id'] == 0) {
         $visit_id = $this->patientLastVisit($ped_assessment['patient_id']);
         if ($visit_id > 0) {
            R::exec(' update ped_assessment set visit_id = ? where id = ?  ', [$visit_id, $ped_assessment_id]);
            $ped_assessment['visit_id'] = $visit_id;
         }
      }

      $this->patientInfo($ped_assessment['patient_id'], $ped_assessment['visit_id']);
      if (!empty($ped_assessment['assessment_date']) && trim($ped_assessment['assessment_date']) != '' && $ped_assessment['assessment_date'] != null) {
         $ped_assessment['assessment_date'] = date('Y/m/d', strtotime($ped_assessment['assessment_date']));
      }
      if ($ped_assessment['cyanotic'])
         $ped_assessment['cyanotic'] = R::findOne('cyanotic', 'id = ' . $ped_assessment['cyanotic'])->name;
      if ($ped_assessment['chest_infection'])
         $ped_assessment['chest_infection'] = R::findOne('chest_infection', 'id = ' . $ped_assessment['chest_infection'])->name;
      if ($ped_assessment['exercise_tolerance'])
         $ped_assessment['exercise_tolerance'] = R::findOne('exercise_tolerance', 'id = ' . $ped_assessment['exercise_tolerance'])->name;
      if ($ped_assessment['chest_pain'])
         $ped_assessment['chest_pain'] = R::findOne('chest_pain', 'id = ' . $ped_assessment['chest_pain'])->name;
      if ($ped_assessment['palpitations'])
         $ped_assessment['palpitations'] = R::findOne('palpitations', 'id = ' . $ped_assessment['palpitations'])->name;
      if ($ped_assessment['hospitalization'])
         $ped_assessment['hospitalization'] = R::findOne('hospitalization', 'id = ' . $ped_assessment['hospitalization'])->name;
      if ($ped_assessment['edema'])
         $ped_assessment['edema'] = R::findOne('edema', 'id = ' . $ped_assessment['edema'])->name;

      $ped_assessment['allergies'] = $this->multiValues($ped_assessment['allergies'], 'allergies', 'id');
      if ($ped_assessment['allergies'] == ' ')
         $ped_assessment['allergies'] = "None";
      $this->smarty->assign('ped_assessment', $ped_assessment);

      $this->loadDrugsData();
      $this->loadMed($ped_assessment_id, 'ped');
      $this->loadCarePlan($ped_assessment_id, 'ped');
   }

   //======================Chloral Hydrate=========================

   public function chloral_show() {
      //check login
      autho::checkautho($this->hosturl);
      //check authoize
      autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
      $patientid = filter_input(INPUT_GET, "patientid");
      $this->smarty->assign('patientId', $patientid);
      if (empty($this->patientid)) {
         header('Location:' . $this->hosturl . '/controllers/index.php?empty=1');
         exit();
      }


      $chloral_sheet = R::getAll('select chloral_sheet.id  , chloral_sheet.sheet_date  
                                from  chloral_sheet 
                                where chloral_sheet.deleted != 1 and chloral_sheet.completed =  1 
                                and patient_id = ' . $patientid);
      $this->smarty->assign('chloral_sheet', $chloral_sheet);

      //call other class with other content
      header::headershow($this->smarty, $this->hosturl);
      sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
      if ($patientid) {
         patientdata::patientdatashow($this->smarty, $this->hosturl);
      }

      $this->smarty->display('heart_reports/chloral_show.html');
      leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
      footer::footershow($this->smarty, $this->hosturl);
   }

   public function chloral_add() {
      //check login
      autho::checkautho($this->hosturl);
      //check authoize
      autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

      $patientid = filter_input(INPUT_GET, "patientid");

      if (empty($patientid)) {
         header('Location:' . $this->hosturl . '/controllers/index.php?empty=1');
         exit();
      }

      $chloral_sheet = R::findOne('chloral_sheet', 'patient_id = ? and completed = 0', [$patientid]);
      if (count($chloral_sheet) <= 0) {
         $chloral_sheet = R::xdispense('chloral_sheet');
         $chloral_sheet->patient_id = $patientid;
         $chloral_sheet->sheet_date = $this->today;
         $chloral_sheet->completed = 0;
         $chloral_sheet->deleted = 0;
         $chloral_sheet->user_id = $_SESSION['user_id'];
         $chloral_sheet_id = R::store($chloral_sheet);
      } else {
         $chloral_sheet_id = $chloral_sheet->id;
      }

      $this->smarty->assign('is_add', 1);
      $this->smarty->assign('tableName', 'chloral_sheet');
      $this->smarty->assign('show', 'chloral_show');

      $this->loadChloral($chloral_sheet_id);

      header::headershow($this->smarty, $this->hosturl);
      sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
      if ($patientid) {
         patientdata::patientdatashow($this->smarty, $this->hosturl);
      }
      $this->smarty->display('heart_reports/chloral_add.html');
      leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
      footer::footershow($this->smarty, $this->hosturl);
   }

   public function chloral_edit() {
      //check login
      autho::checkautho($this->hosturl);
      //check authoize
      autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

      $chloral_sheet_id = filter_input(INPUT_GET, "id");
      $patientid = filter_input(INPUT_GET, "patientid");

      $this->loadChloral($chloral_sheet_id);

      header::headershow($this->smarty, $this->hosturl);
      sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
      if ($patientid) {
         patientdata::patientdatashow($this->smarty, $this->hosturl);
      }
      $this->smarty->display('heart_reports/chloral_add.html');
      leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
      footer::footershow($this->smarty, $this->hosturl);
   }

   public function chloral_print() {
      //check login
      autho::checkautho($this->hosturl);
      //check authoize
      autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

      $chloral_sheet_id = filter_input(INPUT_POST, "id");
      $this->loadChloralPrint($chloral_sheet_id);
      $this->smarty->assign('date', date("Y-m-d"));
      $this->smarty->display('heart_reports/chloral_print.html');
   }

   function loadChloral($chloral_sheet_id) {

      $chloral_sheet = R::getRow('select chloral_sheet.*   
                    from chloral_sheet 
                    where id = ' . $chloral_sheet_id);

      if ($chloral_sheet['visit_id'] == 0) {
         $visit_id = $this->patientLastVisit($chloral_sheet['patient_id']);
         R::exec(' update chloral_sheet set visit_id = ? where id = ?  ', [$visit_id, $chloral_sheet_id]);
      }

      if (!empty($chloral_sheet['sheet_date']) && trim($chloral_sheet['sheet_date']) != '' && $chloral_sheet['sheet_date'] != null) {
         $chloral_sheet['sheet_date'] = date('Y/m/d', strtotime($chloral_sheet['sheet_date']));
      }

      $selectArray = explode(',', $chloral_sheet['allergies']);
      $chloral_sheet['allergies'] = $selectArray;

      $this->smarty->assign('chloral_sheet', $chloral_sheet);
      $this->smarty->assign('patientId', $chloral_sheet['patient_id']);

      $doctors = R::getAll('select awusers.* from awusers
                   join  awrole   on awrole.id =   awusers.role_id
                    where awrole.is_doctor =  1 and deleted != 1  ');
      $this->smarty->assign('doctors', $doctors);

      $allAllergies = R::getAll("select * from allergies where conditions = 0");
      $this->smarty->assign('allAllergies', $allAllergies);

      $this->loadDrugsData();
      $this->loadMed($chloral_sheet_id, 'chloral');
   }

   function loadChloralPrint($chloral_sheet_id) {
      $chloral_sheet = R::getRow('select chloral_sheet.* from chloral_sheet  where id = ' . $chloral_sheet_id);
      if ($chloral_sheet['visit_id'] == 0) {
         $visit_id = $this->patientLastVisit($chloral_sheet['patient_id']);
         if ($visit_id > 0) {
            R::exec(' update chloral_sheet set visit_id = ? where id = ?  ', [$visit_id, $chloral_sheet_id]);
            $chloral_sheet['visit_id'] = $visit_id;
         }
      }
      if ($chloral_sheet['bp_before']) {
         $chloral_sheet['bp_before'] = substr($chloral_sheet['bp_before'], 0, 3) . '/' . substr($chloral_sheet['bp_before'], 3, 3);
      }
      if ($chloral_sheet['bp_after']) {
         $chloral_sheet['bp_after'] = substr($chloral_sheet['bp_after'], 0, 3) . '/' . substr($chloral_sheet['bp_after'], 3, 3);
      }

      $this->patientInfo($chloral_sheet['patient_id'], $chloral_sheet['visit_id']);
      if (!empty($chloral_sheet['sheet_date']) && trim($chloral_sheet['sheet_date']) != '' && $chloral_sheet['sheet_date'] != null) {
         $chloral_sheet['sheet_date'] = date('Y/m/d', strtotime($chloral_sheet['sheet_date']));
      }
      if (!empty($chloral_sheet['last_feed']) && trim($chloral_sheet['last_feed']) != '' && $chloral_sheet['last_feed'] != null) {
         $chloral_sheet['last_feed'] = date('Y/m/d h:i a', strtotime($chloral_sheet['last_feed']));
      }

      $chloral_sheet['allergies'] = $this->multiValues($chloral_sheet['allergies'], 'allergies', 'id');
      if ($chloral_sheet['allergies'] == ' ')
         $chloral_sheet['allergies'] = "None";

      $this->loadDrugsData();
      $this->loadMed($chloral_sheet_id, 'chloral');
      $this->smarty->assign('chloral_sheet', $chloral_sheet);
   }

   //======================Helth_Educate=========================
   public function educate_show() {
      //check login
      autho::checkautho($this->hosturl);
      //check authoize
      autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
      $patientid = filter_input(INPUT_GET, "patientid");
      $this->smarty->assign('patientId', $patientid);
      if (empty($this->patientid)) {
         header('Location:' . $this->hosturl . '/controllers/index.php?empty=1');
         exit();
      }


      $educate_health = R::getAll('select educate_health.id  , educate_health.educate_date  
                                from  educate_health 
                                where educate_health.deleted != 1 and educate_health.completed =  1 
                                and patient_id = ' . $patientid);
      $this->smarty->assign('educate_health', $educate_health);

      //call other class with other content
      header::headershow($this->smarty, $this->hosturl);
      sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
      if ($patientid) {
         patientdata::patientdatashow($this->smarty, $this->hosturl);
      }

      $this->smarty->display('heart_reports/educate_show.html');
      leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
      footer::footershow($this->smarty, $this->hosturl);
   }

   public function educate_add() {
      //check login
      autho::checkautho($this->hosturl);
      //check authoize
      autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

      $patientid = filter_input(INPUT_GET, "patientid");

      if (empty($patientid)) {
         header('Location:' . $this->hosturl . '/controllers/index.php?empty=1');
         exit();
      }

      $educate_health = R::findOne('educate_health', 'patient_id = ? and completed = 0', [$patientid]);
      if (count($educate_health) <= 0) {
         $educate_health = R::xdispense('educate_health');
         $educate_health->patient_id = $patientid;
         $educate_health->educate_date = $this->today;
         $educate_health->completed = 0;
         $educate_health->deleted = 0;
         $educate_health->user_id = $_SESSION['user_id'];
         $educate_health_id = R::store($educate_health);
      } else {
         $educate_health_id = $educate_health->id;
      }

      $this->smarty->assign('is_add', 1);
      $this->smarty->assign('tableName', 'educate_health');
      $this->smarty->assign('show', 'educate_show');

      $this->loadEducate($educate_health_id);

      header::headershow($this->smarty, $this->hosturl);
      sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
      if ($patientid) {
         patientdata::patientdatashow($this->smarty, $this->hosturl);
      }
      $this->smarty->display('heart_reports/educate_add.html');
      leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
      footer::footershow($this->smarty, $this->hosturl);
   }

   public function educate_edit() {
      //check login
      autho::checkautho($this->hosturl);
      //check authoize
      autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

      $educate_health_id = filter_input(INPUT_GET, "id");
      $patientid = filter_input(INPUT_GET, "patientid");

      $this->loadEducate($educate_health_id);

      header::headershow($this->smarty, $this->hosturl);
      sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
      if ($patientid) {
         patientdata::patientdatashow($this->smarty, $this->hosturl);
      }
      $this->smarty->display('heart_reports/educate_add.html');
      leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
      footer::footershow($this->smarty, $this->hosturl);
   }

   public function educate_print() {
      //check login
      autho::checkautho($this->hosturl);
      //check authoize
      autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

      $educate_health_id = filter_input(INPUT_POST, "id");
      $this->loadEducatePrint($educate_health_id);
      $this->smarty->assign('date', date("Y-m-d"));
      $this->smarty->display('heart_reports/educate_print.html');
   }

   function loadEducate($educate_health_id) {

      $educate_health = R::getRow('select educate_health.*   
                    from educate_health 
                    where id = ' . $educate_health_id);

      if ($educate_health['visit_id'] == 0) {
         $visit_id = $this->patientLastVisit($educate_health['patient_id']);
         R::exec(' update educate_health set visit_id = ? where id = ?  ', [$visit_id, $educate_health_id]);
      }

      if (!empty($educate_health['educate_date']) && trim($educate_health['educate_date']) != '' && $educate_health['educate_date'] != null) {
         $educate_health['educate_date'] = date('Y/m/d', strtotime($educate_health['educate_date']));
      }

      $allLanguage = R::getAll("select * from language where conditions = 0");
      $this->smarty->assign('allLanguage', $allLanguage);

      $this->smarty->assign('educate_health', $educate_health);
      $this->smarty->assign('patientId', $educate_health['patient_id']);

      $doctors = R::getAll('select awusers.* from awusers
                   join  awrole   on awrole.id =   awusers.role_id
                    where awrole.is_doctor =  1 and deleted != 1  ');
      $this->smarty->assign('doctors', $doctors);
   }

   function loadEducatePrint($educate_health_id) {
      $educate_health = R::getRow('select educate_health.* from educate_health  where id = ' . $educate_health_id);
      if ($educate_health['visit_id'] == 0) {
         $visit_id = $this->patientLastVisit($educate_health['patient_id']);
         if ($visit_id > 0) {
            R::exec(' update educate_health set visit_id = ? where id = ?  ', [$visit_id, $educate_health_id]);
            $educate_health['visit_id'] = $visit_id;
         }
      }


      $this->patientInfo($educate_health['patient_id'], $educate_health['visit_id']);
      if (!empty($educate_health['educate_date']) && trim($educate_health['educate_date']) != '' && $educate_health['educate_date'] != null) {
         $educate_health['educate_date'] = date('Y/m/d', strtotime($educate_health['educate_date']));
      }

      if ($educate_health['language'])
         $educate_health['language'] = R::findOne('language', 'id = ' . $educate_health['language'])->name;
      $this->smarty->assign('educate_health', $educate_health);
   }

   //======================Entry_data=========================
   public function entry_show() {
      //check login
      autho::checkautho($this->hosturl);
      //check authoize
      autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
      $patientid = filter_input(INPUT_GET, "patientid");
      $this->smarty->assign('patientId', $patientid);
      if (empty($this->patientid)) {
         header('Location:' . $this->hosturl . '/controllers/index.php?empty=1');
         exit();
      }


      $entry_data = R::getAll('select entry_data.id  , entry_data.entry_date  
                            from  entry_data 
                            where entry_data.deleted != 1 and entry_data.completed =  1 
                            and patient_id = ' . $patientid);
      $this->smarty->assign('entry_data', $entry_data);

      //call other class with other content
      header::headershow($this->smarty, $this->hosturl);
      sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
      if ($patientid) {
         patientdata::patientdatashow($this->smarty, $this->hosturl);
      }

      $this->smarty->display('heart_reports/entry_show.html');
      leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
      footer::footershow($this->smarty, $this->hosturl);
   }

   public function entry_add() {
      //check login
      autho::checkautho($this->hosturl);
      //check authoize
      autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

      $patientid = filter_input(INPUT_GET, "patientid");

      if (empty($patientid)) {
         header('Location:' . $this->hosturl . '/controllers/index.php?empty=1');
         exit();
      }



      $entry_data = R::findOne('entry_data', 'patient_id = ? and completed = 0', [$patientid]);
      if (count($entry_data) <= 0) {
         $patientData = R::load('patients', $patientid);

         $entry_data = R::xdispense('entry_data');
         $entry_data->patient_id = $patientid;
         $entry_data->entry_date = $this->today;
         $entry_data->completed = 0;
         $entry_data->deleted = 0;
         $entry_data->user_id = $_SESSION['user_id'];

         if ($patientData->wifeage)
            $entry_data->age = $patientData->wifeage;
         if (isset($patientData->gender)) {
            if ($patientData->gender == 0)
               $entry_data->gender = "female";
            else
               $entry_data->gender = "male";
         }
         if (isset($patientData->statuesid)) {
            $wifestatus = R::load('wifestatus', $patientData->statuesid);
            $entry_data->marital_status = $wifestatus->title;
         }
         if ($patientData->religion)
            $entry_data->religion = $patientData->religion;
         if ($patientData->wifejob) {
            $wifejobs = R::load('wifejobs', $patientData->wifejob);
            $entry_data->job = $wifejobs->title;
         }
         if ($patientData->address)
            $entry_data->address = $patientData->address;

         if ($patientData->governorate) {
            $governorates = R::load('governorate', $patientData->governorate);
            $entry_data->governorate = $governorates->name;
         }
         if ($patientData->governorate_center) {
            $center = R::load('governorate_centers', $patientData->governorate_center);
            $entry_data->city = $center->name;
         }
         if ($patientData->phone)
            $entry_data->phone = $patientData->phone;

         if ($patientData->doctor1) {
            $doctor = R::findOne("awusers", 'user_id = ' . $patientData->doctor1);
            $entry_data->doctor = $doctor->name;
         }
         $entry_data_id = R::store($entry_data);
      } else {
         $entry_data_id = $entry_data->id;
      }

      $this->smarty->assign('is_add', 1);
      $this->smarty->assign('tableName', 'entry_data');
      $this->smarty->assign('show', 'entry_show');

      $this->loadEntry($entry_data_id);

      header::headershow($this->smarty, $this->hosturl);
      sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
      if ($patientid) {
         patientdata::patientdatashow($this->smarty, $this->hosturl);
      }
      $this->smarty->display('heart_reports/entry_add.html');
      leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
      footer::footershow($this->smarty, $this->hosturl);
   }

   public function entry_edit() {
      //check login
      autho::checkautho($this->hosturl);
      //check authoize
      autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

      $entry_data_id = filter_input(INPUT_GET, "id");
      $patientid = filter_input(INPUT_GET, "patientid");

      $this->loadEntry($entry_data_id);

      header::headershow($this->smarty, $this->hosturl);
      sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
      if ($patientid) {
         patientdata::patientdatashow($this->smarty, $this->hosturl);
      }
      $this->smarty->display('heart_reports/entry_add.html');
      leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
      footer::footershow($this->smarty, $this->hosturl);
   }

   public function entry_print() {
      //check login
      autho::checkautho($this->hosturl);
      //check authoize
      autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

      $entry_data_id = filter_input(INPUT_POST, "id");
      $this->loadEntryPrint($entry_data_id);
      $this->smarty->assign('date', date("Y-m-d"));
      $this->smarty->display('heart_reports/entry_print.html');
   }

   function loadEntry($entry_data_id) {

      $entry_data = R::getRow('select entry_data.*   
                from entry_data 
                where id = ' . $entry_data_id);

      if ($entry_data['visit_id'] == 0) {
         $visit_id = $this->patientLastVisit($entry_data['patient_id']);
         R::exec(' update entry_data set visit_id = ? where id = ?  ', [$visit_id, $entry_data_id]);
      }

      if (!empty($entry_data['entry_date']) && trim($entry_data['entry_date']) != '' && $entry_data['entry_date'] != null) {
         $entry_data['entry_date'] = date('Y/m/d', strtotime($entry_data['entry_date']));
      }

      $this->smarty->assign('entry_data', $entry_data);
      $this->smarty->assign('patientId', $entry_data['patient_id']);

      $doctors = R::getAll('select awusers.* from awusers
               join  awrole   on awrole.id =   awusers.role_id
                where awrole.is_doctor =  1 and deleted != 1  ');
      $this->smarty->assign('doctors', $doctors);
   }

   function loadEntryPrint($entry_data_id) {
      $entry_data = R::getRow('select entry_data.* from entry_data  where id = ' . $entry_data_id);
      if ($entry_data['visit_id'] == 0) {
         $visit_id = $this->patientLastVisit($entry_data['patient_id']);
         if ($visit_id > 0) {
            R::exec(' update entry_data set visit_id = ? where id = ?  ', [$visit_id, $entry_data_id]);
            $entry_data['visit_id'] = $visit_id;
         }
      }

      $this->patientInfo($entry_data['patient_id'], $entry_data['visit_id']);
      if (!empty($entry_data['entry_date']) && trim($entry_data['entry_date']) != '' && $entry_data['entry_date'] != null) {
         $entry_data['entry_date'] = date('Y/m/d', strtotime($entry_data['entry_date']));
      }
      $this->smarty->assign('entry_data', $entry_data);
   }

   //======================Falling Sheet=========================

   public function falling_show() {
      //check login
      autho::checkautho($this->hosturl);
      //check authoize
      autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
      $patientid = filter_input(INPUT_GET, "patientid");
      $this->smarty->assign('patientId', $patientid);
      if (empty($this->patientid)) {
         header('Location:' . $this->hosturl . '/controllers/index.php?empty=1');
         exit();
      }


      $falling_sheet = R::getAll('select falling_sheet.id  , falling_sheet.sheet_date  
                                from  falling_sheet 
                                where falling_sheet.deleted != 1 and falling_sheet.completed =  1 
                                and patient_id = ' . $patientid);
      $this->smarty->assign('falling_sheet', $falling_sheet);

      //call other class with other content
      header::headershow($this->smarty, $this->hosturl);
      sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
      if ($patientid) {
         patientdata::patientdatashow($this->smarty, $this->hosturl);
      }

      $this->smarty->display('heart_reports/falling_show.html');
      leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
      footer::footershow($this->smarty, $this->hosturl);
   }

   public function falling_add() {
      //check login
      autho::checkautho($this->hosturl);
      //check authoize
      autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

      $patientid = filter_input(INPUT_GET, "patientid");

      if (empty($patientid)) {
         header('Location:' . $this->hosturl . '/controllers/index.php?empty=1');
         exit();
      }

      $falling_sheet = R::findOne('falling_sheet', 'patient_id = ? and completed = 0', [$patientid]);
      if (count($falling_sheet) <= 0) {
         $falling_sheet = R::xdispense('falling_sheet');
         $falling_sheet->patient_id = $patientid;
         $falling_sheet->sheet_date = $this->today;
         $falling_sheet->completed = 0;
         $falling_sheet->deleted = 0;
         $falling_sheet->user_id = $_SESSION['user_id'];
         $falling_sheet_id = R::store($falling_sheet);
      } else {
         $falling_sheet_id = $falling_sheet->id;
      }

      $this->smarty->assign('is_add', 1);
      $this->smarty->assign('tableName', 'falling_sheet');
      $this->smarty->assign('show', 'falling_show');

      $this->loadFalling($falling_sheet_id);

      header::headershow($this->smarty, $this->hosturl);
      sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
      if ($patientid) {
         patientdata::patientdatashow($this->smarty, $this->hosturl);
      }
      $this->smarty->display('heart_reports/falling_add.html');
      leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
      footer::footershow($this->smarty, $this->hosturl);
   }

   public function falling_edit() {
      //check login
      autho::checkautho($this->hosturl);
      //check authoize
      autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

      $falling_sheet_id = filter_input(INPUT_GET, "id");
      $patientid = filter_input(INPUT_GET, "patientid");

      $this->loadFalling($falling_sheet_id);

      header::headershow($this->smarty, $this->hosturl);
      sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
      if ($patientid) {
         patientdata::patientdatashow($this->smarty, $this->hosturl);
      }
      $this->smarty->display('heart_reports/falling_add.html');
      leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
      footer::footershow($this->smarty, $this->hosturl);
   }

   public function falling_print() {
      //check login
      autho::checkautho($this->hosturl);
      //check authoize
      autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

      $falling_sheet_id = filter_input(INPUT_POST, "id");
      $this->loadFallingPrint($falling_sheet_id);
      $this->smarty->assign('date', date("Y-m-d"));
      $this->smarty->display('heart_reports/falling_print.html');
   }

   function loadFalling($falling_sheet_id) {

      $falling_sheet = R::getRow('select falling_sheet.*   
                    from falling_sheet 
                    where id = ' . $falling_sheet_id);

      if ($falling_sheet['visit_id'] == 0) {
         $visit_id = $this->patientLastVisit($falling_sheet['patient_id']);
         R::exec(' update falling_sheet set visit_id = ? where id = ?  ', [$visit_id, $falling_sheet_id]);
      }

      if (!empty($falling_sheet['sheet_date']) && trim($falling_sheet['sheet_date']) != '' && $falling_sheet['sheet_date'] != null) {
         $falling_sheet['sheet_date'] = date('Y/m/d', strtotime($falling_sheet['sheet_date']));
      }

      $this->smarty->assign('falling_sheet', $falling_sheet);
      $this->smarty->assign('patientId', $falling_sheet['patient_id']);

      $doctors = R::getAll('select awusers.* from awusers
                   join  awrole   on awrole.id =   awusers.role_id
                    where awrole.is_doctor =  1 and deleted != 1  ');
      $this->smarty->assign('doctors', $doctors);
   }

   function loadFallingPrint($falling_sheet_id) {
      $falling_sheet = R::getRow('select falling_sheet.* from falling_sheet  where id = ' . $falling_sheet_id);
      if ($falling_sheet['visit_id'] == 0) {
         $visit_id = $this->patientLastVisit($falling_sheet['patient_id']);
         if ($visit_id > 0) {
            R::exec(' update falling_sheet set visit_id = ? where id = ?  ', [$visit_id, $falling_sheet_id]);
            $falling_sheet['visit_id'] = $visit_id;
         }
      }

      $this->patientInfo($falling_sheet['patient_id'], $falling_sheet['visit_id']);
      if (!empty($falling_sheet['sheet_date']) && trim($falling_sheet['sheet_date']) != '' && $falling_sheet['sheet_date'] != null) {
         $falling_sheet['sheet_date'] = date('Y/m/d', strtotime($falling_sheet['sheet_date']));
      }
      $this->smarty->assign('falling_sheet', $falling_sheet);
   }

   //======================Medication Once=========================

   public function medication_show() {
      //check login
      autho::checkautho($this->hosturl);
      //check authoize
      autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
      $patientid = filter_input(INPUT_GET, "patientid");
      $this->smarty->assign('patientId', $patientid);
      if (empty($this->patientid)) {
         header('Location:' . $this->hosturl . '/controllers/index.php?empty=1');
         exit();
      }


      $medication_sheet = R::getAll('select medication_sheet.id  , medication_sheet.sheet_date  
                                from  medication_sheet 
                                where medication_sheet.deleted != 1 and medication_sheet.completed =  1 
                                and patient_id = ' . $patientid);
      $this->smarty->assign('medication_sheet', $medication_sheet);

      //call other class with other content
      header::headershow($this->smarty, $this->hosturl);
      sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
      if ($patientid) {
         patientdata::patientdatashow($this->smarty, $this->hosturl);
      }

      $this->smarty->display('heart_reports/medication_show.html');
      leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
      footer::footershow($this->smarty, $this->hosturl);
   }

   public function medication_add() {
      //check login
      autho::checkautho($this->hosturl);
      //check authoize
      autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

      $patientid = filter_input(INPUT_GET, "patientid");

      if (empty($patientid)) {
         header('Location:' . $this->hosturl . '/controllers/index.php?empty=1');
         exit();
      }

      $medication_sheet = R::findOne('medication_sheet', 'patient_id = ? and completed = 0', [$patientid]);
      if (count($medication_sheet) <= 0) {
         $medication_sheet = R::xdispense('medication_sheet');
         $medication_sheet->patient_id = $patientid;
         $medication_sheet->sheet_date = $this->today;
         $medication_sheet->completed = 0;
         $medication_sheet->deleted = 0;
         $medication_sheet->user_id = $_SESSION['user_id'];
         $medication_sheet_id = R::store($medication_sheet);
      } else {
         $medication_sheet_id = $medication_sheet->id;
      }

      $this->smarty->assign('is_add', 1);
      $this->smarty->assign('tableName', 'medication_sheet');
      $this->smarty->assign('show', 'medication_show');

      $this->loadMedication($medication_sheet_id);

      header::headershow($this->smarty, $this->hosturl);
      sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
      if ($patientid) {
         patientdata::patientdatashow($this->smarty, $this->hosturl);
      }
      $this->smarty->display('heart_reports/medication_add.html');
      leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
      footer::footershow($this->smarty, $this->hosturl);
   }

   public function medication_edit() {
      //check login
      autho::checkautho($this->hosturl);
      //check authoize
      autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

      $medication_sheet_id = filter_input(INPUT_GET, "id");
      $patientid = filter_input(INPUT_GET, "patientid");

      $this->loadMedication($medication_sheet_id);

      header::headershow($this->smarty, $this->hosturl);
      sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
      if ($patientid) {
         patientdata::patientdatashow($this->smarty, $this->hosturl);
      }
      $this->smarty->display('heart_reports/medication_add.html');
      leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
      footer::footershow($this->smarty, $this->hosturl);
   }

   public function medication_print() {
      //check login
      autho::checkautho($this->hosturl);
      //check authoize
      autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

      $medication_sheet_id = filter_input(INPUT_POST, "id");
      $this->loadMedicationPrint($medication_sheet_id);
      $this->smarty->assign('date', date("Y-m-d"));
      $this->smarty->display('heart_reports/medication_print.html');
   }

   function loadMedication($medication_sheet_id) {
      $medication_sheet = R::getRow('select medication_sheet.*   
                    from medication_sheet 
                    where id = ' . $medication_sheet_id);

      if ($medication_sheet['visit_id'] == 0) {
         $visit_id = $this->patientLastVisit($medication_sheet['patient_id']);
         R::exec(' update medication_sheet set visit_id = ? where id = ?  ', [$visit_id, $medication_sheet_id]);
      }

      if (!empty($medication_sheet['sheet_date']) && trim($medication_sheet['sheet_date']) != '' && $medication_sheet['sheet_date'] != null) {
         $medication_sheet['sheet_date'] = date('Y/m/d', strtotime($medication_sheet['sheet_date']));
      }
      $selectArray = explode(',', $medication_sheet['allergies']);
      $medication_sheet['allergies'] = $selectArray;

      $this->smarty->assign('medication_sheet', $medication_sheet);
      $this->smarty->assign('patientId', $medication_sheet['patient_id']);

      $doctors = R::getAll('select awusers.* from awusers
                   join  awrole   on awrole.id =   awusers.role_id
                    where awrole.is_doctor =  1 and deleted != 1  ');
      $this->smarty->assign('doctors', $doctors);

      $allAllergies = R::getAll("select * from allergies where conditions = 0");
      $this->smarty->assign('allAllergies', $allAllergies);

      $this->loadDrugsData();
      $this->loadMed($medication_sheet_id, 'medication');
   }

   function loadMedicationPrint($medication_sheet_id) {
      $medication_sheet = R::getRow('select medication_sheet.* from medication_sheet  where id = ' . $medication_sheet_id);
      if ($medication_sheet['visit_id'] == 0) {
         $visit_id = $this->patientLastVisit($medication_sheet['patient_id']);
         if ($visit_id > 0) {
            R::exec(' update medication_sheet set visit_id = ? where id = ?  ', [$visit_id, $medication_sheet_id]);
            $medication_sheet['visit_id'] = $visit_id;
         }
      }

      $this->patientInfo($medication_sheet['patient_id'], $medication_sheet['visit_id']);
      if (!empty($medication_sheet['sheet_date']) && trim($medication_sheet['sheet_date']) != '' && $medication_sheet['sheet_date'] != null) {
         $medication_sheet['sheet_date'] = date('Y/m/d', strtotime($medication_sheet['sheet_date']));
      }

      $medication_sheet['allergies'] = $this->multiValues($medication_sheet['allergies'], 'allergies', 'id');
      if ($medication_sheet['allergies'] == ' ')
         $medication_sheet['allergies'] = "None";

      $this->loadDrugsData();
      $this->loadMed($medication_sheet_id, 'medication');
      $this->smarty->assign('medication_sheet', $medication_sheet);
   }

   //======================Instruction Oral=========================

   public function instruction_show() {
      //check login
      autho::checkautho($this->hosturl);
      //check authoize
      autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
      $patientid = filter_input(INPUT_GET, "patientid");
      $this->smarty->assign('patientId', $patientid);
      if (empty($this->patientid)) {
         header('Location:' . $this->hosturl . '/controllers/index.php?empty=1');
         exit();
      }


      $instruction_sheet = R::getAll('select instruction_sheet.id  , instruction_sheet.sheet_date  
                                 from  instruction_sheet 
                                 where instruction_sheet.deleted != 1 and instruction_sheet.completed =  1 
                                 and patient_id = ' . $patientid);
      $this->smarty->assign('instruction_sheet', $instruction_sheet);

      //call other class with other content
      header::headershow($this->smarty, $this->hosturl);
      sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
      if ($patientid) {
         patientdata::patientdatashow($this->smarty, $this->hosturl);
      }

      $this->smarty->display('heart_reports/instruction_show.html');
      leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
      footer::footershow($this->smarty, $this->hosturl);
   }

   public function instruction_add() {
      //check login
      autho::checkautho($this->hosturl);
      //check authoize
      autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

      $patientid = filter_input(INPUT_GET, "patientid");

      if (empty($patientid)) {
         header('Location:' . $this->hosturl . '/controllers/index.php?empty=1');
         exit();
      }

      $instruction_sheet = R::findOne('instruction_sheet', 'patient_id = ? and completed = 0', [$patientid]);
      if (count($instruction_sheet) <= 0) {
         $instruction_sheet = R::xdispense('instruction_sheet');
         $instruction_sheet->patient_id = $patientid;
         $instruction_sheet->sheet_date = $this->today;
         $instruction_sheet->completed = 0;
         $instruction_sheet->deleted = 0;
         $instruction_sheet->user_id = $_SESSION['user_id'];
         $instruction_sheet_id = R::store($instruction_sheet);
      } else {
         $instruction_sheet_id = $instruction_sheet->id;
      }

      $this->smarty->assign('is_add', 1);
      $this->smarty->assign('tableName', 'instruction_sheet');
      $this->smarty->assign('show', 'instruction_show');

      $this->loadInstruction($instruction_sheet_id);

      header::headershow($this->smarty, $this->hosturl);
      sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
      if ($patientid) {
         patientdata::patientdatashow($this->smarty, $this->hosturl);
      }
      $this->smarty->display('heart_reports/instruction_add.html');
      leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
      footer::footershow($this->smarty, $this->hosturl);
   }

   public function instruction_edit() {
      //check login
      autho::checkautho($this->hosturl);
      //check authoize
      autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

      $instruction_sheet_id = filter_input(INPUT_GET, "id");
      $patientid = filter_input(INPUT_GET, "patientid");

      $this->loadInstruction($instruction_sheet_id);

      header::headershow($this->smarty, $this->hosturl);
      sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
      if ($patientid) {
         patientdata::patientdatashow($this->smarty, $this->hosturl);
      }
      $this->smarty->display('heart_reports/instruction_add.html');
      leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
      footer::footershow($this->smarty, $this->hosturl);
   }

   public function instruction_print() {
      //check login
      autho::checkautho($this->hosturl);
      //check authoize
      autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

      $instruction_sheet_id = filter_input(INPUT_POST, "id");
      $this->loadInstructionPrint($instruction_sheet_id);
      $this->smarty->assign('date', date("Y-m-d"));
      $this->smarty->display('heart_reports/instruction_print.html');
   }

   function loadInstruction($instruction_sheet_id) {
      $instruction_sheet = R::getRow('select instruction_sheet.*   
                     from instruction_sheet 
                     where id = ' . $instruction_sheet_id);

      if ($instruction_sheet['visit_id'] == 0) {
         $visit_id = $this->patientLastVisit($instruction_sheet['patient_id']);
         R::exec(' update instruction_sheet set visit_id = ? where id = ?  ', [$visit_id, $instruction_sheet_id]);
      }

      if (!empty($instruction_sheet['sheet_date']) && trim($instruction_sheet['sheet_date']) != '' && $instruction_sheet['sheet_date'] != null) {
         $instruction_sheet['sheet_date'] = date('Y/m/d', strtotime($instruction_sheet['sheet_date']));
      }
      $selectArray = explode(',', $instruction_sheet['allergies']);
      $instruction_sheet['allergies'] = $selectArray;

      $this->smarty->assign('instruction_sheet', $instruction_sheet);
      $this->smarty->assign('patientId', $instruction_sheet['patient_id']);

      $doctors = R::getAll('select awusers.* from awusers
                    join  awrole   on awrole.id =   awusers.role_id
                     where awrole.is_doctor =  1 and deleted != 1  ');
      $this->smarty->assign('doctors', $doctors);

      $allAllergies = R::getAll("select * from allergies where conditions = 0");
      $this->smarty->assign('allAllergies', $allAllergies);

      $this->loadDrugsData();
      $this->loadMed($instruction_sheet_id, 'instruction');
   }

   function loadInstructionPrint($instruction_sheet_id) {
      $instruction_sheet = R::getRow('select instruction_sheet.* from instruction_sheet  where id = ' . $instruction_sheet_id);
      if ($instruction_sheet['visit_id'] == 0) {
         $visit_id = $this->patientLastVisit($instruction_sheet['patient_id']);
         if ($visit_id > 0) {
            R::exec(' update instruction_sheet set visit_id = ? where id = ?  ', [$visit_id, $instruction_sheet_id]);
            $instruction_sheet['visit_id'] = $visit_id;
         }
      }

      $this->patientInfo($instruction_sheet['patient_id'], $instruction_sheet['visit_id']);
      if (!empty($instruction_sheet['sheet_date']) && trim($instruction_sheet['sheet_date']) != '' && $instruction_sheet['sheet_date'] != null) {
         $instruction_sheet['sheet_date'] = date('Y/m/d', strtotime($instruction_sheet['sheet_date']));
      }

      $instruction_sheet['allergies'] = $this->multiValues($instruction_sheet['allergies'], 'allergies', 'id');
      if ($instruction_sheet['allergies'] == ' ')
         $instruction_sheet['allergies'] = "None";

      $this->loadDrugsData();
      $this->loadMed($instruction_sheet_id, 'instruction');
      $this->smarty->assign('instruction_sheet', $instruction_sheet);
   }

   //======================Internal Entry data=========================
   public function internal_entry_show() {
      //check login
      autho::checkautho($this->hosturl);
      //check authoize
      autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
      $patientid = filter_input(INPUT_GET, "patientid");
      $this->smarty->assign('patientId', $patientid);
      if (empty($this->patientid)) {
         header('Location:' . $this->hosturl . '/controllers/index.php?empty=1');
         exit();
      }


      $internal_entry_data = R::getAll('select internal_patient_entry.id  , internal_patient_entry.sysdate  
                            from  internal_patient_entry 
                            where internal_patient_entry.deleted != 1 and internal_patient_entry.completed =  1 
                            and patient_id = ' . $patientid);
      $this->smarty->assign('internal_entry_data', $internal_entry_data);

      //call other class with other content
      header::headershow($this->smarty, $this->hosturl);
      sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
      if ($patientid) {
         patientdata::patientdatashow($this->smarty, $this->hosturl);
      }

      $this->smarty->display('heart_reports/internal_entry_show.html');
      leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
      footer::footershow($this->smarty, $this->hosturl);
   }

   public function internal_entry_add() {
      //check login
      autho::checkautho($this->hosturl);
      //check authoize
      autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

      $patientid = filter_input(INPUT_GET, "patientid");
      if (empty($patientid)) {
         header('Location:' . $this->hosturl . '/controllers/index.php?empty=1');
         exit();
      }

      $internal_entry_data = R::findOne('internal_patient_entry', 'patient_id = ? and completed = 0', [$patientid]);
      if (count($internal_entry_data) <= 0) {
         $internal_entry_data = R::xdispense('internal_patient_entry');
         $internal_entry_data->patient_id = $patientid;
         $internal_entry_data->sysdate = $this->today;
         $internal_entry_data->completed = 0;
         $internal_entry_data->deleted = 0;
         $internal_entry_data->user_id = $_SESSION['user_id'];
         $internal_entry_data->visit_id = 0;

         $internal_entry_data_id = R::store($internal_entry_data);
      } else {
         $internal_entry_data_id = $internal_entry_data->id;
      }

      $this->smarty->assign('is_add', 1);
      $this->smarty->assign('tableName', 'internal_patient_entry');
      $this->smarty->assign('show', 'internal_entry_show');

      $this->loadInternalEntry($internal_entry_data_id);

      header::headershow($this->smarty, $this->hosturl);
      sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
      if ($patientid) {
         patientdata::patientdatashow($this->smarty, $this->hosturl);
      }
      $this->smarty->display('heart_reports/internal_entry_add.html');
      leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
      footer::footershow($this->smarty, $this->hosturl);
   }

   public function internal_entry_edit() {
      //check login
      autho::checkautho($this->hosturl);
      //check authoize
      autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

      $internal_entry_data_id = filter_input(INPUT_GET, "id");
      $patientid = filter_input(INPUT_GET, "patientid");

      $this->loadInternalEntry($internal_entry_data_id);

      header::headershow($this->smarty, $this->hosturl);
      sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
      if ($patientid) {
         patientdata::patientdatashow($this->smarty, $this->hosturl);
      }
      $this->smarty->display('heart_reports/internal_entry_add.html');
      leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
      footer::footershow($this->smarty, $this->hosturl);
   }

   public function internal_entry_print() {
      //check login
      autho::checkautho($this->hosturl);
      //check authoize
      autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

      $internal_entry_data_id = filter_input(INPUT_POST, "id");
      $this->loadInternalEntryPrint($internal_entry_data_id);
      $this->smarty->assign('date', date("Y-m-d"));
      $this->smarty->display('heart_reports/internal_entry_print.html');
   }

   public function internal_entry_print_lbl() {
      //check login
      autho::checkautho($this->hosturl);
      //check authoize
      autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

      $internal_entry_data_id = filter_input(INPUT_POST, "id");
      $this->loadInternalEntryPrint($internal_entry_data_id);

      $programesetting = R::findOne('programesetting');

      $this->smarty->assign('counter', $programesetting->print_lbl_no);
      $this->smarty->display('heart_reports/internal_entry_print_lbl.html');
   }

   function loadInternalEntry($internal_entry_data_id) {

      $internal_entry_data = R::getRow('select internal_patient_entry.*   
                from internal_patient_entry 
                where id = ' . $internal_entry_data_id);

      if (!empty($internal_entry_data['sysdate']) && trim($internal_entry_data['sysdate']) != '' && $internal_entry_data['sysdate'] != null) {
         $internal_entry_data['sysdate'] = date('Y/m/d', strtotime($internal_entry_data['sysdate']));
      }

      if (!empty($internal_entry_data['entry_date']) && trim($internal_entry_data['entry_date']) != '' && $internal_entry_data['entry_date'] != null) {
         $internal_entry_data['entry_date'] = date('Y/m/d', strtotime($internal_entry_data['entry_date']));
      }

      if ($internal_entry_data['visit_id'] > 0) {
         $visitData = R::load('visits', $internal_entry_data['visit_id']);
         $internal_entry_data['docName'] = R::getCell('select name from awusers where user_id = ?', [$visitData->for_doctor]);
         $internal_entry_data['visitdate'] = $visitData->visitdate;
      }

      $selectArray = explode(',', $internal_entry_data['diagnosis']);
      $internal_entry_data['diagnosis'] = $selectArray;

      $this->smarty->assign('internal_entry_data', $internal_entry_data);
      $this->smarty->assign('patientId', $internal_entry_data['patient_id']);

      $this->patientInfo($internal_entry_data['patient_id'], $internal_entry_data['visit_id']);

      $allTo = R::getAll("select * from internal_report_to where conditions = 0");
      $this->smarty->assign('allTo', $allTo);

      $qs = '';

      $deptsToShow = R::getAll('select GROUP_CONCAT(id SEPARATOR ",") allIds from awrole where heart_reports_show = 1')[0];
      if ($deptsToShow['allIds'])
         $qs .= " AND for_department in(" . $deptsToShow['allIds'] . ")";

      $lastEntryData = R::findOne('internal_patient_entry', 'where patient_id = ' . $internal_entry_data['patient_id'] . ' and id < ' . $internal_entry_data_id . ' order by id desc');
      if ($lastEntryData && $lastEntryData->id > 0)
         $qs .= 'and visitdate > DATE(' . $lastEntryData->sysdate . ')';

      $allvisits = R::getAll("select * from visits where visits.deleted = 0 and id not in (select visit_id from internal_patient_entry where id != " . $internal_entry_data_id . " and visit_id > 0) and patientid = " . $internal_entry_data['patient_id'] . " " . $qs);
      $this->smarty->assign('allvisits', $allvisits);

      $alldiagnosis = R::findall('diagnosis', 'conditions = 0 order by name');
      $this->smarty->assign('alldiagnosis', $alldiagnosis);
   }

   function loadInternalEntryPrint($internal_entry_data_id) {
      $internal_entry_data = R::getRow('select internal_patient_entry.* from internal_patient_entry  where id = ' . $internal_entry_data_id);

      $this->patientInfo($internal_entry_data['patient_id'], $internal_entry_data['visit_id']);

      $month = $this->getMonthNameFnAr($internal_entry_data['sysdate']);
      if (!empty($internal_entry_data['sysdate']) && trim($internal_entry_data['sysdate']) != '' && $internal_entry_data['sysdate'] != null) {
         $internal_entry_data['sysdate'] = date('d ' . $month . '، Y', strtotime($internal_entry_data['sysdate']));
      }

      if ($internal_entry_data['visit_id'] > 0) {
         $visitData = R::load('visits', $internal_entry_data['visit_id']);
         $internal_entry_data['docName'] = R::getCell('select name from awusers where user_id = ?', [$visitData->for_doctor]);
         $internal_entry_data['visitdate'] = $visitData->visitdate;
      }

      $month = $this->getMonthNameFnAr($internal_entry_data['visitdate']);
      if (!empty($internal_entry_data['visitdate']) && trim($internal_entry_data['visitdate']) != '' && $internal_entry_data['visitdate'] != null) {
         $internal_entry_data['visitdate'] = date('d ' . $month . '، Y', strtotime($internal_entry_data['visitdate']));
      }

      if (!empty($internal_entry_data['entry_date']) && trim($internal_entry_data['entry_date']) != '' && $internal_entry_data['entry_date'] != null) {
         $internal_entry_data['entry_date'] = date('d ' . $month . '، Y', strtotime($internal_entry_data['entry_date']));
      }

      $internal_entry_data['diagnosis'] = $this->multiValues($internal_entry_data['diagnosis'], 'diagnosis', 'id');

      if ($internal_entry_data['internal_report_to'])
         $internal_entry_data['internal_report_to'] = R::findOne('internal_report_to', 'id = ' . $internal_entry_data['internal_report_to'])->name;

      $this->smarty->assign('internal_entry_data', $internal_entry_data);
   }

   //======================Internal Discharge data=========================
   public function internal_discharge_show() {
      //check login
      autho::checkautho($this->hosturl);
      //check authoize
      autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
      $patientid = filter_input(INPUT_GET, "patientid");
      $this->smarty->assign('patientId', $patientid);
      if (empty($this->patientid)) {
         header('Location:' . $this->hosturl . '/controllers/index.php?empty=1');
         exit();
      }


      $internal_discharge_data = R::getAll('select internal_patient_discharge.id  , internal_patient_discharge.sysdate  
                            from  internal_patient_discharge 
                            where internal_patient_discharge.deleted != 1 and internal_patient_discharge.completed =  1 
                            and patient_id = ' . $patientid);
      $this->smarty->assign('internal_discharge_data', $internal_discharge_data);

      //call other class with other content
      header::headershow($this->smarty, $this->hosturl);
      sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
      if ($patientid) {
         patientdata::patientdatashow($this->smarty, $this->hosturl);
      }

      $this->smarty->display('heart_reports/internal_discharge_show.html');
      leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
      footer::footershow($this->smarty, $this->hosturl);
   }

   public function internal_discharge_add() {
      //check login
      autho::checkautho($this->hosturl);
      //check authoize
      autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

      $patientid = filter_input(INPUT_GET, "patientid");

      if (empty($patientid)) {
         header('Location:' . $this->hosturl . '/controllers/index.php?empty=1');
         exit();
      }



      $internal_discharge_data = R::findOne('internal_patient_discharge', 'patient_id = ? and completed = 0', [$patientid]);
      if (count($internal_discharge_data) <= 0) {
         $patientData = R::load('patients', $patientid);

         $internal_discharge_data = R::xdispense('internal_patient_discharge');
         $internal_discharge_data->patient_id = $patientid;
         $internal_discharge_data->sysdate = $this->today;
         $internal_discharge_data->discharge_date = $this->today;
         $internal_discharge_data->completed = 0;
         $internal_discharge_data->deleted = 0;
         $internal_discharge_data->user_id = $_SESSION['user_id'];

         $lastEntryData = R::findOne('internal_patient_entry', 'where patient_id = ' . $internal_discharge_data['patient_id'] . ' order by id desc');
         if ($lastEntryData['visit_id'] > 0)
            $internal_discharge_data->entry_id = $lastEntryData->id;

         $internal_discharge_data_id = R::store($internal_discharge_data);
      } else {
         $internal_discharge_data_id = $internal_discharge_data->id;
      }

      $this->smarty->assign('is_add', 1);
      $this->smarty->assign('tableName', 'internal_patient_discharge');
      $this->smarty->assign('show', 'internal_discharge_show');

      $this->loadInternalDischarge($internal_discharge_data_id);

      header::headershow($this->smarty, $this->hosturl);
      sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
      if ($patientid) {
         patientdata::patientdatashow($this->smarty, $this->hosturl);
      }
      $this->smarty->display('heart_reports/internal_discharge_add.html');
      leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
      footer::footershow($this->smarty, $this->hosturl);
   }

   public function internal_discharge_edit() {
      //check login
      autho::checkautho($this->hosturl);
      //check authoize
      autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

      $internal_discharge_data_id = filter_input(INPUT_GET, "id");
      $patientid = filter_input(INPUT_GET, "patientid");

      $this->loadInternalDischarge($internal_discharge_data_id);

      header::headershow($this->smarty, $this->hosturl);
      sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
      if ($patientid) {
         patientdata::patientdatashow($this->smarty, $this->hosturl);
      }
      $this->smarty->display('heart_reports/internal_discharge_add.html');
      leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
      footer::footershow($this->smarty, $this->hosturl);
   }

   public function internal_discharge_print() {
      //check login
      autho::checkautho($this->hosturl);
      //check authoize
      autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

      $internal_discharge_data_id = filter_input(INPUT_POST, "id");
      $this->loadInternalDischargePrint($internal_discharge_data_id);
      $this->smarty->assign('date', date("Y-m-d"));
      $this->smarty->display('heart_reports/internal_discharge_print.html');
   }

   function loadInternalDischarge($internal_discharge_data_id) {

      $internal_discharge_data = R::getRow('select internal_patient_discharge.*   
                from internal_patient_discharge 
                where id = ' . $internal_discharge_data_id);

      if (!empty($internal_discharge_data['sysdate']) && trim($internal_discharge_data['sysdate']) != '' && $internal_discharge_data['sysdate'] != null) {
         $internal_discharge_data['sysdate'] = date('Y/m/d', strtotime($internal_discharge_data['sysdate']));
      }

      if (!empty($internal_discharge_data['discharge_date']) && trim($internal_discharge_data['discharge_date']) != '' && $internal_discharge_data['discharge_date'] != null) {
         $internal_discharge_data['discharge_date'] = date('Y/m/d', strtotime($internal_discharge_data['discharge_date']));
      }

      $this->smarty->assign('patientId', $internal_discharge_data['patient_id']);

      $doctors = R::getAll('select awusers.* from awusers
               join  awrole   on awrole.id =   awusers.role_id
                where awrole.is_doctor =  1 and deleted != 1  ');
      $this->smarty->assign('doctors', $doctors);

      $allTo = R::getAll("select * from internal_report_to where conditions = 0");
      $this->smarty->assign('allTo', $allTo);

      $lastEntryData = R::findOne('internal_patient_entry', 'where id = ' . $internal_discharge_data['entry_id'] . ' order by id desc');
      if ($lastEntryData['visit_id'] > 0) {
         $visitData = R::load('visits', $lastEntryData['visit_id']);
         $internal_discharge_data['docName'] = R::getCell('select name from awusers where user_id = ?', [$visitData->for_doctor]);
         $internal_discharge_data['visitdate'] = $visitData->visitdate;
         $visitId = $lastEntryData['visit_id'];
      }
      $internal_discharge_data['diagnosis'] = $this->multiValues($lastEntryData['diagnosis'], 'diagnosis', 'id');

      $this->smarty->assign('internal_discharge_data', $internal_discharge_data);

      $this->patientInfo($internal_discharge_data['patient_id'], $visitId);
   }

   function loadInternalDischargePrint($internal_discharge_data_id) {
      $internal_discharge_data = R::getRow('select internal_patient_discharge.* from internal_patient_discharge  where id = ' . $internal_discharge_data_id);

      $month = $this->getMonthNameFnAr($internal_discharge_data['sysdate']);
      if (!empty($internal_discharge_data['sysdate']) && trim($internal_discharge_data['sysdate']) != '' && $internal_discharge_data['sysdate'] != null) {
         $internal_discharge_data['sysdate'] = date('d ' . $month . '، Y', strtotime($internal_discharge_data['sysdate']));
      }

      $month = $this->getMonthNameFnAr($internal_discharge_data['entry_date']);
      if (!empty($internal_discharge_data['entry_date']) && trim($internal_discharge_data['entry_date']) != '' && $internal_discharge_data['entry_date'] != null) {
         $internal_discharge_data['entry_date'] = date('d ' . $month . '، Y', strtotime($internal_discharge_data['entry_date']));
      }

      $month = $this->getMonthNameFnAr($internal_discharge_data['discharge_date']);
      if (!empty($internal_discharge_data['discharge_date']) && trim($internal_discharge_data['discharge_date']) != '' && $internal_discharge_data['discharge_date'] != null) {
         $internal_discharge_data['discharge_date'] = date('d ' . $month . '، Y', strtotime($internal_discharge_data['discharge_date']));
      }

      if ($internal_discharge_data['internal_report_to'])
         $internal_discharge_data['internal_report_to'] = R::findOne('internal_report_to', 'id = ' . $internal_discharge_data['internal_report_to'])->name;

      $lastEntryData = R::findOne('internal_patient_entry', 'where id = ' . $internal_discharge_data['entry_id'] . ' order by id desc');
      if ($lastEntryData['visit_id'] > 0) {
         $visitData = R::load('visits', $lastEntryData['visit_id']);

         $month = $this->getMonthNameFnAr($visitData['visitdate']);
         if (!empty($visitData['visitdate']) && trim($visitData['visitdate']) != '' && $visitData['visitdate'] != null) {
            $internal_discharge_data['visitdate'] = date('d ' . $month . '، Y', strtotime($visitData['visitdate']));
         }

         $internal_discharge_data['docName'] = R::getCell('select name from awusers where user_id = ?', [$visitData->for_doctor]);
         $visitId = $lastEntryData['visit_id'];
      }
      $internal_discharge_data['diagnosis'] = $this->multiValues($lastEntryData['diagnosis'], 'diagnosis', 'id');

      $this->smarty->assign('internal_discharge_data', $internal_discharge_data);

      $this->patientInfo($internal_discharge_data['patient_id'], $visitId);
   }

   //====================== Entry & Discharge Data =========================
   public function entry_discharge_show() {
      //check login
      autho::checkautho($this->hosturl);
      //check authoize
      autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
      $patientid = filter_input(INPUT_GET, "patientid");
      $this->smarty->assign('patientId', $patientid);
      if (empty($this->patientid)) {
         header('Location:' . $this->hosturl . '/controllers/index.php?empty=1');
         exit();
      }

      $entry_discharge_data = R::getAll('select entry_patient_discharge.id  , entry_patient_discharge.sysdate  
                            from  entry_patient_discharge 
                            where entry_patient_discharge.deleted != 1 and entry_patient_discharge.completed =  1 
                            and patient_id = ' . $patientid);
      $this->smarty->assign('entry_discharge_data', $entry_discharge_data);

      //call other class with other content
      header::headershow($this->smarty, $this->hosturl);
      sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
      if ($patientid) {
         patientdata::patientdatashow($this->smarty, $this->hosturl);
      }

      $this->smarty->display('heart_reports/entry_discharge_show.html');
      leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
      footer::footershow($this->smarty, $this->hosturl);
   }

   public function entry_discharge_add() {
      //check login
      autho::checkautho($this->hosturl);
      //check authoize
      autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

      $patientid = filter_input(INPUT_GET, "patientid");

      if (empty($patientid)) {
         header('Location:' . $this->hosturl . '/controllers/index.php?empty=1');
         exit();
      }

      $entry_discharge_data = R::findOne('entry_patient_discharge', 'patient_id = ? and completed = 0', [$patientid]);
      if (count($entry_discharge_data) <= 0) {
         $entry_discharge_data = R::xdispense('entry_patient_discharge');
         $entry_discharge_data->patient_id = $patientid;
         $entry_discharge_data->sysdate = $this->today;
         $entry_discharge_data->completed = 0;
         $entry_discharge_data->deleted = 0;
         $entry_discharge_data->user_id = $_SESSION['user_id'];

         $lastDischargeData = R::findOne('internal_patient_discharge', 'where patient_id = ' . $patientid . ' order by id desc');
         $entry_discharge_data->discharge_id = $lastDischargeData->id;

         $entry_discharge_data_id = R::store($entry_discharge_data);
      } else {
         $entry_discharge_data_id = $entry_discharge_data->id;
      }

      $this->smarty->assign('is_add', 1);
      $this->smarty->assign('tableName', 'entry_patient_discharge');
      $this->smarty->assign('show', 'entry_discharge_show');

      $this->loadEntryDischarge($entry_discharge_data_id);

      header::headershow($this->smarty, $this->hosturl);
      sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
      if ($patientid) {
         patientdata::patientdatashow($this->smarty, $this->hosturl);
      }
      $this->smarty->display('heart_reports/entry_discharge_add.html');
      leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
      footer::footershow($this->smarty, $this->hosturl);
   }

   public function entry_discharge_edit() {
      //check login
      autho::checkautho($this->hosturl);
      //check authoize
      autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

      $entry_discharge_data_id = filter_input(INPUT_GET, "id");
      $patientid = filter_input(INPUT_GET, "patientid");

      $this->loadEntryDischarge($entry_discharge_data_id);

      header::headershow($this->smarty, $this->hosturl);
      sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
      if ($patientid) {
         patientdata::patientdatashow($this->smarty, $this->hosturl);
      }
      $this->smarty->display('heart_reports/entry_discharge_add.html');
      leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
      footer::footershow($this->smarty, $this->hosturl);
   }

   public function entry_discharge_print() {
      //check login
      autho::checkautho($this->hosturl);
      //check authoize
      autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

      $entry_discharge_data_id = filter_input(INPUT_POST, "id");
      $this->loadEntryDischargePrint($entry_discharge_data_id);
      $this->smarty->assign('date', date("Y-m-d"));
      $this->smarty->display('heart_reports/entry_discharge_print.html');
   }

   function loadEntryDischarge($entry_discharge_data_id) {
      $entry_discharge_data = R::getRow('select entry_patient_discharge.*   
                from entry_patient_discharge 
                where id = ' . $entry_discharge_data_id);

      if (!empty($entry_discharge_data['sysdate']) && trim($entry_discharge_data['sysdate']) != '' && $entry_discharge_data['sysdate'] != null) {
         $entry_discharge_data['sysdate'] = date('Y/m/d', strtotime($entry_discharge_data['sysdate']));
      }

      $this->smarty->assign('patientId', $entry_discharge_data['patient_id']);

      if ($entry_discharge_data['discharge_id']) {
         $dischargeData = R::findOne('internal_patient_discharge', 'where id = ' . $entry_discharge_data['discharge_id'] . ' order by id desc');
         $lastEntryData = R::findOne('internal_patient_entry', 'where id = ' . $dischargeData['entry_id'] . ' order by id desc');
         if ($lastEntryData['visit_id'] > 0) {
            $visitData = R::load('visits', $lastEntryData['visit_id']);
            $entry_discharge_data['docName'] = R::getCell('select name from awusers where user_id = ?', [$visitData->for_doctor]);
            $entry_discharge_data['visitdate'] = $visitData->visitdate;
            $entry_discharge_data['visittime'] = $visitData->visittime;
            $visitId = $lastEntryData['visit_id'];

            if (!empty($visitData->visitdate) && trim($visitData->visitdate) != '' && $visitData->visitdate != null) {
               $entry_discharge_data['visitdate'] = date('Y/m/d', strtotime($visitData->visitdate));
            }
         }
         $entry_discharge_data['diagnosis'] = $this->multiValues($lastEntryData['diagnosis'], 'diagnosis', 'id');

         if (!empty($dischargeData['discharge_date']) && trim($dischargeData['discharge_date']) != '' && $dischargeData['discharge_date'] != null) {
            $entry_discharge_data['discharge_date'] = date('Y/m/d', strtotime($dischargeData['discharge_date']));
         }
      }

      $selectArray = explode(',', $entry_discharge_data['allergies']);
      $entry_discharge_data['allergies'] = $selectArray;

      $selectArray = explode(',', $entry_discharge_data['contagious_disease']);
      $entry_discharge_data['contagious_disease'] = $selectArray;

      $this->smarty->assign('entry_discharge_data', $entry_discharge_data);

      $this->patientInfo($entry_discharge_data['patient_id'], $visitId);

      $allAllergies = R::getAll("select * from allergies where conditions = 0");
      $this->smarty->assign('allAllergies', $allAllergies);

      $allDiseases = R::getAll("select * from contagious_disease where conditions = 0");
      $this->smarty->assign('allDiseases', $allDiseases);

      $qs = '';

      $deptsToShow = R::getAll('select GROUP_CONCAT(id SEPARATOR ",") allIds from awrole where heart_reports_show = 1')[0];
      if ($deptsToShow['allIds'])
         $qs .= " AND for_department in(" . $deptsToShow['allIds'] . ")";

      $allVisits = R::getAll('select visits.*, awrole.name deptName ,organization_name,residence_rooms.name roomNo
                                from visits 
                                LEFT JOIN awrole on awrole.id = visits.for_department 
                                LEFT JOIN organizations on organizations.id = visits.organization_id
                                LEFT JOIN residence_rooms ON residence_rooms.id = visits.room_no
                                where patientid =' . $entry_discharge_data['patient_id'] . ' and visitdate >= Date("' . $entry_discharge_data['visitdate'] . '") and visitdate <= Date("' . $entry_discharge_data['discharge_date'] . '") and visits.deleted = 0 ' . $qs);
      $this->smarty->assign('allVisits', $allVisits);

      $allCareGivers = R::getAll('select * from caregiver where patient_id = ' . $entry_discharge_data['patient_id']);
      $this->smarty->assign('allCareGivers', $allCareGivers);
   }

   function loadEntryDischargePrint($entry_discharge_data_id) {
      $entry_discharge_data = R::getRow('select entry_patient_discharge.* from entry_patient_discharge  where id = ' . $entry_discharge_data_id);

      $month = $this->getMonthNameFnAr($entry_discharge_data['sysdate']);
      if (!empty($entry_discharge_data['sysdate']) && trim($entry_discharge_data['sysdate']) != '' && $entry_discharge_data['sysdate'] != null) {
         $entry_discharge_data['sysdate'] = date('d ' . $month . '، Y', strtotime($entry_discharge_data['sysdate']));
      }

      if ($entry_discharge_data['discharge_id']) {
         $dischargeData = R::findOne('internal_patient_discharge', 'where id = ' . $entry_discharge_data['discharge_id'] . ' order by id desc');
         $lastEntryData = R::findOne('internal_patient_entry', 'where id = ' . $dischargeData['entry_id'] . ' order by id desc');
         if ($lastEntryData['visit_id'] > 0) {
            $visitData = R::load('visits', $lastEntryData['visit_id']);
            $entry_discharge_data['docName'] = R::getCell('select name from awusers where user_id = ?', [$visitData->for_doctor]);
            $entry_discharge_data['visitdate'] = $visitData->visitdate;
            $entry_discharge_data['visittime'] = $visitData->visittime;
            $visitId = $lastEntryData['visit_id'];

            if (!empty($visitData->visitdate) && trim($visitData->visitdate) != '' && $visitData->visitdate != null) {
               $entry_discharge_data['visitdate'] = date('Y/m/d', strtotime($visitData->visitdate));
            }
            $examination = R::getRow('select weight,height from examination where patientid = ' . $entry_discharge_data['patient_id'] . ' and examinationdate <= DATE("' . $visitData->visitdate . '") order by id desc');

            $this->smarty->assign('weight', $examination['weight']);
            $this->smarty->assign('height', $examination['height']);
         }
         $entry_discharge_data['diagnosis'] = $this->multiValues($lastEntryData['diagnosis'], 'diagnosis', 'id');

         if (!empty($dischargeData['discharge_date']) && trim($dischargeData['discharge_date']) != '' && $dischargeData['discharge_date'] != null) {
            $entry_discharge_data['discharge_date'] = date('Y/m/d', strtotime($dischargeData['discharge_date']));
         }
      }
      $entry_discharge_data['diagnosis'] = $this->multiValues($lastEntryData['diagnosis'], 'diagnosis', 'id');

      $entry_discharge_data['allergies'] = $this->multiValues($entry_discharge_data['allergies'], 'allergies', 'id');
      if ($entry_discharge_data['allergies'] == ' ')
         $entry_discharge_data['allergies'] = "None";

      $entry_discharge_data['contagious_disease'] = $this->multiValues($entry_discharge_data['contagious_disease'], 'contagious_disease', 'id');

      $this->smarty->assign('entry_discharge_data', $entry_discharge_data);

      $this->patientInfo($entry_discharge_data['patient_id'], $visitId);

      $qs = "";
      $deptsToShow = R::getAll('select GROUP_CONCAT(id SEPARATOR ",") allIds from awrole where heart_reports_show = 1')[0];
      if ($deptsToShow['allIds'])
         $qs .= " AND for_department in(" . $deptsToShow['allIds'] . ")";

      $allVisits = R::getAll('select visits.*, awrole.name deptName ,organization_name,residence_rooms.name roomNo
                                from visits 
                                LEFT JOIN awrole on awrole.id = visits.for_department 
                                LEFT JOIN organizations on organizations.id = visits.organization_id
                                LEFT JOIN residence_rooms ON residence_rooms.id = visits.room_no
                                where patientid =' . $entry_discharge_data['patient_id'] . ' and visitdate >= Date("' . $entry_discharge_data['visitdate'] . '") and visitdate <= Date("' . $entry_discharge_data['discharge_date'] . '") and visits.deleted = 0 ' . $qs);
      $this->smarty->assign('allVisits', $allVisits);

      $allCareGivers = R::getAll('select * from caregiver where patient_id = ' . $entry_discharge_data['patient_id']);
      $this->smarty->assign('allCareGivers', $allCareGivers);
   }

   //==================================================
   function patientLastVisit($patientId) {
      $visitId = 0;
      $visit = R::findOne('visits', ' patientid = ?  and deleted != 1 
                    and detectionid != 999  and detectionid != 9999 
                    and visitdate <= ? order by visitdate desc ', [$patientId, date('Y-m-d')]);
      if (count($visit) > 0) {
         $visitId = $visit->id;
      }
      return $visitId;
   }

   function patientInfo($patientId, $visitId) {
      $patient = R::load('patients', $patientId);
      $programesetting = R::findOne('programesetting');
      $visit = R::load('visits', $visitId);

      $name = '';
      $sex = '';
      $for = 0;

      if ($programesetting->system_lang == 2) {
         $date = $patient->dateofbirth;
         $name = $patient->wifename;
         if ($patient->gender == 1) {
            $sex = 'Male';
         } else {
            $sex = 'Female';
         }
         $nationalid = $patient->wifenationalid;
         $patientAge = $patient->wifeage;
         $stats = R::load('wifestatus', $patient->statuesid)->title;
         $job = R::load('wifejobs', $patient->wifejob)->title;
         $bl = $patient->wifebl;
      } else {
         if (count($visit) > 0) {
            if ($visit->for_husband == 1) {
               $for = 1;
               $date = $patient->husbanddateofbirth;
               $name = $patient->husdandname;
               $sex = 'Male';
               $nationalid = $patient->husbandnationalid;
               $patientAge = $patient->husbandage;
               $stats = R::load('husstatus', $patient->hus_statuesid)->title;
               $job = R::load('wifejobs', $patient->husbandjob)->title;
               $bl = $patient->husbandbl;
            } else if ($visit->for_husband == 2) {
               $for = 2;
               $child = R::load('patients_childs', $visit->child);
               $date = $child->birth_date;
               if ($child->gender == 1) {
                  $sex = 'Male';
                  if (is_null($child->child_name) || $child->child_name == '') {
                     $name = 'الطفل / ' . $patient->wifename;
                  } else {
                     $name = $child->child_name . '  /  ' . $patient->wifename;
                  }
               } else {
                  $sex = 'Female';
                  if (is_null($child->child_name) || $child->child_name == '') {
                     $name = 'الطفلة / ' . $patient->wifename;
                  } else {
                     $name = $child->child_name . '  /  ' . $patient->wifename;
                  }
               }
            } else {
               $date = $patient->dateofbirth;
               $name = $patient->wifename;
               $sex = 'Female';
               $nationalid = $patient->wifenationalid;
               $patientAge = $patient->wifeage;
               $stats = R::load('wifestatus', $patient->statuesid)->title;
               $job = R::load('wifejobs', $patient->wifejob)->title;
               $bl = $patient->wifebl;
            }
         } else {
            $date = $patient->dateofbirth;
            $name = $patient->wifename;
            $sex = 'Female';
            $nationalid = $patient->wifenationalid;
            $patientAge = $patient->wifeage;
            $stats = R::load('wifestatus', $patient->statuesid)->title;
            $job = R::load('wifejobs', $patient->wifejob)->title;
            $bl = $patient->wifebl;
         }
      }

      if (count($visit) > 0) {
         $role = R::load('awrole', $visit->for_department);
         $this->smarty->assign('deptName', $role->name);
         if ($visit->res_room_no > 0) {
            $room = R::load('residence_rooms', $visit->res_room_no);
            $this->smarty->assign('roomNo', $room->name);
         }

         $this->smarty->assign('bedNo', $visit->bed_no);
         $this->smarty->assign('visitDate', $visit->visitdate);

         $this->getReferredDr($visit->refer_doctor);

         if ($visit->for_doctor) {
            $phys = R::getRow('select name from awusers where user_id = ?', [$visit->for_doctor]);
            $this->smarty->assign('phys', $phys);
         }
      }

      if ($date == '0000-00-00' || is_null($date) || $date == '') {
         $age = 0;
      } else {
         $dateWife = new DateTime($date);
         $today1 = new DateTime(date('Y-m-d'));
         $interval = $today1->diff($dateWife);
         if ($interval->y > 0) {
            $age = $interval->y . ' Years';
         } elseif ($interval->m > 0) {
            $age = $interval->m . ' Months';
         } elseif ($interval->d >= 0) {
            $age = 1 + $interval->d . ' Days';
         }
      }

      if ($patient->governorate_center)
         $center = R::load('governorate_centers', $patient->governorate_center);

      if ($patient->governorate) {
         $governorate = R::load('governorate', $patient->governorate);
      }
      $bloodtype = '';
      if ($bl)
         $bloodtype = R::load('bloodtypes', $bl)->title;

      $this->smarty->assign('statusNo', $patient->statusno);
      $this->smarty->assign('name', $name);
      $this->smarty->assign('sex', $sex);
      $this->smarty->assign('age', $age);
      $this->smarty->assign('dateofbirth', $date);
      $this->smarty->assign('nationalid', $nationalid);
      $this->smarty->assign('address', $patient->address);
      $this->smarty->assign('city', $center->name);
      $this->smarty->assign('phone', $patient->phone);
      $this->smarty->assign('governorate', $governorate->name);
      $this->smarty->assign('patientAge', $patientAge);
      $this->smarty->assign('marital_st', $stats);
      $this->smarty->assign('job', $job);
      $this->smarty->assign('bloodtype', $bloodtype);
   }

   function multiValues($idsText, $tableName, $colName) {
      $v = 1;
      $values = ' ';
      $selectArray = explode(',', $idsText);

      foreach ($selectArray as $data) {
         $obj = R::findOne($tableName, ' ' . $colName . ' = ?  ', [$data]);
         if ($obj->deleted < 1) {
            if ($v > 1) {
               $values .= ' , ';
            }

            $values .= $obj->name;

            $v++;
         }
      }

      return $values;
   }

   function noteValues($values, $note) {
      if (!empty($note) && trim($note) != '' && $note != null) {
         $values .= ' ( ' . $note . ' )';
      }

      return $values;
   }

   public function del() {

      //check login
      autho::checkautho($this->hosturl);
      //        //check authoize
      //        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

      $id = filter_input(INPUT_POST, 'id');
      $tableName = filter_input(INPUT_POST, 'tableName');
      try {

         if ($tableName == "heart_reports") {
            R::exec('update  ' . $tableName . ' set deleted = 1 ,  delete_userid = ' . $_SESSION['user_id'] . '    ,  
                         delete_date = "' . date('Y-m-d H:i:s') . '" WHERE id = ' . $id);
         } else {
            R::exec('update  ' . $tableName . ' set deleted = 1  WHERE id = ' . $id);
         }
         echo 1;
      } catch (Exception $e) {
         echo $e;
      }
   }

   public function complete_one() {
      //check login
      autho::checkautho($this->hosturl);
      //check authoize
      autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

      $id = filter_input(INPUT_GET, 'id');
      $tableName = filter_input(INPUT_GET, 'tname');
      $show = filter_input(INPUT_GET, 'show');
      $patientid = filter_input(INPUT_GET, "patientid");
      try {
         if ($tableName == "ivf_report") {
            R::exec('update  ' . $tableName . ' set completed = 1  
                          ,   completed_date = "' . date('Y-m-d H:i:s') . '"    WHERE id = ' . $id);
         } else {
            R::exec('update  ' . $tableName . ' set completed = 1  WHERE id = ' . $id);
         }

         if (!empty($patientid)) {
            header('Location:' . $this->hosturl . '/controllers/' . $this->controllname . '.php?ac=' . $show . '&patientid=' . $patientid);
         } else {
            header('Location:' . $this->hosturl . '/controllers/' . $this->controllname . '.php?ac=' . $show);
         }
      } catch (Exception $e) {
         print_r($e);
         //    header('Location:' . $this->hosturl . '/error/notadd/' . $this->controllname);
      }
   }

   function getReferredDr($userId) {

      if ($userId > 0) {
         $refer = R::load('refer', $userId);
         $ref_dr = $refer['name'];
      } else {
         $ref_dr = 'لا يوجد';
      }

      $this->smarty->assign('ref_dr', $ref_dr);
   }

   public function update() {
      $id = filter_input(INPUT_POST, "id");
      $value = filter_input(INPUT_POST, "value");
      $tableName = filter_input(INPUT_POST, "tableName");
      $colName = filter_input(INPUT_POST, "colName");
      $patientId = filter_input(INPUT_POST, "patientId");
      $multi = filter_input(INPUT_POST, "multi");

      if ($tableName == 'falling_med') {
         $this->updatedrugs($id, $tableName, $colName, $value);
      }
      //here the update
      $mydata = R::load($tableName, $id);
      if ($multi == 1 || in_array($colName, ['present_history', 'present_illness', 'comorbidities', 'prev_surgeries', 'allergies', 'vaccinations', 'family_history', 'contagious_disease'])) {
         $selected = json_decode($value);
         sort($selected);
         $value = "";
         foreach ($selected as $myname) {
            $value = $value . $myname . ",";
         }
         $value = substr($value, 0, -1);
      }

      $mydata->$colName = $value;
      R::store($mydata);
   }

   public function addNewRecord() {
      $name = filter_input(INPUT_POST, "name");
      $id = filter_input(INPUT_POST, "id");
      $table = filter_input(INPUT_POST, "table");
      $mainTable = filter_input(INPUT_POST, "mainTable");
      $type = filter_input(INPUT_POST, "type");
      try {
         $mytable = R::xdispense($table);
         $mytable->name = $name;
         $mytable->conditions = 0;
         $insertid = R::store($mytable);

         $mydata = R::findone($mainTable, 'id = ?', [$id]);
         if ($type == 'multi') {
            if (empty($mydata->$table))
               $mydata->$table = $insertid;
            else
               $mydata->$table = $mydata->$table . ',' . $insertid;
         } else
            $mydata->$table = $insertid;
         R::store($mydata);
         echo $insertid;
      } catch (Exception $e) {
         echo $e;
      }
   }

   public function allPatientHistory() {
      //check login
      autho::checkautho($this->hosturl);
      //check authoize
      autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

      $colname = filter_input(INPUT_POST, "colName");
      $table;
      switch ($colname) {
         case 'present_history':
            $table = "present_history";
            break;
         case 'present_illness':
            $table = "present_illness";
            break;
         case 'comorbidities':
            $table = "comorbidities";
            break;
         case 'prev_surgeries':
            $table = "prev_surgeries";
            break;
         case 'allergies':
            $table = "allergies";
            break;
         case 'vaccinations':
            $table = "vaccinations";
            break;
         case 'family_history':
            $table = "family_history";
            break;
         case 'contagious_disease':
            $table = 'contagious_disease';
         default:
            break;
      }

      try {

         $alldata = R::findall($table, 'conditions = 0 order by name');
         $this->smarty->assign('alldata', $alldata);
         $this->smarty->assign('table', $table);
         $this->smarty->display('heart_reports/editmodel.html');
      } catch (Exception $e) {
         
      }
   }

   public function addNewRow() {

      //check login
      autho::checkautho($this->hosturl);
      //check authoize
      autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

      //vars here
      $table = filter_input(INPUT_POST, 'tablename');
      // var_dump($table);
      ### insert into table
      $newtable = R::xdispense($table);
      $newtable->conditions = 0;

      $insertid = R::store($newtable);

      echo $insertid;
   }

   public function delPresentHistory() {

      //check login
      autho::checkautho($this->hosturl);
      //check authoize
      autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

      $id = filter_input(INPUT_POST, "id");
      $tableName = filter_input(INPUT_POST, "tableName");
      $colName = filter_input(INPUT_POST, "colName");

      try {
         $obj = R::load($tableName, $id);
         if (!empty($colName) && $colName != '' && $colName != null) {
            $obj->$colName = 1;
         } else {
            $obj->conditions = 1;
         }
         R::store($obj);

         echo 1;
      } catch (Exception $e) {
         
      }
   }

   public function editselect() {
      //check login
      autho::checkautho($this->hosturl);
      //check authoize
      autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
      $tableName = filter_input(INPUT_POST, "tableName");
      $name = filter_input(INPUT_POST, "name");
      $patientid = filter_input(INPUT_POST, "patientid");
      $rowoftableid = filter_input(INPUT_POST, "rowoftableid");
      $maintableName = filter_input(INPUT_POST, "maintableName");

      $alldata = R::findAll($tableName, 'conditions = 0');

      // print_r($tableName);
      $this->smarty->assign('table', $tableName);
      $this->smarty->assign('selectname', $name);
      $this->smarty->assign('alldata', $alldata);
      $this->smarty->assign('patientid', $patientid);
      $this->smarty->assign('rowoftableid', $rowoftableid);
      $this->smarty->assign('maintableName', $maintableName);

      $this->smarty->display('heart_reports/editmodel.html');
   }

   function addNewMed() {
      $id = filter_input(INPUT_POST, "id");
      $itr = filter_input(INPUT_POST, "itr");
      $tableName = filter_input(INPUT_POST, "tableName");
      $mainId = rtrim($tableName, "med") . 'id';
      if ($id > 0) {
         $medication = R::xdispense($tableName);
         $medication->$mainId = $id;
         $medication->deleted = 0;
         $medication->id = R::store($medication);

         $this->smarty->assign('data', $medication);
         $this->smarty->assign('itr', $itr);
         $this->smarty->assign('tableName', $tableName);
         $this->loadDrugsData();

         $this->smarty->display('heart_reports/' . $tableName . '.html');
      }
   }

   function loadMed($table_id, $tableName) {
      $allMedData = R::getAll(
                      'select ' . $tableName . '_med.*, drugs.drugname  as drugName
                                                  from ' . $tableName . '_med   
                                                       LEFT JOIN  drugs ON ' . $tableName . '_med.drugid =drugs.id
                                                    where ' . $tableName . '_med.deleted != 1 and ' . $tableName . '_med.' . $tableName . '_id = ?  ',
                      [$table_id]
      );

      $this->smarty->assign('allMedData', $allMedData);
      $this->smarty->assign('medCount', count($allMedData));
   }

   function loadDrugsData() {
      $drugs = R::getAll('SELECT  id , drugname   FROM drugs where deleted != 1 order by drugname asc');
      $allDrugDoses = R::getAll('SELECT distinct  drugdos   FROM drugs order by drugdos asc');

      $this->smarty->assign('drugs', $drugs);
      $this->smarty->assign('allDrugDoses', $allDrugDoses);
   }

   private function updatedrugs($id, $tablename, $colname, $value) {
      $obj = R::load($tablename, $id);
      if ($colname == 'drugid') {
         if ($value != '') {
            $drug = R::load("drugs", $value);
            $obj->drugname = $drug->drugname;
         }
      }

      $obj->$colname = $value;
      try {
         R::store($obj);
      } catch (Exception $e) {
         
      }
   }

   function addCarePlan() {
      $id = filter_input(INPUT_POST, "id");
      $itr = filter_input(INPUT_POST, "itr");
      $tableName = filter_input(INPUT_POST, "tableName");
      $table = rtrim($tableName, "care_plan");
      $mainId = $table . '_id';

      if ($id > 0) {
         $carePlan = R::xdispense($tableName);
         $carePlan->$mainId = $id;
         $carePlan->deleted = 0;
         $carePlan->id = R::store($carePlan);

         $this->smarty->assign('data', $carePlan);
         $this->smarty->assign('itr', $itr);
         $this->smarty->assign('tableName', $tableName);
         $this->smarty->display('heart_reports/' . $tableName . '.html');
      }
   }

   function loadCarePlan($table_id, $tableName) {
      $allCarePlanData = R::getAll(
                      'select ' . $tableName . '_care_plan.*
            from ' . $tableName . '_care_plan   
            where ' . $tableName . '_care_plan.deleted != 1 and ' . $tableName . '_care_plan.' . $tableName . '_id = ?  ',
                      [$table_id]
      );

      $this->smarty->assign('allCarePlanData', $allCarePlanData);
      $this->smarty->assign('carePlanCount', count($allCarePlanData));
   }

   function getMonthNameFnAr($date) {
      $timestamp = strtotime($date);
      $month = date('M', $timestamp);
      $months = array("Jan" => "يناير", "Feb" => "فبراير", "Mar" => "مارس", "Apr" => "أبريل", "May" => "مايو", "Jun" => "يونيو", "Jul" => "يوليو", "Aug" => "أغسطس", "Sep" => "سبتمبر", "Oct" => "أكتوبر", "Nov" => "نوفمبر", "Dec" => "ديسمبر");
      $name = $month;
      foreach ($months as $key => $value) {
         if ($month == $key) {
            $name = $value;
            break;
         }
      }
      return $name;
   }

   function getVisitData() {
      $visitId = $_POST['visitid'];
      $visit = R::load('visits', $visitId);
      $doctorName = R::getRow('select name from awusers where user_id = ?', [$visit->for_doctor]);
      echo $doctorName['name'];
   }

   function getVisitDetails($visitId, $entry_data) {
      $visit = R::load('visits', $visitId);
      $programesetting = R::findOne('programesetting');

      $entry_data['entry_date'] = $visit->visitdate;

      $doctorName = R::getRow('select name from awusers where user_id = ?', [$visit->for_doctor]);
      $entry_data['doctorName'] = $doctorName['name'];

      if ($visit->organization_id > 0 && $programesetting->organizations != 1) {
         $visitOrg = R::load('organizations', $visit->organization_id);
         $entry_data['orgName'] = $visitOrg->organization_name;
      }

      if ($visit->detectionid > 0) {
         $detection = R::load('detections', $visit->detectionid);
         $entry_data['detName'] = $detection->title;
      }


      return $entry_data;
   }
}
