<?php

/*
 * awframework from aw.inc present aw controller
 * it will help you develop easy and fast with secure tools
 * you can edit and add what you feel right
 * don't change in structure of file
 */

require_once("imp/_imp.php");

class Controllers {

    public $smarty;
    public $hosturl;
    public $controllname;
    public $shcontrollname;
    public $active;

    public function __construct() {
        require_once("../public/aw_config.php");
        require_once("imp/_autho.php"); //general functions
        $this->smarty = $smarty;
        $this->hosturl = $hosturl;

        $this->controllname = 'externals';
        $this->shcontrollname = 'externals';
        $this->smarty->assign('controllname', $this->controllname);
        $this->smarty->assign('shcontrollname', $this->shcontrollname);

        require_once("../../_library/plugins/Breadcrumbs/Breadcrumbs.php");
        $acty = filter_input(INPUT_GET, 'ac');
        $bc = new breadcrumbs($hosturl, '', '', $acty);
        $bc->crumbs();
        $breadcrumbs = $bc->breadcrumbs;
        $smarty->assign('breadcrumbs', $breadcrumbs);

        $active[0] = 'externals'; //controller name or tab name
        $this->active = $active;

        R::ext('xdispense', function ($type) {
            return R::getRedBean()->dispense($type);
        });

        require_once("_header.php");
        require_once("_patientdata.php");
        require_once("_sidebar.php");
        require_once("_leftsidebar.php");
        require_once("_footer.php");
    }

    public function index() {
        
    }

    public function visit_info() {

        $visitId = 535; //filter_input(INPUT_GET, "patientid");
        $visit = R::load('visits', $visitId);
        if (count($visit) > 0) {
            $this->smarty->assign('visitDate', date("Y/m/d", strtotime($visit->visitdate)));
            $this->smarty->assign('visitDateC', (date("Y-m-d", strtotime($visit->visitdate))) . ' 12:00:00');
            $this->smarty->assign('dayName', $this->getDayNameFnAr($visit->visitdate));

            if ($visit->visitdate >= date('Y-m-d')) {
                $sql = '   and for_doctor  =  ' . $visit->for_doctor . '  and for_department  =  ' . $visit->for_department;
                $programesetting = R::findOne('programesetting');
                date_default_timezone_set('Africa/Cairo');
                $time = date('H', time());

                if ($time <= $programesetting->addshours) {
                    ## iam now at extra time show yesterday visits  also
                    $allvisit = R::count('visits', 'visitdate in (? , ? )  and deleted = ?  and customer_add != 1   ' . $sql . '
                                                  ORDER BY id ASC  ', [date('Y-m-d'), date('Y-m-d', strtotime("-1 days")), 0]);
                    $viewed = R::count('visits', 'visitdate in (? , ? )  and deleted = ?   and view = 1 and id <   ' . $visit->id . ' 
                                                        and customer_add != 1   ' . $sql . '
                                                  ORDER BY id ASC  ', [date('Y-m-d'), date('Y-m-d', strtotime("-1 days")), 0]);
                    $me = R::count('visits', 'visitdate in (? , ? )  and deleted = ?   
                                                        and customer_add != 1   ' . $sql . ' and id <=   ' . $visit->id . ' 
                                                  ORDER BY id ASC  ', [date('Y-m-d'), date('Y-m-d', strtotime("-1 days")), 0]);
                } else {
                    $allvisit = R::count('visits', 'visitdate = ?  and deleted = ?    and customer_add != 1
                             ' . $sql . '      ORDER BY id ASC  ', [date('Y-m-d'), 0]);

                    $viewed = R::count('visits', 'visitdate = ?  and deleted = ?    and customer_add != 1   and view = 1 
                             and id <   ' . $visit->id . '    ' . $sql . '      ORDER BY id ASC  ', [date('Y-m-d'), 0]);

                    $me = R::count('visits', 'visitdate = ?  and deleted = ?    and customer_add != 1  and id <=   ' . $visit->id . ' 
                             ' . $sql . '      ORDER BY id ASC  ', [date('Y-m-d'), 0]);
                }

                $this->smarty->assign('current', $viewed + 1);
                $this->smarty->assign('yours', $me);
            } else {
                $this->smarty->assign('passed', 1);
            }
        }

        $this->smarty->display('externals/ticket.tpl');
    }

    private function getDayNameFnAr($date) {
        $timestamp = strtotime($date);

        $day = date('w', $timestamp);

        switch ($day) {
            case 0:
                $name = 'الأحد  ';
                break;
            case 1:
                $name = ' الإثنين';
                break;
            case 2:
                $name = ' الثلاثاء';
                break;
            case 3:
                $name = 'الأربعاء ';
                break;
            case 4:
                $name = 'الخميس  ';
                break;
            case 5:
                $name = 'الجمعة ';
                break;
            case 6:
                $name = 'السبت ';
                break;
        }

        return $name;
    }

    // at the end of class call
    public function __destruct() {
        //close connection
        R::close();
    }

}
