<?php

//require_once("imp/_imp.php");
require_once("../public/aw_config.php");
//include PHPExcel library
require_once "Classes/PHPExcel/IOFactory.php";

startexcel();

function startexcel() {
    $lists = R::findAll('price_lists', '  deleted = 0 ');
    $detections = R::findAll('detections', '  del != 1  and title != ""      order by title asc ');
    $sql = ' select   invests.id ,  invests.name , invests.price  ,   investcats.name  as catName
                                from    invests
                                join  investcats                     on investcats.id   = invests.investcatid
                                where  invests.deleted != 1   and invests.name  != ""       order by  invests.investcatid asc
                                ,   invests.name asc  ';
    $invests = R::getAll($sql);

    $sql = ' select   rays.id ,  rays.name , rays.price  ,   rayscats.name  as catName
                                from    rays
                                join  rayscats                       on rayscats.id   = rays.rayscatid
                                where  rays.deleted != 1   and rays.name  != ""        order by  rays.rayscatid asc
                                ,   rays.name asc  ';
    $rays = R::getAll($sql);

    createSingleExcel($lists, $detections, $invests, $rays);
}

function createSingleExcel($lists, $detections, $invests, $rays) {
    $table = createhtmltable($lists, $detections, $invests, $rays);

    ################## Save excel sheet  ##########################################        
    ##  prepare download
    $filename = 'all_lists.xlsx';

    ## Put the html into a temporary file
    $tmpfile = time() . '.html';
    file_put_contents($tmpfile, $table);

    ## Read the contents of the file into PHPExcel Reader class
    $reader = new PHPExcel_Reader_HTML;
    $content = $reader->load($tmpfile);

############### #################################### style ###########################################
    $content = style($content);
    $content = contentAfter($content, $lists, $detections, $invests, $rays);
###############################################################################################################
    //prepare download
    // Pass to writer and output as needed

    $objWriter = PHPExcel_IOFactory::createWriter($content, 'Excel2007');

    $target_dir = "../excel_backups";
    if (!file_exists($target_dir)) {
        mkdir($target_dir . '/', 0777, true);
    }

    $objWriter->save('../excel_backups/' . $filename);
    //$objWriter->save(str_replace($filename,'../excel_backups/xx.xls',$filename));   ## this replace if file with the same name exist
    // Delete temporary file
    unlink($tmpfile);
}

function createhtmltable($lists, $detections, $invests, $rays) {
    $tables = '';
    $tables .= lists($lists, $detections, $invests, $rays);
    #############################################################################     
    return $tables;
}

######## Data

function lists($lists, $detections, $invests, $rays) {
    $table = '';
    foreach ($lists as $list) {
        $table .= '<table>';
        $table .= '<tr> ';
        $table .= '<td>' . $list->id . ' </td><td></td><td>' . $list->name . ' </td><td></td><td></td><td></td>';
        $table .= '</tr> ';
        $table .= detections($detections);
        $table .= invests($invests);
        $table .= rays($rays);
        $table .= '</table>';
    }
    return $table;
}

function detections($detections) {
    $table = ' ';
    $table .= '<tr> ';
    $table .= '<td></td><td></td><td> Services</td><td></td><td></td><td></td>';
    $table .= '</tr> ';
    $table .= '<tr> ';
    $table .= '<td></td> <td></td>
                <td> contract_price  </td>
                 <td>  patient_hold </td>
                 <td>discount_type </td>
                <td></td>';
    $table .= '</tr> ';
    foreach ($detections as $det) {
        $table .= '<tr> ';
        $table .= '<td>' . $det->id . ' </td><td>' . $det->title . ' </td><td></td><td></td><td></td><td></td>';
        $table .= '</tr> ';
    }
    return $table;
}

function invests($invests) {
    $table = '<tr><td> </td><td> </td><td></td><td></td><td></td><td></td></tr> ';
    $table .= '<tr> ';
    $table .= '<td></td><td> </td><td> Invests</td><td></td><td></td><td></td>';
    $table .= '</tr> ';
    $table .= '<tr> ';
    $table .= '<td></td> <td> </td>
                <td> contract_price  </td>
                 <td>  patient_hold </td>
                 <td>discount_type </td>
                <td></td>';
    $table .= '</tr> ';
    foreach ($invests as $invest) {
        $table .= '<tr> ';
        $table .= '<td>' . $invest['id'] . ' </td><td>' . $invest['name'] . ' </td><td></td><td></td><td></td><td></td>';
        $table .= '</tr> ';
    }
    return $table;
}

function rays($rays) {
    $table = '<tr><td> </td><td> </td><td></td><td></td><td></td><td></td></tr> ';
    $table .= '<tr> ';
    $table .= '<td></td><td> </td><td> Rays</td><td></td><td></td><td></td>';
    $table .= '</tr> ';
    $table .= '<tr> ';
    $table .= '<td></td> <td> </td>
                <td> contract_price  </td>
                 <td>  patient_hold </td>
                 <td>discount_type </td>
                <td></td>';
    $table .= '</tr> ';
    foreach ($rays as $ray) {
        $table .= '<tr> ';
        $table .= '<td>' . $ray['id'] . ' </td><td>' . $ray['name'] . ' </td><td></td><td></td><td></td><td></td>';
        $table .= '</tr> ';
    }
    return $table;
}

######## style  

function style($content) {
    ## Auto size columns for active sheet
    foreach (range('A ', 'Z') as $columnID) {
        $content->getActiveSheet()->getColumnDimension($columnID)->setAutoSize(true);
    }
    foreach (range('A ', 'A') as $columnID) {
        $content->getActiveSheet()->getColumnDimension($columnID)->setAutoSize(true);
    }

    return $content;
}

function contentAfter($content, $lists, $detections, $invests, $rays) {

    ## backdround color   and font style
    $backColorArray = array('fill' => array('type' => PHPExcel_Style_Fill::FILL_SOLID
            , 'color' => array('rgb' => '2bd476'),));

    $i = 2;
    $step = count($detections) + count($invests) + count($rays) + 10;
    $stepAll = ($step * count($lists)) + (2 * count($lists));

    foreach ($lists as $list) {

        if ($i >= 2 && $i < $stepAll) {
            $content->getActiveSheet()->setCellValue('C' . $i, $list->name);
            $content->getActiveSheet()->getStyle('A' . $i . ':E' . $i)->applyFromArray($backColorArray);
            $content = sectionHead($content, $i, $detections, $invests, $rays);
        }
        $i = $i + $step;
    }
    return $content;
}

function sectionHead($content, $i, $detections, $invests, $rays) {
    $iSer = $i + 1;
    $xSer = $iSer + 1;

    $iInv = $xSer + count($detections) + 2;
    $xInv = $iInv + 1;

    $iRay = $xInv + count($invests) + 2;
    $xRay = $iRay + 1;

    $content->getActiveSheet()->setCellValue('C' . $iSer, ' الخدمات ');
    $content->getActiveSheet()->setCellValue('C' . $iInv, 'التحاليل');
    $content->getActiveSheet()->setCellValue('C' . $iRay, 'الأشعة');

    $content->getActiveSheet()->setCellValue('C' . $xSer, '  سعر التعاقد ');
    $content->getActiveSheet()->setCellValue('D' . $xSer, '  نسبة التحمل');
    $content->getActiveSheet()->setCellValue('E' . $xSer, 'نوع   التحمل  ');

    $content->getActiveSheet()->setCellValue('C' . $xInv, '  سعر التعاقد ');
    $content->getActiveSheet()->setCellValue('D' . $xInv, '  نسبة التحمل');
    $content->getActiveSheet()->setCellValue('E' . $xInv, 'نوع   التحمل  ');

    $content->getActiveSheet()->setCellValue('C' . $xRay, '  سعر التعاقد ');
    $content->getActiveSheet()->setCellValue('D' . $xRay, '  نسبة التحمل');
    $content->getActiveSheet()->setCellValue('E' . $xRay, 'نوع   التحمل  ');

    $backColorArray = array('fill' => array('type' => PHPExcel_Style_Fill::FILL_SOLID
            , 'color' => array('rgb' => 'e4d88d'),));

    $content->getActiveSheet()->getStyle('A' . $iSer . ':E' . $iSer)->applyFromArray($backColorArray);
    $content->getActiveSheet()->getStyle('A' . $iInv . ':E' . $iInv)->applyFromArray($backColorArray);
    $content->getActiveSheet()->getStyle('A' . $iRay . ':E' . $iRay)->applyFromArray($backColorArray);

    $backColorArray = array('fill' => array('type' => PHPExcel_Style_Fill::FILL_SOLID
            , 'color' => array('rgb' => 'f6cfcf'),));

    $content->getActiveSheet()->getStyle('C' . $xSer . ':E' . $xSer)->applyFromArray($backColorArray);
    $content->getActiveSheet()->getStyle('C' . $xInv . ':E' . $xInv)->applyFromArray($backColorArray);
    $content->getActiveSheet()->getStyle('C' . $xRay . ':E' . $xRay)->applyFromArray($backColorArray);

    $content = detectionCorrect($content, $xSer + 1, $detections);
    $content = investCorrect($content, $xInv + 1, $invests);
    $content = raysCorrect($content, $xRay + 1, $rays);
    return $content;
}

function detectionCorrect($content, $i, $detections) {
    foreach ($detections as $det) {
        $content->getActiveSheet()->setCellValue('B' . $i, $det->title);
        $i++;
    }
    return $content;
}

function investCorrect($content, $i, $invests) {
    foreach ($invests as $invest) {
        $content->getActiveSheet()->setCellValue('B' . $i, $invest['name']);
        $i++;
    }
    return $content;
}

function raysCorrect($content, $i, $rays) {
    foreach ($rays as $ray) {
        $content->getActiveSheet()->setCellValue('B' . $i, $ray['name']);
        $i++;
    }
    return $content;
}
