<?php

/*
 * awframework from aw.inc present aw controller
 * it will help you develop easy and fast with secure tools
 * you can edit and add what you feel right
 * don't change in structure of file
 */

use RedBeanPHP\RedException;

require_once("imp/_imp.php");

/**
 * @class calendar
 */
class Controllers
{

    //public vars
    public $smarty;
    public $host_url;
    public $controlName;
    public $active;
    public $patientId;

    /**
     * @throws RedException
     */
    public function __construct()
    {
        require_once('../public/aw_config.php');
        require_once("imp/_autho.php"); //general functions
        /** @var $smarty
         * @var $hosturl
         */
        $this->smarty = $smarty;
        $this->host_url = $hosturl;

        require_once("../../_library/plugins/Breadcrumbs/Breadcrumbs.php");
        $action = filter_input(INPUT_GET, 'ac');
        $bc = new breadcrumbs($hosturl, '', '', $action);
        $bc->crumbs();
        $breadcrumbs = $bc->breadcrumbs;
        $smarty->assign('breadcrumbs', $breadcrumbs);

        $this->controlName = 'endoscopy';
        $shcontrollname = 'Endoscopy';
        $this->smarty->assign('controllname', $this->controlName);
        $this->smarty->assign('shcontrollname', $shcontrollname);

        $active[0] = 'endoscopy';
        $active[1] = $this->controlName;
        $active[2] = 'show';
        $this->active = $active;

        R::ext('xdispense', static function ($type) {
            return R::getRedBean()->dispense($type);
        });

        require_once("_header.php");
        require_once("_sidebar.php");
        require_once("_leftsidebar.php");
        require_once("_footer.php");
        require_once("_patientdata.php");

        $this->patientId = patientdata::patientid();
    }

    public function index()
    {
        $this->authChecking();
        $this->checkPatientId();

        $patientInfo = R::findOne('patients', 'id = ?', [$this->patientId]);
        $this->smarty->assign('patientInfo', $patientInfo);

        $dateWife = new DateTime($patientInfo->dateofbirth);
        $today = new DateTime(date('Y-m-d'));
        $interva2 = $today->diff($dateWife);
        $this->smarty->assign('new_age_calc', $interva2->y);
        $refer_doctor = R::findOne('awusers', 'user_id = ?', [$patientInfo->refer_doctor]);
        $this->smarty->assign('refer_doctor', $refer_doctor);

        $templateData = R::findOne('endoscopy_template', 'id = 1');
        $this->smarty->assign('template_data', $templateData);

        $this->smartyHtml('endoscopy/endoscopy/add.html.tpl');
    }

    public function add()
    {
        $this->authChecking();

        $bean = R::dispense('endoscopy');
        $bean->patient_id = $patientID = filter_input(INPUT_POST, 'patient_id');
        $bean->exam_date = filter_input(INPUT_POST, 'exam_date');
        $bean->indication = filter_input(INPUT_POST, 'indication');
        $bean->anesthesia = filter_input(INPUT_POST, 'anesthesia');
        $bean->procedure = filter_input(INPUT_POST, 'procedure');
        $bean->esophagus = filter_input(INPUT_POST, 'esophagus');
        $bean->cardio_esophageal_junction= filter_input(INPUT_POST, 'cardio_esophageal_junction');
        $bean->stomach = filter_input(INPUT_POST, 'stomach');
        $bean->pylorus = filter_input(INPUT_POST, 'pylorus');
        $bean->duodenum = filter_input(INPUT_POST, 'duodenum');
        $bean->conclusion = filter_input(INPUT_POST, 'conclusion');
        $bean->signature = filter_input(INPUT_POST, 'signature');
        $bean->created_at = date('Y-m-d H:i:s');
        $bean->updated_at = date('Y-m-d H:i:s');

        try {
            R::store($bean);
            header('Location:' . $this->host_url . '/controllers/' . $this->controlName . '.php?ac=show&patientid=' . $patientID);
        } catch (Exception $e) {
            header('Location:' . $this->host_url . '/controllers/error?ac=notadd&id=' . $this->controlName);
        }
    }

    public function show()
    {

        $this->authChecking();
        $this->checkPatientId();

        $arr = R::findAll('endoscopy', 'patient_id = ? order by exam_date', [$this->patientId]);
        $this->smarty->assign('arr', $arr);

        $this->smartyHtml('endoscopy/endoscopy/show.html.tpl');
    }

    public function edit()
    {

        $this->authChecking();
        $this->checkPatientId();

        $patientInfo = R::findOne('patients', 'id = ?', [$this->patientId]);
        $this->smarty->assign('patientInfo', $patientInfo);

        $dateWife = new DateTime($patientInfo->dateofbirth);
        $today = new DateTime(date('Y-m-d'));
        $interva2 = $today->diff($dateWife);
        $this->smarty->assign('new_age_calc', $interva2->y);
        $refer_doctor = R::findOne('awusers', 'user_id = ?', [$patientInfo->refer_doctor]);
        $this->smarty->assign('refer_doctor', $refer_doctor);

        $id = filter_input(INPUT_GET, 'id');
        $endoscopy = R::findOne('endoscopy', 'id = ? and patient_id = ?', [$id, $this->patientId]);
        $this->smarty->assign('edit_data', $endoscopy);

        $this->smartyHtml('endoscopy/endoscopy/edit.html.tpl');
    }

    public function update()
    {
        $this->authChecking();

        $id = filter_input(INPUT_POST, 'id');

        $bean = R::load('endoscopy', $id);
        $bean->patient_id = $patientID = filter_input(INPUT_POST, 'patient_id');
        $bean->exam_date = filter_input(INPUT_POST, 'exam_date');
        $bean->indication = filter_input(INPUT_POST, 'indication');
        $bean->anesthesia = filter_input(INPUT_POST, 'anesthesia');
        $bean->procedure = filter_input(INPUT_POST, 'procedure');
        $bean->esophagus = filter_input(INPUT_POST, 'esophagus');
        $bean->cardio_esophageal_junction= filter_input(INPUT_POST, 'cardio_esophageal_junction');
        $bean->stomach = filter_input(INPUT_POST, 'stomach');
        $bean->pylorus = filter_input(INPUT_POST, 'pylorus');
        $bean->duodenum = filter_input(INPUT_POST, 'duodenum');
        $bean->conclusion = filter_input(INPUT_POST, 'conclusion');
        $bean->signature = filter_input(INPUT_POST, 'signature');
        $bean->updated_at = date('Y-m-d H:i:s');

        try {
            R::store($bean);
            header('Location:' . $this->host_url . '/controllers/' . $this->controlName . '.php?ac=show&patientid=' . $patientID);
        } catch (Exception $e) {
            header('Location:' . $this->host_url . '/controllers/error?ac=notupdate&id=' . $this->controlName);
        }
    }

    public function del()
    {

        $this->authChecking();

        $item_id = filter_input(INPUT_POST, 'id');
        $from_ajax = filter_input(INPUT_POST, 'fromajax');

        $endoscopy = R::load('endoscopy', $item_id);

        try {
            R::trash($endoscopy);
            echo '1';
        } catch (Exception $e) {
            if (!$from_ajax) {
                header('Location:' . $this->host_url . '/controllers/error?ac=notdel&id=' . $this->controlName);
            } else {
                echo '0';
            }
        }
    }

    public function uploadImage()
    {

        $this->authChecking();
        $this->checkPatientId();

        $patientInfo = R::findOne('patients', 'id = ?', [$this->patientId]);
        $this->smarty->assign('patientInfo', $patientInfo);

        $dateWife = new DateTime($patientInfo->dateofbirth);
        $today = new DateTime(date('Y-m-d'));
        $interva2 = $today->diff($dateWife);
        $this->smarty->assign('new_age_calc', $interva2->y);
        $refer_doctor = R::findOne('awusers', 'user_id = ?', [$patientInfo->refer_doctor]);
        $this->smarty->assign('refer_doctor', $refer_doctor);

        $id = filter_input(INPUT_GET, 'id');
        $endoscopy = R::findOne('endoscopy', 'id = ? and patient_id = ?', [$id, $this->patientId]);
        $this->smarty->assign('edit_data', $endoscopy);

        $endoscopyImages = R::findAll('endoscopy_images', 'patient_id = ? and endoscopy_id = ?', [$this->patientId, $id]);
        $this->smarty->assign('endoscopy_images', $endoscopyImages);

        $this->smartyHtml('endoscopy/endoscopy/upload_images.html.tpl');
    }

    public function upload()
    {
        $this->authChecking(true, false);

        require_once("../../_library/plugins/classupload/uploadfunctions.php");

        $image = uploadnew('file', false, 0, 0, 'endoscopy', false);
        $bean = R::xdispense('endoscopy_images');
        $bean->image = $image;
        $bean->patient_id = filter_input(INPUT_POST, 'patient_id');
        $bean->endoscopy_id = filter_input(INPUT_POST, 'endoscopy_id');
        $bean->create_date = date('Y-m-d');
        $id = R::store($bean);
        echo $id;
    }

    public function removeImage()
    {
        $this->authChecking(true, false);

        $itemId = filter_input(INPUT_POST, 'id');

        $bean = R::findOne('endoscopy_images', 'id = ?', [$itemId]);

        if (file_exists('../../upload/endoscopy/' . $bean->image)) {
            chmod('../../upload/endoscopy/' . $bean->image, 0777);
            unlink('../../upload/endoscopy/' . $bean->image);
        }

        try {
            R::trash($bean);
            echo '1';
        } catch (Exception $e) {
            echo '0';
        }
    }

    public function printReport()
    {
        $this->authChecking();
        $this->patientId = filter_input(0, 'patientId');

        $patientInfo = R::findOne('patients', 'id = ?', [$this->patientId]);
        $this->smarty->assign('patientInfo', $patientInfo);

        $dateWife = new DateTime($patientInfo->dateofbirth);
        $today = new DateTime(date('Y-m-d'));
        $interva2 = $today->diff($dateWife);
        $this->smarty->assign('new_age_calc', $interva2->y);
        $refer_doctor = R::findOne('awusers', 'user_id = ?', [$patientInfo->refer_doctor]);
        $this->smarty->assign('refer_doctor', $refer_doctor);

        $id = filter_input(0, 'id');
        $endoscopy = R::findOne('endoscopy', 'id = ? and patient_id = ?', [$id, $this->patientId]);
        $this->smarty->assign('edit_data', $endoscopy);

        $templateData = R::findOne('endoscopy_template', 'id = 1');
        $this->smarty->assign('template_data', $templateData);

        $endoscopyImages = R::findAll('endoscopy_images', 'patient_id = ? and endoscopy_id = ?', [$this->patientId, $id]);
        $this->smarty->assign('endoscopy_images', $endoscopyImages);

        $this->smarty->display('endoscopy/endoscopy/print.html.tpl');
    }

    public function __destruct()
    {
        R::close();
    }

    /**
     * @return void
     */
    protected function smartyHtml($file_path)
    {
        header::headershow($this->smarty, $this->host_url);
        sidebar::sidebarshow($this->smarty, $this->host_url, $this->active);
        $this->smarty->display($file_path);
        leftsidebar::leftsidebarshow($this->smarty, $this->host_url);
        footer::footershow($this->smarty, $this->host_url);
    }

    /**
     * @return void
     */
    protected function authChecking($loginCheck = true, $permissionCheck = true)
    {
        !$loginCheck ?: autho::checkautho($this->host_url);
        !$permissionCheck ?: autho::checkauthoize($this->controlName, $this->host_url, $_SESSION['role_id']);
    }

    /**
     * @return void
     */
    protected function checkPatientId()
    {
        $patientId = filter_input(INPUT_GET, "patientid");
        $this->smarty->assign('patientId', $patientId);
        if (empty($this->patientId)) {
            header('Location:' . $this->host_url . '/controllers/index.php?empty=1');
            exit();
        }
    }


}
