<?php

require_once("imp/_imp.php");

class Controllers {

//public vars
    public $smarty;
    public $hosturl;
    public $controllname;
    public $shcontrollname;
    public $active;
    public $time;
    public $today;
    public $patientid;

// it will run in everytime with
// default requried
    public function __construct() {
        require_once("../public/aw_config.php");
        require_once("imp/_autho.php"); //general functions
        $this->smarty = $smarty;
        $this->hosturl = $hosturl;

//here name of controll to known
        $this->controllname = 'embryology';
        $this->shcontrollname = 'embryology';
        $this->smarty->assign('controllname', $this->controllname);
        $this->smarty->assign('shcontrollname', $this->shcontrollname);


        require_once("../../_library/plugins/classupload/uploadfunctions.php");

//breadcrumbs
        require_once("../../_library/plugins/Breadcrumbs/Breadcrumbs.php");
        $acty = filter_input(INPUT_GET, 'ac');
        $bc = new breadcrumbs($hosturl, '', '', $acty);
        $bc->crumbs();
        $breadcrumbs = $bc->breadcrumbs;
        $smarty->assign('breadcrumbs', $breadcrumbs);

# here show the active page in menu
// array called active[] with level of active element
        $active[0] = 'embryology'; //controller name or tab name
        $active[1] = 'embryology'; //controller name
// do name  // switch($do)
        switch ($acty) {
            case '':$active[2] = 'embryologyadd';
                break;
            case 'show':$active[2] = 'embryologyshow';
                break;
            default :$active[2] = 'embryologyshow';
                break;
        }
        $this->active = $active;



//here will call all php pages
        require_once("_header.php");
        require_once("_patientdata.php");
        require_once("_sidebar.php");
        require_once("_leftsidebar.php");
        require_once("_footer.php");

        $this->patientid = patientdata::patientid();

        //find loading time
        $this->time = microtime(true);
        $this->today = date('Y-m-d');
    }

    public function index() {


        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $patientid = filter_input(INPUT_GET, "patientid");
         if (empty($this->patientid)) {
            header('Location:' . $this->hosturl . '/controllers/index.php?empty=1');
            exit();
        }
        $this->smarty->assign('patientId', $patientid);
        //load all parents here
        $showElems = R::getAll('SELECT embryologyreport.id as embryologyreport_id,embryologyreport.clinician_id,
            embryologyreport.patient_id as patientId,awusers.name as clinician_name,
            patients.wifename as wifename from embryologyreport
             LEFT JOIN  awusers ON embryologyreport.clinician_id =awusers.user_id
              LEFT JOIN  patients ON embryologyreport.patient_id =patients.id where embryologyreport.patient_id=' . $patientid . ' order by embryologyreport_id desc
         ');
        $this->smarty->assign('showElems', $showElems);

//        $patient = R::load("patients", $patientid);
//
//        $wifename = $patient->wifename;
//        $this->smarty->assign('wifename', $wifename);
        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        if ($patientid) {
            patientdata::patientdatashow($this->smarty, $this->hosturl);
        }
        $this->smarty->display('embryology/show.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function add() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        $patientid = filter_input(INPUT_GET, "patientid");
        $this->smarty->assign('patientId', $patientid);
        if (empty($this->patientid)) {
            header('Location:' . $this->hosturl . '/controllers/index.php?empty=1');
            exit();
        }
        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        if ($patientid) {
            patientdata::patientdatashow($this->smarty, $this->hosturl);
        }

        $users = R::getAll("select* from awusers");
        $this->smarty->assign('users', $users);

        $clinician = R::getAll("select* from awusers where role_id=4");
        $this->smarty->assign('clinician', $clinician);

        $embryologist = R::getAll("select* from awusers where role_id=11");
        $this->smarty->assign('embryologist', $embryologist);

        $this->smarty->display('embryology/add.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function addit() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //vars here

        $patientid = filter_input(INPUT_GET, "patientid");
        $clinician = filter_input(INPUT_POST, 'clinician');
        $embryologist = filter_input(INPUT_POST, 'embryologist');
        $day_of_transfer = filter_input(INPUT_POST, 'day_of_transfer');
        $date = filter_input(INPUT_POST, 'date');
        $sperm_source = filter_input(INPUT_POST, 'sperm_source');
        $count = filter_input(INPUT_POST, 'count');
        $motility = filter_input(INPUT_POST, 'motility');
        $morphology = filter_input(INPUT_POST, 'morphology');
        $oocyte_retrived = filter_input(INPUT_POST, 'oocyte_retrived');
        $mii = filter_input(INPUT_POST, 'mii');
        $mi = filter_input(INPUT_POST, 'mi');
        $gv = filter_input(INPUT_POST, 'gv');
        $atretic = filter_input(INPUT_POST, 'atretic');
        $empty_follicle = filter_input(INPUT_POST, 'empty_follicle');
        $fertilized_egg = filter_input(INPUT_POST, 'fertilized_egg');
        $cleavage = filter_input(INPUT_POST, 'cleavage');
        $embryo_transfer_stage = filter_input(INPUT_POST, 'embryo_transfer_stage');
        $embryo_transfer_grade = filter_input(INPUT_POST, 'embryo_transfer_grade');
        $embryo_freezing_embryos = filter_input(INPUT_POST, 'embryo_freezing_embryos');
        $embryo_freezing_straws = filter_input(INPUT_POST, 'embryo_freezing_straws');
        $embryo_freezing_day = filter_input(INPUT_POST, 'embryo_freezing_day');
        $embryologyimg = uploadnew("embryologyimg", False, 0, 0, 'embryologyimg');

        $this->smarty->assign('patientId', $patientid);

        //here the add
        $report = R::dispense('embryologyreport');

        $report->patient_id = $patientid;
        $report->clinician_id = $clinician;
        $report->embryologist_id = $embryologist;
        $report->day_of_transfer = $day_of_transfer;
        $report->date = $date;
        $report->sperm_source = $sperm_source;
        $report->count = $count;
        $report->motility = $motility;
        $report->morphology = $morphology;
        $report->oocyte_retrived = $oocyte_retrived;
        $report->mii = $mii;
        $report->mi = $mi;
        $report->gv = $gv;
        $report->atretic = $atretic;
        $report->empty_follicle = $empty_follicle;
        $report->fertilized_egg = $fertilized_egg;
        $report->cleavage = $cleavage;
        $report->embryo_transfer_stage = $embryo_transfer_stage;
        $report->embryo_transfer_grade = $embryo_transfer_grade;
        $report->embryo_freezing_embryos = $embryo_freezing_embryos;
        $report->embryo_freezing_straws = $embryo_freezing_straws;
        $report->embryo_freezing_day = $embryo_freezing_day;
        $report->embryologyimg = $embryologyimg;


        try {
            $id = R::store($report);
            if (!empty($patientid)) {
                header('Location:' . $this->hosturl . '/controllers/' . $this->controllname . '.php?ac=show&patientid=' . $patientid);
            } else {
                header('Location:' . $this->hosturl . '/controllers/' . $this->controllname . '.php?ac=show');
            }
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/error/notadd/' . $this->controllname);
        }
    }

    public function show() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $patientid = filter_input(INPUT_GET, "patientid");
        $this->smarty->assign('patientId', $patientid);
        //load all parents here
        $showElems = R::getAll('SELECT embryologyreport.id as embryologyreport_id,embryologyreport.clinician_id,
            embryologyreport.patient_id as patientId,awusers.name as clinician_name,
            patients.wifename as wifename from embryologyreport
             LEFT JOIN  awusers ON embryologyreport.clinician_id =awusers.user_id
              LEFT JOIN  patients ON embryologyreport.patient_id =patients.id where embryologyreport.patient_id=' . $patientid . ' order by embryologyreport_id desc
         ');
        $this->smarty->assign('showElems', $showElems);

//        $patient = R::load("patients", $patientid);
//
//        $wifename = $patient->wifename;
//        $this->smarty->assign('wifename', $wifename);
        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        if ($patientid) {
            patientdata::patientdatashow($this->smarty, $this->hosturl);
        }
        $this->smarty->display('embryology/show.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function edit() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //get id for item
        $id = filter_input(INPUT_GET, 'id');
        $patientid = filter_input(INPUT_GET, "patientid");
        //load all here
        $editElement = R::load('embryologyreport', $id);
        $this->smarty->assign('editElement', $editElement);
//        print_r($editElement);
        $this->smarty->assign('patientId', $patientid);


        $clinician = R::getAll("select* from awusers where role_id=4");
        $this->smarty->assign('clinician', $clinician);

        $embryologist = R::getAll("select* from awusers where role_id=11");
        $this->smarty->assign('embryologist', $embryologist);

        $users = R::getAll("select* from awusers");
        $this->smarty->assign('users', $users);

        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        if ($patientid) {
            patientdata::patientdatashow($this->smarty, $this->hosturl);
        }
        $this->smarty->display('embryology/edit.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function updateit() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //vars here
        $patientid = filter_input(INPUT_GET, "patientid");
        $clinician = filter_input(INPUT_POST, 'clinician');
        $embryologist = filter_input(INPUT_POST, 'embryologist');
        $day_of_transfer = filter_input(INPUT_POST, 'day_of_transfer');
        $date = filter_input(INPUT_POST, 'date');
        $sperm_source = filter_input(INPUT_POST, 'sperm_source');
        $count = filter_input(INPUT_POST, 'count');
        $motility = filter_input(INPUT_POST, 'motility');
        $morphology = filter_input(INPUT_POST, 'morphology');
        $oocyte_retrived = filter_input(INPUT_POST, 'oocyte_retrived');
        $mii = filter_input(INPUT_POST, 'mii');
        $mi = filter_input(INPUT_POST, 'mi');
        $gv = filter_input(INPUT_POST, 'gv');
        $atretic = filter_input(INPUT_POST, 'atretic');
        $empty_follicle = filter_input(INPUT_POST, 'empty_follicle');
        $fertilized_egg = filter_input(INPUT_POST, 'fertilized_egg');
        $cleavage = filter_input(INPUT_POST, 'cleavage');
        $embryo_transfer_stage = filter_input(INPUT_POST, 'embryo_transfer_stage');
        $embryo_transfer_grade = filter_input(INPUT_POST, 'embryo_transfer_grade');
        $embryo_freezing_embryos = filter_input(INPUT_POST, 'embryo_freezing_embryos');
        $embryo_freezing_straws = filter_input(INPUT_POST, 'embryo_freezing_straws');
        $embryo_freezing_day = filter_input(INPUT_POST, 'embryo_freezing_day');
        $embryologyimg = uploadupdate("embryologyimg", "imageurl", False, 0, 0, 'embryologyimg');
        $id = filter_input(INPUT_POST, 'id');

        $this->smarty->assign('patientId', $patientid);


        //here the update
        $report = R::load('embryologyreport', $id);

        $report->patient_id = $patientid;
        $report->clinician_id = $clinician;
        $report->embryologist_id = $embryologist;
        $report->day_of_transfer = $day_of_transfer;
        $report->date = $date;
        $report->sperm_source = $sperm_source;
        $report->count = $count;
        $report->motility = $motility;
        $report->morphology = $morphology;
        $report->oocyte_retrived = $oocyte_retrived;
        $report->mii = $mii;
        $report->mi = $mi;
        $report->gv = $gv;
        $report->atretic = $atretic;
        $report->empty_follicle = $empty_follicle;
        $report->fertilized_egg = $fertilized_egg;
        $report->cleavage = $cleavage;
        $report->embryo_transfer_stage = $embryo_transfer_stage;
        $report->embryo_transfer_grade = $embryo_transfer_grade;
        $report->embryo_freezing_embryos = $embryo_freezing_embryos;
        $report->embryo_freezing_straws = $embryo_freezing_straws;
        $report->embryo_freezing_day = $embryo_freezing_day;
        $report->embryologyimg = $embryologyimg;


        try {
            R::store($report);
            if (!empty($patientid)) {
                header('Location:' . $this->hosturl . '/controllers/' . $this->controllname . '.php?ac=show&patientid=' . $patientid);
            } else {
                header('Location:' . $this->hosturl . '/controllers/' . $this->controllname . '.php?ac=show');
            }
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/error/notupdate/' . $this->controllname);
        }
    }

    public function del() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $id = filter_input(INPUT_POST, 'id');
        try {
            R::exec('DELETE from embryologyreport WHERE id = ' . $id);
            echo 1;
        } catch (Exception $e) {
            
        }
    }

    public function getprint() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $patientId = filter_input(INPUT_POST, "patientid");

        $patientData = R::load("patients", $patientId);

        $wifename = $patientData->wifename;
        $wifeage = $patientData->wifeage;

        $this->smarty->assign('wifename', $wifename);
        $this->smarty->assign('wifeage', $wifeage);

        $id = filter_input(INPUT_POST, "id");
        $editElement = R::load('embryologyreport', $id);

        $editElement->date = date('Y/m/d', strtotime($editElement->date));

        $clinician_id = $editElement->clinician_id;
        $embryologist_id = $editElement->embryologist_id;


        $clinician_name = R::getRow('select name from awusers where user_id = ' . $clinician_id);
        $this->smarty->assign('clinician_name', $clinician_name["name"]);

        $embryologist_name = R::getRow('select name from awusers where user_id = ' . $embryologist_id);
        $this->smarty->assign('embryologist_name', $embryologist_name["name"]);

        $nurse_name = R::getRow('select name from awusers where user_id = ' . $embryologist_id);
        $this->smarty->assign('embryologist_name', $embryologist_name["name"]);

        $embryologist_name = R::getRow('select name from awusers where user_id = ' . $embryologist_id);
        $this->smarty->assign('embryologist_name', $embryologist_name["name"]);

        $this->smarty->assign('editElement', $editElement);
        $this->smarty->display('embryology/print.html');
    }

    // at the end of class call
    public function __destruct() {
        //colse connection
        R::close();
    }

}
