<?php

require_once("imp/_imp.php");

class Controllers {

    //public vars
    public $smarty;
    public $hosturl;
    public $controllname;
    public $shcontrollname;
    public $active;
    public $time;
    public $today;
    public $patientid;

    // it will run in everytime with
    // default requried
    public function __construct() {
        require_once("../public/aw_config.php");
        require_once("imp/_autho.php"); //general functions
        $this->smarty = $smarty;
        $this->hosturl = $hosturl;

        //here name of controll to known
        $this->controllname = 'embryofreezing';
        $this->shcontrollname = 'embryofreezing';
        $this->smarty->assign('controllname', $this->controllname);
        $this->smarty->assign('shcontrollname', $this->shcontrollname);

        //breadcrumbs
        require_once("../../_library/plugins/Breadcrumbs/Breadcrumbs.php");
        $acty = filter_input(INPUT_GET, 'ac');
        $bc = new breadcrumbs($hosturl, '', '', $acty);
        $bc->crumbs();
        $breadcrumbs = $bc->breadcrumbs;
        $smarty->assign('breadcrumbs', $breadcrumbs);

        # here show the active page in menu
        // array called active[] with level of active element
        $active[0] = 'embryofreezing'; //controller name or tab name
        $active[1] = 'embryofreezing'; //controller name
        // do name  // switch($do)
        switch ($acty) {
            case '':
                $active[2] = 'show';
                break;
            case 'show':
                $active[2] = 'show';
                break;
            default:
                $active[2] = 'show';
                break;
        }
        $this->active = $active;

        R::ext('xdispense', function ($type) {
            return R::getRedBean()->dispense($type);
        });

        //here will call all php pages
        require_once("_header.php");
        require_once("_patientdata.php");
        require_once("_sidebar.php");
        require_once("_leftsidebar.php");
        require_once("_footer.php");

        $this->patientid = patientdata::patientid();

        //find loading time
        $this->time = microtime(true);
        $this->today = date('Y-m-d');
    }

    public function show() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $patientid = filter_input(INPUT_GET, "patientid");
        $this->smarty->assign('patientId', $patientid);
        if (empty($this->patientid)) {
            header('Location:' . $this->hosturl . '/controllers/index.php?empty=1');
            exit();
        }

        $embryofreezingreport = R::getAll('select embryofreezingreport.id  ,doc.name as referred_dr_name  
                                                                , embryofreezingreport.date    ,emb.name as embryologist_name  
                            from  embryofreezingreport 
                                   LEFT JOIN  awusers   doc   ON         embryofreezingreport.h_doctor1 =doc.user_id
                                  LEFT JOIN  awusers   emb   ON         embryofreezingreport.embryologist =emb.user_id
                            where embryofreezingreport.deleted != 1 and embryofreezingreport.completed =  1  
                            and patient_id = ' . $patientid);

        $this->smarty->assign('embryofreezingreport', $embryofreezingreport);

        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        if ($patientid) {
            patientdata::patientdatashow($this->smarty, $this->hosturl);
        }
        $this->smarty->display('embryofreezing/show.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    public function add() {


        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        $patientid = filter_input(INPUT_GET, "patientid");

        if (empty($patientid)) {
            header('Location:' . $this->hosturl . '/controllers/index.php?empty=1');
            exit();
        }

        $embryofreezingreport = R::findOne('embryofreezingreport', 'patient_id = ? and completed = 0', [$patientid]);
        if (count($embryofreezingreport) <= 0) {
            //create new
            $patient = R::load('patients', $patientid);

            $embryofreezingreport = R::xdispense('embryofreezingreport');
            $embryofreezingreport->patient_id = $patientid;
            $embryofreezingreport->date = $this->today;
            $embryofreezingreport->completed = 0;
            $embryofreezingreport->doctor1 = $patient->doctor1;
            $embryofreezingreport->h_doctor1 = $patient->h_doctor1;
            $embryofreezingreport->user_id = $_SESSION['user_id'];
            $embryofreezingreport_id = R::store($embryofreezingreport);
        } else {
            $embryofreezingreport_id = $embryofreezingreport->id;
        }

        $this->smarty->assign('is_add', 1);
        $this->smarty->assign('tableName', 'embryofreezingreport');
        $this->smarty->assign('show', 'show');

        $this->loadFreezingReport($embryofreezingreport_id);

        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        if ($patientid) {
            patientdata::patientdatashow($this->smarty, $this->hosturl);
        }
        $this->smarty->display('embryofreezing/add.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    function loadFreezingReport($embryofreezingreport_id) {

        $embryofreezingreport = R::getRow('select *  ,  embryologist.name as embryologist_name 
            
                from embryofreezingreport 
                left join   awusers   embryologist       on   embryofreezingreport.embryologist   =  embryologist.user_id 
                
                where id = ' . $embryofreezingreport_id);

        $embryofreezingreport['date'] = date('Y/m/d', strtotime($embryofreezingreport['date']));
        $this->smarty->assign('embryofreezingreport', $embryofreezingreport);

        $this->getReferredDr($embryofreezingreport['h_doctor1']);

        $embryothawing = R::getAll(" select * from embryothawing where embryofreezing_id = $embryofreezingreport_id ");
        $this->smarty->assign('embryothawing', $embryothawing);
        $this->smarty->assign('embryothawingCount', count($embryothawing));

        $embryos = R::getAll(" select * from embryo where embryofreezing_id = $embryofreezingreport_id ");
        $this->smarty->assign('embryos', $embryos);
        $this->smarty->assign('embryosCount', count($embryos));

        $embryo_device = R::findAll('embryo_device', ' deleted != 1 ');
        $this->smarty->assign('embryo_device', $embryo_device);

        $embryologist = R::getAll("select* from awusers where role_id=11");
        $this->smarty->assign('embryologist', $embryologist);

        $clinician = R::getAll("select* from awusers where role_id=4");
        $this->smarty->assign('clinician', $clinician);

        $kits = R::getAll("select* from kit where deleted != 1");
        $this->smarty->assign('kits', $kits);
        //        //select all devices 
        //        $devices = R::getAll("select* from device");
        //        $this->smarty->assign('devices', $devices);
        //        //select all cathetrs
        //        $cathetrs = R::getAll("select* from cathetr");
        //        $this->smarty->assign('cathetrs', $cathetrs);
        //
        $stages = R::getAll("select* from stage where deleted != 1");
        $this->smarty->assign('stages', $stages);

        $grades = R::getAll("select* from grade where deleted != 1");
        $this->smarty->assign('grades', $grades);
        ///////////////new row/////////////
        //        $embryothawing = R::findall('embryothawing');
        //
        //        $this->smarty->assign('embryothawing', $embryothawing);
        //        $this->smarty->assign('thawing', count($embryothawing));

        $programesetting = R::findOne('programesetting');
        $this->smarty->assign('programesetting', $programesetting);

        if ($programesetting->tanks_view == 1) {
            $cells = $this->loadCellsDisplay($embryofreezingreport_id);
            $this->smarty->assign('cells', $cells);
        } elseif ($programesetting->tanks_view == 2) {
            $this->tankStyle2();
        }
    }

    function getReferredDr($userId) {

        if ($userId > 0) {
            $refer = R::getRow('select name from awusers where user_id = ?', [$userId]);
            $ref_dr = $refer['name'];
        } else {
            $ref_dr = 'لا يوجد';
        }

        $this->smarty->assign('ref_dr', $ref_dr);
    }

    public function update() {
        $id = filter_input(INPUT_POST, "id");
        $value = filter_input(INPUT_POST, "value");
        $tableName = filter_input(INPUT_POST, "tableName");
        $colName = filter_input(INPUT_POST, "colName");
        $patientId = filter_input(INPUT_POST, "patientId");

        //here the update
        $mydata = R::load($tableName, $id);

        $mydata->$colName = $value;
        R::store($mydata);
    }

    public function del() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $id = filter_input(INPUT_POST, 'id');
        $tableName = filter_input(INPUT_POST, 'tableName');
        try {
            R::exec('update  ' . $tableName . ' set deleted = 1  WHERE id = ' . $id);
            echo 1;
        } catch (Exception $e) {
            echo -1;
        }
    }

    public function editModal() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $tableName = filter_input(INPUT_POST, "tableName");
        $data_selectid = filter_input(INPUT_POST, "data_selectid");
        $colName = filter_input(INPUT_POST, "colName");

        switch ($tableName) {
            case 'stage':
            case 'grade':
            case 'kit':
                $colName = $tableName;
                break;

            default:
                break;
        }


        $alldata = R::findAll($tableName, ' deleted != 1');

        $this->smarty->assign('alldata', $alldata);

        $this->smarty->assign('colName', $colName);

        $this->smarty->assign('tableName', $tableName);
        $this->smarty->assign('data_selectid', $data_selectid);

        $this->smarty->display('embryofreezing/editmodel.html');
    }

    public function insertNewRow() {
        //embryoscoring table

        $row_id = filter_input(INPUT_POST, 'row_id');
        $myItra = filter_input(INPUT_POST, 'myItra');
        $tablename = filter_input(INPUT_POST, "tablename");
        //
        //
        $embryo = R::xdispense($tablename);
        $embryo->embryofreezing_id = $row_id;

        $embryo->id = R::store($embryo);
        if ($embryo->id) {
            switch ($tablename) {
                case 'embryo':
                    $stages = R::getAll("select* from stage where deleted != 1");
                    $this->smarty->assign('stages', $stages);

                    $grades = R::getAll("select* from grade where deleted != 1");
                    $this->smarty->assign('grades', $grades);

                    $this->smarty->assign('itr', $myItra);
                    $this->smarty->assign('row_id', $embryo->id);

                    $this->smarty->display('embryofreezing/embryoRow.html');
                    break;

                case 'embryothawing':
                    $embryologist = R::getAll("select* from awusers where role_id=11");
                    $this->smarty->assign('embryologist', $embryologist);

                    $clinician = R::getAll("select* from awusers where role_id=4");
                    $this->smarty->assign('clinician', $clinician);

                    $this->smarty->assign('data', $embryo);
                    $this->smarty->assign('itr', $myItra);

                    $this->smarty->display('embryofreezing/thawingRow.html');
                    break;

                default:

                    break;
            }
        }
    }

    public function addRow() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        //        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $value = filter_input(INPUT_POST, 'value');
        $name = filter_input(INPUT_POST, 'name');
        $table = filter_input(INPUT_POST, 'table');

        $add = R::xdispense($table);
        $add->$name = $value;
        $add->deleted = 0;
        $inserted = R::store($add);
        echo $inserted;
    }

    public function addNewRow() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //vars here
        $table = filter_input(INPUT_POST, 'tableName');
        $columname = filter_input(INPUT_POST, 'colName');

        ### insert into table
        $newtable = R::dispense($table);
        $newtable->$columname = "";

        $insertid = R::store($newtable);

        echo $insertid;
    }

    public function delRowsommedel() {

        $id = filter_input(INPUT_POST, "id");
        $tableName = filter_input(INPUT_POST, "tableName");
        try {
            R::exec('update  ' . $tableName . ' set deleted = 1  WHERE id = ' . $id);
            echo 1;
        } catch (Exception $e) {
            echo -1;
        }
    }

    public function complete_one() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        //  autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $id = filter_input(INPUT_GET, 'id');
        $tableName = filter_input(INPUT_GET, 'tname');
        $show = filter_input(INPUT_GET, 'show');
        $patientid = filter_input(INPUT_GET, "patientid");
        try {
            if ($tableName == "ivf_report") {
                R::exec('update  ' . $tableName . ' set completed = 1  
                          ,   completed_date = "' . date('Y-m-d H:i:s') . '"    WHERE id = ' . $id);
            } else {
                R::exec('update  ' . $tableName . ' set completed = 1  WHERE id = ' . $id);
            }

            if (!empty($patientid)) {
                header('Location:' . $this->hosturl . '/controllers/' . $this->controllname . '.php?ac=' . $show . '&patientid=' . $patientid);
            } else {
                header('Location:' . $this->hosturl . '/controllers/' . $this->controllname . '.php?ac=' . $show);
            }
        } catch (Exception $e) {
            print_r($e);
            //    header('Location:' . $this->hosturl . '/error/notadd/' . $this->controllname);
        }
    }

    public function edit() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //get id for item
        $embryofreezingreport_id = filter_input(INPUT_GET, 'id');
        $patientid = filter_input(INPUT_GET, "patientid");

        $this->loadFreezingReport($embryofreezingreport_id);

        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        if ($patientid) {
            patientdata::patientdatashow($this->smarty, $this->hosturl);
        }
        $this->smarty->display('embryofreezing/add.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    ##################################################################

    public function index() {


        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
        $patientid = filter_input(INPUT_GET, "patientid");
        if (empty($patientid)) {
            header('Location:' . $this->hosturl . '/controllers/index.php?empty=1');
            exit();
        } else {

            $this->smarty->assign('patientId', $patientid);

            //call other class with other content
            //check login
            autho::checkautho($this->hosturl);
            //check authoize
            autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

            $patientid = filter_input(INPUT_GET, "patientid");
            //load all declerations here

            $this->smarty->assign('patientId', $patientid);

            //call other class with other content


            $showElems = R::getAll("select* from embryofreezingreport WHERE patient_id = $patientid order by id asc");
            $mydata = array();
            foreach ($showElems as $showElem) {
                $embryologist_name = R::findOne('awusers', 'user_id = ? ', [$showElem['embryologist']]);
                $showElem['embryologist_name'] = $embryologist_name->name;
                $ref_by_prof_dr_name = R::findOne('awusers', 'user_id = ? ', [$showElem['ref_by_prof_dr']]);
                $showElem['ref_by_prof_dr_name'] = $ref_by_prof_dr_name->name;

                $output = array(
                    "embryologist_name" => $embryologist_name->name,
                    "ref_by_prof_dr_name" => $ref_by_prof_dr_name->name,
                    "date" => $showElem['date'],
                    "id" => $showElem['id']
                );

                array_push($mydata, $output);
            }


            $this->smarty->assign('mydata', $mydata);

            header::headershow($this->smarty, $this->hosturl);
            sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
            if ($patientid) {
                patientdata::patientdatashow($this->smarty, $this->hosturl);
            }
            $this->smarty->display('embryofreezing/show.html');
            leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
            footer::footershow($this->smarty, $this->hosturl);
        }
    }

    public function addkit() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $kit = filter_input(INPUT_POST, 'selectedkit');
        $addkit = R::dispense('kit');
        $addkit->kit = $kit;
        $inserted = R::store($addkit);
        echo $inserted;
    }

    public function addDevice() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $device = filter_input(INPUT_POST, 'selecteddevice');
        $adddevice = R::dispense('device');
        $adddevice->device = $device;
        $inserted = R::store($adddevice);
        echo $inserted;
    }

    public function addGrade() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $grade = filter_input(INPUT_POST, 'selectedgrade');
        $addgrade = R::dispense('grade');
        $addgrade->grade = $grade;
        $inserted = R::store($addgrade);
        echo $inserted;
    }

    public function addStage() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $stage = filter_input(INPUT_POST, 'selectedstage');
        $addstage = R::dispense('stage');
        $addstage->stage = $stage;
        $inserted = R::store($addstage);
        echo $inserted;
    }

    public function addCathetr() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $cathetr = filter_input(INPUT_POST, 'selectedcathetr');
        $addcathetr = R::dispense('cathetr');
        $addcathetr->cathetr = $cathetr;
        $inserted = R::store($addcathetr);
        echo $inserted;
    }

    //edit the new row of modal
    public function updateModal() {
        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        $tableName = filter_input(INPUT_POST, "tablename");
        $value = filter_input(INPUT_POST, "value");
        $id = filter_input(INPUT_POST, "id");

        $colName = filter_input(INPUT_POST, "colName");
        print_r($tableName);

        $mydata = R::load($tableName, $id);
        $mydata->$colName = $value;
        R::store($mydata);
    }

    public function addit() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //vars here


        $embryo_counter = filter_input(INPUT_POST, 'embryo');
        $thawitr_counter = filter_input(INPUT_POST, 'thawitr');
        $patientid = filter_input(INPUT_GET, "patientid");
        $ref_by_dr_id = filter_input(INPUT_POST, 'ref_by_dr_id');
        $embryologist = filter_input(INPUT_POST, 'embryologist');
        $date = filter_input(INPUT_POST, 'date');
        $no_of_straws = filter_input(INPUT_POST, 'no_of_straws');
        $no_of_embryos = filter_input(INPUT_POST, 'no_of_embryos');
        $days = filter_input(INPUT_POST, 'days');

        $kit = filter_input(INPUT_POST, 'kit');
        $device = filter_input(INPUT_POST, 'device');
        $location = filter_input(INPUT_POST, 'location');
        $lot_no = filter_input(INPUT_POST, 'lot_no');
        $notes = filter_input(INPUT_POST, 'notes');

        $this->smarty->assign('patientId', $patientid);

        //here the add
        $report = R::dispense('embryofreezingreport');

        $report->patient_id = $patientid;
        $report->date = $date;
        $report->ref_by_prof_dr = $ref_by_dr_id;
        $report->embryologist = $embryologist;
        $report->no_of_straws = $no_of_straws;
        $report->no_of_embryos = $no_of_embryos;
        $report->day_of_freezing = $days;
        $report->note = $notes;
        $report->kit = $kit;
        $report->lot_no = $lot_no;
        $report->device = $device;
        $report->location = $location;
        $id_report = R::store($report);
        ///////////save ittration into database///////////
        for ($i = 1; $i <= $thawitr_counter; $i++) {
            // check if exist row //
            $safyinput1 = filter_input(INPUT_POST, 'safyinput1_' . $i . '');
            if (!empty($safyinput1)) {

                $no_of_embryos = filter_input(INPUT_POST, 'no_of_embryos_' . $i . '_1');
                $thawing_date = filter_input(INPUT_POST, 'thawing_date_' . $i . '_2');
                $recovered = filter_input(INPUT_POST, 'recovered_' . $i . '_3');
                $lost = filter_input(INPUT_POST, 'lost_' . $i . '_4');
                $et_date = filter_input(INPUT_POST, 'et_date_' . $i . '_5');
                $embryos = filter_input(INPUT_POST, 'embryos_' . $i . '_6');
                $grades = filter_input(INPUT_POST, 'grades_' . $i . '_7');
                $embryol = filter_input(INPUT_POST, 'embryol_' . $i . '_8');
                $clinician = filter_input(INPUT_POST, 'clinician_' . $i . '_9');
                $cathetr = filter_input(INPUT_POST, 'cathetr_' . $i . '_10');

                $embryothawing = R::dispense('embryothawing');
                $embryothawing->embryofreezing_id = $id_report;
                $embryothawing->no_of_embryos = $no_of_embryos;
                $embryothawing->thawing_date = $thawing_date;
                $embryothawing->recovered = $recovered;
                $embryothawing->lost = $lost;
                $embryothawing->e_t_date = $et_date;
                $embryothawing->embryos = $embryos;
                $embryothawing->grades = $grades;
                $embryothawing->embryol_oigist = $embryol;
                $embryothawing->clinician = $clinician;
                $embryothawing->cathetr = $cathetr;

                R::store($embryothawing);
            }
        }



        ///////////save ittration into database///////////
        for ($i = 1; $i <= $embryo_counter; $i++) {
            // check if exist row //
            $safyinput2 = filter_input(INPUT_POST, 'safyinput2_' . $i . '');

            if (!empty($safyinput2)) {
                $stage1 = filter_input(INPUT_POST, 'stage_' . $i . '_1_1');
                $grade1 = filter_input(INPUT_POST, 'grade_' . $i . '_1_2');
                $stage2 = filter_input(INPUT_POST, 'stage_' . $i . '_2_1');
                $grade2 = filter_input(INPUT_POST, 'grade_' . $i . '_2_2');
                $stage3 = filter_input(INPUT_POST, 'stage_' . $i . '_3_1');
                $grade3 = filter_input(INPUT_POST, 'grade_' . $i . '_3_2');
                $stage4 = filter_input(INPUT_POST, 'stage_' . $i . '_4_1');
                $grade4 = filter_input(INPUT_POST, 'grade_' . $i . '_4_2');
                $stage5 = filter_input(INPUT_POST, 'stage_' . $i . '_5_1');
                $grade5 = filter_input(INPUT_POST, 'grade_' . $i . '_5_2');
                $stage6 = filter_input(INPUT_POST, 'stage_' . $i . '_6_1');
                $grade6 = filter_input(INPUT_POST, 'grade_' . $i . '_6_2');
                //            echo 'stage1' . $stage1;



                $embryo = R::dispense('embryo');
                $embryo->embryofreezing_id = $id_report;
                $embryo->stage1 = $stage1;
                $embryo->stage2 = $stage2;
                $embryo->stage3 = $stage3;
                $embryo->stage4 = $stage4;
                $embryo->stage5 = $stage5;
                $embryo->stage6 = $stage6;
                $embryo->grade1 = $grade1;
                $embryo->grade2 = $grade2;
                $embryo->grade3 = $grade3;
                $embryo->grade4 = $grade4;
                $embryo->grade5 = $grade5;
                $embryo->grade6 = $grade6;
                //            print_r('<pre>');
                //            print_r($embryo);
                //            print_r('<pre>');


                R::store($embryo);
            }
        }

        //////
        try {
            if (!empty($patientid)) {
                header('Location:' . $this->hosturl . '/controllers/' . $this->controllname . '.php?ac=show&patientid=' . $patientid);
            } else {
                header('Location:' . $this->hosturl . '/controllers/' . $this->controllname . '.php?ac=show');
            }
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/error/notadd/' . $this->controllname);
        }
    }

    //    public function edit() {
    //
    //        //check login
    //        autho::checkautho($this->hosturl);
    //        //check authoize
    //        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);
    //
    //        //get id for item
    //        $id = filter_input(INPUT_GET, 'id');
    //        $patientid = filter_input(INPUT_GET, "patientid");
    //
    //        $ref_dr_id = R::load(patients, $patientid);
    //        if (!empty($ref_dr_id->refer_doctor)) {
    //            $ref_dr = R::getAll("select* from awusers where user_id=$ref_dr_id->refer_doctor");
    //            $this->smarty->assign('ref_dr', $ref_dr[0]);
    //        } else {
    //            $this->smarty->assign('ref_dr', "لايوجد");
    //        }
    //
    //
    //        $embryologist = R::getAll("select* from awusers where role_id=11");
    //        $this->smarty->assign('embryologist', $embryologist);
    //
    //        $clinician = R::getAll("select* from awusers where role_id=4");
    //        $this->smarty->assign('clinician', $clinician);
    //
    //        //load all here
    //        $users = R::getAll("select* from awusers");
    //        $this->smarty->assign('users', $users);
    //        //select all kits 
    //        $kits = R::getAll("select* from kit");
    //        $this->smarty->assign('kits', $kits);
    //        //select all devices 
    //        $devices = R::getAll("select* from device");
    //        $this->smarty->assign('devices', $devices);
    //        //select all cathetrs
    //        $cathetrs = R::getAll("select* from cathetr");
    //        $this->smarty->assign('cathetrs', $cathetrs);
    //
    //        $stages = R::getAll("select* from stage");
    //        $this->smarty->assign('stages', $stages);
    //
    //        $grades = R::getAll("select* from grade");
    //        $this->smarty->assign('grades', $grades);
    //        ///////////////new row/////////////
    //        $embryothawing = R::findall('embryothawing');
    //
    //        $embryofreezingreport = R::load("embryofreezingreport", $id);
    //        $this->smarty->assign('embryofreezingreport', $embryofreezingreport);
    //
    //        $embryothawing = R::getAll(" select * from embryothawing where embryofreezing_id = $id ");
    //        $this->smarty->assign('embryothawing', $embryothawing);
    //
    //        $embryos = R::getAll(" select * from embryo where embryofreezing_id = $id ");
    //        //
    //        $this->smarty->assign('embryos', $embryos);
    //        ///count rows for ittration///
    //        $count_embryothawing = R::count('embryothawing', 'embryofreezing_id = ?', [$id]);
    //        $count_embryo = R::count('embryo', 'embryofreezing_id = ?', [$id]);
    //        $this->smarty->assign('count_embryothawing', $count_embryothawing);
    //        $this->smarty->assign('count_embryo', $count_embryo);
    //        //
    //        $this->smarty->assign('embryothawing', $embryothawing);
    //        $this->smarty->assign('thawing', count($embryothawing));
    //        // call other class with other content
    //        header::headershow($this->smarty, $this->hosturl);
    //        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
    //        if ($patientid) {
    //            patientdata::patientdatashow($this->smarty, $this->hosturl);
    //        }
    //        $this->smarty->display('embryofreezing/edit.html');
    //        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
    //        footer::footershow($this->smarty, $this->hosturl);
    //    }

    public function updateit() {

        //check login
        autho::checkautho($this->hosturl);
        //check authoize
        autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

        //vars here
        $embryo_counter = filter_input(INPUT_POST, 'embryo');
        $thawitr_counter = filter_input(INPUT_POST, 'thawitr');
        $patientid = filter_input(INPUT_GET, "patientid");
        $ref_by_dr_id = filter_input(INPUT_POST, 'ref_by_dr_id');
        $embryologist = filter_input(INPUT_POST, 'embryologist');
        $date = filter_input(INPUT_POST, 'date');
        $no_of_straws = filter_input(INPUT_POST, 'no_of_straws');
        $no_of_embryos = filter_input(INPUT_POST, 'no_of_embryos');
        $days = filter_input(INPUT_POST, 'days');
        $collapsed = filter_input(INPUT_POST, 'collapsed');

        $kit = filter_input(INPUT_POST, 'kit');
        $device = filter_input(INPUT_POST, 'device');
        $location = filter_input(INPUT_POST, 'location');
        $lot_no = filter_input(INPUT_POST, 'lot_no');
        $notes = filter_input(INPUT_POST, 'notes');

        $id = filter_input(INPUT_POST, 'id');

        $this->smarty->assign('patientId', $patientid);

        //here the update
        $report = R::load('embryofreezingreport', $id);

        $report->patient_id = $patientid;
        $report->date = $date;
        $report->ref_by_prof_dr = $ref_by_dr_id;
        $report->embryologist = $embryologist;
        $report->no_of_straws = $no_of_straws;
        $report->no_of_embryos = $no_of_embryos;
        $report->day_of_freezing = $days;
        $report->note = $notes;
        $report->kit = $kit;
        $report->lot_no = $lot_no;
        $report->device = $device;
        $report->location = $location;
        $report->collapsed = $collapsed;

        //        
        $id_report = R::store($report);
        R::exec('DELETE from embryothawing WHERE embryofreezing_id = ' . $id_report);
        R::exec('DELETE from embryo WHERE embryofreezing_id = ' . $id_report);

        //
        for ($i = 1; $i <= $thawitr_counter; $i++) {
            // check if exist row //
            $safyinput1 = filter_input(INPUT_POST, 'safyinput1_' . $i . '');

            if (!empty($safyinput1)) {
                $no_of_embryos = filter_input(INPUT_POST, 'no_of_embryos_' . $i . '_1');
                $thawing_date = filter_input(INPUT_POST, 'thawing_date_' . $i . '_2');
                $recovered = filter_input(INPUT_POST, 'recovered_' . $i . '_3');
                $lost = filter_input(INPUT_POST, 'lost_' . $i . '_4');
                $et_date = filter_input(INPUT_POST, 'et_date_' . $i . '_5');
                $embryos = filter_input(INPUT_POST, 'embryos_' . $i . '_6');
                $grades = filter_input(INPUT_POST, 'grades_' . $i . '_7');
                $embryol = filter_input(INPUT_POST, 'embryol_' . $i . '_8');
                $clinician = filter_input(INPUT_POST, 'clinician_' . $i . '_9');
                $cathetr = filter_input(INPUT_POST, 'cathetr_' . $i . '_10');
                //
                $embryothawing = R::dispense('embryothawing');
                $embryothawing->embryofreezing_id = $id_report;
                $embryothawing->no_of_embryos = $no_of_embryos;
                $embryothawing->thawing_date = $thawing_date;
                $embryothawing->recovered = $recovered;
                $embryothawing->lost = $lost;
                $embryothawing->e_t_date = $et_date;
                $embryothawing->embryos = $embryos;
                $embryothawing->grades = $grades;
                $embryothawing->embryol_oigist = $embryol;
                $embryothawing->clinician = $clinician;
                $embryothawing->cathetr = $cathetr;
                R::store($embryothawing);
            }
        }

        /////////////save ittration into database///////////
        for ($i = 1; $i <= $embryo_counter; $i++) {
            // check if exist row //
            $safyinput2 = filter_input(INPUT_POST, 'safyinput2_' . $i . '');

            if (!empty($safyinput2)) {
                $stage1 = filter_input(INPUT_POST, 'stage_' . $i . '_1_1');
                $grade1 = filter_input(INPUT_POST, 'grade_' . $i . '_1_2');
                $stage2 = filter_input(INPUT_POST, 'stage_' . $i . '_2_1');
                $grade2 = filter_input(INPUT_POST, 'grade_' . $i . '_2_2');
                $stage3 = filter_input(INPUT_POST, 'stage_' . $i . '_3_1');
                $grade3 = filter_input(INPUT_POST, 'grade_' . $i . '_3_2');
                $stage4 = filter_input(INPUT_POST, 'stage_' . $i . '_4_1');
                $grade4 = filter_input(INPUT_POST, 'grade_' . $i . '_4_2');
                $stage5 = filter_input(INPUT_POST, 'stage_' . $i . '_5_1');
                $grade5 = filter_input(INPUT_POST, 'grade_' . $i . '_5_2');
                $stage6 = filter_input(INPUT_POST, 'stage_' . $i . '_6_1');
                $grade6 = filter_input(INPUT_POST, 'grade_' . $i . '_6_2');
                //            echo 'stage1' . $stage1;



                $embryo = R::dispense('embryo');
                $embryo->embryofreezing_id = $id_report;
                $embryo->stage1 = $stage1;
                $embryo->stage2 = $stage2;
                $embryo->stage3 = $stage3;
                $embryo->stage4 = $stage4;
                $embryo->stage5 = $stage5;
                $embryo->stage6 = $stage6;
                $embryo->grade1 = $grade1;
                $embryo->grade2 = $grade2;
                $embryo->grade3 = $grade3;
                $embryo->grade4 = $grade4;
                $embryo->grade5 = $grade5;
                $embryo->grade6 = $grade6;
                //            print_r('<pre>');
                //            print_r($embryo);
                //            print_r('<pre>');


                R::store($embryo);
            }
        }

        try {
            if (!empty($patientid)) {
                header('Location:' . $this->hosturl . '/controllers/' . $this->controllname . '.php?ac=show&patientid=' . $patientid);
            } else {
                header('Location:' . $this->hosturl . '/controllers/' . $this->controllname . '.php?ac=show');
            }
        } catch (Exception $e) {
            header('Location:' . $this->hosturl . '/error/notupdate/' . $this->controllname);
        }
    }

    public function drawRow() {       ## new row without database insert
        $type = filter_input(INPUT_POST, "type");   ## ussimple or uscomplete or usantenatal
        $itr = filter_input(INPUT_POST, "itr");
        $patientId = filter_input(INPUT_POST, "patientId");

        $tablename = filter_input(INPUT_POST, "tableName");
        if ($type == "thawing") {
            #################################################################### Heba : ## Drugs Data   ##############################################################################

            $users = R::getAll("select* from awusers");
            $this->smarty->assign('users', $users);
            //select all kits 
            //select all cathetrs
            //select all embryologist

            $embryologist = R::getAll("select* from awusers where role_id=11");
            $this->smarty->assign('embryologist', $embryologist);

            $clinician = R::getAll("select* from awusers where role_id=4");
            $this->smarty->assign('clinician', $clinician);

            $cathetrs = R::getAll("select* from cathetr");
            $this->smarty->assign('cathetrs', $cathetrs);
            $this->smarty->assign('itr', $itr);
            $this->smarty->assign('type', $type);
        } else {
            $stages = R::getAll("select* from stage");
            $this->smarty->assign('stages', $stages);

            $grades = R::getAll("select* from grade");
            $this->smarty->assign('grades', $grades);
            $this->smarty->assign('itr', $itr);
            $this->smarty->assign('type', $type);
        }
        if ($tablename == "embryothawing") {
            $this->smarty->display('embryofreezing/newrowUS.html');
        } else {
            $this->smarty->display('embryofreezing/newrowUS_1.html');
        }
    }

    function loadCellsDisplay($embryosLabId) {

        $cells = R::getAll('select tank_cell , location , btn_no , row_no , col_no  , cell_no 
                                        from embryoslab_tank_cells where deleted = 0 
                                         and embryoslab_id = ?  ', [$embryosLabId]);
        $i = 0;
        foreach ($cells as $cell) {
            $tanks_general = R::findOne('tanks_general', '  location = ?  and btn_no = ?  ', [$cell['location'], $cell['btn_no']]);
            $cells[$i]['rows_letter'] = $tanks_general->rows_letter;
            $i++;
        }
        return $cells;
    }

    public function tankLocation() {
        //check login
        autho::checkautho($this->hosturl);
        $specTabId = filter_input(INPUT_POST, "specTabId");
        $specCanId = filter_input(INPUT_POST, "specCanId");
        $preview = filter_input(INPUT_POST, "preview");

        $this->smarty->assign('specTabId', $specTabId);
        $this->smarty->assign('specCanId', $specCanId);
        $this->smarty->assign('preview', $preview);

        $this->tankLocationSetting();
        $this->smarty->display('embryofreezing/tank_location.html');
    }

    public function tankLocationDisplay() {
        //check login
        autho::checkautho($this->hosturl);
        $embryosLabId = filter_input(INPUT_POST, "embryosLabId");
        $cells = $this->loadCellsDisplay($embryosLabId);
        $this->smarty->assign('cells', $cells);
        $this->smarty->display('embryofreezing/cells.html');
    }

    function tankSetting() {
        //check login
        autho::checkautho($this->hosturl);

        //        $colors = array("#8db3e2", "#c4bc96", "#e5b8b7", "#d6e3bc", "#ccc0d9", "#b6dde8", "#fbd4b4", "#ffff66", "#ffccff");
        //        $this->smarty->assign('colors', $colors);
        $this->tankLocationSetting();

        $tanks_generalsA = R::findAll("tanks_general", '  location = "A"  order by  id asc  ');
        foreach ($tanks_generalsA as $tanks_general) {
            for ($i = 1; $i <= 9; $i++) {
                $col = 'row' . $i . '_color';
                $colLetter = 'color' . $i . '_letter';
                $colName = 'color' . $i . '_name';
                $color = R::load("colors", $tanks_general->$col);
                $tanks_general->$colName = $color->color_name;
                $tanks_general->$colLetter = $color->color_letter;
            }
        }

        $tanks_generalsB = R::findAll("tanks_general", '  location = "B"  order by  id asc  ');
        foreach ($tanks_generalsB as $tanks_general) {
            for ($i = 1; $i <= 9; $i++) {
                $col = 'row' . $i . '_color';
                $colLetter = 'color' . $i . '_letter';
                $colName = 'color' . $i . '_name';
                $color = R::load("colors", $tanks_general->$col);
                $tanks_general->$colName = $color->color_name;
                $tanks_general->$colLetter = $color->color_letter;
            }
        }


        $this->smarty->assign('tanks_generalsA', $tanks_generalsA);
        $this->smarty->assign('tanks_generalsB', $tanks_generalsB);

        $colors = R::findAll("colors");
        $this->smarty->assign('colors', $colors);

        //call other class with other content
        header::headershow($this->smarty, $this->hosturl);
        sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
        $this->smarty->display('embryofreezing/tank_settings.html');
        leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
        footer::footershow($this->smarty, $this->hosturl);
    }

    function tankLocationSetting() {
        for ($i = 1; $i <= 21; $i++) {
            $tanks_generalA = R::findOne('tanks_general', '  location = "A"  and btn_no = ' . $i);
            if (count($tanks_generalA) <= 0) {
                $tanks_generalA = R::xdispense('tanks_general');
                $tanks_generalA->location = "A";
                $tanks_generalA->btn_no = $i;
                R::store($tanks_generalA);
            }


            $tanks_generalB = R::findOne('tanks_general', '  location = "B"  and btn_no = ' . $i);
            if (count($tanks_generalB) <= 0) {
                $tanks_generalB = R::xdispense('tanks_general');
                $tanks_generalB->location = "B";
                $tanks_generalB->btn_no = $i;
                R::store($tanks_generalB);
            }
        }
    }

    function tankCanSetting($location, $btn_no) {
        $tanks_general = R::findOne('tanks_general', '  location = ?  and btn_no = ?  ', [$location, $btn_no]);
        for ($i = 1; $i <= 9; $i++) {
            $col = 'row' . $i . '_color';
            $colLetter = 'color' . $i . '_letter';
            $colName = 'color' . $i . '_name';
            $color = R::load("colors", $tanks_general->$col);
            $tanks_general->$colName = $color->color_name;
            $tanks_general->$colLetter = $color->color_letter;
        }
        $this->smarty->assign('tanks_general', $tanks_general);
        //   print_r($tanks_general);
    }

    public function tankCan() {
        //check login
        autho::checkautho($this->hosturl);

        $embryosLabId = filter_input(INPUT_POST, "embryosLabId");
        $preview = filter_input(INPUT_POST, "preview");
        $location = filter_input(INPUT_POST, "location");
        $no = filter_input(INPUT_POST, "no");

        $this->tankCanSetting($location, $no);
        if ($preview != 1) {
            $this->tankCanDetails($embryosLabId, $location, $no);
        } else {
            $this->smarty->assign('patCells', array());
            $this->smarty->assign('otherCells', array());
        }

        $this->smarty->assign('no', $no);
        $this->smarty->assign('location', $location);
        $this->smarty->assign('preview', $preview);
        $this->smarty->display('embryofreezing/tank_cans.html');
    }

    function tankCanDetails($embryosLabId) {
        $cells = R::getAll('select tank_cell  from embryoslab_tank_cells where deleted = 0 
                and embryoslab_id = ?  ', [$embryosLabId]);

        $other_cells = R::getAll('select tank_cell  from embryoslab_tank_cells where deleted = 0 
                and embryoslab_id != ?  ', [$embryosLabId]);

        #########################################
        $patCells = array();
        $otherCells = array();

        foreach ($cells as $value) {
            $tank_cell = trim($value['tank_cell']);
            array_push($patCells, $tank_cell);
        }
        $this->smarty->assign('patCells', $patCells);

        foreach ($other_cells as $value) {
            $tank_cell = trim($value['tank_cell']);
            array_push($otherCells, $tank_cell);
        }
        $this->smarty->assign('otherCells', $otherCells);

        #########################################
    }

    public function saveTankLocation() {
        //check login
        autho::checkautho($this->hosturl);
        $embryosLabId = filter_input(INPUT_POST, "embryosLabId");
        $selectedCells = json_decode(stripslashes(filter_input(INPUT_POST, 'selectedCells')));
        $errorMsg = ' ';
        $error = 0;
        $ids = '';
        $location = filter_input(INPUT_POST, "location");
        $btn_no = filter_input(INPUT_POST, "no");

        if (count($selectedCells) > 0) {

            foreach ($selectedCells as $cell) {
                $notEmpty = R::findOne(
                                'embryoslab_tank_cells',
                                'deleted = 0   and location = ?  and btn_no = ?
                and row_no = ?  and col_no = ?  and cell_no = ? and  embryoslab_id != ?  ',
                                [$cell[0], $cell[1], $cell[2], $cell[3], $cell[4], $embryosLabId]
                );
                if (count($notEmpty) > 0) {
                    $errorMsg = $cell[0] . ' _' . $cell[1] . ' _' . $cell[2] . ' _' . $cell[3] . ' _' . $cell[4] . '  reserved to another Patient';
                    $error = 1;
                } else {
                    $resForMe = R::findOne(
                                    'embryoslab_tank_cells',
                                    'deleted = 0   and location = ?  and btn_no = ?
                and row_no = ?  and col_no = ?  and cell_no = ? and  embryoslab_id = ?  ',
                                    [$cell[0], $cell[1], $cell[2], $cell[3], $cell[4], $embryosLabId]
                    );
                    if ($ids != '') {
                        $ids .= ' , ';
                    }
                    if (count($resForMe) > 0) {
                        $ids .= $resForMe->id;
                    } else {
                        $ids .= $this->storeTankCell($cell[0], $cell[1], $cell[2], $cell[3], $cell[4], $embryosLabId);
                    }
                }
            }

            R::exec('update  embryoslab_tank_cells set  deleted = 1  , userid_edit = ' . $_SESSION['user_id'] . ' 
               , date_edit = "' . date('Y-m-d H:i:s') . '"     where id  not in (' . $ids . ')  and embryoslab_id = ' . $embryosLabId . '   
                    and location = "' . $location . '"  and btn_no = "' . $btn_no . '" ');
        } else {
            R::exec('update  embryoslab_tank_cells set  deleted = 1  , userid_edit = ' . $_SESSION['user_id'] . ' 
               , date_edit = "' . date('Y-m-d H:i:s') . '"     where embryoslab_id = ' . $embryosLabId . ' 
                    and location = "' . $location . '"  and btn_no = "' . $btn_no . '" ');
        }

        if ($error != 1) {
            $errorMsg = ' saved Successfully ';
        }
        echo $errorMsg;
    }

    function storeTankCell($location, $btn_no, $row_no, $col_no, $cell_no, $embryoslab_id) {
        $add = R::xdispense('embryoslab_tank_cells');
        $add->embryoslab_id = $embryoslab_id;
        $add->location = $location;
        $add->btn_no = $btn_no;
        $add->row_no = $row_no;
        $add->col_no = $col_no;
        $add->cell_no = $cell_no;
        $add->date_add = date('Y-m-d H:i:s');
        $add->user_id = $_SESSION['user_id'];
        $add->tank_cell = $location . '_' . $btn_no . '_' . $row_no . '_' . $col_no . '_' . $cell_no;
        $add->deleted = 0;
        $id = R::store($add);
        return $id;
    }

    function tankStyle2() {
        $patientId = filter_input(INPUT_GET, "patientid");
        if (!$patientId)
            $patientId = filter_input(INPUT_POST, "patientid");

        # tanks
        $tanks = R::findAll('tanks');
        $this->smarty->assign('tanks', $tanks);

        // get tank cell for patient
        $tank_cells = R::getAll('select DISTINCT tank_id,up_level_name,cell_name,patient_id,tanks.name ,tanks.tank_type
                from tankcells inner join tanks on tankcells.tank_id = tanks.id where patient_id =  ? and tank_type = 1', [$patientId]);
        $this->smarty->assign('tank_cells', $tank_cells);
        $tank_cells_2 = R::getAll('select DISTINCT tank_id,up_level_name,cell_name,patient_id,tanks.name ,tanks.tank_type,cell_part_name 
                from tankcells inner join tanks on tankcells.tank_id = tanks.id where patient_id =  ? and tank_type = 2', [$patientId]);
        $this->smarty->assign('tank_cells_2', $tank_cells_2);
        $tank_cells_3 = R::getAll('select DISTINCT tank_id,up_level_name,cell_name,patient_id,tanks.name ,tanks.tank_type,cell_part_name 
                from tankcells inner join tanks on tankcells.tank_id = tanks.id where patient_id =  ? and tank_type = 3', [$patientId]);
        $this->smarty->assign('tank_cells_3', $tank_cells_3);
    }

    function getPrint() {
        //check login
        autho::checkautho($this->hosturl);

        $embryofreezingreport_id = filter_input(INPUT_POST, 'id');
        $patientId = filter_input(INPUT_POST, 'patientid');
        $patientData = R::load("patients", $patientId);

        $wifename = $patientData->wifename;
        $wifeage = $patientData->wifeage;
        $husbandname = $patientData->husdandname;
        $husbandage = $patientData->husbandage;

        $this->smarty->assign('wifename', $wifename);
        $this->smarty->assign('wifeage', $wifeage);
        $this->smarty->assign('husbandname', $husbandname);
        $this->smarty->assign('husbandage', $husbandage);

        $this->loadFreezingReport($embryofreezingreport_id);

        $this->smarty->display('embryofreezing/print.html');
    }

    // at the end of class call
    public function __destruct() {
        //colse connection
        R::close();
    }
}
