<?php

/*
 * awframework from aw.inc present aw controller
 * it will help you develop easy and fast with secure tools
 * you can edit and add what you feel right
 * don't change in strucure of file
 */

require_once("imp/_imp.php");

class Controllers {

   //public vars
   public $smarty;
   public $hosturl;
   public $controllname;
   public $shcontrollname;
   public $active;
   //menu itr for input
   public $menuitr;

   // it will run in everytime with
   // default requried
   public function __construct() {
      require_once("../public/aw_config.php");
      require_once("imp/_autho.php"); //general functions

      $this->smarty = $smarty;
      $this->hosturl = $hosturl;

      //here name of controll to known
      $this->controllname = '_role';
      $this->shcontrollname = 'Roles panel';
      $this->smarty->assign('controllname', $this->controllname);
      $this->smarty->assign('shcontrollname', $this->shcontrollname);

      //breadcrumbs
      require_once("../../_library/plugins/Breadcrumbs/Breadcrumbs.php");
      $acty = filter_input(INPUT_GET, 'ac');
      $bc = new breadcrumbs($hosturl, $this->controllname, $this->shcontrollname, $acty);
      $bc->crumbs();
      $breadcrumbs = $bc->breadcrumbs;
      $smarty->assign('breadcrumbs', $breadcrumbs);

      # here show the active page in menu
      // array called active[] with level of active element
      $active[0] = 'managment'; //controller name or tab name
      $active[1] = 'role'; //controller name
      // do name  // switch($do)
      switch ($acty) {
         case '':$active[2] = 'roleadd';
            break;
         case 'show':$active[2] = 'roleshow';
            break;
         default :$active[2] = 'roleshow';
            break;
      }
      $this->active = $active;

      //here will call all php pages
      require_once("_header.php");
      require_once("_sidebar.php");
      require_once("_leftsidebar.php");
      require_once("_footer.php");
   }

   //here the frist page and
   //the frist action in this class
   public function index() {

      //check login
      autho::checkautho($this->hosturl);
      //check authoize
      autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

      $roles = R::findAll('awrole');
      $this->smarty->assign('roles', $roles);

      $index_redirect = R::findAll('index_redirect', ' deleted != 1  ');
      $this->smarty->assign('index_redirect', $index_redirect);

      $external_labs = R::findall('external_labs', 'deleted != ? ', [1]);
      $this->smarty->assign('external_labs', $external_labs);

      $detections = R::findAll('detections', 'del = 0');
      $this->smarty->assign('detections', $detections);

      //call other class with other content
      header::headershow($this->smarty, $this->hosturl);
      sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
      $this->smarty->display('_role/add.html');
      leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
      footer::footershow($this->smarty, $this->hosturl);
   }

   public function addit() {

      //check login
      autho::checkautho($this->hosturl);
      //check authoize
      autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

      //vars here
      $name = filter_input(INPUT_POST, 'name');
      $visit_show = filter_input(INPUT_POST, 'visit_show');
      $doctor_visit_show = filter_input(INPUT_POST, 'doctor_visit_show');
      $doctor_show = filter_input(INPUT_POST, 'doctor_show');
      $is_doctor = filter_input(INPUT_POST, 'is_doctor');
      $redirect_to = filter_input(INPUT_POST, 'redirect_to');
      $user_visits_only = filter_input(INPUT_POST, 'user_visits_only');
      $index_search = filter_input(INPUT_POST, 'index_search');
      $financial_visits = filter_input(INPUT_POST, 'financial_visits');
      $external_lab = filter_input(INPUT_POST, 'external_lab');
      $today_list = filter_input(INPUT_POST, 'today_list');
      $heart_reports_show = filter_input(INPUT_POST, 'heart_reports_show');

      $related_dr_depts = '';

      $i = 1;
      foreach ($_POST['related_dr_depts'] as $selectedOption) {

         if ($i != 1) {
            $related_dr_depts .= ' , ';
         }
         $related_dr_depts .= $selectedOption;
         $i++;
      }



      if (filter_input(INPUT_POST, 'index_visits_depts_all') == 1) {
         $index_visits_depts = -1;
      } else {
         $index_visits_depts = '';
         $i = 1;
         foreach ($_POST['index_visits_depts'] as $selectedOption) {

            if ($i != 1) {
               $index_visits_depts .= ' , ';
            }
            $index_visits_depts .= $selectedOption;
            $i++;
         }
      }



      $custom_detections = '';
      $i = 1;
      foreach ($_POST['custom_detections'] as $selectedOption) {

         if ($i != 1) {
            $custom_detections .= ' , ';
         }
         $custom_detections .= $selectedOption;
         $i++;
      }




      //here the add
      $role = R::dispense('awrole');
      $role->name = $name;
      $role->related_dr_depts = $related_dr_depts;
      $role->index_visits_depts = $index_visits_depts;
      $role->custom_detections = $custom_detections;
      $role->visit_show = $visit_show;
      $role->doctor_visit_show = $doctor_visit_show;
      $role->doctor_show = $doctor_show;
      $role->is_doctor = $is_doctor;
      $role->redirect_to = $redirect_to;
      $role->user_visits_only = $user_visits_only;
      $role->index_search = $index_search;
      $role->financial_visits = $financial_visits;
      $role->screen_show = filter_input(0, 'screen_show');
      $role->external_lab = $external_lab;
      $role->today_list = $today_list;
      $role->heart_reports_show = $heart_reports_show;

      try {
         $id = R::store($role);

         if (filter_input(INPUT_POST, 'index_visits_depts_all') != 1) {
            r::exec(' update awrole set index_visits_depts = ? where id = ?  ', [$id, $id]);
         }
         header('Location:' . $this->hosturl . '/controllers/' . $this->controllname . '.php?ac=show');
      } catch (Exception $e) {
         header('Location:' . $this->hosturl . '/controllers/error?ac=notadd&id=' . $this->controllname);
      }
   }

   public function show() {

      //check login
      autho::checkautho($this->hosturl);
      //check authoize
      autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

      //here will load the menu show
      $roles = R::findAll('awrole', 'order by id desc');
      $this->smarty->assign('roles', $roles);

      //call other class with other content
      header::headershow($this->smarty, $this->hosturl);
      sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
      $this->smarty->display('_role/show.html');
      leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
      footer::footershow($this->smarty, $this->hosturl);
   }

   public function edit() {

      //check login
      autho::checkautho($this->hosturl);
      //check authoize
      autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

      //get id for item
      $itemid = filter_input(INPUT_GET, 'id');

      //load all here
      $role = R::load('awrole', $itemid);
      $this->smarty->assign('role', $role);

      #########################################
      $drRoles = array();

      $dr_roles = explode(',', $role->related_dr_depts);

      foreach ($dr_roles as $value) {
         $value = trim($value);
         array_push($drRoles, $value);
      }
      $this->smarty->assign('drRoles', $drRoles);

      #########################################
      $indexVisitsRoles = array();

      if ($role->index_visits_depts == -1) {
         $role->index_visits_depts_all = 1;
      } else {
         $index_roles = explode(',', $role->index_visits_depts);

         foreach ($index_roles as $value) {
            $value = trim($value);
            array_push($indexVisitsRoles, $value);
         }
      }


      $this->smarty->assign('indexVisitsRoles', $indexVisitsRoles);

      #########################################
      $customDetections = array();
      $custom_detections = explode(',', $role->custom_detections);

      foreach ($custom_detections as $value) {
         $value = trim($value);
         array_push($customDetections, $value);
      }

      $this->smarty->assign('customDetections', $customDetections);

      #########################################

      $roles = R::findAll('awrole');
      $this->smarty->assign('roles', $roles);

      $index_redirect = R::findAll('index_redirect', ' deleted != 1  ');
      $this->smarty->assign('index_redirect', $index_redirect);

      $external_labs = R::findall('external_labs', 'deleted != ? ', [1]);
      $this->smarty->assign('external_labs', $external_labs);

      $detections = R::findAll('detections', 'del = 0');
      $this->smarty->assign('detections', $detections);

      ################################################
      $file = '../../upload/rolerecords/' . $itemid . '.wav';
      $voiceRecord = 0;
      if (file_exists($file)) {
         $voiceRecord = 1;
      }
      $this->smarty->assign('voiceRecord', $voiceRecord);
      ################################################
      //call other class with other content
      header::headershow($this->smarty, $this->hosturl);
      sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);
      $this->smarty->display('_role/edit.html');
      leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
      footer::footershow($this->smarty, $this->hosturl);
   }

   public function updateit() {

      //check login
      autho::checkautho($this->hosturl);
      //check authoize
      autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

      //vars here
      $name = filter_input(INPUT_POST, 'name');
      $id = filter_input(INPUT_POST, 'id');

      $visit_show = filter_input(INPUT_POST, 'visit_show');
      $doctor_visit_show = filter_input(INPUT_POST, 'doctor_visit_show');
      $doctor_show = filter_input(INPUT_POST, 'doctor_show');
      $is_doctor = filter_input(INPUT_POST, 'is_doctor');
      $redirect_to = filter_input(INPUT_POST, 'redirect_to');
      $user_visits_only = filter_input(INPUT_POST, 'user_visits_only');
      $index_search = filter_input(INPUT_POST, 'index_search');
      $financial_visits = filter_input(INPUT_POST, 'financial_visits');
      $external_lab = filter_input(INPUT_POST, 'external_lab');
      $today_list = filter_input(INPUT_POST, 'today_list');
      $heart_reports_show = filter_input(INPUT_POST, 'heart_reports_show');

      $related_dr_depts = '';

      if ($_POST['related_dr_depts'] && !empty($_POST['related_dr_depts'])) {
         $i = 1;
         foreach ($_POST['related_dr_depts'] as $selectedOption) {
            if ($i != 1) {
               $related_dr_depts .= ' , ';
            }
            $related_dr_depts .= $selectedOption;
            $i++;
         }
      }


      if (filter_input(INPUT_POST, 'index_visits_depts_all') == 1) {
         $index_visits_depts = -1;
      } else {
         $i = 1;
         $index_visits_depts = '';
         if ($_POST['index_visits_depts'] && !empty($_POST['index_visits_depts'])) {
            foreach ($_POST['index_visits_depts'] as $selectedOption) {
               if ($i != 1) {
                  $index_visits_depts .= ' , ';
               }
               $index_visits_depts .= $selectedOption;
               $i++;
            }
         }
      }



      $i = 1;
      $custom_detections = '';
      if ($_POST['custom_detections'] && !empty($_POST['custom_detections'])) {
         foreach ($_POST['custom_detections'] as $selectedOption) {
            if ($i != 1) {
               $custom_detections .= ' , ';
            }
            $custom_detections .= $selectedOption;
            $i++;
         }
      }



      //R::debug( TRUE );
      //load all parents here
      $role = R::load('awrole', $id);

      //here the upadte
      $role->name = $name;
      $role->related_dr_depts = $related_dr_depts;
      $role->index_visits_depts = $index_visits_depts;
      $role->custom_detections = $custom_detections;
      $role->visit_show = $visit_show;
      $role->doctor_visit_show = $doctor_visit_show;
      $role->doctor_show = $doctor_show;
      $role->is_doctor = $is_doctor;
      $role->redirect_to = $redirect_to;
      $role->user_visits_only = $user_visits_only;
      $role->index_search = $index_search;
      $role->financial_visits = $financial_visits;
      $role->screen_show = filter_input(0, 'screen_show');
      $role->external_lab = $external_lab;
      $role->today_list = $today_list;
      $role->heart_reports_show = $heart_reports_show;

      try {
         R::store($role);
         header('Location:' . $this->hosturl . '/controllers/' . $this->controllname . '.php?ac=show');
      } catch (Exception $e) {
         header('Location:' . $this->hosturl . '/controllers/error.php?ac=notupdate&id=' . $this->controllname);
      }
   }

   public function del() {

      //check login
      autho::checkautho($this->hosturl);
      //check authoize
      autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

      //get id for item
      $itemid = filter_input(INPUT_GET, 'id');

      $roleusers = R::getRow('select * from awusers where role_id = ?', [$itemid]);
      if ($roleusers > 0) {
         header('Location:' . $this->hosturl . '/controllers/error.php?ac=relate&id=' . $this->controllname);
         exit();
      }


      //load all item here
      $role = R::load('awrole', $itemid);

      try {

         R::trash($role);
         R::exec('delete from awrolemenu where role_id = ?', [$itemid]);
         R::exec('delete from awrolecontrollprop where role_id = ?', [$itemid]);

         header('Location:' . $this->hosturl . '/controllers/' . $this->controllname . '.php?ac=show');
      } catch (Exception $e) {
         header('Location:' . $this->hosturl . '/controllers/error.php?ac=notdel&id=' . $this->controllname);
      }
   }

   public function setting() {

      //check login
      autho::checkautho($this->hosturl);
      //check authoize
      autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

      //get id for item
      $itemid = filter_input(INPUT_GET, 'id');

      $this->menuitr = 0;

      //send role
      $role = R::load('awrole', $itemid);
      $this->smarty->assign('role', $role);

      //menu display
      $dismenu = $this->displaymenush(0, $this->hosturl, $itemid);
      $this->smarty->assign('dismenu', $dismenu);

      //controlls
      $controlls = R::findAll('awcontroll');
      foreach ($controlls as $single) {
         $awcontroll = R::findAll('awcontrollprop', 'awcontroll_id = ?', [$single->id]);
         $single->props = $awcontroll;
         foreach ($awcontroll as $sin) {
            $getroleprop = R::findOne('awrolecontrollprop', 'role_id = ? and controllprop_id = ?', [$itemid, $sin->id]);
            $countrslt = count($getroleprop);
            if ($countrslt > 0) {
               $sin->rolevalue = $getroleprop->checkval;
            } else {
               $sin->rolevalue = $sin->checkval;
            }
         }
      }
      $this->smarty->assign('controlls', $controlls);

      //call other class with other content
      header::headershow($this->smarty, $this->hosturl);
      sidebar::sidebarshow($this->smarty, $this->hosturl, $this->active);

      ##############################  index.html buttons show    ####################################
      $drawBtn = $this->displaybtns($itemid);
      $this->smarty->assign('drawBtn', $drawBtn);

###################################################################################

      $this->smarty->display('_role/setting.html');
      leftsidebar::leftsidebarshow($this->smarty, $this->hosturl);
      footer::footershow($this->smarty, $this->hosturl);
   }

   public function drawOtherUnit($btn, $btnName) {
      $menuhtml = '';

      $menuhtml .= '<li class="dd-item dd3-item" data-id="' . $btn->id . '">';
      $menuhtml .= '<div class=""></div><div class="dd3-content rtl ">'
              . $btnName
              . '<div  class="col-md-3 pull-right forroleradio ltr">'
              . '<div class="radio-list"><label class="radio-inline nopadding">'
              . '<input type="radio" class="btn_role_item"  data-btnid="' . $btn->btn_id . '" name="btncheck' . $btn->btn_id . '" value="1" ';
      if ($btn->checkval == 1) {
         $menuhtml .= 'checked';
      }
      $menuhtml .= '/> Yes </label>'
              . '<label class="radio-inline nopadding">'
              . '<input type="radio" class="btn_role_item" data-btnid="' . $btn->btn_id . '"  name="btncheck' . $btn->btn_id . '" value="0" ';
      if ($btn->checkval == 0) {
         $menuhtml .= 'checked';
      }
      $menuhtml .= '/> No</label></div>'
              . '</div>'
              . '</div>';
      $menuhtml .= '</li>';

      return $menuhtml;
   }

   public function displaybtns($roleid) {
      $drawBtn = '';
      ###############################################################################
      $btn1 = R::findOne('awrolebtn', ' role_id = ? and btn_id = 1  ', [$roleid]);
      if (count($btn1) < 1) {
         $btn1 = R::dispense('awrolebtn');
         $btn1->role_id = $roleid;
         $btn1->btn_id = 1;
         $btn1->checkval = 0;
         $btn1->id = R::store($btn1);
      }
      $drawBtn .= $this->drawbtnunit($btn1, 'زر إضافة مريضة  ');
      ##################################################################################
      $btn2 = R::findOne('awrolebtn', ' role_id = ? and btn_id = 2  ', [$roleid]);
      if (count($btn2) < 1) {
         $btn2 = R::dispense('awrolebtn');
         $btn2->role_id = $roleid;
         $btn2->btn_id = 2;
         $btn2->checkval = 0;
         $btn2->id = R::store($btn2);
      }
      $drawBtn .= $this->drawbtnunit($btn2, 'زر إضافة زيارة ');
      ###################################################################################
      $btn3 = R::findOne('awrolebtn', ' role_id = ? and btn_id = 3  ', [$roleid]);
      if (count($btn3) < 1) {
         $btn3 = R::dispense('awrolebtn');
         $btn3->role_id = $roleid;
         $btn3->btn_id = 3;
         $btn3->checkval = 0;
         $btn3->id = R::store($btn3);
      }
      $drawBtn .= $this->drawbtnunit($btn3, 'زر تعديل  زيارة ');
      ###################################################################################
      $btn4 = R::findOne('awrolebtn', ' role_id = ? and btn_id = 4  ', [$roleid]);
      if (count($btn4) < 1) {
         $btn4 = R::dispense('awrolebtn');
         $btn4->role_id = $roleid;
         $btn4->btn_id = 4;
         $btn4->checkval = 0;
         $btn4->id = R::store($btn4);
      }
      $drawBtn .= $this->drawbtnunit($btn4, 'زر حذف  زيارة ');
      ###################################################################################
      $btn5 = R::findOne('awrolebtn', ' role_id = ? and btn_id = 5  ', [$roleid]);
      if (count($btn5) < 1) {
         $btn5 = R::dispense('awrolebtn');
         $btn5->role_id = $roleid;
         $btn5->btn_id = 5;
         $btn5->checkval = 0;
         $btn5->id = R::store($btn5);
      }
      $drawBtn .= $this->drawbtnunit($btn5, 'زر تعديل  شكوى  العملاء  ');
      ###################################################################################
      $btn6 = R::findOne('awrolebtn', ' role_id = ? and btn_id = 6  ', [$roleid]);
      if (count($btn6) < 1) {
         $btn6 = R::dispense('awrolebtn');
         $btn6->role_id = $roleid;
         $btn6->btn_id = 6;
         $btn6->checkval = 0;
         $btn6->id = R::store($btn6);
      }
      $drawBtn .= $this->drawbtnunit($btn6, 'زر حذف   شكوى  العملاء  ');
      ###################################################################################
      $btn7 = R::findOne('awrolebtn', ' role_id = ? and btn_id = 7  ', [$roleid]);
      if (count($btn7) < 1) {
         $btn7 = R::dispense('awrolebtn');
         $btn7->role_id = $roleid;
         $btn7->btn_id = 7;
         $btn7->checkval = 0;
         $btn7->id = R::store($btn7);
      }
      $drawBtn .= $this->drawOtherUnit($btn7, '  إضافة وتعديل زيارة بتاريخ سابق   ');
      ###################################################################################
      $btn8 = R::findOne('awrolebtn', ' role_id = ? and btn_id = 8   ', [$roleid]);
      if (count($btn8) < 1) {
         $btn8 = R::dispense('awrolebtn');
         $btn8->role_id = $roleid;
         $btn8->btn_id = 8;
         $btn8->checkval = 0;
         $btn8->id = R::store($btn8);
      }
      $drawBtn .= $this->drawbtnunit($btn8, 'زر إيقاف حالة  ');
      ###################################################################################
      $btn9 = R::findOne('awrolebtn', ' role_id = ? and btn_id = 9   ', [$roleid]);
      if (count($btn9) < 1) {
         $btn9 = R::dispense('awrolebtn');
         $btn9->role_id = $roleid;
         $btn9->btn_id = 9;
         $btn9->checkval = 0;
         $btn9->id = R::store($btn9);
      }
      $drawBtn .= $this->drawbtnunit($btn9, 'زر تعديل  manual operation  ');
      ###################################################################################
      $btn10 = R::findOne('awrolebtn', ' role_id = ? and btn_id = 10   ', [$roleid]);
      if (count($btn10) < 1) {
         $btn10 = R::dispense('awrolebtn');
         $btn10->role_id = $roleid;
         $btn10->btn_id = 10;
         $btn10->checkval = 0;
         $btn10->id = R::store($btn10);
      }
      $drawBtn .= $this->drawbtnunit($btn10, 'زر حذف  manual operation  ');
      ###################################################################################
      $btn11 = R::findOne('awrolebtn', ' role_id = ? and btn_id = 11  ', [$roleid]);
      if (count($btn11) < 1) {
         $btn11 = R::dispense('awrolebtn');
         $btn11->role_id = $roleid;
         $btn11->btn_id = 11;
         $btn11->checkval = 0;
         $btn11->id = R::store($btn11);
      }
      $drawBtn .= $this->drawbtnunit($btn11, 'زر الوصول   manual operation  ');
      ###################################################################################
      $btn12 = R::findOne('awrolebtn', ' role_id = ? and btn_id = 12  ', [$roleid]);
      if (count($btn12) < 1) {
         $btn12 = R::dispense('awrolebtn');
         $btn12->role_id = $roleid;
         $btn12->btn_id = 12;
         $btn12->checkval = 0;
         $btn12->id = R::store($btn12);
      }
      $drawBtn .= $this->drawbtnunit($btn12, 'زر دخول الاستقبال    manual operation  ');
      ###################################################################################
      $btn13 = R::findOne('awrolebtn', ' role_id = ? and btn_id = 13  ', [$roleid]);
      if (count($btn13) < 1) {
         $btn13 = R::dispense('awrolebtn');
         $btn13->role_id = $roleid;
         $btn13->btn_id = 13;
         $btn13->checkval = 0;
         $btn13->id = R::store($btn13);
      }
      $drawBtn .= $this->drawbtnunit($btn13, 'زر خروج الاستقبال    manual operation  ');
      ###################################################################################
      $btn14 = R::findOne('awrolebtn', ' role_id = ? and btn_id = 14  ', [$roleid]);
      if (count($btn14) < 1) {
         $btn14 = R::dispense('awrolebtn');
         $btn14->role_id = $roleid;
         $btn14->btn_id = 14;
         $btn14->checkval = 0;
         $btn14->id = R::store($btn14);
      }
      $drawBtn .= $this->drawbtnunit($btn14, 'عمود التكلفة    manual operation  ');
      ###################################################################################
      $btn15 = R::findOne('awrolebtn', ' role_id = ? and btn_id = 15  ', [$roleid]);
      if (count($btn15) < 1) {
         $btn15 = R::dispense('awrolebtn');
         $btn15->role_id = $roleid;
         $btn15->btn_id = 15;
         $btn15->checkval = 0;
         $btn15->id = R::store($btn15);
      }
      $drawBtn .= $this->drawbtnunit($btn15, '  تعديل ال rfc من بروفايل المريض   ');

      ###################################################################################
      $btn16 = R::findOne('awrolebtn', ' role_id = ? and btn_id = 16  ', [$roleid]);
      if (count($btn16) < 1) {
         $btn16 = R::dispense('awrolebtn');
         $btn16->role_id = $roleid;
         $btn16->btn_id = 16;
         $btn16->checkval = 0;
         $btn16->id = R::store($btn16);
      }
      $drawBtn .= $this->drawbtnunit($btn16, '  الحضور -  operation report   ');

      ###################################################################################
      $btn17 = R::findOne('awrolebtn', ' role_id = ? and btn_id = 17  ', [$roleid]);
      if (count($btn17) < 1) {
         $btn17 = R::dispense('awrolebtn');
         $btn17->role_id = $roleid;
         $btn17->btn_id = 17;
         $btn17->checkval = 0;
         $btn17->id = R::store($btn17);
      }
      $drawBtn .= $this->drawbtnunit($btn17, '  العمليات -  operation report   ');

      ###################################################################################
      $btn18 = R::findOne('awrolebtn', ' role_id = ? and btn_id = 18  ', [$roleid]);
      if (count($btn18) < 1) {
         $btn18 = R::dispense('awrolebtn');
         $btn18->role_id = $roleid;
         $btn18->btn_id = 18;
         $btn18->checkval = 0;
         $btn18->id = R::store($btn18);
      }
      $drawBtn .= $this->drawbtnunit($btn18, '  الإقامة -  operation report   ');

      ###################################################################################
      $btn19 = R::findOne('awrolebtn', ' role_id = ? and btn_id = 19  ', [$roleid]);
      if (count($btn19) < 1) {
         $btn19 = R::dispense('awrolebtn');
         $btn19->role_id = $roleid;
         $btn19->btn_id = 19;
         $btn19->checkval = 0;
         $btn19->id = R::store($btn19);
      }
      $drawBtn .= $this->drawbtnunit($btn19, ' استرجاع من الزيارات السابقة  ');

      ###################################################################################
      $btn20 = R::findOne('awrolebtn', ' role_id = ? and btn_id = 20  ', [$roleid]);
      if (count($btn20) < 1) {
         $btn20 = R::dispense('awrolebtn');
         $btn20->role_id = $roleid;
         $btn20->btn_id = 20;
         $btn20->checkval = 0;
         $btn20->id = R::store($btn20);
      }
      $drawBtn .= $this->drawbtnunit($btn20, ' حذف التحويلات الخارجية ');

      ###################################################################################
      $btn21 = R::findOne('awrolebtn', ' role_id = ? and btn_id = 21  ', [$roleid]);
      if (count($btn21) < 1) {
         $btn21 = R::dispense('awrolebtn');
         $btn21->role_id = $roleid;
         $btn21->btn_id = 21;
         $btn21->checkval = 0;
         $btn21->id = R::store($btn21);
      }
      $drawBtn .= $this->drawbtnunit($btn21, ' زر الدفع    ');

      ###################################################################################
      return $drawBtn;
   }

   public function drawbtnunit($btn, $btnName) {
      $menuhtml = '';

      $menuhtml .= '<li class="dd-item dd3-item" data-id="' . $btn->id . '">';
      $menuhtml .= '<div class=""></div><div class="dd3-content rtl">'
              . $btnName
              . '<div  class="col-md-3 pull-right forroleradio ltr">'
              . '<div class="radio-list"><label class="radio-inline nopadding">'
              . '<input type="radio" class="btn_role_item"  data-btnid="' . $btn->btn_id . '" name="btncheck' . $btn->btn_id . '" value="1" ';
      if ($btn->checkval == 1) {
         $menuhtml .= 'checked';
      }
      $menuhtml .= '/> Show </label>'
              . '<label class="radio-inline nopadding">'
              . '<input type="radio" class="btn_role_item" data-btnid="' . $btn->btn_id . '"  name="btncheck' . $btn->btn_id . '" value="0" ';
      if ($btn->checkval == 0) {
         $menuhtml .= 'checked';
      }
      $menuhtml .= '/> Hide</label></div>'
              . '</div>'
              . '</div>';
      $menuhtml .= '</li>';

      return $menuhtml;
   }

   //just use it to draw menu
   public function displaymenush($parent, $hosturl, $roleid) {


      $menuhtml = "";
      //get the all about this level in menu
      $result = R::getAll('SELECT a.*, Deriv1.count FROM `awmenu` a  LEFT OUTER JOIN (SELECT parent, COUNT(*) AS Count FROM `awmenu` GROUP BY parent) Deriv1 ON a.id = Deriv1.parent WHERE a.parent= ?', [$parent]);

      foreach ($result as $srel) {

         //check the value of group
         $getrolemenu = R::findOne('awrolemenu', 'role_id = ? and menu_id = ?', [$roleid, $srel['id']]);
         $countrslt = count($getrolemenu);
         if ($countrslt > 0) {
            $srel['rolevalue'] = $getrolemenu['checkval'];
         } else {
            $srel['rolevalue'] = 0;
         }

         //main itr for input
         $this->menuitr++;

         if ($srel['count'] > 0) {
            $menuhtml .= '<li class="dd-item dd3-item" data-id="' . $srel["id"] . '">';
            $menuhtml .= '<div class=""></div><div class="dd3-content">'
                    . '<i class="' . $srel["icon"] . '"></i> '
                    . $srel["label"]
                    . '<input type="hidden" name="menuid' . $this->menuitr . '" value="' . $srel["id"] . '"/>'
                    . '<div  class="col-md-3 pull-right forroleradio">'
                    . '<div class="radio-list"><label class="radio-inline nopadding">'
                    . '<input type="radio" class="menu_role_item menuroleyes" data-menuid="' . $srel["id"] . '" name="menurolecheck' . $this->menuitr . '" value="1" ';
            if ($srel['rolevalue'] == 1) {
               $menuhtml .= 'checked';
            }
            $menuhtml .= '/> Show </label>'
                    . '<label class="radio-inline nopadding">'
                    . '<input type="radio" class="menu_role_item menuroleno" data-menuid="' . $srel["id"] . '" name="menurolecheck' . $this->menuitr . '" value="0" ';
            if ($srel['rolevalue'] == 0) {
               $menuhtml .= 'checked';
            }
            $menuhtml .= '/> Hide</label></div>'
                    . '</div>'
                    . '</div>';
            $menuhtml .= '<ol class="dd-list">'
                    . $this->displaymenush($srel["id"], $hosturl, $roleid)
                    . '</ol>'
                    . '</li>';
         } elseif ($srel['count'] == 0) {
            $menuhtml .= '<li class="dd-item dd3-item" data-id="' . $srel["id"] . '">';
            $menuhtml .= '<div class=""></div><div class="dd3-content">'
                    . '<i class="' . $srel["icon"] . '"></i> '
                    . '<input type="hidden" name="menuid' . $this->menuitr . '" value="' . $srel["id"] . '"/>'
                    . $srel["label"]
                    . '<div  class="col-md-3 pull-right forroleradio">'
                    . '<div class="radio-list"><label class="radio-inline nopadding">'
                    . '<input type="radio" class="menu_role_item menuroleyes" data-menuid="' . $srel["id"] . '" name="menurolecheck' . $this->menuitr . '" value="1" ';
            if ($srel['rolevalue'] == 1) {
               $menuhtml .= 'checked';
            }
            $menuhtml .= '/> Show </label>'
                    . '<label class="radio-inline nopadding">'
                    . '<input type="radio" class="menu_role_item menuroleno" data-menuid="' . $srel["id"] . '" name="menurolecheck' . $this->menuitr . '" value="0" ';
            if ($srel['rolevalue'] == 0) {
               $menuhtml .= 'checked';
            }
            $menuhtml .= '/> Hide</label></div>'
                    . '</div>'
                    . '</div>';
            $menuhtml .= '</li>';
         }
      }

      return $menuhtml;
   }

   public function insetting() {

      //check login
      autho::checkautho($this->hosturl);
      //check authoize
      autho::checkauthoize($this->controllname, $this->hosturl, $_SESSION['role_id']);

      print_r(count($_POST));

      //get id for item
      $itemid = filter_input(INPUT_POST, 'roleid');
      $itrmenu = count(R::findAll('awmenu'));
      $itrcontroll = filter_input(INPUT_POST, 'itrcontroll');
      $itrcontrollprop = filter_input(INPUT_POST, 'itrcontrollprop1');

      //R::debug('true');

      try {

         //insert the role menu
         for ($i = 1; $i <= $itrmenu; $i++) {
            $menuid = filter_input(INPUT_POST, 'menuid' . $i);
            $checkval = filter_input(INPUT_POST, 'menurolecheck' . $i);

            if (!$menuid) {
               continue;
            }


            //check if this item already in awrolemenu
            $getrolemenu = R::findOne('awrolemenu', 'role_id = ? and menu_id = ?', [$itemid, $menuid]);
            $countrslt = count($getrolemenu);
            if ($countrslt > 0) {
               //update
               $awrolemenu = R::load('awrolemenu', $getrolemenu->id);
               $awrolemenu->role = R::load('awrole', $itemid);
               $awrolemenu->menu = R::load('awmenu', $menuid);
               $awrolemenu->checkval = $checkval;

               R::store($awrolemenu);
            } else {
               //insert
               $awrolemenu = R::dispense('awrolemenu');
               $awrolemenu->role = R::load('awrole', $itemid);
               $awrolemenu->menu = R::load('awmenu', $menuid);
               $awrolemenu->checkval = $checkval;

               R::store($awrolemenu);
            }
         }

         //insert controll prop
         for ($i = 1; $i <= $itrcontroll; $i++) {
            $itrcontrollprop = filter_input(INPUT_POST, 'itrcontrollprop' . $i);

            //insert every prop
            for ($ix = 0; $ix <= $itrcontrollprop; $ix++) {
               $controllpropid = filter_input(INPUT_POST, 'controllpropid' . $i . $ix);
               $checkval = filter_input(INPUT_POST, 'proprolecheck' . $i . $ix);

               if (!$controllpropid) {
                  continue;
               }

               $getroleprop = R::findOne('awrolecontrollprop', 'role_id = ? and controllprop_id = ?', [$itemid, $controllpropid]);
               $countrslt = count($getroleprop);
               if ($countrslt > 0) {
                  //update
                  $awrolecontrollprop = R::load('awrolecontrollprop', $getroleprop->id);
                  $awrolecontrollprop->role = R::load('awrole', $itemid);
                  $awrolecontrollprop->controllprop = R::load('awcontrollprop', $controllpropid);
                  $awrolecontrollprop->checkval = $checkval;

                  R::store($awrolecontrollprop);
               } else {
                  //insert
                  $awrolecontrollprop = R::dispense('awrolecontrollprop');
                  $awrolecontrollprop->role = R::load('awrole', $itemid);
                  $awrolecontrollprop->controllprop = R::load('awcontrollprop', $controllpropid);
                  $awrolecontrollprop->checkval = $checkval;

                  R::store($awrolecontrollprop);
               }
            }
         }

         //insert the btn  
         for ($i = 1; $i <= 6; $i++) {
            $checkval = filter_input(INPUT_POST, 'btncheck' . $i);
            //$checkval = filter_input(INPUT_POST, 'btncheck6');
            //$ddcheckval = filter_input(INPUT_POST, 'sdd');
            //echo $i.'-';print($checkval);echo '<br/>';

            ($checkval) ? $checkval = $checkval : $checkval = 0;

            $btn = R::findOne('awrolebtn', ' role_id = ? and btn_id = ?   ', [$itemid, $i]);
            $btn->checkval = $checkval;
            $ff = R::store($btn);
            //print($ff);
         }



         //header('Location:' . $this->hosturl . '/controllers/' . $this->controllname . '.php?ac=show');
      } catch (Exception $e) {
         echo $e->getMessage();
         //header('Location:' . $this->hosturl . '/controllers/error?ac=insetting&id=' . $this->controllname);
      }
   }

   public function updateMenuSetting() {
      $role_id = filter_input(INPUT_POST, 'roleid');
      $menu_id = filter_input(INPUT_POST, 'menuid');
      $check_val = filter_input(INPUT_POST, 'menurolecheck');

      if (!$menu_id) {
         return false;
      }

      //R::debug('true');

      $getrolemenu = R::findOne('awrolemenu', 'role_id = ? and menu_id = ?', [$role_id, $menu_id]);
      if ($getrolemenu) {
         //update
         $awrolemenu = R::load('awrolemenu', $getrolemenu->id);
         $awrolemenu->role = R::load('awrole', $role_id);
         $awrolemenu->menu = R::load('awmenu', $menu_id);
         $awrolemenu->checkval = $check_val;

         $result = R::store($awrolemenu);
      } else {
         //insert
         $awrolemenu = R::dispense('awrolemenu');
         $awrolemenu->role = R::load('awrole', $role_id);
         $awrolemenu->menu = R::load('awmenu', $menu_id);
         $awrolemenu->checkval = $check_val;

         $result = R::store($awrolemenu);
      }


      return $result;
   }

   public function updateControlSetting() {
      $role_id = filter_input(INPUT_POST, 'roleid');
      $controll_prop_id = filter_input(INPUT_POST, 'controllpropid');
      $check_val = filter_input(INPUT_POST, 'proprolecheck');

      if (!$controll_prop_id) {
         return false;
      }

      $getroleprop = R::findOne('awrolecontrollprop', 'role_id = ? and controllprop_id = ?', [$role_id, $controll_prop_id]);
      if ($getroleprop) {
         //update
         $awrolecontrollprop = R::load('awrolecontrollprop', $getroleprop->id);
         $awrolecontrollprop->role = R::load('awrole', $role_id);
         $awrolecontrollprop->controllprop = R::load('awcontrollprop', $controll_prop_id);
         $awrolecontrollprop->checkval = $check_val;
         $result = R::store($awrolecontrollprop);
      } else {
         //insert
         $awrolecontrollprop = R::dispense('awrolecontrollprop');
         $awrolecontrollprop->role = R::load('awrole', $role_id);
         $awrolecontrollprop->controllprop = R::load('awcontrollprop', $controll_prop_id);
         $awrolecontrollprop->checkval = $check_val;
         $result = R::store($awrolecontrollprop);
      }

      return $result;
   }

   public function updateBtnSetting() {
      $role_id = filter_input(INPUT_POST, 'roleid');
      $btn_id = filter_input(INPUT_POST, 'btn_id');
      $check_val = filter_input(INPUT_POST, 'btncheck');

      if (!$btn_id) {
         return false;
      }

      $btn = R::findOne('awrolebtn', ' role_id = ? and btn_id = ?   ', [$role_id, $btn_id]);
      //update
      $btn->checkval = $check_val;
      $result = R::store($btn);

      return $result;
   }

   public function duplicate() {
      $itemid = filter_input(INPUT_GET, 'id');
      $other_itemid = filter_input(INPUT_GET, 'other');

      $aw_role_menus = R::findAll('awrolemenu', 'role_id = ?', [$itemid]);

      foreach ($aw_role_menus as $single) {
         //insert
         $awrolemenu = R::dispense('awrolemenu');
         $awrolemenu->role_id = $other_itemid;
         $awrolemenu->menu_id = $single->menu_id;
         $awrolemenu->checkval = $single->checkval;
         echo 'controll';
         echo $rslt = R::store($awrolemenu);
         echo '<br/>';
      }

      $aw_role_controllers = R::findAll('awrolecontrollprop', 'role_id = ?', [$itemid]);
      foreach ($aw_role_controllers as $single) {
         $awrolecontrollprop = R::dispense('awrolecontrollprop');
         $awrolecontrollprop->role_id = $other_itemid;
         $awrolecontrollprop->controllprop_id = $single->controllprop_id;
         $awrolecontrollprop->checkval = $single->checkval;
         echo 'controll';
         echo $top = R::store($awrolecontrollprop);
         echo '<br/>';
      }
   }

   // at the end of class call
   public function __destruct() {
      //colse connection
      R::close();
   }
}
